/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.kantegasso.oidc.OidcProcedureData;
import io.vavr.collection.HashMap;
import io.vavr.control.Either;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.samllib.validation.SAMLSessionIdentification;

@Scanned
public class SingleLogoutConfigAction
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final ApplicationProperties applicationProperties;
    private final OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper;

    @Inject
    public SingleLogoutConfigAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.oidcProcedureFactoryWrapper = bucket.getOidcProcedureFactoryWrapper();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        String action = req.getParameter("action");
        String id = this.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (StringUtils.equals("editSingleLogout", action)) {
            boolean singleLogoutEnabled = StringUtils.equals(req.getParameter("singleLogoutEnabled"), "on");
            IdpConfigurationBuilder builder = configuration.fold(oidc -> {
                IdpConfigurationBuilder.OIDC oidcBuilder = IdpConfigurationBuilder.of(oidc);
                if (singleLogoutEnabled) {
                    OIDCIdpConfiguration oidcConf = (OIDCIdpConfiguration)configuration;
                    Either maybeOidcProcedureData = this.oidcProcedureFactoryWrapper.createOidcProcedure(HashMap.of("discovery_url", oidcConf.getDiscoveryUrl(), "workaround", oidcConf.getKind().getOidcLibRepresentation())).flatMap(data -> data.get("discovery_url").filter(StringUtils::isNotBlank).isDefined() ? data.discover() : Either.right(data));
                    if (maybeOidcProcedureData.isRight()) {
                        String sessionEndpoint = (String)((OidcProcedureData)maybeOidcProcedureData.get()).get("end_session_endpoint").getOrNull();
                        boolean oidcSloProbablySupported = HttpUrlUtils.isValidAndNonEmptyUri(sessionEndpoint);
                        model.put("oidcSloNotSupported", !oidcSloProbablySupported);
                        model.put("oidcSuccessfullyEnabled", oidcSloProbablySupported);
                        return (IdpConfigurationBuilder)oidcBuilder.setSingleLogoutEnabled(oidcSloProbablySupported);
                    }
                    model.put("errorMessageFromOidc", maybeOidcProcedureData.getLeft());
                }
                return (IdpConfigurationBuilder)oidcBuilder.setSingleLogoutEnabled(false);
            }, saml -> {
                SAMLSessionIdentification.ValidationPolicy validationPolicy = Optional.ofNullable(req.getParameter("sessionIdentificationValidationPolicy")).map(SAMLSessionIdentification.ValidationPolicy::valueOf).orElse(SAMLSessionIdentification.ValidationPolicy.getDefault());
                String logoutServiceUrl = StringUtils.trim(req.getParameter("logoutUrl"));
                return (IdpConfigurationBuilder)IdpConfigurationBuilder.of(saml).setSessionIdValidationPolicy(validationPolicy).setIdpSingleLogoutServiceURL(logoutServiceUrl).setSingleLogoutEnabled(singleLogoutEnabled);
            });
            String logoutReturnUrl = StringUtils.trimToNull(req.getParameter("logoutReturnUrl"));
            builder.setSingleLogoutReturnURL(logoutReturnUrl);
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        this.renderPage(req, resp, model);
    }

    private void validateSingleLogoutURL(Map<String, Object> model, boolean singleLogoutEnabled, String logoutUrl) {
        if (singleLogoutEnabled && (StringUtils.isBlank(logoutUrl) || !HttpUrlUtils.validateURL(logoutUrl))) {
            model.put("invalidIdpSingleLogoutServiceURL", true);
        }
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException, ServletException {
        resp.setContentType("text/html");
        String id = this.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        configuration.ifSaml(samlConf -> {
            model.put("sessionIdentificationValidationPolicy", (Object)Optional.ofNullable(samlConf.getSessionIdentificationValidationPolicy()).orElse(SAMLSessionIdentification.ValidationPolicy.getDefault()));
            this.validateSingleLogoutURL(model, samlConf.isSingleLogoutEnabled(), samlConf.getSingleLogoutServiceURL());
        });
        configuration.ifOidc(oidcConf -> model.put("transformedReturnUrl", HttpUrlUtils.transformToAbsoluteUrl(oidcConf.getSingleLogoutReturnURL(), this.applicationProperties)));
        model.put("topMenu", "SAML");
        model.put("menuItem", "singlelogout");
        model.put("idp", configuration);
        model.put("serviceProviderLogoutServiceURL", this.idpConfManager.getServiceProviderLogoutServiceURL(req, id));
        model.put("kerberosConfigured", this.kerbConfManager.isKeytabConfigured());
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.getTemplateRenderer().render("templates/saml/saml-idp-single-logout.vm", model, (Writer)resp.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }
}

