/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.collection.Array;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.PrincipalEntry;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.GroupEvaluation;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluator;
import org.kantega.atlaskerb.saml.AtlSpServletSupport;
import org.kantega.atlaskerb.saml.Fingerprint;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;
import org.kantega.atlaskerb.saml.cache.AtlassianAuthnStateCache;
import org.kantega.atlaskerb.saml.cache.AtlassianCacheStorageService;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelper;
import org.kantega.atlaskerb.saml.logout.SingleLogoutAppHelperFactory;
import org.kantega.atlaskerb.saml.util.SessionIdentificationHelper;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.TestUtils;
import org.kantega.samllib.IdGenerator;
import org.kantega.samllib.spi.AuthnStateCache;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.ResultType;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.kantega.samllib.validation.SamlLogoutValidationResult;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.kantega.samllib.validation.ValidationResult;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.security.credential.Credential;
import org.opensaml.storage.ReplayCache;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceProviderFactory {
    public static final String SESSION_IDENTIFICATION_KEY = "sessionIdentification";
    private static final Logger log = LoggerFactory.getLogger(ServiceProviderFactory.class);
    private final ConnectorConfManager connectorConfManager;
    private final IdpConfManager idpConfManager;
    private final ReplayCache replayCache;
    private final AuthnStateCache authnStateCache;
    private final KerbConfManager kerbConfManager;
    private final AuditLogFacade auditLogFacade;
    private final IdGenerator random = new IdGenerator();
    private final TemplateRenderer renderer;
    private final HostApp hostApp;
    private final SingleLogoutAppHelper logoutAppHelper;
    private final SAMLResponseEvaluator responseEvaluator;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final SafeRedirect safeRedirect;

    @Inject
    public ServiceProviderFactory(@ComponentImport UserManager userManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport CacheManager cacheManager, @ComponentImport TemplateRenderer renderer, IdpConfManager idpConfManager, KerbConfManager kerbConfManager, AuditLogFacade auditLogFacade, ConnectorConfManager connectorConfManager, HostAppFactory hostAppFactory, SAMLResponseEvaluator responseEvaluator, SafeRedirect safeRedirect, SingleLogoutAppHelperFactory singleLogoutAppHelperFactory) {
        this.connectorConfManager = connectorConfManager;
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
        this.auditLogFacade = auditLogFacade;
        this.renderer = renderer;
        this.hostApp = hostAppFactory.getInstance();
        this.logoutAppHelper = singleLogoutAppHelperFactory.getInstance();
        this.responseEvaluator = responseEvaluator;
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.safeRedirect = safeRedirect;
        this.replayCache = new ReplayCache();
        this.replayCache.setStrict(true);
        this.replayCache.setStorage(new AtlassianCacheStorageService(cacheManager));
        this.authnStateCache = new AtlassianAuthnStateCache(cacheManager);
    }

    public static String getTargetLinkUrl(String urlString, String baseUrl) {
        return (String)Try.of(() -> urlString).mapTry(URI::new).filterTry(uri -> uri.isAbsolute() ? ServiceProviderFactory.validateAbsoluteUri(uri, baseUrl) : ServiceProviderFactory.validateRelativeUri(uri)).map(URI::toString).getOrNull();
    }

    private static boolean validateAbsoluteUri(URI uri, String baseUrl) {
        return Try.of(() -> uri).mapTry(URI::toURL).filterTry(url -> Array.of("http", "https").contains(url.getProtocol())).mapTry(URL::toString).filterTry(urlString -> StringUtils.startsWith(urlString, baseUrl)).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, "javascript:")).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, "<script")).mapTry(urlString -> true).getOrElse(false);
    }

    private static boolean validateRelativeUri(URI uri) {
        return Try.of(() -> uri).mapTry(URI::toString).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, "://")).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, "javascript:")).filterTry(uriString -> !StringUtils.contains((CharSequence)uriString, "<script")).mapTry(urlString -> true).getOrElse(false);
    }

    public ServiceProviderSpi getInstance(SAMLIdpConfiguration config) {
        return new SpConfSpi(config);
    }

    private void authenticateUserInCrowdSSO(Principal principal, Directory userDirectory) throws OperationFailedException {
        String appName = (String)userDirectory.getAttributes().get("application.name");
        if (appName != null && this.connectorConfManager.getDirectory(appName) == null) {
            try {
                SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth groupSyncMode = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.forDirectory((Attributes)userDirectory);
                if (groupSyncMode == SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.ALWAYS) {
                    DbCachingRemoteDirectoryInstanceLoader instanceLoader = (DbCachingRemoteDirectoryInstanceLoader)ComponentLocator.getComponent(DbCachingRemoteDirectoryInstanceLoader.class);
                    DbCachingRemoteDirectory directory = (DbCachingRemoteDirectory)instanceLoader.getDirectory(userDirectory);
                    RemoteCrowdDirectory crowdDirectory = (RemoteCrowdDirectory)this.hostApp.getAuthorativeDirectory(directory);
                    try {
                        String token = crowdDirectory.getCrowdClient().authenticateSSOUserWithoutValidatingPassword(new UserAuthenticationContext(principal.getName(), null, new ValidationFactor[0], null));
                        crowdDirectory.getCrowdClient().invalidateSSOToken(token);
                    }
                    catch (OperationFailedException e) {
                        log.debug("REST-call failed. Likely because of a remote jira");
                    }
                    catch (ApplicationAccessDeniedException | ApplicationPermissionException | InactiveAccountException | InvalidAuthenticationException e) {
                        log.error("Error authenticating user remotely", e);
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                log.debug("Unable to perform user sync on login since Crowd API is too old and not compatible with triggering this. Sync will happen on next scheduled synchronisation");
            }
        }
    }

    private void renderErrors(List<String> errors, SamlResponseValidationResult result) throws IOException {
        HttpServletResponse resp = result.getResponse();
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        resp.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
        Map<String, Object> model = this.newModel();
        model.put("errors", errors);
        model.put("errorPageMessage", this.kerbConfManager.getErrorPageMessage());
        model.put("requestURI", ServiceProviderFactory.getTargetLinkUrl(result.getRelayState(), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)));
        model.put("baseUrl", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.renderer.render("templates/saml/login-error.vm", model, (Writer)resp.getWriter());
    }

    private void renderLogoutErrors(SamlLogoutValidationResult result, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        Map<String, Object> model = this.newModel();
        model.put("errors", result.getResults());
        model.put("errorPageMessage", this.kerbConfManager.getErrorPageMessage());
        model.put("displayName", this.applicationProperties.getDisplayName());
        String id = result.getServiceProviderSpi().getIdentityProviderId();
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        model.put("idp", configuration.getName());
        this.renderer.render("templates/saml/logout-error.vm", model, (Writer)resp.getWriter());
    }

    private boolean isSystemAdmin(HttpServletRequest request) {
        return HttpUrlUtils.isSystemAdmin(this.userManager, request);
    }

    private void recordTest(SamlResponseValidationResult result, ResponseEvaluationCode code, SAMLResponseEvaluationResult evaluationResult, IdpConfiguration idpConfiguration) throws IOException {
        if (result.getResponseObject() == null) {
            result.getResponse().sendError(400, "Response did not contain a SAML response object");
            return;
        }
        try {
            String xml = result.getResponseObject() == null ? null : AtlSpServletSupport.serializeXml(XMLObjectSupport.marshall(result.getResponseObject()));
            this.idpConfManager.recordTestResult(idpConfiguration.getId(), result, evaluationResult, xml, this.kerbConfManager.getRemoteIpAddress(result.getRequest()));
            if (idpConfiguration.getNotificationEmails() != null && !this.isSystemAdmin(result.getRequest())) {
                try {
                    this.sendNotificationEmails(result, idpConfiguration);
                }
                catch (Exception e) {
                    log.error("Could not send notification emails", (Throwable)e);
                }
            }
        }
        catch (MarshallingException e) {
            throw new RuntimeException(e);
        }
        String location = TestUtils.testResultURL(result.getRequest(), idpConfiguration, this.idpConfManager, this.userManager, result.getAuthnRequestID());
        result.getResponse().sendRedirect(location);
    }

    private void sendNotificationEmails(SamlResponseValidationResult result, IdpConfiguration idpConfiguration) {
        if (!this.hostApp.isSMTPSupported() || !this.hostApp.isSMTPEnabled()) {
            return;
        }
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        String evalPath = this.idpConfManager.getServiceProviderEvaluateTestURL(result.getRequest(), idpConfiguration.getId());
        evalPath = evalPath.substring(result.getRequest().getContextPath().length());
        String url = baseUrl + evalPath + "?id=" + result.getAuthnRequestID();
        String subject = "New SAML authentication test result";
        String body = "A new SAML authentication test result was received\n\nVisit the following URL to see the result:\n\n" + url;
        for (String recipient : idpConfiguration.getNotificationEmails().split(",")) {
            if ((recipient = recipient.trim()).isEmpty()) continue;
            this.hostApp.sendEmail(recipient, subject, body);
        }
    }

    protected Map<String, Object> newModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        new PluginKey();
        String pluginKey = PluginKey.getPluginKey();
        model.put("pluginKey", pluginKey);
        model.put("pluginResource", pluginKey + ":atlaskerb");
        return model;
    }

    private class SpConfSpi
    implements ServiceProviderSpi {
        private final String USERNAME_ATTR = ServiceProviderSpi.class.getName() + "_username";
        private final SAMLIdpConfiguration samlIdpConfiguration;
        private final Map<String, Credential> idpValidationCredentials = new HashMap<String, Credential>();
        private final Credential authnSigningCertCredential;

        public SpConfSpi(SAMLIdpConfiguration samlIdpConfiguration) {
            this.samlIdpConfiguration = samlIdpConfiguration;
            for (byte[] certBytes : samlIdpConfiguration.getSigningCerts()) {
                this.idpValidationCredentials.put(Fingerprint.sha1Fingerprint(certBytes), ServiceProviderFactory.this.idpConfManager.getIdpSigningCredential(certBytes));
            }
            this.authnSigningCertCredential = ServiceProviderFactory.this.idpConfManager.getSpSigningCredential();
        }

        @Override
        public String getIdentityProviderId() {
            return this.samlIdpConfiguration.getId();
        }

        @Override
        public ReplayCache getReplayCache() {
            return ServiceProviderFactory.this.replayCache;
        }

        @Override
        public AuthnStateCache getAuthnStateCache(HttpServletRequest req) {
            return ServiceProviderFactory.this.authnStateCache;
        }

        @Override
        public String getIdpDestination(HttpServletRequest req) {
            return this.samlIdpConfiguration.getIdpURL();
        }

        @Override
        public String getACSLocation(HttpServletRequest req) {
            return ServiceProviderFactory.this.idpConfManager.getServiceProviderLoginURL(req, this.samlIdpConfiguration.getId());
        }

        @Override
        public String getLogoutLocation(HttpServletRequest req) {
            return ServiceProviderFactory.this.idpConfManager.getServiceProviderLogoutServiceURL(req, this.samlIdpConfiguration.getId());
        }

        @Override
        public String getIssuerName(HttpServletRequest req) {
            if (this.samlIdpConfiguration.getIssuerPolicy() == SAMLIdpConfiguration.IssuerPolicy.CUSTOM && this.samlIdpConfiguration.getIssuer() != null && !this.samlIdpConfiguration.getIssuer().isEmpty()) {
                return this.samlIdpConfiguration.getIssuer();
            }
            return this.getACSLocation(req);
        }

        @Override
        public Credential getSigningCredential() {
            return this.authnSigningCertCredential;
        }

        @Override
        public String nextSamlRequestId() {
            return ServiceProviderFactory.this.random.next();
        }

        @Override
        public List<Credential> getIdentityProviderCredentials(Signature signature) {
            if (signature.getKeyInfo() != null && signature.getKeyInfo().getX509Datas() != null) {
                for (X509Data x509Data : signature.getKeyInfo().getX509Datas()) {
                    Iterator<X509Certificate> iterator2 = x509Data.getX509Certificates().iterator();
                    if (!iterator2.hasNext()) continue;
                    X509Certificate certificate = iterator2.next();
                    String base64 = certificate.getValue();
                    Credential credential = this.idpValidationCredentials.get(Fingerprint.sha1Fingerprint(Base64.decodeBase64(base64)));
                    if (credential == null) {
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(credential);
                }
            }
            return new ArrayList<Credential>(this.idpValidationCredentials.values());
        }

        @Override
        public List<Credential> getAllIdentityProviderCredentials() {
            return new ArrayList<Credential>(this.idpValidationCredentials.values());
        }

        private AuthnRequest createAuthnRequest(HttpServletRequest req) {
            AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject();
            authnRequest.setForceAuthn(this.isForceAuthn(req));
            authnRequest.setIsPassive(false);
            authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            authnRequest.setAssertionConsumerServiceURL(this.getACSLocation(req));
            Issuer issuer = new IssuerBuilder().buildObject();
            issuer.setValue(this.getIssuerName(req));
            issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
            authnRequest.setIssuer(issuer);
            authnRequest.setDestination(this.getIdpDestination(req));
            authnRequest.setIssueInstant(DateTime.now());
            authnRequest.setID(this.nextSamlRequestId());
            NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
            nameIDPolicy.setAllowCreate(true);
            nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            authnRequest.setNameIDPolicy(nameIDPolicy);
            RequestedAuthnContext requestedAuthnContext = new RequestedAuthnContextBuilder().buildObject();
            requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.EXACT);
            AuthnContextClassRef authnContextClassRef = new AuthnContextClassRefBuilder().buildObject();
            authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
            requestedAuthnContext.getAuthnContextClassRefs().add(authnContextClassRef);
            authnRequest.setRequestedAuthnContext(requestedAuthnContext);
            return authnRequest;
        }

        @Override
        public AuthnRequest buildAuthnRequest(HttpServletRequest request) {
            String customNameIdFormat;
            AuthnRequest authnRequest = this.createAuthnRequest(request);
            switch (this.samlIdpConfiguration.getRequestedAuthnContextPolicy()) {
                case DO_NOT_SEND: {
                    authnRequest.setRequestedAuthnContext(null);
                    break;
                }
                case CUSTOM: {
                    AuthnContextComparisonTypeEnumeration comparison;
                    switch (this.samlIdpConfiguration.getRequestedAuthnContextComparison()) {
                        case MINIMUM: {
                            comparison = AuthnContextComparisonTypeEnumeration.MINIMUM;
                            break;
                        }
                        case MAXIMUM: {
                            comparison = AuthnContextComparisonTypeEnumeration.MAXIMUM;
                            break;
                        }
                        case BETTER: {
                            comparison = AuthnContextComparisonTypeEnumeration.BETTER;
                            break;
                        }
                        default: {
                            comparison = AuthnContextComparisonTypeEnumeration.EXACT;
                        }
                    }
                    authnRequest.getRequestedAuthnContext().setComparison(comparison);
                    List<AuthnContextClassRef> refs = authnRequest.getRequestedAuthnContext().getAuthnContextClassRefs();
                    refs.clear();
                    for (String ref : this.samlIdpConfiguration.getAuthnContextClassRef().split("\n")) {
                        if ((ref = ref.trim()).isEmpty()) continue;
                        AuthnContextClassRef accr = new AuthnContextClassRefBuilder().buildObject();
                        accr.setAuthnContextClassRef(ref);
                        refs.add(accr);
                    }
                    break;
                }
            }
            authnRequest.getNameIDPolicy().setAllowCreate(this.samlIdpConfiguration.getAllowCreate() == IdpConfiguration.AllowCreate.TRUE);
            if (this.samlIdpConfiguration.getNameIdFormat() == IdpConfiguration.NameIdFormat.CUSTOM && (customNameIdFormat = this.samlIdpConfiguration.getCustomNameIdFormat()) != null && !customNameIdFormat.trim().isEmpty()) {
                authnRequest.getNameIDPolicy().setFormat(customNameIdFormat.trim());
            }
            return authnRequest;
        }

        @Override
        public Optional<SAMLSessionIdentification> getSessionIdentification(HttpServletRequest req) {
            return Optional.ofNullable(req.getSession(false)).flatMap(session -> Optional.ofNullable((String)session.getAttribute(ServiceProviderFactory.SESSION_IDENTIFICATION_KEY))).map(SessionIdentificationHelper::fromJson);
        }

        @Override
        public SAMLSessionIdentification.ValidationPolicy getSessionIdentificationValidationPolicy() {
            return Optional.ofNullable(this.samlIdpConfiguration.getSessionIdentificationValidationPolicy()).orElse(SAMLSessionIdentification.ValidationPolicy.getDefault());
        }

        @Override
        public void responseValidationFailed(SamlResponseValidationResult result) throws IOException {
            if (this.isTest(result) && result.getAuthnRequestID() != null) {
                ServiceProviderFactory.this.recordTest(result, ResponseEvaluationCode.FAILED_SAML_VALIDATION, null, this.samlIdpConfiguration);
            } else {
                ArrayList<ResultType> resultTypes = new ArrayList<ResultType>();
                for (ValidationResult validationResult : result.getResults()) {
                    resultTypes.add(validationResult.getType());
                }
                String errorCodes = ((Object)resultTypes).toString();
                log.error("SAML response validation failed with the following error codes: " + errorCodes);
                ServiceProviderFactory.this.renderErrors(Collections.singletonList("SAML Response validation failed: " + errorCodes), result);
            }
        }

        @Override
        public void responseValidationSucceded(SamlResponseValidationResult result) throws IOException {
            ArrayList<String> errors = new ArrayList<String>();
            SAMLResponseEvaluationResult evaluationResult = ServiceProviderFactory.this.responseEvaluator.evaluate(this.samlIdpConfiguration, result, this.samlIdpConfiguration.getUsernameAttribute(), this.samlIdpConfiguration.getUserLookupAttribute(), this.samlIdpConfiguration.getUserLookupTransform(), this.samlIdpConfiguration.getCustomNameAttribute(), this.samlIdpConfiguration.getCustomEmailAttribute(), this.samlIdpConfiguration.getCustomUsernameAttributeName(), true);
            if (this.isTest(result)) {
                ServiceProviderFactory.this.recordTest(result, evaluationResult.getCode(), evaluationResult, this.samlIdpConfiguration);
            } else {
                AttributeInfo configuredUsernameAttribute;
                if (!ServiceProviderFactory.this.idpConfManager.isLicenseValid()) {
                    errors.add("Kantega SSO Plugin license is not valid");
                    ServiceProviderFactory.this.renderErrors(errors, result);
                    return;
                }
                PrincipalEntry principalEntry = evaluationResult.getResolvedPrincipalEntry();
                if (evaluationResult.getAttributeInfos().isEmpty()) {
                    errors.add("The response contained no attribute which could be used as usernames");
                    ServiceProviderFactory.this.auditLogFacade.loginFailed(null, "SAML", "The response contained no attribute which could be used as usernames");
                }
                if ((configuredUsernameAttribute = evaluationResult.getConfiguredUsernameAttributeInfo()) == null) {
                    errors.add("The response did not contain the expected SAML username attribute");
                } else if (evaluationResult.isUserDomainRejected()) {
                    String userDomain = evaluationResult.getUserDomain();
                    if (userDomain != null) {
                        errors.add("Identity provider does not allow logging in users from domain @" + userDomain);
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "SAML", "Identity provider does not allow logging in users from domain");
                    } else {
                        errors.add("Identity provider configuration restricts login to usernames with a known domain. The authenticated username does not end with a domain");
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "SAML", "Identity provider configuration restricts login to usernames with a known domain. The authenticated username does not end with a domain");
                    }
                } else {
                    String username = evaluationResult.getSearchedUsername();
                    ServiceProviderFactory.this.responseEvaluator.evaluateGroups(username, this.samlIdpConfiguration.getManagedGroups(), ServiceProviderFactory.this.responseEvaluator.findSamlGroups(result.getAssertions()), evaluationResult.getGroupEvaluation(), this.samlIdpConfiguration.isCreateAllIncomingGroups());
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    Optional<Directory> jitDirectory = ServiceProviderFactory.this.hostApp.findJitDirectory(this.samlIdpConfiguration.getJitDirectory());
                    if (jitDirectory.isPresent()) {
                        if (principalEntry == null) {
                            if (this.samlIdpConfiguration.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE) {
                                principalEntry = this.createUser(jitDirectory.get(), errors, evaluationResult, principalEntry, userRecipe, username);
                            } else {
                                if (this.samlIdpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                                    this.addAuthenticatedAnonymousBrowsingSession(result, username);
                                    return;
                                }
                                errors.add("Account not found in " + ServiceProviderFactory.this.applicationProperties.getDisplayName());
                                ServiceProviderFactory.this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "SAML", "Account not found in " + ServiceProviderFactory.this.applicationProperties.getDisplayName());
                            }
                        } else if (this.userExistInJITDirectory(jitDirectory.get(), evaluationResult)) {
                            if ((principalEntry.getUserState() == PrincipalEntry.UserState.FOUND || principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) && this.samlIdpConfiguration.getUserUpdatePolicy() == IdpConfiguration.UserUpdatePolicy.UPDATE) {
                                this.updateUser(jitDirectory.get(), errors, userRecipe, principalEntry.getUserState() != PrincipalEntry.UserState.INACTIVE);
                            }
                            if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE && this.samlIdpConfiguration.getUserActivatePolicy() == IdpConfiguration.UserActivatePolicy.ACTIVATE) {
                                this.updateUser(jitDirectory.get(), errors, userRecipe, true);
                                Principal p = principalEntry.getPrincipal().get();
                                principalEntry = new PrincipalEntry(p, PrincipalEntry.UserState.FOUND);
                            }
                        }
                    } else {
                        if (this.samlIdpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                            this.addAuthenticatedAnonymousBrowsingSession(result, username);
                            return;
                        }
                        errors.add("Count not create or update user with Just-in-time provisioning (JIT). JIT directory is not specified.");
                    }
                    if (principalEntry != null && principalEntry.getPrincipal().isPresent()) {
                        Principal principal = principalEntry.getPrincipal().get();
                        Directory userDirectory = evaluationResult.getResolvedUserDirectory();
                        if (userDirectory != null && userDirectory.getType() == DirectoryType.CROWD) {
                            try {
                                ServiceProviderFactory.this.authenticateUserInCrowdSSO(principal, userDirectory);
                            }
                            catch (OperationFailedException e) {
                                ServiceProviderFactory.this.renderErrors(Collections.singletonList("Failed to authenticate user in remote Crowd directory"), result);
                                ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", "Failed to authenticate user in remote Crowd directory.");
                                return;
                            }
                        }
                        if (!this.updateGroupMemberships(evaluationResult, principal, username)) {
                            errors.add("Failed updating group memberships for user");
                            ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", "Failed updating group memberships for user.");
                        } else {
                            boolean canLogin;
                            boolean isPrincipalFound;
                            HttpServletRequest request = result.getRequest();
                            boolean bl = isPrincipalFound = principalEntry.getUserState() == PrincipalEntry.UserState.FOUND;
                            if (isPrincipalFound) {
                                ServiceProviderFactory.this.hostApp.publishUserAuthenticatedEvent(principalEntry.getPrincipal().get());
                            }
                            if ((canLogin = ServiceProviderFactory.this.hostApp.canLogin(principal, request)) && isPrincipalFound) {
                                String cookieVal = this.samlIdpConfiguration.getId();
                                HttpSession session = request.getSession();
                                String sessionUsername = (String)session.getAttribute(this.USERNAME_ATTR);
                                session.removeAttribute(this.USERNAME_ATTR);
                                if (sessionUsername != null) {
                                    cookieVal = cookieVal + ":" + sessionUsername;
                                }
                                int maxAge = 31536000;
                                String discoverPath = request.getContextPath() + "/plugins/servlet/no.kantega.saml/discover";
                                this.setLastSamlAccountCookie(cookieVal, maxAge, discoverPath, result.getResponse());
                                ServiceProviderFactory.this.hostApp.authenticateWithProduct(request, result.getResponse(), principal);
                                result.getSessionIdentification().ifPresent(sessionIdentification -> {
                                    String json = SessionIdentificationHelper.toJson(sessionIdentification);
                                    request.getSession(true).setAttribute(ServiceProviderFactory.SESSION_IDENTIFICATION_KEY, (Object)json);
                                });
                                if (ServiceProviderFactory.this.kerbConfManager.isRemembermeCookieEnabled()) {
                                    HttpServletResponse response = result.getResponse();
                                    ServiceProviderFactory.this.hostApp.setRememberMeCookie(request, response, principal.getName());
                                }
                                if (result.getRelayState() != null && !"None".equals(result.getRelayState())) {
                                    ServiceProviderFactory.this.safeRedirect.sendRedirect(result.getRelayState(), request, result.getResponse());
                                } else {
                                    result.getResponse().sendRedirect(request.getContextPath() + "/");
                                }
                                ServiceProviderFactory.this.auditLogFacade.loginSuccess(principal.getName(), "SAML");
                                return;
                            }
                            if (!canLogin) {
                                errors.add(String.format("Account does not have permission to use %s", ServiceProviderFactory.this.applicationProperties.getDisplayName()));
                                ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", String.format("Account does not have permission to use %s", ServiceProviderFactory.this.applicationProperties.getDisplayName()));
                            }
                            if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) {
                                errors.add(String.format("User %s is not active", principal.getName()));
                                ServiceProviderFactory.this.auditLogFacade.loginFailed(principal.getName(), "SAML", "User is not active.");
                            }
                        }
                    } else {
                        if (this.samlIdpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                            this.addAuthenticatedAnonymousBrowsingSession(result, username);
                            return;
                        }
                        errors.add("Principal (account) not found. Unable to authenticate user");
                    }
                }
                ServiceProviderFactory.this.renderErrors(errors, result);
            }
        }

        private void addAuthenticatedAnonymousBrowsingSession(SamlResponseValidationResult result, String username) throws IOException {
            ServiceProviderFactory.this.hostApp.addAuthenticatedAnonymousBrowsingSession(username, this.samlIdpConfiguration, result.getRequest(), result.getResponse());
            ServiceProviderFactory.this.auditLogFacade.loginSuccess(Option.of(username).getOrElse("[anonymous]"), "Authenticated anonymous browsing SAML");
        }

        private boolean userExistInJITDirectory(Directory directory, SAMLResponseEvaluationResult evaluationResult) {
            return directory.getId().equals(evaluationResult.getResolvedUserDirectory().getId());
        }

        private PrincipalEntry createUser(Directory directory, List<String> errors, SAMLResponseEvaluationResult evaluationResult, PrincipalEntry principalEntry, UserRecipe userRecipe, String usernameFromIdp) {
            block9: {
                if (userRecipe != null && userRecipe.isComplete()) {
                    try {
                        if (IdpConfManager.hasRequiredGroupsForCreation(this.samlIdpConfiguration, evaluationResult.getGroupEvaluation().getManagedGroups())) {
                            this.addUser(userRecipe, directory, usernameFromIdp);
                            principalEntry = new PrincipalEntry(ServiceProviderFactory.this.userManager.resolve(userRecipe.getUsername().getValue()), PrincipalEntry.UserState.FOUND);
                            break block9;
                        }
                        errors.add("Account could not be created. User did not have any managed groups in the SAML response from " + this.samlIdpConfiguration.getName());
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "SAML", "Account could not be created. User did not have any managed groups in the SAML response from " + this.samlIdpConfiguration.getName());
                    }
                    catch (Exception e) {
                        UUID uuid = UUID.randomUUID();
                        String message = "Failed creating account for SAML user " + userRecipe.getUsername().getValue() + " in directory \"" + directory.getName() + "\" (Log correlation ID: " + uuid + ")";
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "SAML", message);
                        log.error(message, (Throwable)e);
                        errors.add(message);
                    }
                } else if (userRecipe == null) {
                    errors.add("Account cannot be created because of missing user recipe");
                    ServiceProviderFactory.this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "SAML", "Account can not be created because of missing user recipe.");
                } else {
                    if (userRecipe.getName() == null) {
                        errors.add("Account cannot be created because no name attribute were included in the SAML response");
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "SAML", "Account can not be created because configured name attribute was not included in the SAML response.");
                    }
                    if (userRecipe.getEmail() == null) {
                        errors.add("Account cannot be created because no email attribute was included in the SAML response");
                        ServiceProviderFactory.this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "SAML", "Account can not be created because configured email attribute was not included in the SAML response.");
                    }
                }
            }
            return principalEntry;
        }

        private void updateUser(Directory directory, List<String> errors, UserRecipe userRecipe, boolean isActive) {
            if (userRecipe != null && userRecipe.isComplete()) {
                String username = ServiceProviderFactory.this.hostApp.normalizeUsername(userRecipe.getUsername().getValue());
                String fullname = userRecipe.getName().getValue();
                String email = userRecipe.getEmail().getValue();
                ServiceProviderFactory.this.hostApp.updateUser(directory, username, fullname, email, isActive);
            } else if (userRecipe == null) {
                errors.add("Account cannot be updated because of missing user recipe");
            } else {
                if (userRecipe.getName() == null) {
                    errors.add("Account cannot be updated because no name attributes were included in the SAML response");
                }
                if (userRecipe.getEmail() == null) {
                    errors.add("Account cannot be updated because no email attribute was included in the SAML response");
                }
            }
        }

        @Override
        public void logoutSuccess(SamlLogoutValidationResult result) throws IOException {
            HttpServletResponse res = result.getResponse();
            HttpServletRequest req = result.getRequest();
            String id = this.getIdentityProviderId();
            SAMLIdpConfiguration cfg = ServiceProviderFactory.this.idpConfManager.getSamlIdpById(id);
            String returnUrl = cfg.getSingleLogoutReturnURL();
            if (StringUtils.isNotBlank(returnUrl)) {
                res.sendRedirect(returnUrl);
            } else {
                ServiceProviderFactory.this.logoutAppHelper.dispatchToLogoutConfirmed(req, res, id);
            }
        }

        @Override
        public void invalidateSession(HttpServletRequest req, HttpServletResponse res) {
            ServiceProviderFactory.this.hostApp.invalidateSession(res, req);
        }

        @Override
        public void logoutFailed(SamlLogoutValidationResult result) throws IOException {
            ArrayList errs = new ArrayList();
            HttpServletResponse resp = result.getResponse();
            result.getResults().forEach(r -> {
                String ts = r.getType().name();
                errs.add(ts);
                log.debug("logoutFailed: {} => {}", (Object)ts, (Object)String.join((CharSequence)",", r.getModel().keySet()));
            });
            ServiceProviderFactory.this.renderLogoutErrors(result, resp);
        }

        void setLastSamlAccountCookie(String cookieVal, int maxAge, String discoverPath, HttpServletResponse response) {
            boolean needsSupportForTomcat8 = true;
            if (!needsSupportForTomcat8) {
                Cookie cookie = new Cookie("sml_lst_act", cookieVal);
                cookie.setPath(discoverPath);
                cookie.setComment("HttpOnly");
                cookie.setVersion(0);
                cookie.setMaxAge(maxAge);
                response.addCookie(cookie);
            } else {
                Date expiresDate = new Date(System.currentTimeMillis() + (long)maxAge * 1000L);
                SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.US);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                StringBuilder sb = new StringBuilder();
                sb.append("sml_lst_act=\"").append(cookieVal).append("\"; Version=1; Comment=HttpOnly; Max-Age=").append(maxAge).append("; Expires=").append(df.format(expiresDate)).append("; Path=").append(discoverPath);
                String setCookie = sb.toString();
                response.addHeader("Set-Cookie", setCookie);
            }
        }

        private void addUser(UserRecipe userRecipe, Directory dir, String usernameFromIdp) {
            ServiceProviderFactory.this.hostApp.addUser(dir, ServiceProviderFactory.this.hostApp.normalizeUsername(userRecipe.getUsername().getValue()), userRecipe.getName().getValue(), userRecipe.getEmail().getValue(), this.samlIdpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp));
        }

        boolean updateGroupMemberships(SAMLResponseEvaluationResult evaluationResult, Principal principal, String usernameFromIdp) {
            GroupEvaluation groupEvaluation = evaluationResult.getGroupEvaluation();
            if (this.samlIdpConfiguration.isCreateAllIncomingGroups() && groupEvaluation.syncUserIdpGroups(ServiceProviderFactory.this.hostApp, principal, this.samlIdpConfiguration.isRemoveNonIdpGroupsFromUser(), this.samlIdpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp))) {
                return false;
            }
            if (groupEvaluation.setManagedGroups(ServiceProviderFactory.this.hostApp, principal)) {
                return groupEvaluation.setDefaultGroups(ServiceProviderFactory.this.hostApp, principal, this.samlIdpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp));
            }
            return false;
        }

        @Override
        public int getIssueInstantLifeTimeMs() {
            return 30000;
        }

        @Override
        public boolean isForceAuthn(HttpServletRequest request) {
            return this.isTest(request) && request.getParameter("force") != null;
        }

        @Override
        public String getRelayState(HttpServletRequest request, LogoutRequest logoutRequest) {
            return null;
        }

        @Override
        public String getRelayState(HttpServletRequest request, AuthnRequest authnRequest) {
            String username = request.getParameter("username");
            if (username != null) {
                request.getSession().setAttribute(this.USERNAME_ATTR, (Object)username);
            } else {
                request.getSession().removeAttribute(this.USERNAME_ATTR);
            }
            String target = request.getParameter("target");
            if (target != null) {
                target = target.replaceAll(" ", "%20");
                return target.replaceAll("~", "%7E");
            }
            if (this.isTest(request)) {
                try {
                    String authnRequestFormatted = AtlSpServletSupport.formatXml(XMLObjectSupport.marshall(authnRequest));
                    ServiceProviderFactory.this.idpConfManager.recordTestStarted(this.samlIdpConfiguration.getId(), authnRequest.getID(), authnRequestFormatted, ServiceProviderFactory.this.kerbConfManager.getRemoteIpAddress(request));
                }
                catch (MarshallingException e) {
                    throw new RuntimeException(e);
                }
                return "test";
            }
            return null;
        }

        @Override
        public boolean isEncryptedAssertionsRequired() {
            return this.samlIdpConfiguration.isEncryptedAssertionsRequired();
        }

        @Override
        public boolean isSingleLogoutEnabled() {
            return this.samlIdpConfiguration.isSingleLogoutEnabled();
        }

        @Override
        public String getIdpSingleLogoutServiceURL() {
            return this.samlIdpConfiguration.getSingleLogoutServiceURL();
        }

        private boolean isTest(SamlResponseValidationResult result) {
            return "test".equals(result.getRelayState());
        }

        private boolean isTest(HttpServletRequest request) {
            return TestUtils.isTest(request);
        }
    }
}

