/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.web.context.HttpContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

@Scanned
public class SSOScriptLoginHookCondition
implements Condition {
    private final HostApp hostApp;
    private final IdpConfManager idpConfManager;
    private final HttpContext httpContext;
    private Set<String> products;

    @Inject
    public SSOScriptLoginHookCondition(@ComponentImport HttpContext httpContext, HostAppFactory hostAppFactory, IdpConfManager idpConfManager) {
        this.hostApp = hostAppFactory.getInstance();
        this.idpConfManager = idpConfManager;
        this.httpContext = httpContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String products = params.get("products");
        if (products != null) {
            this.products = new HashSet<String>();
            for (String product : products.split(",")) {
                if ((product = product.trim()).isEmpty()) continue;
                this.products.add(product);
            }
        }
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        HttpServletRequest request = this.httpContext.getRequest();
        return this.shouldAddLoginScripts(request);
    }

    public boolean shouldDoFederatedSSO(HttpServletRequest request) {
        return !this.querystringHasNosaml(request) && !this.hostApp.isRestApi(HttpUrlUtils.getInternalPath(request)) && this.isProductMatch() && this.idpConfManager.isSamlEnabled() && this.idpConfManager.isLicenseValid() && this.idpConfManager.countActiveProviders() > 0;
    }

    public boolean shouldAddLoginScripts(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        boolean isLoginPage = this.hostApp.isPageWithLoginForm(request, requestURI.substring(request.getContextPath().length()));
        return isLoginPage && this.shouldDoFederatedSSO(request);
    }

    private boolean querystringHasNosaml(HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), "nosaml");
    }

    private boolean isProductMatch() {
        if (this.products == null) {
            return true;
        }
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }
}

