/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SSOScriptLoginHookCondition;
import org.kantega.atlaskerb.saml.ServiceDeskSignupFilter;
import org.kantega.atlaskerb.saml.util.ScriptInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefinedMobileLoginFilter
implements Filter {
    private final TemplateRenderer templateRenderer;
    private final SSOScriptLoginHookCondition SSOScriptLoginHookCondition;
    private final HostApp hostApp;
    private final KerbConfManager kerbConfManager;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean enableFederatedSSO;
    private boolean manualLogin;
    private int samlRedirectDelay;
    private String emailFromHeader;

    @Inject
    public RefinedMobileLoginFilter(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport HttpContext httpContext, HostAppFactory hostAppFactory, IdpConfManager idpConfManager, KerbConfManager kerbConfManager, UserLookupService userLookupService) {
        this.hostApp = hostAppFactory.getInstance();
        this.templateRenderer = templateRenderer;
        this.kerbConfManager = kerbConfManager;
        this.SSOScriptLoginHookCondition = new SSOScriptLoginHookCondition(httpContext, hostAppFactory, idpConfManager);
        this.samlRedirectDelay = idpConfManager.getRedirectProgressDelay();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.emailFromHeader = ServiceDeskSignupFilter.getEmailFromHeader(req, this.kerbConfManager);
        this.enableFederatedSSO = this.SSOScriptLoginHookCondition.shouldDoFederatedSSO(req);
        this.manualLogin = this.hostApp.shouldLoginManually(req, resp);
        CharResponseWrapper wrapper = new CharResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrapper);
        PrintWriter responseWriter = response.getWriter();
        if (wrapper.getContentType().contains("text/html")) {
            CharArrayWriter charWriter = new CharArrayWriter();
            String originalContent = wrapper.toString();
            int bodyTagIndex = originalContent.indexOf("</body>") - 1;
            charWriter.write(originalContent.substring(0, bodyTagIndex));
            ScriptInjector scriptInjector = new ScriptInjector(this.templateRenderer, this.kerbConfManager, req.getContextPath());
            charWriter.write(scriptInjector.prepareInjectScript(this.kerbConfManager.isTraditionalLoginDisabled(), this.enableFederatedSSO, this.manualLogin, this.samlRedirectDelay, this.emailFromHeader).toString());
            charWriter.write("<script>\nwindow.addEventListener(\"load\", function () {\n  if (\"MutationObserver\" in window) {\n    var obs = new MutationObserver(function (mutations, observer) {\n      console.log(\"Observed mutation design fix\");\n      var formNode = document.getElementById('workAccountForm');\n       formNode.classList.add(\"form-buttons\");\n       var bar = document.getElementsByClassName('bar-fill');\n      var button = document.getElementById('loginMainButton');      bar[0].style.backgroundColor =         window.getComputedStyle(button).getPropertyValue('color')\n    });      obs.observe(document.body, {childList: true, subtree: true});\n  }\n});\n</script>");
            charWriter.write(originalContent.substring(bodyTagIndex));
            String alteredContent = charWriter.toString();
            response.setContentLength(alteredContent.length());
            responseWriter.write(alteredContent);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private class CharResponseWrapper
    extends HttpServletResponseWrapper {
        private CharArrayWriter writer;

        public CharResponseWrapper(HttpServletResponse response) {
            super(response);
            this.writer = new CharArrayWriter();
        }

        public PrintWriter getWriter() {
            return new PrintWriter(this.writer);
        }

        public String toString() {
            return this.writer.toString();
        }
    }
}

