/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.regextranformation.RegexTransformationResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class IdpUserLookupServlet
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(IdpUserLookupServlet.class);
    private static final String JOHN_DOE_EXAMPLE_COM = "john.doe@example.com";
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private IdpConfiguration configuration;
    private String requestId;

    @Inject
    public IdpUserLookupServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.requestId = this.getId(req);
        this.configuration = this.idpConfManager.getIdentityProviderById(this.requestId);
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        if (this.configuration == null) {
            resp.sendError(404);
            return;
        }
        this.configuration = this.idpConfManager.getIdentityProviderById(this.getId(req));
        JSONArray regexTransformations = new JSONArray();
        List<Pair<String, String>> regexTuples = this.configuration.getUserTransformationRegexes();
        List<RegexTransformationResult> validations = UserMappingUtils.regexTransformations(JOHN_DOE_EXAMPLE_COM, regexTuples);
        validations.forEach(result -> regexTransformations.put(result.toJson()));
        Optional<String> transformedUsername = UserMappingUtils.transformUsername(JOHN_DOE_EXAMPLE_COM, regexTuples);
        model.put("regexTransformationsWithHtml", regexTransformations.toString());
        model.put("userPrincipalName", JOHN_DOE_EXAMPLE_COM);
        model.put("regexTuples", regexTuples);
        model.put("noTransformation", IdpConfiguration.UserLookupTransform.NONE.toString());
        model.put("namePartTransformation", IdpConfiguration.UserLookupTransform.NAME_PART.toString());
        model.put("regexTransformation", IdpConfiguration.UserLookupTransform.REGEX.toString());
        model.put("selectedUserLookupTransform", this.configuration.getUserLookupTransform().toString());
        model.put("transformedUsername", transformedUsername.orElse("<no match>"));
        model.put("topMenu", "SAML");
        model.put("menuItem", "userLookupSettings");
        model.put("usernameAttributes", IdpConfiguration.UsernameAttribute.values());
        model.put("customUsernameAttributeName", this.configuration.getCustomUsernameAttributeName());
        model.put("idp", this.configuration);
        model.put("samlConfigURL", this.idpConfManager.getIdpConfigUrl(req));
        model.put("serviceURL", this.idpConfManager.getServiceProviderLoginURL(req, this.requestId));
        model.put("testingURL", this.idpConfManager.getServiceProviderTestURL(req, this.requestId));
        model.put("metadataURL", this.idpConfManager.getServiceProviderMetadataURL(req, this.requestId));
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("canAddUser", this.hostApp.canAddUser());
        model.put("defaultGroups", this.idpConfManager.commaSeparated(this.configuration.getDefaultGroups()));
        model.put("serverName", req.getServerName());
        model.put("test", req.getParameter("test"));
        this.getTemplateRenderer().render("templates/saml/saml-idp-user-lookup.vm", model, (Writer)resp.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }

    private List<Pair<String, String>> processRegexTuples(HttpServletRequest req) {
        int rowNumber = 0;
        ArrayList<Pair<String, String>> inputRegexTuples = new ArrayList<Pair<String, String>>();
        String regexLookup = req.getParameter("regexLookup" + rowNumber);
        String regexReplacement = req.getParameter("regexReplacement" + rowNumber);
        if (!StringUtils.isEmpty(regexLookup) && !StringUtils.isEmpty(regexReplacement)) {
            inputRegexTuples.add(Pair.of(regexLookup, regexReplacement));
        }
        while (regexLookup != null && regexReplacement != null) {
            regexLookup = req.getParameter("regexLookup" + ++rowNumber);
            regexReplacement = req.getParameter("regexReplacement" + rowNumber);
            if (StringUtils.isEmpty(regexLookup) && StringUtils.isEmpty(regexReplacement)) continue;
            inputRegexTuples.add(Pair.of(regexLookup, regexReplacement));
        }
        return inputRegexTuples;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = this.getId(req);
        String action = req.getParameter("action");
        if ("editUserLookupSettings".equals(action)) {
            IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(this.idpConfManager.getIdentityProviderById(id));
            Optional.ofNullable(req.getParameter("usernameAttr")).map(StringUtils::trim).map(IdpConfiguration.UsernameAttribute::valueOf).ifPresent(builder::setUsernameAttribute);
            Optional.ofNullable(req.getParameter("userLookupAttribute")).map(StringUtils::trim).map(IdpConfiguration.UserLookupAttribute::valueOf).ifPresent(builder::setUserLookupAttribute);
            Optional.ofNullable(req.getParameter("customUsernameAttributeName")).map(StringUtils::trim).filter(StringUtils::isNotBlank).ifPresent(builder::setCustomUsernameAttributeName);
            IdpConfiguration.UserLookupTransform userLookupTransform = IdpConfiguration.UserLookupTransform.valueOf(StringUtils.trim(req.getParameter("userLookupTransform")));
            builder.setUserLookupTransform(userLookupTransform);
            List<Pair<String, String>> regexTuples = this.processRegexTuples(req);
            if (userLookupTransform == IdpConfiguration.UserLookupTransform.REGEX && !regexTuples.isEmpty()) {
                builder.setUserTransformationRegexes(regexTuples);
            }
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        Map<String, Object> model = this.newModel(req);
        this.renderPage(req, resp, model);
    }
}

