/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlXMLParser;

@Scanned
public class IdpRedirectRulesServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private final Set<String> tabs = new HashSet<String>(Arrays.asList("location", "accounts", "domains", "idpsetup"));

    @Inject
    public IdpRedirectRulesServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        String id = this.getId(req);
        model.put("isJsdInstalled", this.kerbConfManager.isJsdInstalled());
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        model.put("redirectProgressDelay", this.idpConfManager.getRedirectProgressDelay());
        model.put("loginEnabledForJSD", this.idpConfManager.getLoginEnabledForJSD());
        model.put("multipleProviders", this.idpConfManager.getIdentityProviders().size() > 1);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        List<IdpConfiguration.RedirectPolicy> exclusiveRedirectPolicies = Arrays.asList(IdpConfiguration.RedirectPolicy.HARD, IdpConfiguration.RedirectPolicy.ALL);
        Collection idpConfigurations = this.idpConfManager.getIdentityProviders().stream().filter(config -> config.isEnabled()).collect(Collectors.toList());
        List exclusiveConfigurations = idpConfigurations.stream().filter(config -> exclusiveRedirectPolicies.contains((Object)config.getRedirectPolicy())).collect(Collectors.toList());
        List activeNonExclusiveConfigurations = idpConfigurations.stream().filter(config -> {
            if (config.getRedirectPolicy() == IdpConfiguration.RedirectPolicy.NONE) {
                return false;
            }
            return !exclusiveConfigurations.contains(config);
        }).collect(Collectors.toList());
        if (exclusiveConfigurations.size() > 0) {
            model.put("exclusiveConfigurations", exclusiveConfigurations);
            if (exclusiveConfigurations.size() > 1) {
                model.put("warningMultipleExclusiveConfigurations", true);
            }
            if (activeNonExclusiveConfigurations.size() > 0) {
                model.put("warningUnusedActiveConfigurations", true);
                model.put("activeNonExclusiveConfigurations", activeNonExclusiveConfigurations);
            }
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "redirect-rules");
        model.put("idp", configuration);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("knownDomains", configuration.getKnownDomains());
        model.put("multipleDomains", configuration.getKnownDomains().size() > 1);
        model.put("matchedUserDirectoryIds", configuration.getMatchedUserDirectoryIds());
        model.put("userDirectories", this.userLookupService.getActiveUserDirectories());
        model.put("redirectGroups", this.idpConfManager.commaSeparated(configuration.getRedirectGroups()));
        model.put("noAutoSsoUrl", this.hostApp.getLoginPage() + "?noautosso");
        model.put("noSAMLUrl", this.hostApp.getLoginPage() + "?nosaml");
        this.getTemplateRenderer().render("templates/saml/saml-idp-redirect-rules.vm", model, (Writer)resp.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = this.getId(req);
        String redirectPolicyString = req.getParameter("redirectPolicy");
        if (redirectPolicyString == null) {
            redirectPolicyString = IdpConfiguration.RedirectPolicy.ALL.name();
        }
        IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(this.idpConfManager.getIdentityProviderById(id));
        IdpConfiguration.RedirectPolicy redirectPolicy = IdpConfiguration.RedirectPolicy.valueOf(redirectPolicyString);
        builder.setRedirectPolicy(redirectPolicy);
        builder.setVisible(req.getParameter("visible") != null);
        if (redirectPolicy == IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN || redirectPolicy == IdpConfiguration.RedirectPolicy.USER_DIRECTORY || redirectPolicy == IdpConfiguration.RedirectPolicy.USER_GROUP) {
            builder.setKnownAutoRedirect(req.getParameter("knownAutoRedirect") != null);
            builder.setSendLoginHint(req.getParameter("sendLoginHint") != null);
        }
        LinkedHashSet<Long> matching = new LinkedHashSet<Long>();
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            if (req.getParameter("directory_" + directory.getId()) == null) continue;
            matching.add(directory.getId());
        }
        builder.setMatchedUserDirectoryIds(matching);
        String redirectGroupsParam = req.getParameter("redirectGroups");
        LinkedHashSet<String> redirectGroups = SamlXMLParser.parseSet(redirectGroupsParam);
        builder.setRedirectGroups(redirectGroups);
        this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        this.idpConfManager.setLoginEnabledForJSD("on".equals(req.getParameter("loginEnabledForJSD")));
        this.idpConfManager.setRedirectProgressDelay(req.getParameter("redirectProgressDelay"));
        resp.sendRedirect("redirect-rules");
    }
}

