/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;

@Scanned
public class IdpKnownDomainsServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final Set<String> tabs = new HashSet<String>(Arrays.asList("location", "accounts", "domains", "idpsetup"));

    @Inject
    public IdpKnownDomainsServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        String id = this.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        String tab = req.getParameter("tab");
        if (tab != null && this.tabs.contains(tab)) {
            model.put("activeTab", tab);
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "domains");
        model.put("idp", configuration);
        model.put("ssoProtocol", (Object)configuration.getProtocol());
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("allowedDomains", this.idpConfManager.commaSeparated(configuration.getKnownDomains()));
        model.put("hostedDomainEnabled", configuration.isHostedDomain());
        this.getTemplateRenderer().render("templates/saml/saml-idp-known-domains.vm", model, (Writer)resp.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String id = this.getId(req);
        IdpConfiguration existing = this.idpConfManager.getIdentityProviderById(id);
        String usernamePolicyParam = req.getParameter("usernamePolicy");
        IdpConfiguration.UsernamePolicy usernamePolicy = IdpConfiguration.UsernamePolicy.valueOf(usernamePolicyParam);
        String knownDomainsParam = req.getParameter("knownDomains");
        LinkedHashSet<String> knownDomains = this.parseSet(knownDomainsParam);
        boolean hostedDomainEnabled = "on".equals(req.getParameter("hostedDomainEnabled"));
        IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(existing);
        builder.setUsernamePolicy(usernamePolicy);
        builder.setKnownDomains(knownDomains);
        builder.setHostedDomain(hostedDomainEnabled);
        this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        resp.sendRedirect("domains");
    }

    private LinkedHashSet<String> parseSet(String defaultGroupsParam) {
        LinkedHashSet<String> defaultGroups = new LinkedHashSet<String>();
        if (defaultGroupsParam != null) {
            for (String g : defaultGroupsParam.split(",")) {
                if ((g = g.trim()).isEmpty()) continue;
                defaultGroups.add(g);
            }
        }
        return defaultGroups;
    }
}

