/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.saml.IdpConfManager;

@Scanned
public class IdpGroupsServlet
extends RequireAdminServlet {
    private final UserManager userManager;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final ApplicationProperties applicationProperties;

    @Inject
    public IdpGroupsServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException, ServletException {
        String query = req.getParameter("query");
        if (query != null) {
            IdpGroupsServlet.printGroupsAsJson(resp, query, this.userManager);
        } else {
            resp.setContentType("text/html");
            String id = this.getId(req);
            IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
            if (configuration == null) {
                resp.sendError(404);
                return;
            }
            model.put("topMenu", "SAML");
            model.put("menuItem", "managedGroups");
            model.put("idp", configuration);
            model.put("displayName", this.applicationProperties.getDisplayName());
            model.put("test", req.getParameter("test"));
            model.put("changed", req.getParameter("changed") != null);
            model.put("userTestURL", this.idpConfManager.getServiceProviderNonAdminTestURL(req, id));
            model.put("groupTool", new GroupTool(this.hostApp));
            model.put("managedGroupsRequiredForCreatedUsers", configuration.isManagedGroupsRequiredForJITCreation() && configuration.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE);
            model.put("userNotFoundPolicy", (Object)configuration.getUserNotFoundPolicy());
            this.getTemplateRenderer().render("templates/saml/idp-groups.vm", model, (Writer)resp.getWriter());
        }
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ManagedGroup mg;
        Set<String> existing;
        boolean changingRemoveNonIdpGroupsFromUser;
        String idpId = this.getId(req);
        String addManagedGroup = req.getParameter("addManagedGroup");
        String removeManagedGroup = req.getParameter("removeManagedGroup");
        String saveRegexDefaultGroup = req.getParameter("saveRegexDefaultGroup");
        String regexValue = req.getParameter("regexValue");
        String addDefaultGroup = req.getParameter("addDefaultGroup");
        String removeDefaultGroup = req.getParameter("removeDefaultGroup");
        String addGroupParameter = req.getParameter("addGroupParameter");
        String removeGroupParameter = req.getParameter("removeGroupParameter");
        IdpConfiguration previousConf = this.idpConfManager.getIdentityProviderById(idpId);
        IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(previousConf);
        String createAllIncomingGroups = req.getParameter("createAllIncomingGroups");
        if (createAllIncomingGroups != null) {
            builder.setCreateAllIncomingGroups("true".equalsIgnoreCase(createAllIncomingGroups));
        }
        if (changingRemoveNonIdpGroupsFromUser = "true".equalsIgnoreCase(req.getParameter("changingRemoveNonIdpGroupsFromUser"))) {
            builder.setremoveNonIdpGroupsFromUser("on".equalsIgnoreCase(req.getParameter("removeNonIdpGroupsFromUser")));
        } else if ("false".equalsIgnoreCase(createAllIncomingGroups)) {
            builder.setremoveNonIdpGroupsFromUser(false);
        }
        if (addGroupParameter != null) {
            existing = builder.getIdpGroupsAttributes();
            existing.add(addGroupParameter);
        }
        if (removeGroupParameter != null) {
            existing = builder.getIdpGroupsAttributes();
            existing.remove(removeGroupParameter);
        }
        if (addManagedGroup != null) {
            mg = new ManagedGroup(addManagedGroup);
            builder.getManagedGroups().add(mg);
        } else if (removeManagedGroup != null) {
            mg = new ManagedGroup(removeManagedGroup);
            builder.getManagedGroups().remove(mg);
        } else if (addDefaultGroup != null) {
            builder.getDefaultGroups().add(addDefaultGroup);
        } else if (removeDefaultGroup != null) {
            builder.getDefaultGroups().remove(removeDefaultGroup);
        } else {
            boolean isManagedGroupsRequiredForCreatedUsers = "on".equalsIgnoreCase(req.getParameter("managedGroupsRequiredForCreatedUsers"));
            builder.setManagedGroupsRequiredForJITCreation(isManagedGroupsRequiredForCreatedUsers);
        }
        if (saveRegexDefaultGroup != null) {
            Map<String, String> rules = previousConf.getDefaultGroupsRules();
            if (StringUtils.isBlank(regexValue)) {
                rules.remove(saveRegexDefaultGroup);
            } else {
                rules.put(saveRegexDefaultGroup, regexValue.trim());
            }
            builder.setDefaultGroupsRules(rules);
        }
        this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        resp.sendRedirect("groups");
    }

    public static void printGroupsAsJson(HttpServletResponse resp, String query, UserManager userManager) throws IOException {
        resp.setContentType("application/json");
        PrintWriter w = resp.getWriter();
        JSONObject jsonObject = new JSONObject();
        LinkedHashSet groupNames = new LinkedHashSet();
        for (String groupName : userManager.findGroupNamesByPrefix(query, 0, 100)) {
            TreeMap<String, String> group = new TreeMap<String, String>();
            group.put("id", groupName);
            group.put("name", groupName);
            groupNames.add(group);
        }
        jsonObject.put("groups", groupNames);
        w.print(jsonObject);
    }

    public static class GroupTool {
        private final HostApp hostApp;

        public GroupTool(HostApp hostApp) {
            this.hostApp = hostApp;
        }

        public boolean isExistingGroup(String name) {
            return this.hostApp.isExistingGroup(name);
        }
    }
}

