/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.kantegasso.jsonmapping.JsonMapping;
import com.kantegasso.oidc.OidcProcedureData;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.FederatedIdentityResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.GroupResult;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OIDCResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OidcTestRecord;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluationResult;
import org.kantega.atlaskerb.saml.AddIdpAction;
import org.kantega.atlaskerb.saml.Fingerprint;
import org.kantega.atlaskerb.saml.IdpDraft;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;
import org.kantega.atlaskerb.saml.SamlXMLParser;
import org.kantega.atlaskerb.saml.TestRecord;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.samllib.OpenSamlInit;
import org.kantega.samllib.tools.SamlKeyGenerator;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class IdpConfManager
implements DebugInfo {
    public final String IDENTITY_PROVIDERS_URL_ROOT = "providers";
    static final String ENCRYPTED_ASSERTIONS_REQUIRED = "encryptedAssertionsRequired";
    static final String USE_POST_BINDING = "usePostBinding";
    static final String SINGLE_LOGOUT_SERVICE_URL = "singleLogoutServiceURL";
    static final String SINGLE_LOGOUT_RETURN_URL = "singleLogoutReturnURL";
    private static final String IDP_URL = "idpURL";
    private static final String METADATA_URL = "metadataURL";
    private static final String SINGLE_LOGOUT_ENABLED = "singleLogoutEnabled";
    private static final String TLS_FINGERPRINT = "tlsFingerprint";
    private static final String NAME = "name";
    private static final String PROVIDER_ELEM = "provider";
    private static final String USER_NOT_FOUND_POLICY = "userNotFoundPolicy";
    private static final String USER_UPDATE_POLICY = "userUpdatePolicy";
    private static final String USER_ACTIVATE_POLICY = "userActivatePolicy";
    private static final String DEFAULT_GROUPS = "defaultGroups";
    private static final String DEFAULT_GROUPS_RULES = "defaultGroupsRules";
    private static final String KNOWN_DOMAINS = "knownDomains";
    private static final String AUTO_UPDATE_KNOWN_DOMAINS = "autoAddKnownDomains";
    private static final String REDIRECT_GROUPS = "redirectGroups";
    private static final String JIT_DIRECTORY = "jitDirectory";
    private static final String ENABLED = "enabled";
    private static final String USERNAME_ATTRIBUTE = "usernameAttribute";
    private static final String SELECTED_USERNAME_ATTRIBUTE_INFO = "selectedUsernameAttributeInfo";
    private static final String CUSTOM_USERNAME_ATTRIBUTE_NAME = "customUsernameAttributeName";
    private static final int DAY = 86400000;
    private static final String TEST_NOTIFICATIONS_EMAIL = "testNotificationEmailAddresses";
    private static final String USERNAME_POLICY = "usernamePolicy";
    private static final String REDIRECT_POLICY = "redirectPolicy";
    private static final String CERTIFICATE = "certificate";
    private static final String VISIBLE = "visible";
    private static final String HOSTED_DOMAIN = "hostedDomain";
    private static final String SEND_LOGIN_HINT = "sendLoginHint";
    private static final String USER_LOOKUP_ATTRIBUTE = "userLookupAttribute";
    private static final String USER_LOOKUP_TRANSFORM = "userLookupTransform";
    private static final String KIND = "kind";
    private static final String PROTOCOL = "protocol";
    private static final String BASE_URL = "baseURL";
    private static final String SAML_STATE_ID = "samlStateId";
    private static final String CUSTOM_NAME_ATTRIBUTE = "customNameAttribute";
    private static final String CUSTOM_EMAIL_ATTRIBUTE = "customEmailAttribute";
    private static final String REQUESTED_AUTHN_CONTEXT_POLICY = "requestedAuthnContextPolicy";
    private static final String REQUESTED_AUTHN_CONTEXT_COMPARISON = "requestedAuthnContextComparison";
    private static final String AUTHN_CONTEXT_CLASS_REF = "authnContextClassRef";
    private static final String ISSUER_POLICY = "issuerPolicy";
    private static final String ISSUER = "issuer";
    private static final String CREATE_ALL_INCOMING_GROUPS = "createAllIncomingGroups";
    private static final String REMOVE_NON_IDP_GROUPS_FROM_USER = "removeNonIdpGroupsFromUser";
    private static final String MANAGED_GROUP = "managedGroup";
    private static final String MANAGED_GROUPS_REQUIRED_FOR_USER_CREATION = "atLeastOneManagedGroupRequiredForJITCreation";
    private static final String MATCHED_USER_DIRECTORIES = "userDirectories";
    private static final String ALLOW_CREATE = "allowCreate";
    private static final String NAMEID_FORMAT = "nameIdFormat";
    private static final String CUSTOM_NAMEID_FORMAT = "customNameIdFormat";
    private static final String REDIRECT_CUSTOM_PROGRESS_DELAY = "redirectCustomProgressDelay";
    private static final String LOGIN_ENABLED_FOR_JSD = "loginEnabledForJSD";
    private static final String REGEX_TUPLES = "regexTuples";
    private static final String KNOWN_AUTO_REDIRECT = "knownAutoRedirect";
    private static final String SESSION_IDENTIFICATION_VALIDATION_POLICY = "sessionIdentificationValidationPolicy";
    private static final String AUTO_REFRESH_METADATA_ENABLED = "autoRefreshMetadataEnabled";
    private static final String IDP_GROUPS_ATTRIBUTE = "idpGroupsAttribute";
    private static final String AUTHENTICATED_ANONYMOUS_BROWSING_ENABLED = "authenticatedAnonymousBrowsingEnabled";
    private static final String OIDC_CLIENT_ID = "oidcClientId";
    private static final String OIDC_CLIENT_SECRET = "oidcClientSecret";
    private static final String OIDC_CLIENT_SECRET_EXPIRY = "oidcClientSecretExpiry";
    private static final String OIDC_DISCOVERY_URL = "oidcDiscoveryUrl";
    private static final String OIDC_SCOPES = "oidcScopes";
    private static final String OIDC_ISSUER_ALLOWLIST = "oidcIssuerAllowList";
    private static final Logger log = LoggerFactory.getLogger(IdpConfManager.class);
    private final HostApp hostApp;
    private final ApplicationProperties applicationProperties;
    private final PluginSettings settings;
    private final PluginLicenseManager pluginLicenseManager;
    private final OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper;
    private final AtomicReference<ProviderState> state = new AtomicReference();
    private final SecureRandom secureRandom = new SecureRandom();

    @Inject
    public IdpConfManager(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PluginLicenseManager pluginLicenseManager, OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper, HostAppFactory hostAppFactory) {
        this.hostApp = hostAppFactory.getInstance();
        this.applicationProperties = applicationProperties;
        this.pluginLicenseManager = pluginLicenseManager;
        this.oidcProcedureFactoryWrapper = oidcProcedureFactoryWrapper;
        OpenSamlInit.init();
        this.settings = pluginSettingsFactory.createGlobalSettings();
        this.readState();
    }

    public static boolean hasRequiredGroupsForCreation(IdpConfiguration idp, Collection<GroupResult> groups2) {
        boolean idpConfiguredWithManagedGroups = !idp.getManagedGroups().isEmpty();
        boolean responseContainsManagedGroup = groups2.stream().anyMatch(GroupResult::isIdpGroupMember);
        boolean isManagedGroupsRequiredForJITCreation = idp.isManagedGroupsRequiredForJITCreation();
        if (isManagedGroupsRequiredForJITCreation && (idpConfiguredWithManagedGroups || idp.isCreateAllIncomingGroups())) {
            return responseContainsManagedGroup;
        }
        return true;
    }

    public Map<String, String> getSettings() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (KEYS keys2 : KEYS.values()) {
            Object value = this.settings.get(keys2.key);
            if (!(value instanceof String)) continue;
            result.put(keys2.key, (String)value);
        }
        return result;
    }

    public void restoreSettings(Properties props) {
        for (KEYS keys2 : KEYS.values()) {
            this.settings.remove(keys2.key);
        }
        for (KEYS keys2 : KEYS.values()) {
            String value = props.getProperty(keys2.key);
            if (value == null) continue;
            this.settings.put(keys2.key, (Object)value);
        }
        this.updateStateId();
        this.currentState();
    }

    public void readState() {
        this.state.set(this.getState(this.currentStateId()));
    }

    private String currentStateId() {
        return (String)this.settings.get(KEYS.SAML_STATE_ID.key);
    }

    private void updateStateId() {
        String nextId = UUID.randomUUID().toString();
        this.settings.put(KEYS.SAML_STATE_ID.key, (Object)nextId);
    }

    private ProviderState getState(String stateId) {
        return new ProviderState(stateId, this.readIdpConfigurations());
    }

    public Collection<IdpConfiguration> getIdentityProviders() {
        return this.currentState().getIdpConfigurations();
    }

    private ProviderState currentState() {
        String currentStateId;
        ProviderState cachedState = this.state.get();
        if (!cachedState.isCurrent(currentStateId = this.currentStateId())) {
            ProviderState nextState = this.getState(currentStateId);
            if (this.state.compareAndSet(cachedState, nextState)) {
                return nextState;
            }
            return this.state.get();
        }
        return cachedState;
    }

    private Collection<IdpConfiguration> readIdpConfigurations() {
        File providersDir = this.getProvidersDirectory();
        if (!providersDir.exists()) {
            return Collections.emptyList();
        }
        File[] providerDirs = providersDir.listFiles(file -> file.isDirectory() && this.getProviderXmlFile(file).exists());
        if (providerDirs == null) {
            return Collections.emptyList();
        }
        ArrayList<IdpConfiguration> configurations = new ArrayList<IdpConfiguration>();
        for (File providerDir : providerDirs) {
            File providerXmlFile = this.getProviderXmlFile(providerDir);
            try {
                IdpConfiguration provider = this.parseIdpProvider(providerXmlFile);
                configurations.add(provider);
            }
            catch (Exception e) {
                log.error("Exception parsing provider xml file: " + providerXmlFile.getAbsolutePath(), (Throwable)e);
            }
        }
        configurations.sort(Comparator.comparing(IdpConfiguration::getName));
        return configurations;
    }

    private File getProviderXmlFile(File providerDir) {
        return new File(providerDir, "provider.xml");
    }

    private IdpConfiguration parseIdpProvider(File providerFile) {
        Node tuplesNode;
        String issuer;
        SAMLIdpConfiguration.RequestedAuthnContextPolicy requestedAuthnContextPolicy;
        String usernamePolicyName;
        Document doc = SamlXMLParser.parseProviderDocument(providerFile);
        Element element = doc.getDocumentElement();
        String name = element.getAttribute(NAME);
        String idpURL = element.getAttribute(IDP_URL);
        String userNotFoundPolicyName = element.getAttribute(USER_NOT_FOUND_POLICY);
        IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy = IdpConfiguration.UserNotFoundPolicy.REJECT;
        if (StringUtils.isNotBlank(userNotFoundPolicyName)) {
            userNotFoundPolicy = IdpConfiguration.UserNotFoundPolicy.valueOf(userNotFoundPolicyName);
        }
        String userUpdatePolicyName = element.getAttribute(USER_UPDATE_POLICY);
        IdpConfiguration.UserUpdatePolicy userUpdatePolicy = IdpConfiguration.UserUpdatePolicy.NONE;
        if (StringUtils.isNotBlank(userUpdatePolicyName)) {
            userUpdatePolicy = IdpConfiguration.UserUpdatePolicy.valueOf(userUpdatePolicyName);
        }
        String userActivatePolicyName = element.getAttribute(USER_ACTIVATE_POLICY);
        IdpConfiguration.UserActivatePolicy userActivatePolicy = IdpConfiguration.UserActivatePolicy.NONE;
        if (StringUtils.isNotBlank(userActivatePolicyName)) {
            userActivatePolicy = IdpConfiguration.UserActivatePolicy.valueOf(userActivatePolicyName);
        }
        String customUsernameAttributeName = element.getAttribute(CUSTOM_USERNAME_ATTRIBUTE_NAME);
        LinkedHashSet<String> defaultGroups = SamlXMLParser.parseSet(element.getAttribute(DEFAULT_GROUPS));
        Map defaultGroupsRules = JsonMapping.Read.stringMapFromJson(element.getAttribute(DEFAULT_GROUPS_RULES)).getOrElse(new HashMap());
        LinkedHashSet<String> knownDomains = SamlXMLParser.parseSet(element.getAttribute(KNOWN_DOMAINS));
        boolean autoUpdateKnownDomains = "true".equals(element.getAttribute(AUTO_UPDATE_KNOWN_DOMAINS));
        LinkedHashSet<String> redirectGroups = SamlXMLParser.parseSet(element.getAttribute(REDIRECT_GROUPS));
        String metadataURL = element.getAttribute(METADATA_URL);
        String tlsFingerprint = element.getAttribute(TLS_FINGERPRINT);
        String id = providerFile.getParentFile().getName();
        boolean enabled = !"false".equals(element.getAttribute(ENABLED));
        boolean singleLogoutEnabled = Boolean.parseBoolean(element.getAttribute(SINGLE_LOGOUT_ENABLED));
        String singleLogoutserviceURL = element.getAttribute(SINGLE_LOGOUT_SERVICE_URL);
        String singleLogoutReturnURL = element.getAttribute(SINGLE_LOGOUT_RETURN_URL);
        boolean authenticatedAnonymousBrowsingEnabled = Boolean.parseBoolean(element.getAttribute(AUTHENTICATED_ANONYMOUS_BROWSING_ENABLED));
        SAMLSessionIdentification.ValidationPolicy sessionIdentificationValidationPolicy = Optional.ofNullable(element.getAttribute(SESSION_IDENTIFICATION_VALIDATION_POLICY)).filter(StringUtils::isNotBlank).map(SAMLSessionIdentification.ValidationPolicy::valueOf).orElse(null);
        String notificationEmails = element.getAttribute(TEST_NOTIFICATIONS_EMAIL);
        if (notificationEmails.isEmpty()) {
            notificationEmails = null;
        }
        IdpConfiguration.UsernamePolicy usernamePolicy = StringUtils.isBlank(usernamePolicyName = element.getAttribute(USERNAME_POLICY)) ? IdpConfiguration.UsernamePolicy.ANY : IdpConfiguration.UsernamePolicy.valueOf(usernamePolicyName);
        boolean encryptedAssertionsRequired = Optional.ofNullable(element.getAttribute(ENCRYPTED_ASSERTIONS_REQUIRED)).map(Boolean::valueOf).orElse(false);
        boolean usePostBinding = Optional.ofNullable(element.getAttribute(USE_POST_BINDING)).map(Boolean::valueOf).orElse(false);
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        NodeList certList = element.getElementsByTagName(CERTIFICATE);
        for (int i = 0; i < certList.getLength(); ++i) {
            Element certE = (Element)certList.item(i);
            certs.add(Base64.decodeBase64(certE.getTextContent()));
        }
        boolean visible = "true".equals(element.getAttribute(VISIBLE));
        boolean hostedDomain = "true".equals(element.getAttribute(HOSTED_DOMAIN));
        boolean sendLoginHint = !"false".equals(element.getAttribute(SEND_LOGIN_HINT));
        String userLookupVal = element.getAttribute(USER_LOOKUP_ATTRIBUTE);
        IdpConfiguration.UserLookupAttribute userLookupAttribute = IdpConfiguration.UserLookupAttribute.USERNAME;
        if (!userLookupVal.isEmpty()) {
            userLookupAttribute = IdpConfiguration.UserLookupAttribute.valueOf(userLookupVal);
        }
        String userLookupTransformVal = element.getAttribute(USER_LOOKUP_TRANSFORM);
        IdpConfiguration.UserLookupTransform userLookupTransform = IdpConfiguration.UserLookupTransform.NONE;
        if (!userLookupTransformVal.isEmpty()) {
            userLookupTransform = IdpConfiguration.UserLookupTransform.valueOf(userLookupTransformVal);
        }
        IdpConfiguration.Kind kind = IdpConfiguration.Kind.UNSPECIFIED;
        String kindAttr = element.getAttribute(KIND);
        if (!kindAttr.isEmpty()) {
            kind = IdpConfiguration.Kind.valueOf(kindAttr);
        }
        IdpConfiguration.SSOProtocol protocol = IdpConfiguration.SSOProtocol.SAML;
        String protocolAttr = element.getAttribute(PROTOCOL);
        if (!protocolAttr.isEmpty()) {
            protocol = IdpConfiguration.SSOProtocol.valueOf(protocolAttr);
        }
        IdpConfiguration.RedirectPolicy redirectPolicy = IdpConfiguration.RedirectPolicy.ALL;
        String redirectPolicyVal = element.getAttribute(REDIRECT_POLICY);
        if (!redirectPolicyVal.isEmpty() && (redirectPolicy = IdpConfiguration.RedirectPolicy.valueOf(redirectPolicyVal)) == IdpConfiguration.RedirectPolicy.MANUAL) {
            redirectPolicy = !knownDomains.isEmpty() ? IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN : IdpConfiguration.RedirectPolicy.USER_DIRECTORY;
        }
        String customNameAttribute = element.getAttribute(CUSTOM_NAME_ATTRIBUTE);
        String customEmailAttribute = element.getAttribute(CUSTOM_EMAIL_ATTRIBUTE);
        SAMLIdpConfiguration.RequestedAuthnContextComparison requestedAuthnContextComparison = SAMLIdpConfiguration.RequestedAuthnContextComparison.EXACT;
        String authnContextClassRef = element.getAttribute(AUTHN_CONTEXT_CLASS_REF);
        String requestedAuthnContextPolicyVal = element.getAttribute(REQUESTED_AUTHN_CONTEXT_POLICY);
        if (requestedAuthnContextPolicyVal.isEmpty()) {
            requestedAuthnContextPolicy = SAMLIdpConfiguration.RequestedAuthnContextPolicy.CUSTOM;
            authnContextClassRef = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
            if (kind == IdpConfiguration.Kind.AZURE_AD) {
                requestedAuthnContextPolicy = SAMLIdpConfiguration.RequestedAuthnContextPolicy.DO_NOT_SEND;
            }
        } else {
            requestedAuthnContextPolicy = SAMLIdpConfiguration.RequestedAuthnContextPolicy.valueOf(requestedAuthnContextPolicyVal);
            String requestedAuthnContextComparisonVal = element.getAttribute(REQUESTED_AUTHN_CONTEXT_COMPARISON);
            if (!requestedAuthnContextComparisonVal.isEmpty()) {
                requestedAuthnContextComparison = SAMLIdpConfiguration.RequestedAuthnContextComparison.valueOf(requestedAuthnContextComparisonVal);
            }
            if (authnContextClassRef.isEmpty()) {
                authnContextClassRef = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
            }
        }
        SAMLIdpConfiguration.IssuerPolicy issuerPolicy = SAMLIdpConfiguration.IssuerPolicy.DEFAULT;
        String issuerPolicyVal = element.getAttribute(ISSUER_POLICY);
        if (!issuerPolicyVal.isEmpty()) {
            issuerPolicy = SAMLIdpConfiguration.IssuerPolicy.valueOf(issuerPolicyVal);
        }
        if ((issuer = element.getAttribute(ISSUER)).isEmpty()) {
            issuer = null;
        }
        IdpConfiguration.AllowCreate allowCreate = IdpConfiguration.AllowCreate.TRUE;
        String allowCreateVal = element.getAttribute(ALLOW_CREATE);
        if (!allowCreateVal.isEmpty()) {
            allowCreate = IdpConfiguration.AllowCreate.valueOf(allowCreateVal);
        }
        IdpConfiguration.NameIdFormat nameIdFormat = IdpConfiguration.NameIdFormat.DEFAULT;
        String nameIdFormatVal = element.getAttribute(NAMEID_FORMAT);
        if (!nameIdFormatVal.isEmpty()) {
            nameIdFormat = IdpConfiguration.NameIdFormat.valueOf(nameIdFormatVal);
        }
        String customNameIdFormat = element.getAttribute(CUSTOM_NAMEID_FORMAT);
        boolean createAllIncomingGroups = io.vavr.control.Option.of(element.getAttribute(CREATE_ALL_INCOMING_GROUPS)).map(Boolean::valueOf).getOrElse(false);
        boolean removeNonIdpGroupsFromUser = io.vavr.control.Option.of(element.getAttribute(REMOVE_NON_IDP_GROUPS_FROM_USER)).map(Boolean::valueOf).getOrElse(false);
        boolean autoRefreshMetadataEnabled = io.vavr.control.Option.of(element.getAttribute(AUTO_REFRESH_METADATA_ENABLED)).map(Boolean::valueOf).getOrElse(false);
        ArrayList<ManagedGroup> managedGroups = new ArrayList<ManagedGroup>(SamlXMLParser.parseGroups(element.getElementsByTagName(MANAGED_GROUP)).values());
        boolean atLeastOneManagedGroupRequiredForJITCreation = false;
        String atLeastOneManagedGroupRequiredVal = element.getAttribute(MANAGED_GROUPS_REQUIRED_FOR_USER_CREATION);
        if (!atLeastOneManagedGroupRequiredVal.isEmpty()) {
            atLeastOneManagedGroupRequiredForJITCreation = Boolean.parseBoolean(atLeastOneManagedGroupRequiredVal);
        }
        TreeSet<Long> matchedUserDirectoryIds = new TreeSet<Long>(SamlXMLParser.parseLongSet(element.getAttribute(MATCHED_USER_DIRECTORIES)));
        boolean knownAutoRedirect = !"false".equals(element.getAttribute(KNOWN_AUTO_REDIRECT));
        NodeList regexTuplesNodeList = element.getElementsByTagName(REGEX_TUPLES);
        ArrayList<Pair<String, String>> regexTuples = new ArrayList();
        if (regexTuplesNodeList != null && (tuplesNode = element.getElementsByTagName(REGEX_TUPLES).item(0)) != null) {
            NodeList tupleNodeList = tuplesNode.getChildNodes();
            regexTuples = SamlXMLParser.parseRegexTuples(tupleNodeList);
        }
        Optional<Long> jitDirectory = StringUtils.isNotBlank(element.getAttribute(JIT_DIRECTORY)) && StringUtils.isNumeric(element.getAttribute(JIT_DIRECTORY)) ? Optional.of(Long.valueOf(element.getAttribute(JIT_DIRECTORY))) : Optional.empty();
        String selectedUsernameAttributeInfo = element.getAttribute(SELECTED_USERNAME_ATTRIBUTE_INFO);
        java.util.HashSet<String> idpGroupsAttributes = new java.util.HashSet<String>(Arrays.asList(element.getAttribute(IDP_GROUPS_ATTRIBUTE).split(",")));
        idpGroupsAttributes.removeIf(it -> StringUtils.equals(it, ""));
        if (protocol == IdpConfiguration.SSOProtocol.OIDC) {
            java.util.HashSet scopes;
            String clientId = element.getAttribute(OIDC_CLIENT_ID);
            String clientSecret = element.getAttribute(OIDC_CLIENT_SECRET);
            Long clientSecretExpiry = Long.parseLong(element.getAttribute(OIDC_CLIENT_SECRET_EXPIRY));
            String discoveryUrl = element.getAttribute(OIDC_DISCOVERY_URL);
            String[] issuerAllowList = Try.of(() -> element.getAttribute(OIDC_ISSUER_ALLOWLIST)).mapTry(StringUtils::deleteWhitespace).mapTry(allowListAsStr -> StringUtils.split(allowListAsStr, ",")).getOrElse(new String[0]);
            IdpConfiguration.UsernameAttribute usernameAttribute = IdpConfiguration.UsernameAttribute.SUB;
            String usernameAttributeValue = element.getAttribute(USERNAME_ATTRIBUTE);
            if (StringUtils.isNotBlank(usernameAttributeValue)) {
                usernameAttribute = IdpConfiguration.UsernameAttribute.valueOf(usernameAttributeValue);
            }
            boolean shouldDoUpdate = false;
            if (!element.hasAttribute(OIDC_SCOPES)) {
                Set migrationScopes = new java.util.HashSet();
                Either<String, OidcProcedureData> maybeOidcData = this.oidcProcedureFactoryWrapper.createOidcProcedure(io.vavr.collection.HashMap.of("discovery_url", discoveryUrl, "workaround", kind));
                if (maybeOidcData.isLeft()) {
                    log.error(ErrorUtils.createErrorMessage("KSSO-811AXICDRJ", "Failed to run OIDC while parsing IdP: " + maybeOidcData.getLeft()));
                } else {
                    OidcProcedureData oidcProcedureData = maybeOidcData.get();
                    Either<String, OidcProcedureData> maybeDiscovery = oidcProcedureData.discover();
                    if (maybeDiscovery.isLeft()) {
                        log.error(ErrorUtils.createErrorMessage("KSSO-Z5BGY9CVOF", "Failed to perform discovery while parsing IdP: " + maybeDiscovery.getLeft()));
                    } else {
                        oidcProcedureData = maybeDiscovery.get();
                        List<String> scopesSupported = oidcProcedureData.getScopesSupported();
                        HashSet<String> upgradeScopes = HashSet.of("openid", "address", "email", "profile", "phone", NAME, "groups", "read:user", "user:email");
                        migrationScopes = scopesSupported.isEmpty() ? upgradeScopes.toJavaSet() : ((HashSet)upgradeScopes.filter(scopesSupported::contains)).toJavaSet();
                    }
                }
                scopes = migrationScopes;
                shouldDoUpdate = true;
            } else {
                scopes = SamlXMLParser.parseSet(element.getAttribute(OIDC_SCOPES));
            }
            OIDCIdpConfiguration configuration = new OIDCIdpConfiguration(defaultGroups, defaultGroupsRules, autoUpdateKnownDomains, customEmailAttribute, customNameAttribute, customUsernameAttributeName, enabled, id, jitDirectory, kind, knownDomains, knownAutoRedirect, createAllIncomingGroups, removeNonIdpGroupsFromUser, managedGroups, atLeastOneManagedGroupRequiredForJITCreation, matchedUserDirectoryIds, name, notificationEmails, redirectGroups, redirectPolicy, regexTuples, singleLogoutEnabled, singleLogoutReturnURL, userActivatePolicy, userLookupAttribute, userLookupTransform, usernameAttribute, usernamePolicy, userNotFoundPolicy, userUpdatePolicy, visible, hostedDomain, selectedUsernameAttributeInfo, idpGroupsAttributes, sendLoginHint, authenticatedAnonymousBrowsingEnabled, clientId, clientSecret, clientSecretExpiry, discoveryUrl, scopes, issuerAllowList);
            if (shouldDoUpdate) {
                this.updateIdpConfiguration(configuration);
            }
            return configuration;
        }
        IdpConfiguration.UsernameAttribute usernameAttribute = IdpConfiguration.UsernameAttribute.UPN;
        String usernameAttributeValue = element.getAttribute(USERNAME_ATTRIBUTE);
        if (StringUtils.isNotBlank(usernameAttributeValue)) {
            usernameAttribute = IdpConfiguration.UsernameAttribute.valueOf(usernameAttributeValue);
        }
        return new SAMLIdpConfiguration(allowCreate, defaultGroups, defaultGroupsRules, autoUpdateKnownDomains, customEmailAttribute, customNameAttribute, customUsernameAttributeName, enabled, id, jitDirectory, kind, knownDomains, knownAutoRedirect, createAllIncomingGroups, removeNonIdpGroupsFromUser, managedGroups, atLeastOneManagedGroupRequiredForJITCreation, matchedUserDirectoryIds, name, notificationEmails, redirectGroups, redirectPolicy, regexTuples, singleLogoutEnabled, userActivatePolicy, userLookupAttribute, userLookupTransform, usernameAttribute, usernamePolicy, userNotFoundPolicy, userUpdatePolicy, visible, hostedDomain, selectedUsernameAttributeInfo, idpGroupsAttributes, sendLoginHint, authenticatedAnonymousBrowsingEnabled, authnContextClassRef, customNameIdFormat, encryptedAssertionsRequired, usePostBinding, idpURL, issuer, issuerPolicy, metadataURL, nameIdFormat, sessionIdentificationValidationPolicy, certs, singleLogoutserviceURL, singleLogoutReturnURL, tlsFingerprint, requestedAuthnContextComparison, requestedAuthnContextPolicy, autoRefreshMetadataEnabled);
    }

    private File getProvidersDirectory() {
        return new File(this.getSamlDirectory(), "providers");
    }

    private File getSamlDirectory() {
        return new File(this.hostApp.getHomeDirectory(), "saml");
    }

    public void addIdpConfiguration(IdpConfiguration config) {
        String id = config.getId();
        this.ensureKeysExist(config.getName());
        this.getProviderDirectory(id).mkdirs();
        this.persistProvider(config);
    }

    public void updateIdpConfiguration(IdpConfiguration config) {
        this.getProviderDirectory(config.getId()).mkdirs();
        this.persistProvider(config);
    }

    String generateSamlPrivateKeyPassword() {
        byte[] passwordBytes = new byte[32];
        this.secureRandom.nextBytes(passwordBytes);
        return Fingerprint.sha1Fingerprint(passwordBytes);
    }

    int getRedirectProgressDelay() {
        try {
            return Integer.parseInt((String)this.settings.get(REDIRECT_CUSTOM_PROGRESS_DELAY));
        }
        catch (Exception exception) {
            return 2;
        }
    }

    void setRedirectProgressDelay(String delaySeconds) {
        int savedSeconds = 2;
        try {
            savedSeconds = Integer.parseInt(delaySeconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.settings.put(REDIRECT_CUSTOM_PROGRESS_DELAY, (Object)("" + savedSeconds));
    }

    boolean getLoginEnabledForJSD() {
        boolean returnValue = true;
        try {
            if (this.settings.get(LOGIN_ENABLED_FOR_JSD) != null) {
                returnValue = Boolean.parseBoolean((String)this.settings.get(LOGIN_ENABLED_FOR_JSD));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnValue;
    }

    void setLoginEnabledForJSD(boolean value) {
        this.settings.put(LOGIN_ENABLED_FOR_JSD, (Object)("" + value));
    }

    String getSamlPrivateKeyPassword() {
        return (String)this.settings.get(KEYS.SAML_PRIVATE_KEY_PASSWORD.key);
    }

    void setSamlPrivateKeyPassword(String samlPrivateKeyPassword) {
        this.settings.put(KEYS.SAML_PRIVATE_KEY_PASSWORD.key, (Object)samlPrivateKeyPassword);
    }

    void ensureKeysExist(String serverName) {
        if (!this.isActiveSigningKeyDefined()) {
            String id = this.generateKeyFile(serverName);
            this.promoteActiveCertificate(id);
        }
    }

    void addStandbyKey(String serverName) {
        this.generateKeyFile(serverName);
    }

    java.util.List<X509Certificate> getStandbyCertificates() {
        if (this.isActiveSigningKeyDefined()) {
            String active = this.getActiveSigningKeyShaId();
            File[] files = this.getSigningKeysDirectory().listFiles(pathname -> pathname.getName().endsWith(".jks") && !pathname.getName().startsWith(active));
            if (files != null && files.length > 0) {
                ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
                for (File file : files) {
                    try {
                        X509Certificate cert = this.parseCert(new SamlKeyGenerator(this.secureRandom).getSigningCertificate(file));
                        certs.add(cert);
                    }
                    catch (Exception e) {
                        log.error("Exception parsing certificate file: " + file, (Throwable)e);
                    }
                }
                Collections.sort(certs, (o1, o2) -> o2.getNotBefore().compareTo(o1.getNotBefore()));
                return certs;
            }
        }
        return Collections.emptyList();
    }

    void promoteActiveCertificate(String id) {
        try {
            File activeSigningKeyFile = this.getActiveSigningKeyMarkerFile();
            File temp = new File(this.getSigningKeysDirectory(), ".temp");
            FileUtils.writeStringToFile((File)temp, (String)id);
            this.renameFile(temp, activeSigningKeyFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void deleteCertificate(String id) {
        new File(this.getSigningKeysDirectory(), id + ".jks").delete();
    }

    private String generateKeyFile(String serverName) {
        try {
            SamlKeyGenerator samlKeyGenerator = new SamlKeyGenerator(this.secureRandom);
            KeyStore keyStore = samlKeyGenerator.generateKeyStore(serverName, this.getSamlPrivateKeyPassword());
            String sha256 = Fingerprint.sha256Fingerprint(keyStore.getCertificate("myCert").getEncoded());
            File keyFile = new File(this.getSigningKeysDirectory(), sha256 + ".jks");
            samlKeyGenerator.writeKeyStore(keyFile, keyStore);
            return sha256;
        }
        catch (KeyStoreException | CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private File getActiveSigningKeyFile() {
        return new File(this.getSigningKeysDirectory(), this.getActiveSigningKeyShaId() + ".jks");
    }

    public boolean isActiveSigningKeyDefined() {
        File markerFile = this.getActiveSigningKeyMarkerFile();
        if (!markerFile.exists()) {
            return false;
        }
        File activeSigningKeyFile = this.getActiveSigningKeyFile(this.getActiveSigningKeyShaId());
        if (!activeSigningKeyFile.exists()) {
            return false;
        }
        try {
            this.getSigningCert();
        }
        catch (Exception e) {
            log.error("Exception parsing signing key file: " + activeSigningKeyFile.getAbsolutePath(), (Throwable)e);
            return false;
        }
        return true;
    }

    private String getActiveSigningKeyShaId() {
        try {
            return FileUtils.readFileToString((File)this.getActiveSigningKeyMarkerFile()).trim();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getActiveSigningKeyMarkerFile() {
        return new File(this.getSigningKeysDirectory(), "activekey-sha256.txt");
    }

    private File getActiveSigningKeyFile(String sha256) {
        return new File(this.getSigningKeysDirectory(), sha256 + ".jks");
    }

    public File getSigningKeysDirectory() {
        return new File(this.getSamlDirectory(), "keys");
    }

    private File getProviderDirectory(String uid) {
        File providersDirectory = this.getProvidersDirectory();
        return new File(providersDirectory, uid);
    }

    private void persistProvider(IdpConfiguration config) {
        File providerDir = this.getProviderDirectory(config.getId());
        try {
            String singleLogoutReturnURL;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element provider = document.createElement(PROVIDER_ELEM);
            provider.setAttribute(KIND, config.getKind().name());
            provider.setAttribute(PROTOCOL, config.getProtocol().toString());
            provider.setAttribute(NAME, config.getName());
            provider.setAttribute(USER_NOT_FOUND_POLICY, config.getUserNotFoundPolicy().name());
            provider.setAttribute(USER_UPDATE_POLICY, config.getUserUpdatePolicy().name());
            provider.setAttribute(USER_ACTIVATE_POLICY, config.getUserActivatePolicy().name());
            provider.setAttribute(USERNAME_ATTRIBUTE, config.getUsernameAttribute().name());
            provider.setAttribute(CUSTOM_USERNAME_ATTRIBUTE_NAME, config.getCustomUsernameAttributeName());
            provider.setAttribute(USERNAME_POLICY, config.getUsernamePolicy().name());
            provider.setAttribute(REDIRECT_POLICY, config.getRedirectPolicy().name());
            provider.setAttribute(MATCHED_USER_DIRECTORIES, this.commaSeparatedLongs(config.getMatchedUserDirectoryIds()));
            provider.setAttribute(DEFAULT_GROUPS, this.commaSeparated(config.getDefaultGroups()));
            provider.setAttribute(DEFAULT_GROUPS_RULES, JsonMapping.Write.mapAsJson(config.getDefaultGroupsRules()).map(JSONObject::toString).getOrElse(""));
            provider.setAttribute(KNOWN_DOMAINS, this.commaSeparated(config.getKnownDomains()));
            provider.setAttribute(AUTO_UPDATE_KNOWN_DOMAINS, Boolean.toString(config.isAutoUpdateKnownDomains()));
            provider.setAttribute(CREATE_ALL_INCOMING_GROUPS, Boolean.toString(config.isCreateAllIncomingGroups()));
            provider.setAttribute(REMOVE_NON_IDP_GROUPS_FROM_USER, Boolean.toString(config.isRemoveNonIdpGroupsFromUser()));
            provider.setAttribute(SINGLE_LOGOUT_ENABLED, String.valueOf(config.isSingleLogoutEnabled()));
            provider.setAttribute(REDIRECT_GROUPS, this.commaSeparated(config.getRedirectGroups()));
            provider.setAttribute(MANAGED_GROUPS_REQUIRED_FOR_USER_CREATION, Boolean.toString(config.isManagedGroupsRequiredForJITCreation()));
            provider.setAttribute(ENABLED, Boolean.toString(config.isEnabled()));
            provider.setAttribute(VISIBLE, Boolean.toString(config.isVisible()));
            provider.setAttribute(HOSTED_DOMAIN, Boolean.toString(config.isHostedDomain()));
            provider.setAttribute(USER_LOOKUP_ATTRIBUTE, config.getUserLookupAttribute().name());
            provider.setAttribute(USER_LOOKUP_TRANSFORM, config.getUserLookupTransform().name());
            provider.setAttribute(KNOWN_AUTO_REDIRECT, Boolean.toString(config.isKnownAutoRedirect()));
            provider.setAttribute(SEND_LOGIN_HINT, Boolean.toString(config.isSendLoginHint()));
            provider.setAttribute(IDP_GROUPS_ATTRIBUTE, String.join((CharSequence)",", config.getIdpGroupsAttributes()));
            provider.setAttribute(AUTHENTICATED_ANONYMOUS_BROWSING_ENABLED, Boolean.toString(config.isAuthenticatedAnonymousBrowsingEnabled()));
            this.addGroupElements(provider, config.getManagedGroups());
            if (config.getJitDirectory().isPresent()) {
                provider.setAttribute(JIT_DIRECTORY, String.valueOf(config.getJitDirectory().get()));
            }
            if (config.getCustomNameAttribute() != null) {
                provider.setAttribute(CUSTOM_NAME_ATTRIBUTE, config.getCustomNameAttribute());
            } else {
                provider.removeAttribute(CUSTOM_NAME_ATTRIBUTE);
            }
            if (config.getCustomEmailAttribute() != null) {
                provider.setAttribute(CUSTOM_EMAIL_ATTRIBUTE, config.getCustomEmailAttribute());
            } else {
                provider.removeAttribute(CUSTOM_EMAIL_ATTRIBUTE);
            }
            Element regexTupleListElement = SamlXMLParser.listOfTuplesToXML(document, REGEX_TUPLES, config.getUserTransformationRegexes());
            if (regexTupleListElement != null) {
                provider.appendChild(regexTupleListElement);
            }
            if (StringUtils.isNotBlank(singleLogoutReturnURL = config.getSingleLogoutReturnURL())) {
                provider.setAttribute(SINGLE_LOGOUT_RETURN_URL, singleLogoutReturnURL);
            }
            config.ifSaml(samlConfig -> {
                String singleLogoutServiceURL;
                provider.setAttribute(IDP_URL, samlConfig.getIdpURL());
                provider.setAttribute(ENCRYPTED_ASSERTIONS_REQUIRED, Boolean.toString(samlConfig.isEncryptedAssertionsRequired()));
                provider.setAttribute(USE_POST_BINDING, Boolean.toString(samlConfig.isUsePostBinding()));
                provider.setAttribute(REQUESTED_AUTHN_CONTEXT_POLICY, samlConfig.getRequestedAuthnContextPolicy().name());
                provider.setAttribute(REQUESTED_AUTHN_CONTEXT_COMPARISON, samlConfig.getRequestedAuthnContextComparison().name());
                provider.setAttribute(AUTHN_CONTEXT_CLASS_REF, samlConfig.getAuthnContextClassRef());
                provider.setAttribute(ISSUER_POLICY, samlConfig.getIssuerPolicy().name());
                provider.setAttribute(ALLOW_CREATE, samlConfig.getAllowCreate().name());
                provider.setAttribute(NAMEID_FORMAT, samlConfig.getNameIdFormat().name());
                provider.setAttribute(CUSTOM_NAMEID_FORMAT, samlConfig.getCustomNameIdFormat());
                provider.setAttribute(AUTO_REFRESH_METADATA_ENABLED, Boolean.toString(samlConfig.isAutoRefreshMetadataEnabled()));
                this.replaceCertificates(provider, samlConfig.getSigningCerts());
                SAMLSessionIdentification.ValidationPolicy siPolicy = samlConfig.getSessionIdentificationValidationPolicy();
                if (siPolicy != null && siPolicy != SAMLSessionIdentification.ValidationPolicy.getDefault()) {
                    provider.setAttribute(SESSION_IDENTIFICATION_VALIDATION_POLICY, siPolicy.name());
                }
                if (StringUtils.isNotBlank(singleLogoutServiceURL = samlConfig.getSingleLogoutServiceURL())) {
                    provider.setAttribute(SINGLE_LOGOUT_SERVICE_URL, singleLogoutServiceURL);
                }
                if (samlConfig.getMetadataURL() != null) {
                    provider.setAttribute(METADATA_URL, samlConfig.getMetadataURL());
                }
                if (samlConfig.getTlsFingerprint() != null) {
                    provider.setAttribute(TLS_FINGERPRINT, samlConfig.getTlsFingerprint());
                }
                if (samlConfig.getIssuer() != null) {
                    provider.setAttribute(ISSUER, samlConfig.getIssuer());
                }
            });
            config.ifOidc(oidcConfig -> {
                provider.setAttribute(OIDC_CLIENT_ID, oidcConfig.getClientId());
                provider.setAttribute(OIDC_CLIENT_SECRET, oidcConfig.getClientSecret());
                provider.setAttribute(OIDC_CLIENT_SECRET_EXPIRY, oidcConfig.getClientSecretExpiry().toString());
                provider.setAttribute(OIDC_DISCOVERY_URL, oidcConfig.getDiscoveryUrl());
                provider.setAttribute(OIDC_SCOPES, this.commaSeparated(oidcConfig.getScopes()));
                provider.setAttribute(OIDC_ISSUER_ALLOWLIST, this.commaSeparated(oidcConfig.getIssuerAllowList()));
            });
            document.appendChild(provider);
            this.persistProviderDocument(providerDir, document);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAuthenticatedAnonymousBrowsingSessionActive(HttpServletRequest request) {
        return Try.of(() -> request.getSession(false)).toOption().flatMap(io.vavr.control.Option::of).map(session -> this.findIdentityProviderById((String)session.getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID")).isDefined()).getOrElse(false);
    }

    private void replaceCertificates(Element provider, java.util.List<byte[]> signingCerts) {
        NodeList existing = provider.getElementsByTagName(CERTIFICATE);
        LinkedList<Element> toRemove = new LinkedList<Element>();
        for (int i = 0; i < existing.getLength(); ++i) {
            toRemove.add((Element)existing.item(i));
        }
        for (Element element : toRemove) {
            provider.removeChild(element);
        }
        for (byte[] certBytes : signingCerts) {
            this.addCertificate(provider, certBytes);
        }
    }

    private void addCertificate(Element provider, byte[] certBytes) {
        String base64 = Base64.encodeBase64String(certBytes);
        NodeList existingCerts = provider.getElementsByTagName(CERTIFICATE);
        for (int i = 0; i < existingCerts.getLength(); ++i) {
            if (!base64.equals(existingCerts.item(i).getTextContent())) continue;
            return;
        }
        Element certE = provider.getOwnerDocument().createElement(CERTIFICATE);
        certE.setTextContent(base64);
        provider.appendChild(certE);
    }

    private void persistProviderDocument(File providerDir, Document document) {
        try {
            File tempFile = new File(providerDir, "_provider.xml");
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), StandardCharsets.UTF_8);){
                transformer.transform(new DOMSource(document), new StreamResult(out));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.renameFile(tempFile, this.getProviderXmlFile(tempFile.getParentFile()));
            this.updateStateId();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private void renameFile(File sourceFile, File destFile) {
        try {
            Files.move(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String commaSeparated(Set<String> groups2) {
        StringBuilder sb = new StringBuilder();
        for (String g : groups2) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(g);
        }
        return sb.toString();
    }

    String commaSeparated(String[] items) {
        return io.vavr.control.Option.of(items).map(Arrays::stream).map(stream -> stream.collect(Collectors.toSet())).map(this::commaSeparated).getOrElse("");
    }

    IdpConfiguration getEnabledIdentityProviderById(String id) {
        IdpConfiguration config = this.getIdentityProviderById(id);
        return config != null && config.isEnabled() ? config : null;
    }

    public IdpConfiguration getIdentityProviderById(String id) {
        for (IdpConfiguration configuration : this.getIdentityProviders()) {
            if (!configuration.getId().equals(id)) continue;
            return configuration;
        }
        return null;
    }

    public io.vavr.control.Option<IdpConfiguration> findIdentityProviderById(String maybeId) {
        return List.ofAll(this.getIdentityProviders()).find(idpConfiguration -> io.vavr.control.Option.of(idpConfiguration.getId()).exists(id -> io.vavr.control.Option.of(maybeId).contains((String)id)));
    }

    public io.vavr.control.Option<IdpConfiguration> findIdentityProviderByIdFromPath(HttpServletRequest request) {
        return this.findIdentityProviderById(this.getIdPIdFromPath(request));
    }

    public SAMLIdpConfiguration getSamlIdpById(String id) {
        IdpConfiguration cfg = this.getIdentityProviderById(id);
        if (!(cfg instanceof SAMLIdpConfiguration)) {
            throw new RuntimeException(id + " is not SAMLIdpConfiguration: " + cfg.getClass().getSimpleName());
        }
        return (SAMLIdpConfiguration)cfg;
    }

    public OIDCIdpConfiguration getOidcIdpById(String id) {
        IdpConfiguration cfg = this.getIdentityProviderById(id);
        if (!(cfg instanceof OIDCIdpConfiguration)) {
            throw new RuntimeException(id + " is not OidcIdpConfiguration: " + cfg.getClass().getSimpleName());
        }
        return (OIDCIdpConfiguration)cfg;
    }

    boolean isEncryptedAssertionsRequiredForIdpOrDraft(String id) {
        IdpConfiguration idp = this.getIdentityProviderById(id);
        if (idp != null) {
            if (idp instanceof SAMLIdpConfiguration) {
                return ((SAMLIdpConfiguration)idp).isEncryptedAssertionsRequired();
            }
            return false;
        }
        Properties props = this.readProviderDraft(id);
        if (props != null) {
            return Boolean.valueOf(props.getProperty(ENCRYPTED_ASSERTIONS_REQUIRED, "false"));
        }
        return false;
    }

    boolean isSingleLogoutEnabledForIdpOrDraft(String id) {
        return Optional.ofNullable(this.getIdentityProviderById(id)).map(IdpConfiguration::isSingleLogoutEnabled).orElseGet(() -> Optional.ofNullable(this.readProviderDraft(id)).map(props -> Boolean.valueOf(props.getProperty(SINGLE_LOGOUT_ENABLED, "false"))).orElse(false));
    }

    byte[] getSigningCert() {
        File signingKeys = this.getActiveSigningKeyFile();
        return new SamlKeyGenerator(this.secureRandom).getSigningCertificate(signingKeys);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Credential getIdpSigningCredential(byte[] buf) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(buf);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(in);
            BasicX509Credential basicX509Credential = new BasicX509Credential(certificate);
            return basicX509Credential;
        }
        catch (IOException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public Credential getSpSigningCredential() {
        return new SamlKeyGenerator(this.secureRandom).getSpSigningCredentials(this.getActiveSigningKeyFile(), this.getSamlPrivateKeyPassword());
    }

    public String getIdentityProvidersSubpathRoot() {
        return "providers";
    }

    public String getIdpConfigUrl(HttpServletRequest request) {
        return this.getPluginAdminBase(request) + "/" + this.getIdentityProvidersSubpathRoot();
    }

    public String getIdPIdFromPath(HttpServletRequest request) {
        return io.vavr.control.Option.of(request).map(HttpUrlUtils::getInternalPath).filter(path -> path.contains("providers")).map(path -> StringUtils.substringBetween(path, "providers/", "/")).getOrElse("");
    }

    private String getPluginAdminBase(HttpServletRequest request) {
        return request.getContextPath() + "/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin";
    }

    private String getSAMLRequestCertPath(HttpServletRequest request) {
        return this.getPluginAdminBase(request) + "/certs/request/" + request.getServerName() + "-saml-request-cert.cer";
    }

    String getSAMLRequestCertURL(HttpServletRequest request) {
        try {
            URI uri = new URI(request.getRequestURL().toString());
            URI serviceUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), this.getSAMLRequestCertPath(request), null, null);
            return serviceUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    String getProviderOverviewURL(String spId, HttpServletRequest request) {
        return this.getIdpConfigUrl(request) + "/" + spId + "/overview";
    }

    String getProviderAdminURL(String spId, HttpServletRequest request) {
        return this.getIdpConfigUrl(request) + "/" + spId + "/config";
    }

    public String getServiceProviderLoginURL(HttpServletRequest req, String id) {
        return this.getServiceProviderURL(req, id, "/login");
    }

    String getServiceProviderTestURL(HttpServletRequest req, String id) {
        return this.getIdpConfigUrl(req) + "/" + id + "/test";
    }

    public String getServiceProviderNonAdminTestURL(HttpServletRequest req, String id) {
        return this.getServiceProviderURL(req, id, "/usertest");
    }

    public String getServiceProviderEvaluateTestURL(HttpServletRequest req, String id) {
        return this.getIdpConfigUrl(req) + "/" + id + "/evaluate-test";
    }

    String getServiceProviderMetadataURL(HttpServletRequest req, String id) {
        return this.getServiceProviderURL(req, id, "/metadata.xml");
    }

    String getServiceProviderLogoutServiceURL(HttpServletRequest req, String id) {
        return this.getServiceProviderURL(req, id, "/logout");
    }

    private String getServiceProviderURL(HttpServletRequest req, String id, String path) {
        try {
            URI uri = new URI(req.getRequestURL().toString());
            URI serviceUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), req.getContextPath() + "/plugins/servlet/no.kantega.saml/sp/" + id + path, null, null);
            return serviceUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    X509Certificate parseCert(byte[] signingCert) {
        try {
            CertificateFactory factory2 = CertificateFactory.getInstance("X509");
            return (X509Certificate)factory2.generateCertificate(new ByteArrayInputStream(signingCert));
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public java.util.List<IdpConfiguration> getProvidersByKind(IdpConfiguration.Kind identityProviderKind) {
        ArrayList<IdpConfiguration> matches = new ArrayList<IdpConfiguration>();
        for (IdpConfiguration provider : this.getIdentityProviders()) {
            if (provider.getKind() != identityProviderKind) continue;
            matches.add(provider);
        }
        return matches;
    }

    java.util.List<IdpConfiguration> getProvidersByVisibility(boolean visibility) {
        ArrayList<IdpConfiguration> matches = new ArrayList<IdpConfiguration>();
        for (IdpConfiguration configuration : this.getIdentityProviders()) {
            if (!configuration.isEnabled() || configuration.isVisible() != visibility) continue;
            matches.add(configuration);
        }
        return matches;
    }

    public java.util.List<IdpConfiguration> getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy redirectPolicy) {
        ArrayList<IdpConfiguration> matches = new ArrayList<IdpConfiguration>();
        for (IdpConfiguration configuration : this.getIdentityProviders()) {
            if (!configuration.isEnabled() || configuration.getRedirectPolicy() != redirectPolicy) continue;
            matches.add(configuration);
        }
        return matches;
    }

    java.util.List<IdpConfiguration> getProvidersByRedirectPolicy(EnumSet<IdpConfiguration.RedirectPolicy> redirectPolicies) {
        ArrayList<IdpConfiguration> matches = new ArrayList<IdpConfiguration>();
        for (IdpConfiguration configuration : this.getIdentityProviders()) {
            if (!configuration.isEnabled() || !redirectPolicies.contains((Object)configuration.getRedirectPolicy())) continue;
            matches.add(configuration);
        }
        return matches;
    }

    void removeIdentityProvider(String id) {
        File providerDirectory = this.getProviderDirectory(id);
        try {
            FileUtils.deleteDirectory((File)providerDirectory);
            this.updateStateId();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void recordTestStarted(String idpConfigurationID, String id, String xml, String remoteAddr) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, id);
        testDirectory.mkdirs();
        try {
            File tmpFile = new File(testDirectory, "_request.xml");
            FileUtils.writeStringToFile((File)tmpFile, (String)xml, (String)"utf-8");
            File requestFile = this.getRecordedTestRequestFile(idpConfigurationID, id);
            this.renameFile(tmpFile, requestFile);
            Properties props = this.readTestProperties(testDirectory);
            props.setProperty("requestTime", ISODateTimeFormat.dateTime().print(DateTime.now()));
            props.setProperty("requestAddress", remoteAddr);
            this.writeTestProperties(testDirectory, props);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.deleteOldTests(idpConfigurationID, this.getTestDirectories(idpConfigurationID));
    }

    public void recordTestStarted(String idpConfigurationID, String id, String remoteAddr) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, id);
        testDirectory.mkdirs();
        Properties props = this.readTestProperties(testDirectory);
        props.setProperty("requestTime", ISODateTimeFormat.dateTime().print(DateTime.now()));
        props.setProperty("requestAddress", remoteAddr);
        this.writeTestProperties(testDirectory, props);
        this.deleteOldTests(idpConfigurationID, this.getTestDirectories(idpConfigurationID));
    }

    void recordTestResult(String idpConfigurationID, SamlResponseValidationResult result, SAMLResponseEvaluationResult evaluationResult, String xml, String remoteAddr) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, result.getAuthnRequestID());
        testDirectory.mkdirs();
        File tmpFile = new File(testDirectory, "_response.xml");
        File responseFile = this.getRecordedTestResponseFile(idpConfigurationID, result.getAuthnRequestID());
        if (xml != null) {
            try {
                FileUtils.writeStringToFile((File)tmpFile, (String)xml, (String)"utf-8");
                this.renameFile(tmpFile, responseFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Properties props = this.readTestProperties(testDirectory);
        this.updateResultProps(evaluationResult, props);
        props.setProperty("responseTime", ISODateTimeFormat.dateTime().print(result.getNow()));
        props.setProperty("responseAddress", remoteAddr);
        this.writeTestProperties(testDirectory, props);
    }

    public void recordOIDCTestStarted(String idpConfigurationID, String targetUrl, OidcProcedureData oidcProcedureData, String testId) {
        try {
            File testDirectory = this.getTestDirectory(idpConfigurationID, testId);
            File tmpFile = new File(testDirectory, "_oidcProcedureInit.json");
            String json = oidcProcedureData.sanitizedStringRepresentation().getOrElse("{'error':'Failed test recording'}");
            FileUtils.writeStringToFile((File)tmpFile, (String)json, (String)"utf-8");
            File requestFile = this.getRecordedTestStartedOIDCProcedureFile(idpConfigurationID, testId);
            this.renameFile(tmpFile, requestFile);
            Properties props = this.readTestProperties(testDirectory);
            props.setProperty("requestTime", ISODateTimeFormat.dateTime().print(DateTime.now()));
            io.vavr.control.Option.of(targetUrl).peek(url -> props.setProperty("targetUrl", (String)url));
            this.writeTestProperties(testDirectory, props);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            log.warn(ErrorUtils.createErrorMessage("KSSO-51ZKNC8IWP", "Failed saving OIDC test started: " + e));
        }
        this.deleteOldTests(idpConfigurationID, this.getTestDirectories(idpConfigurationID));
    }

    public void recordOIDCTestResult(String idpConfigurationID, String testId, OIDCResponseEvaluationResult evaluationResult, JSONObject profileJson) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, testId);
        testDirectory.mkdirs();
        File tmpFile = new File(testDirectory, "_response.json");
        File responseFile = this.getRecordedOIDCTestResponseFile(idpConfigurationID, testId);
        try {
            FileUtils.writeStringToFile((File)tmpFile, (String)profileJson.toString(), (String)"utf-8");
            this.renameFile(tmpFile, responseFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Properties props = this.readTestProperties(testDirectory);
        this.updateResultProps(evaluationResult, props);
        props.setProperty("responseTime", ISODateTimeFormat.dateTime().print(DateTime.now()));
        this.writeTestProperties(testDirectory, props);
    }

    public void recordErrorTestOIDCProcedureBeforeRequest(String idpConfigurationID, String testId, OidcProcedureData oidcProcedureData, ErrorUtils.KssoError kssoError, ResponseEvaluationCode code) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, testId);
        testDirectory.mkdirs();
        File tmpFile = new File(testDirectory, "_oidcProcedureSetupBeforeRequest.json");
        File responseFile = this.getRecordedTestOidcProcedureFileBeforeRequest(idpConfigurationID, testId);
        try {
            String json = oidcProcedureData.sanitizedStringRepresentation().getOrElse("{'error':'Failed test recording'}");
            FileUtils.writeStringToFile((File)tmpFile, (String)json, (String)"utf-8");
            this.renameFile(tmpFile, responseFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Properties props = this.readTestProperties(testDirectory);
        io.vavr.control.Option.of(kssoError).peek(error -> {
            props.setProperty("errorCode", error.code);
            props.setProperty("errorMessage", error.message);
            props.setProperty("error", error.toString());
        });
        io.vavr.control.Option.of(code).peek(respCode -> props.setProperty("code", respCode.name()));
        this.writeTestProperties(testDirectory, props);
    }

    public void recordTestOIDCProcedureBeforeRequest(String idpConfigurationID, String testId, OidcProcedureData oidcProcedureData, ResponseEvaluationCode code) {
        this.recordErrorTestOIDCProcedureBeforeRequest(idpConfigurationID, testId, oidcProcedureData, null, code);
    }

    public void recordErrorTestOIDCProcedureAfterResponse(String idpConfigurationID, String testId, OidcProcedureData oidcProcedureData, ErrorUtils.KssoError kssoError, ResponseEvaluationCode code) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, testId);
        testDirectory.mkdirs();
        File tmpFile = new File(testDirectory, "_oidcProcedureSetupAfterResponse.json");
        File responseFile = this.getRecordedTestOidcProcedureFileAfterResponse(idpConfigurationID, testId);
        try {
            String json = oidcProcedureData.sanitizedStringRepresentation().getOrElse("{'error':'Failed test recording'}");
            FileUtils.writeStringToFile((File)tmpFile, (String)json, (String)"utf-8");
            this.renameFile(tmpFile, responseFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Properties props = this.readTestProperties(testDirectory);
        props.setProperty("responseTime", ISODateTimeFormat.dateTime().print(DateTime.now()));
        io.vavr.control.Option.of(kssoError).peek(error -> {
            props.setProperty("errorCode", error.code);
            props.setProperty("errorMessage", error.message);
            props.setProperty("error", error.toString());
        });
        io.vavr.control.Option.of(code).peek(respCode -> props.setProperty("code", respCode.name()));
        this.writeTestProperties(testDirectory, props);
    }

    public void recordTestOIDCProcedureAfterResponse(String idpConfigurationID, String testId, OidcProcedureData oidcProcedureData, ResponseEvaluationCode code) {
        this.recordErrorTestOIDCProcedureAfterResponse(idpConfigurationID, testId, oidcProcedureData, null, code);
    }

    void updateAndStoreTestresults(String idpConfigurationID, SamlResponseValidationResult result, SAMLResponseEvaluationResult evaluationResult) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, result.getAuthnRequestID());
        Properties props = this.readTestProperties(testDirectory);
        this.updateResultProps(evaluationResult, props);
        this.writeTestProperties(testDirectory, props);
    }

    void updateAndStoreTestresults(String idpConfigurationID, String testRecordId, OIDCResponseEvaluationResult evaluationResult) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, testRecordId);
        Properties props = this.readTestProperties(testDirectory);
        this.updateResultProps(evaluationResult, props);
        this.writeTestProperties(testDirectory, props);
    }

    private void updateResultProps(FederatedIdentityResponseEvaluationResult evaluationResult, Properties props) {
        if (evaluationResult != null) {
            ResponseEvaluationCode code = evaluationResult.getCode();
            props.setProperty("code", code.name());
            String username = evaluationResult.getUsername();
            if (username != null) {
                props.setProperty("username", username);
            } else {
                props.remove("username");
            }
            String fullname = evaluationResult.getFullname();
            if (fullname != null) {
                props.setProperty("fullname", fullname);
            }
        }
    }

    Properties getTestProperties(String idpConfigurationID, TestRecord testRecord) {
        return this.readTestProperties(this.getTestDirectory(idpConfigurationID, testRecord.getId()));
    }

    private Properties readTestProperties(File testDirectory) {
        File testPropertiesFile = this.getTestPropertiesFile(testDirectory);
        Properties p = new Properties();
        if (testPropertiesFile.exists()) {
            try (FileInputStream is = new FileInputStream(testPropertiesFile);){
                p.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return p;
    }

    private void writeTestProperties(File testDirectory, Properties props) {
        try (FileOutputStream out = new FileOutputStream(this.getTestPropertiesFile(testDirectory));){
            props.store(out, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getTestPropertiesFile(File testDirectory) {
        return new File(testDirectory, "test.properties");
    }

    private void deleteOldTests(String idpConfigurationID, File[] testDirs) {
        int MAX_TEST_RECORDS = 10;
        if (testDirs.length > MAX_TEST_RECORDS) {
            for (int i = testDirs.length - 1; i >= MAX_TEST_RECORDS; --i) {
                this.deleteTestDirectory(idpConfigurationID, testDirs[i]);
            }
        }
    }

    private File[] getTestDirectories(String idpConfigurationID) {
        File directory = this.getTestsDirectory(idpConfigurationID);
        File[] testDirs = directory.listFiles(File::isDirectory);
        if (testDirs == null) {
            return new File[0];
        }
        Arrays.sort(testDirs, (o1, o2) -> {
            long diff = o2.lastModified() - o1.lastModified();
            return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        });
        return testDirs;
    }

    private File getTestDirectory(String idpConfigurationID, String testName) {
        return new File(this.getTestsDirectory(idpConfigurationID), testName);
    }

    private File getTestsDirectory(String idpConfigurationID) {
        File providerDirectory = this.getProviderDirectory(idpConfigurationID);
        return new File(providerDirectory, "tests");
    }

    java.util.List<TestRecord> getRecordedTests(String idpConfigurationID) {
        ArrayList<TestRecord> records = new ArrayList<TestRecord>();
        for (File dir : this.getTestDirectories(idpConfigurationID)) {
            if (System.currentTimeMillis() - dir.lastModified() > 259200000L) {
                this.deleteTestDirectory(idpConfigurationID, dir);
                continue;
            }
            records.add(this.readRecord(dir));
        }
        return records;
    }

    private TestRecord readRecord(File dir) {
        Properties props = this.readTestProperties(dir);
        return new TestRecord(dir.getName(), new Date(dir.lastModified()), props);
    }

    private OidcTestRecord readOidcRecord(File dir) {
        Properties props = this.readTestProperties(dir);
        return new OidcTestRecord(dir.getName(), new Date(dir.lastModified()), props);
    }

    TestRecord getRecordedTest(String idpConfigurationID, String evaluateId) {
        return this.readRecord(this.getTestDirectory(idpConfigurationID, evaluateId));
    }

    OidcTestRecord getRecordedOIDCTest(String idpConfigurationID, String evaluateId) {
        return this.readOidcRecord(this.getTestDirectory(idpConfigurationID, evaluateId));
    }

    File getRecordedTestRequestFile(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "request.xml");
    }

    File getRecordedTestResponseFile(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "response.xml");
    }

    File getRecordedTestStartedOIDCProcedureFile(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "oidcProcedureInit.json");
    }

    File getRecordedTestOidcProcedureFileBeforeRequest(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "oidcProcedureSetupBeforeRequest.json");
    }

    File getRecordedOIDCTestResponseFile(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "response.json");
    }

    File getRecordedTestOidcProcedureFileAfterResponse(String idpConfigurationID, String id) {
        return new File(this.getTestDirectory(idpConfigurationID, id), "oidcProcedureSetupAfterResponse.json");
    }

    void deleteTestDirectory(String idpConfigurationID, String testId) {
        File testDirectory = this.getTestDirectory(idpConfigurationID, testId);
        this.deleteTestDirectory(idpConfigurationID, testDirectory);
    }

    private void deleteTestDirectory(String idpConfigurationID, File testDir) {
        if (this.getTestsDirectory(idpConfigurationID).equals(testDir.getParentFile())) {
            try {
                FileUtils.deleteDirectory((File)testDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    String nextId() {
        return Long.toString(Math.abs(this.secureRandom.nextLong()), 36);
    }

    boolean isProviderOrDraft(String id) {
        if (id == null) {
            return true;
        }
        try {
            Long.parseLong(id, 36);
        }
        catch (NumberFormatException e) {
            return false;
        }
        for (IdpConfiguration idpConfiguration : this.getIdentityProviders()) {
            if (!idpConfiguration.getId().equals(id)) continue;
            return true;
        }
        File[] draftFiles = this.getProvidersDirectory().listFiles(pathname -> pathname.getName().equals(id + ".draft"));
        return draftFiles != null && draftFiles.length == 1;
    }

    private File[] getProviderDraftFiles() {
        File[] draftFiles = this.getProvidersDirectory().listFiles(pathname -> pathname.getName().endsWith(".draft"));
        return draftFiles == null ? new File[]{} : draftFiles;
    }

    public java.util.List<IdpDraft> getProviderDrafts() {
        ArrayList<IdpDraft> drafts = new ArrayList<IdpDraft>();
        for (File file : this.getProviderDraftFiles()) {
            String id = file.getName().substring(0, file.getName().indexOf("."));
            drafts.add(new IdpDraft(new Date(file.lastModified()), id, this.readProviderDraft(id)));
        }
        Collections.sort(drafts, (o1, o2) -> o2.getLastModified().compareTo(o1.getLastModified()));
        return drafts;
    }

    void addIdpCert(String id, byte[] certBytes) {
        if (certBytes == null || certBytes.length == 0) {
            return;
        }
        Document document = SamlXMLParser.parseProviderDocument(this.getProviderXmlFile(this.getProviderDirectory(id)));
        Element element = document.getDocumentElement();
        this.addCertificate(element, certBytes);
        this.persistProviderDocument(this.getProviderDirectory(id), document);
    }

    public void deleteIdpCert(String id, String deleteFingerprint) {
        Document document = SamlXMLParser.parseProviderDocument(this.getProviderXmlFile(this.getProviderDirectory(id)));
        Element element = document.getDocumentElement();
        NodeList certificates = element.getElementsByTagName(CERTIFICATE);
        for (int i = 0; i < certificates.getLength(); ++i) {
            Node certE = certificates.item(i);
            String textContent = certE.getTextContent();
            byte[] certBytes = Base64.decodeBase64(textContent);
            String fingerprint = Fingerprint.formatSsha1Fingerprint(certBytes);
            if (!deleteFingerprint.equals(fingerprint)) continue;
            element.removeChild(certE);
        }
        this.persistProviderDocument(this.getProviderDirectory(id), document);
    }

    public boolean isLicenseValid() {
        Option optionalLicense = this.pluginLicenseManager.getLicense();
        if (!optionalLicense.isDefined()) {
            return false;
        }
        PluginLicense pluginLicense = (PluginLicense)optionalLicense.get();
        return pluginLicense.isValid();
    }

    public int countActiveProviders() {
        int count = 0;
        for (IdpConfiguration idpConfiguration : this.getIdentityProviders()) {
            if (!idpConfiguration.isEnabled()) continue;
            ++count;
        }
        return count;
    }

    public boolean isSamlEnabled() {
        return !"false".equals(this.settings.get(KEYS.SAML_ENABLED.key));
    }

    void setSamlEnabled(boolean manualLoginLogEnabled) {
        this.settings.put(KEYS.SAML_ENABLED.key, (Object)Boolean.toString(manualLoginLogEnabled));
    }

    void deleteProviderDraft(String id) {
        File draft = new File(this.getProvidersDirectory(), id + ".draft");
        draft.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Properties readProviderDraft(String id) {
        File draft = new File(this.getProvidersDirectory(), id + ".draft");
        if (!draft.exists()) {
            return null;
        }
        Properties props = new Properties();
        try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(draft), StandardCharsets.UTF_8);){
            props.load(in);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void saveProviderDraft(Map<String, String> copyState, AddIdpAction.Step step) {
        File draft = new File(this.getProvidersDirectory(), copyState.get("id") + ".draft");
        draft.getParentFile().mkdirs();
        Properties props = new Properties();
        props.putAll(copyState);
        String nameValue = (String)props.get(NAME);
        if (nameValue != null) {
            props.put(NAME, new String(Base64.decodeBase64(nameValue)));
        }
        props.setProperty("step", step.getName());
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(draft), StandardCharsets.UTF_8);){
            props.store(out, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String commaSeparatedLongs(Set<Long> longs) {
        StringBuilder sb = new StringBuilder();
        for (Long l : longs) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(l);
        }
        return sb.toString();
    }

    private void addGroupElements(Element provider, Collection<ManagedGroup> managedGroups) {
        for (ManagedGroup managedGroup : managedGroups) {
            Element element = provider.getOwnerDocument().createElement(MANAGED_GROUP);
            element.setAttribute(NAME, managedGroup.getName());
            provider.appendChild(element);
        }
    }

    void updateSigningKeyPassword(String currentPassword, String newPassword) {
        if (currentPassword == null && newPassword == null) {
            return;
        }
        if (currentPassword != null && currentPassword.equals(newPassword)) {
            return;
        }
        if (this.isActiveSigningKeyDefined()) {
            SamlKeyGenerator generator = new SamlKeyGenerator(this.secureRandom);
            File[] keystoreFiles = this.getSigningKeysDirectory().listFiles(pathname -> pathname.getName().endsWith(".jks"));
            if (keystoreFiles != null) {
                for (File file : keystoreFiles) {
                    generator.getPrivateKey(file, currentPassword);
                }
                for (File file : keystoreFiles) {
                    generator.updatePassword(file, currentPassword, newPassword);
                }
            }
        }
    }

    public boolean isKnownAutoRedirect() {
        return !"false".equals(this.settings.get(KNOWN_AUTO_REDIRECT));
    }

    public boolean isSendLoginHint() {
        return !"false".equals(this.settings.get(SEND_LOGIN_HINT));
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        json.put("settings", this.getSettings());
        json.put("redirectProgressDelay", this.getRedirectProgressDelay());
        return json;
    }

    private static class ProviderState {
        private final String stateId;
        private final Collection<IdpConfiguration> idpConfigurations;

        ProviderState(String stateId, Collection<IdpConfiguration> idpConfigurations) {
            this.stateId = stateId;
            this.idpConfigurations = idpConfigurations;
        }

        Collection<IdpConfiguration> getIdpConfigurations() {
            return this.idpConfigurations;
        }

        boolean isCurrent(String stateId) {
            if (stateId == null) {
                return this.stateId == null;
            }
            return stateId.equals(this.stateId);
        }
    }

    private static enum KEYS {
        SAML_STATE_ID("samlStateId"),
        SAML_ENABLED("samlEnabled"),
        SAML_PRIVATE_KEY_PASSWORD("samlPrivateKeyPassword"),
        REDIRECT_CUSTOM_PROGRESS_DELAY("redirectCustomProgressDelay"),
        LOGIN_ENABLED_FOR_JSD("loginEnabledForJSD");

        private final String key;

        private KEYS(String key) {
            this.key = key;
        }
    }
}

