/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.kantega.atlaskerb.saml.Fingerprint;

public class FingerprintSSLSocketFactory
extends SSLSocketFactory {
    private static FingerprintSSLSocketFactory instance;
    private final SSLContext context;
    private final SSLSocketFactory socketFactory;

    public FingerprintSSLSocketFactory() {
        this(null);
    }

    public FingerprintSSLSocketFactory(String fingerprint) {
        try {
            this.context = SSLContext.getInstance("TLS");
            this.context.init(null, new TrustManager[]{new FingerprintTrustManager(fingerprint)}, new SecureRandom());
            this.socketFactory = this.context.getSocketFactory();
            instance = this;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLSocketFactory getDefault() {
        return instance;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoclose) throws IOException {
        return this.socketFactory.createSocket(socket, host, port, autoclose);
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.socketFactory.createSocket(address, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.socketFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localhost, int localPort) throws IOException {
        return this.socketFactory.createSocket(address, port, localhost, localPort);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.context.getDefaultSSLParameters().getCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.context.getDefaultSSLParameters().getCipherSuites();
    }

    public static class FingerPrintException
    extends CertificateException {
        private final X509Certificate[] x509Certificates;

        public FingerPrintException(String message, X509Certificate[] x509Certificates) {
            super(message);
            this.x509Certificates = x509Certificates;
        }

        public X509Certificate[] getX509Certificates() {
            return this.x509Certificates;
        }
    }

    private static class FingerprintTrustManager
    implements X509TrustManager {
        private final String fingerprint;
        private final List<X509TrustManager> defaultTrustManagers = new ArrayList<X509TrustManager>();

        public FingerprintTrustManager(String fingerprint) {
            this.fingerprint = fingerprint == null ? null : fingerprint.trim().replace(" ", "");
            try {
                TrustManagerFactory factory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory2.init((KeyStore)null);
                for (TrustManager trustManager : factory2.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    this.defaultTrustManagers.add((X509TrustManager)trustManager);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            for (X509TrustManager defaultTrustManager : this.defaultTrustManagers) {
                try {
                    defaultTrustManager.checkServerTrusted(x509Certificates, s);
                    return;
                }
                catch (CertificateException certificateException) {
                }
            }
            if (this.fingerprint != null) {
                for (X509Certificate x509Certificate : x509Certificates) {
                    new Fingerprint();
                    String signatureFingerprint = Fingerprint.sha1Fingerprint(x509Certificate.getEncoded());
                    if (!signatureFingerprint.equals(this.fingerprint)) continue;
                    return;
                }
            }
            throw new FingerPrintException("Certificate with expected fingerprint not found", x509Certificates);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

