/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.API;
import io.vavr.collection.List;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONObject;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PrincipalEntry;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.TestKerberosAction;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.oidc.InitiateOidcLogin;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCStateCache;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OIDCResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OIDCResponseEvaluator;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluator;
import org.kantega.atlaskerb.saml.AtlSpServletSupport;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;
import org.kantega.atlaskerb.saml.ServiceProviderFactory;
import org.kantega.atlaskerb.saml.TestRecord;
import org.kantega.atlaskerb.saml.util.ErrorPageRenderer;
import org.kantega.samllib.spi.AuthnState;
import org.kantega.samllib.spi.AuthnStateCache;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.kantega.samllib.validation.SamlResponseValidator;
import org.kantega.samllib.validation.ValidationResult;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.xmlsec.signature.impl.X509CertificateImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class EvaluateTestServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final IdpConfManager idpConfManager;
    private final KerbConfManager kerbConfManager;
    private final SAMLResponseEvaluator samlResponseEvaluator;
    private final OIDCResponseEvaluator oidcResponseEvaluator;
    private final PluginLicenseManager licenseManager;
    private final ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private final OIDCStateCache oidcStateCache;
    private final ServiceProviderFactory serviceProviderFactory;
    private final ConnectorConfManager connectorConfManager;
    private final OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper;
    private final ErrorPageRenderer errorPageRenderer;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Inject
    public EvaluateTestServlet(RequireAdminServletDependencyBucket bucket, SAMLResponseEvaluator samlResponseEvaluator, OIDCResponseEvaluator oidcResponseEvaluator, OIDCStateCache oidcStateCache, ServiceProviderFactory serviceProviderFactory, ErrorPageRenderer errorPageRenderer, OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.userManager = bucket.getUserManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.licenseManager = bucket.getPluginLicenseManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.samlResponseEvaluator = samlResponseEvaluator;
        this.oidcResponseEvaluator = oidcResponseEvaluator;
        this.oidcStateCache = oidcStateCache;
        this.serviceProviderFactory = serviceProviderFactory;
        this.oidcProcedureFactoryWrapper = bucket.getOidcProcedureFactoryWrapper();
        this.errorPageRenderer = errorPageRenderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IdpConfiguration idp = this.idpConfManager.getIdentityProviderById(this.getId(request));
        if (idp == null) {
            response.sendError(404);
            return;
        }
        IdpConfiguration.UserLookupAttribute userLookupAttribute = this.getUserLookupAttributeFromConfig(idp);
        this.runTest(idp, request, response, idp.getUsernameAttribute(), userLookupAttribute, idp.getUserLookupTransform(), idp.getCustomNameAttribute(), idp.getCustomEmailAttribute(), idp.getCustomUsernameAttributeName(), idp.getSelectedUsernameAttributeInfo());
    }

    private IdpConfiguration.UserLookupAttribute getUserLookupAttributeFromConfig(IdpConfiguration idp) {
        IdpConfiguration.UserLookupAttribute userLookupAttribute = idp.getUserLookupAttribute();
        if (idp.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE) {
            userLookupAttribute = IdpConfiguration.UserLookupAttribute.USERNAME;
        }
        return userLookupAttribute;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IdpConfiguration current = this.idpConfManager.getIdentityProviderById(this.getId(request));
        if (current == null) {
            response.sendError(404);
            return;
        }
        IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(current);
        if (request.getParameter("addKnownDomain") != null) {
            String domain = StringUtils.trim(request.getParameter("domain"));
            if (StringUtils.isNotEmpty(domain)) {
                builder.getKnownDomains().add(domain);
            }
        } else if (request.getParameter("allowAllDomains") != null) {
            builder.setUsernamePolicy(IdpConfiguration.UsernamePolicy.ANY);
        }
        if (request.getParameter("manageGroups") != null) {
            TreeSet<ManagedGroup> managed = new TreeSet<ManagedGroup>(current.getManagedGroups());
            this.getGroupUpdates(request).stream().map(ManagedGroup::new).forEach(managed::add);
            builder.setManagedGroups(new ArrayList<ManagedGroup>(managed));
        }
        current = builder.build();
        this.idpConfManager.updateIdpConfiguration(current);
        String selectedAttributeInfo = request.getParameter("selectedAttributeInfo");
        IdpConfiguration.UsernameAttribute usernameAttribute = this.getUsernameAttribute(request, current, selectedAttributeInfo);
        IdpConfiguration.UserLookupAttribute userLookupAttribute = IdpConfiguration.UserLookupAttribute.valueOf(request.getParameter("userLookupAttribute"));
        String customNameAttribute = StringUtils.trimToNull(request.getParameter("customNameAttributeSelector"));
        String customEmailAttribute = StringUtils.trimToNull(request.getParameter("customEmailAttributeSelector"));
        String customUsernameAttributeName = selectedAttributeInfo;
        if (current.getProtocol() == IdpConfiguration.SSOProtocol.SAML) {
            customUsernameAttributeName = request.getParameter("customUsernameAttributeName");
        }
        if (request.getParameter("saveSettings") != null) {
            IdpConfigurationBuilder<?, ?> b = IdpConfigurationBuilder.ofGeneric(current);
            b.setUsernameAttribute(usernameAttribute);
            b.setUserLookupAttribute(userLookupAttribute);
            b.setCustomNameAttribute(customNameAttribute);
            b.setCustomEmailAttribute(customEmailAttribute);
            b.setCustomUsernameAttributeName(customUsernameAttributeName);
            b.setSelectedUsernameAttributeInfo(selectedAttributeInfo);
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)b.build());
            response.sendRedirect("evaluate-test?id=" + request.getParameter("id"));
        } else {
            this.runTest(current, request, response, usernameAttribute, userLookupAttribute, current.getUserLookupTransform(), customNameAttribute, customEmailAttribute, customUsernameAttributeName, selectedAttributeInfo);
        }
    }

    private IdpConfiguration.UsernameAttribute getUsernameAttribute(HttpServletRequest request, IdpConfiguration existingIdp, String selectedAttributeInfo) {
        if (existingIdp.getProtocol() == IdpConfiguration.SSOProtocol.OIDC) {
            return AttributeInfo.getUsernameAttributeOf(selectedAttributeInfo);
        }
        return IdpConfiguration.UsernameAttribute.valueOf(request.getParameter("usernameAttribute"));
    }

    @NotNull
    private Set<String> getGroupUpdates(HttpServletRequest request) {
        TreeSet<String> addGroups = new TreeSet<String>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String param = (String)parameterNames.nextElement();
            if (!param.startsWith("manage_group_")) continue;
            addGroups.add(param.substring("manage_group_".length()));
        }
        return addGroups;
    }

    private void runTest(IdpConfiguration idp, HttpServletRequest request, HttpServletResponse response, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customEmailAttribute, String customUsernameAttributeName, String selectedUsernameAttributeInfo) throws IOException {
        if (request.getParameter("run") != null) {
            if (idp.isSAML()) {
                response.sendRedirect(this.idpConfManager.getServiceProviderLoginURL(request, idp.getId()) + "?test");
            } else if (idp.isOIDC()) {
                String callbackUrl = ResumeOidcLoginServlet.getCallbackUrl(this.applicationProperties);
                boolean prepareOnly = true;
                OIDCIdpConfiguration oidcIdpConfiguration = (OIDCIdpConfiguration)idp;
                response.sendRedirect(InitiateOidcLogin.run(request, response, oidcIdpConfiguration, this.idpConfManager, callbackUrl, null, null, prepareOnly, this.oidcStateCache, null, this.oidcProcedureFactoryWrapper, this.errorPageRenderer, this.userManager));
            }
            return;
        }
        String id = request.getParameter("id");
        if (id != null) {
            TestRecord record;
            TestRecord testRecord = record = idp.isSAML() ? this.idpConfManager.getRecordedTest(idp.getId(), id) : this.idpConfManager.getRecordedOIDCTest(idp.getId(), id);
            if (record == null) {
                response.sendError(404);
                return;
            }
            if (idp.isSAML()) {
                this.evaluateTest((SAMLIdpConfiguration)idp, record, request, response, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customEmailAttribute, customUsernameAttributeName);
            } else if (idp.isOIDC()) {
                this.evaluateTest((OIDCIdpConfiguration)idp, record, request, response, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customEmailAttribute, customUsernameAttributeName, selectedUsernameAttributeInfo);
            }
        } else {
            response.sendError(404);
        }
    }

    private void checkNonstandardSeraphAuthenticator(Map<String, Object> model) {
        String nonStandardAuthenticator = this.hostApp.hasNonStandardAuthenticator();
        if (nonStandardAuthenticator != null) {
            model.put("nonStandardSeraphAuthenticator", nonStandardAuthenticator);
            model.put("standardSeraphAuthenticator", this.hostApp.getStandardAuthenticatorClassName());
        }
    }

    private void evaluateTest(SAMLIdpConfiguration idp, TestRecord record, HttpServletRequest req, HttpServletResponse resp, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customEmailAttribute, String customUsernameAttributeName) throws IOException {
        File responseFile;
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        Map<String, Object> model = this.newModel(req);
        this.checkNonstandardSeraphAuthenticator(model);
        model.put("validationResult", null);
        model.put("knownAttributeNames", this.samlResponseEvaluator.getKnownAttributeNames());
        model.put("topMenu", "SAML");
        model.put("menuItem", "providerTest");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("crowdURL", req.getContextPath() + "/plugins/servlet/embedded-crowd/directories/list");
        model.put("userLookupService", this.userLookupService);
        model.put("idp", idp);
        model.put("record", record);
        model.put("dateTool", new DateTool());
        model.put("dirtySettings", this.isSettingsDirty(idp, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customEmailAttribute, customUsernameAttributeName));
        model.put("samlConfigURL", this.idpConfManager.getIdpConfigUrl(req));
        model.put("certTool", new CertTool());
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(idp.getKind()));
        model.put("matchingConnectorType", this.connectorConfManager.findMatchingConnectorType(idp.getKind()));
        this.checkLicensing(model);
        model.put("providerUrl", this.idpConfManager.getProviderAdminURL(idp.getId(), req));
        model.put("loginUrl", this.idpConfManager.getServiceProviderLoginURL(req, idp.getId()));
        model.put("usernameAttribute", (Object)usernameAttribute);
        model.put("userLookupAttribute", (Object)userLookupAttribute);
        model.put("userLookupTransform", (Object)userLookupTransform);
        model.put("userLookupAttributes", IdpConfiguration.UserLookupAttribute.values());
        model.put("customNameAttribute", customNameAttribute);
        model.put("customEmailAttribute", customEmailAttribute);
        model.put("hasCustomUserAttribute", customNameAttribute != null || customEmailAttribute != null);
        model.put("hasLDAPDirectories", this.userLookupService.hasActiveLDAPDirectories());
        if (customUsernameAttributeName == null) {
            customUsernameAttributeName = idp.getCustomUsernameAttributeName();
        }
        model.put("customUsernameAttributeName", customUsernameAttributeName);
        File requestFile = this.idpConfManager.getRecordedTestRequestFile(idp.getId(), record.getId());
        if (requestFile.exists()) {
            AuthnRequest authnRequest = this.parseRequestFile(requestFile);
            model.put("requestXML", AtlSpServletSupport.formatXml(authnRequest.getDOM()));
        }
        if ((responseFile = this.idpConfManager.getRecordedTestResponseFile(idp.getId(), record.getId())).exists()) {
            Response response = this.parseResponseFile(responseFile);
            model.put("responseXML", AtlSpServletSupport.formatXml(response.getDOM()));
            ServiceProviderSpi instance = this.serviceProviderFactory.getInstance(idp);
            Properties props = this.idpConfManager.getTestProperties(idp.getId(), record);
            Optional<String> responseTime = Optional.ofNullable(props.getProperty("responseTime"));
            if (!responseTime.isPresent()) {
                model.put("incompleteResponse", true);
            }
            DateTime now = ISODateTimeFormat.dateTimeParser().parseDateTime(responseTime.orElse(DateTime.now().toString()));
            TestPageAuthnStateCache authnStateCache = new TestPageAuthnStateCache();
            authnStateCache.put(record.getId(), new AuthnState());
            SamlResponseValidationResult result = new SamlResponseValidationResult(req, resp, instance, now);
            new SamlResponseValidator(null, authnStateCache, instance).validate(response, result);
            if (result.hasDecryptedAssertions()) {
                model.put("hasDecryptedAssertions", true);
                model.put("decryptedAssertionsXML", result.getDecryptedAssertions().stream().map(assertion -> AtlSpServletSupport.formatXml(assertion.getDOM())).collect(Collectors.toList()));
            }
            CertTool certTool = new CertTool();
            java.util.List validationResults = List.ofAll(result.getResults()).map(res -> {
                Map<String, Object> resModel = res.getModel();
                JSONObject parsedCert = io.vavr.collection.HashMap.ofAll(resModel).get("cert").toTry().mapTry(cert -> (X509CertificateImpl)cert).mapTry(X509CertificateImpl::getValue).filterTry(Objects::nonNull).mapTry(certTool::parse).mapTry(cert -> {
                    JSONObject certJson = new JSONObject();
                    certJson.put("subjectDn", cert.getSubjectDN().getName());
                    certJson.put("issuerDn", cert.getIssuerDN().getName());
                    certJson.put("notBefore", cert.getNotBefore().toString());
                    certJson.put("notAfter", cert.getNotAfter().toString());
                    certJson.put("sigAlgName", cert.getSigAlgName());
                    certJson.put("keySize", String.valueOf(certTool.getKeySize((X509Certificate)cert)));
                    certJson.put("fingerPrint", certTool.fingerPrint(cert.getEncoded()));
                    return certJson;
                }).getOrElse(new JSONObject());
                Map<String, Object> parsedModel = API.Map("cert", resModel.get("cert"), "parsedCert", parsedCert).toJavaMap();
                return new ValidationResult(res.getMessage(), res.getType(), parsedModel);
            }).asJava();
            model.put("samlValidationResults", validationResults);
            SAMLResponseEvaluationResult evaluationResult = this.samlResponseEvaluator.evaluate(idp, result, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customEmailAttribute, customUsernameAttributeName, false);
            model.put("evaluationResult", evaluationResult);
            boolean serviceUrlWithHttps = StringUtils.startsWith(StringUtils.lowerCase(this.idpConfManager.getServiceProviderLoginURL(req, idp.getId())), "https");
            model.put("notHttps", !serviceUrlWithHttps);
            AttributeInfo configuredAttribute = evaluationResult.getConfiguredUsernameAttributeInfo();
            if (configuredAttribute != null) {
                model.put("configuredUsernameAttribute", configuredAttribute);
                boolean userDomainRejected = evaluationResult.isUserDomainRejected();
                model.put("userDomainRejected", userDomainRejected);
                boolean success = false;
                String username = null;
                if (evaluationResult.getResolvedPrincipalEntry() != null) {
                    PrincipalEntry pe = evaluationResult.getResolvedPrincipalEntry();
                    if (pe.getPrincipal().isPresent()) {
                        Principal user = pe.getPrincipal().get();
                        username = user.getName();
                        model.put("usersDirectory", this.hostApp.getDirectoryForUser(user.getName()));
                        model.put("userPrincipal", user);
                        model.put("userProfile", this.userManager.getUserProfile(user.getName()));
                        model.put("contextPath", req.getContextPath());
                        boolean canLogin = this.hostApp.canLogin(user, req);
                        model.put("canLogin", canLogin);
                        success = canLogin && !userDomainRejected && pe.getUserState() == PrincipalEntry.UserState.FOUND;
                    }
                    model.put("isActive", pe.getUserState() != PrincipalEntry.UserState.INACTIVE);
                } else if (evaluationResult.getUserRecipe() != null) {
                    UserRecipe userRecipe = evaluationResult.getUserRecipe();
                    model.put("userRecipe", userRecipe);
                    if (userRecipe.isComplete()) {
                        username = userRecipe.getUsername().getValue();
                        boolean bl = success = !userDomainRejected;
                    }
                }
                if (username != null) {
                    this.samlResponseEvaluator.evaluateGroups(username, idp.getManagedGroups(), this.samlResponseEvaluator.findSamlGroups(result.getAssertions()), evaluationResult.getGroupEvaluation(), idp.isCreateAllIncomingGroups());
                    boolean requiredGroupsForCreation = IdpConfManager.hasRequiredGroupsForCreation(idp, evaluationResult.getGroupEvaluation().getManagedGroups());
                    model.put("hasRequiredGroupsForCreation", requiredGroupsForCreation);
                    model.put("success", success && requiredGroupsForCreation);
                } else {
                    model.put("success", success);
                }
            }
            this.idpConfManager.updateAndStoreTestresults(idp.getId(), result, evaluationResult);
        }
        TestKerberosAction.addDebugInfo(req, model, this.connectorConfManager, this.idpConfManager, this.kerbConfManager, this.applicationProperties, this.userLookupService, "SAML");
        StringWriter debuginfo = new StringWriter();
        this.renderer.render("templates/atlaskerb/debuginfo.vm", model, (Writer)debuginfo);
        model.put("debugInfo", debuginfo);
        this.renderer.render("templates/saml/test-eval.vm", model, (Writer)resp.getWriter());
    }

    private void evaluateTest(OIDCIdpConfiguration idp, TestRecord record, HttpServletRequest req, HttpServletResponse resp, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customEmailAttribute, String customUsernameAttributeName, String selectedUsernameAttributeInfo) throws IOException {
        File responseFile;
        Try<String> oidcProcedureJson;
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        Map<String, Object> model = this.newModel(req);
        this.checkNonstandardSeraphAuthenticator(model);
        model.put("validationResult", null);
        model.put("topMenu", "SAML");
        model.put("menuItem", "providerTest");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("crowdURL", req.getContextPath() + "/plugins/servlet/embedded-crowd/directories/list");
        model.put("userLookupService", this.userLookupService);
        model.put("idp", idp);
        model.put("record", record);
        model.put("dateTool", new DateTool());
        model.put("dirtySettings", this.isOidcSettingsDirty(idp, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customEmailAttribute, customUsernameAttributeName, selectedUsernameAttributeInfo));
        model.put("certTool", new CertTool());
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(idp.getKind()));
        model.put("matchingConnectorType", this.connectorConfManager.findMatchingConnectorType(idp.getKind()));
        this.checkLicensing(model);
        model.put("usernameAttribute", (Object)usernameAttribute);
        model.put("selectedAttributeInfo", selectedUsernameAttributeInfo);
        model.put("userLookupAttribute", (Object)userLookupAttribute);
        model.put("userLookupTransform", (Object)userLookupTransform);
        model.put("userLookupAttributes", IdpConfiguration.UserLookupAttribute.values());
        model.put("customNameAttribute", customNameAttribute);
        model.put("customEmailAttribute", customEmailAttribute);
        model.put("hasCustomUserAttribute", customNameAttribute != null || customEmailAttribute != null);
        model.put("hasLDAPDirectories", this.userLookupService.hasActiveLDAPDirectories());
        model.put("customUsernameAttributeName", customUsernameAttributeName);
        Try.of(() -> this.idpConfManager.getTestProperties(idp.getId(), record)).onSuccess(testProperties -> {
            boolean isError = Option.of(testProperties.getProperty("error")).isDefined();
            if (isError) {
                model.put("isErrorTestResult", true);
                model.put("errorCode", testProperties.getProperty("errorCode"));
                model.put("errorMessage", testProperties.getProperty("errorMessage"));
                model.put("oidcTestError", testProperties.getProperty("error"));
            }
            model.put("responseTime", testProperties.getProperty("responseTime"));
        });
        File beforeRequestProcedureFile = this.idpConfManager.getRecordedTestOidcProcedureFileBeforeRequest(idp.getId(), record.getId());
        File initProcedureFile = this.idpConfManager.getRecordedTestStartedOIDCProcedureFile(idp.getId(), record.getId());
        if (beforeRequestProcedureFile.exists()) {
            oidcProcedureJson = this.readOidcProcedureJsonRepresentationFromFile(beforeRequestProcedureFile);
            oidcProcedureJson.onSuccess(jsonString -> model.put("oidcProcedureJsonBeforeRequest", jsonString));
        } else if (initProcedureFile.exists()) {
            oidcProcedureJson = this.readOidcProcedureJsonRepresentationFromFile(initProcedureFile);
            oidcProcedureJson.onSuccess(jsonString -> model.put("oidcProcedureJsonBeforeRequest", jsonString));
        }
        File afterResponseProcedureFile = this.idpConfManager.getRecordedTestOidcProcedureFileAfterResponse(idp.getId(), record.getId());
        if (afterResponseProcedureFile.exists()) {
            Try<String> oidcProcedureJson2 = this.readOidcProcedureJsonRepresentationFromFile(afterResponseProcedureFile);
            oidcProcedureJson2.onSuccess(jsonString -> model.put("oidcProcedureJsonAfterResponse", jsonString));
        }
        if ((responseFile = this.idpConfManager.getRecordedOIDCTestResponseFile(idp.getId(), record.getId())).exists()) {
            JSONObject profileJson = this.parseJsonProfile(responseFile);
            model.put("profile", profileJson);
            Either<String, OIDCResponseEvaluationResult> maybeEvaluationResult = this.oidcResponseEvaluator.evaluate(idp, profileJson, usernameAttribute, userLookupAttribute, userLookupTransform, customNameAttribute, customEmailAttribute, customUsernameAttributeName, false);
            if (maybeEvaluationResult.isLeft()) {
                model.put("failedEvaluation", maybeEvaluationResult.getLeft());
            } else {
                model.put("evaluationResult", maybeEvaluationResult.get());
                boolean serviceUrlWithHttps = StringUtils.startsWith(StringUtils.lowerCase(this.idpConfManager.getServiceProviderLoginURL(req, idp.getId())), "https");
                model.put("notHttps", !serviceUrlWithHttps);
                AttributeInfo configuredAttribute = maybeEvaluationResult.get().getConfiguredUsernameAttributeInfo();
                if (configuredAttribute != null) {
                    model.put("configuredUsernameAttribute", configuredAttribute);
                    boolean userDomainRejected = maybeEvaluationResult.get().isUserDomainRejected();
                    model.put("userDomainRejected", userDomainRejected);
                    boolean success = false;
                    String username = null;
                    if (maybeEvaluationResult.get().getResolvedPrincipalEntry() != null) {
                        PrincipalEntry pe = maybeEvaluationResult.get().getResolvedPrincipalEntry();
                        if (pe.getPrincipal().isPresent()) {
                            Principal user = pe.getPrincipal().get();
                            username = user.getName();
                            model.put("usersDirectory", this.hostApp.getDirectoryForUser(user.getName()));
                            model.put("userPrincipal", user);
                            model.put("userProfile", this.userManager.getUserProfile(user.getName()));
                            model.put("contextPath", req.getContextPath());
                            boolean canLogin = this.hostApp.canLogin(user, req);
                            model.put("canLogin", canLogin);
                            success = canLogin && !userDomainRejected && pe.getUserState() == PrincipalEntry.UserState.FOUND;
                        }
                        model.put("isActive", pe.getUserState() != PrincipalEntry.UserState.INACTIVE);
                    } else if (maybeEvaluationResult.get().getUserRecipe() != null) {
                        UserRecipe userRecipe = maybeEvaluationResult.get().getUserRecipe();
                        model.put("userRecipe", userRecipe);
                        if (userRecipe.isComplete()) {
                            username = userRecipe.getUsername().getValue();
                            boolean bl = success = !userDomainRejected;
                        }
                    }
                    if (username != null) {
                        this.oidcResponseEvaluator.evaluateGroups(username, idp.getManagedGroups(), this.oidcResponseEvaluator.findOidcGroups(profileJson, idp.getIdpGroupsAttributes()), maybeEvaluationResult.get().getGroupEvaluation(), idp.isCreateAllIncomingGroups());
                        boolean requiredGroupsForCreation = IdpConfManager.hasRequiredGroupsForCreation(idp, maybeEvaluationResult.get().getGroupEvaluation().getManagedGroups());
                        model.put("hasRequiredGroupsForCreation", requiredGroupsForCreation);
                        model.put("success", success && requiredGroupsForCreation);
                    } else {
                        model.put("success", success);
                    }
                }
                this.idpConfManager.updateAndStoreTestresults(idp.getId(), record.getId(), maybeEvaluationResult.get());
            }
        }
        TestKerberosAction.addDebugInfo(req, model, this.connectorConfManager, this.idpConfManager, this.kerbConfManager, this.applicationProperties, this.userLookupService, "OIDC");
        StringWriter debuginfo = new StringWriter();
        this.renderer.render("templates/atlaskerb/debuginfo.vm", model, (Writer)debuginfo);
        model.put("debugInfo", debuginfo);
        this.renderer.render("templates/saml/oidc-test-eval.vm", model, (Writer)resp.getWriter());
    }

    private Try<String> readOidcProcedureJsonRepresentationFromFile(File oidcProcedureFile) {
        return JsonMapping.Read.jsonObjectFromFile(oidcProcedureFile).mapTry(JSONObject::toString);
    }

    private boolean isSettingsDirty(IdpConfiguration idp, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customEmailAttribute, String customUsernameAttributeName) {
        return usernameAttribute != idp.getUsernameAttribute() || userLookupAttribute != this.getUserLookupAttributeFromConfig(idp) || userLookupTransform != idp.getUserLookupTransform() || !StringUtils.equals(idp.getCustomNameAttribute(), customNameAttribute) || !StringUtils.equals(idp.getCustomEmailAttribute(), customEmailAttribute) || !StringUtils.equals(idp.getCustomUsernameAttributeName(), customUsernameAttributeName);
    }

    private boolean isOidcSettingsDirty(IdpConfiguration idp, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String customNameAttribute, String customEmailAttribute, String customUsernameAttributeName, String selectedUsernameAttributeInfo) {
        return usernameAttribute != idp.getUsernameAttribute() || userLookupAttribute != this.getUserLookupAttributeFromConfig(idp) || userLookupTransform != idp.getUserLookupTransform() || !StringUtils.equals(idp.getCustomNameAttribute(), customNameAttribute) || !StringUtils.equals(idp.getCustomEmailAttribute(), customEmailAttribute) || !StringUtils.equals(idp.getCustomUsernameAttributeName(), customUsernameAttributeName) || !StringUtils.equals(idp.getSelectedUsernameAttributeInfo(), selectedUsernameAttributeInfo);
    }

    private Response parseResponseFile(File responseFile) {
        return (Response)this.parse(responseFile);
    }

    private AuthnRequest parseRequestFile(File requestFile) {
        return (AuthnRequest)this.parse(requestFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XMLObject parse(File responseFile) {
        try (FileInputStream is = new FileInputStream(responseFile);){
            XMLObject xMLObject = XMLObjectSupport.unmarshallFromInputStream(this.parserPool, is);
            return xMLObject;
        }
        catch (IOException | XMLParserException | UnmarshallingException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject parseJsonProfile(File responseFile) {
        try {
            FileReader fileReader = new FileReader(responseFile);
            StringBuilder jsonStringBuilder = new StringBuilder();
            while (fileReader.ready()) {
                jsonStringBuilder.append((char)fileReader.read());
            }
            String jsonString = jsonStringBuilder.toString();
            return new JSONObject(jsonString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }

    private void checkLicensing(Map<String, Object> model) {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.licenseManager.getLicense().get();
            model.put("license", license);
            model.put("licenseValid", license.isValid());
        } else {
            model.put("licenseMissing", Boolean.TRUE);
        }
    }

    private static class TestPageAuthnStateCache
    implements AuthnStateCache {
        private final Map<String, AuthnState> cache = new HashMap<String, AuthnState>();

        private TestPageAuthnStateCache() {
        }

        @Override
        public void put(String authnRequestId, AuthnState state) {
            this.cache.put(authnRequestId, state);
        }

        @Override
        public AuthnState remove(String authnRequestId) {
            return this.cache.remove(authnRequestId);
        }
    }
}

