/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.DiscoverIdpHelper;
import org.kantega.atlaskerb.saml.IdpConfManager;

@Scanned
public class DiscoverIdpServlet
extends HttpServlet {
    private final IdpConfManager idpConfManager;
    private final UserManager userManager;
    private final HostApp hostApp;
    private final UserLookupService userLookupService;
    private final DiscoverIdpHelper discoverIdpHelper;

    @Inject
    public DiscoverIdpServlet(IdpConfManager idpConfManager, HostAppFactory hostAppFactory, @ComponentImport UserManager userManager, UserLookupService userLookupService) {
        this.idpConfManager = idpConfManager;
        this.userManager = userManager;
        this.hostApp = hostAppFactory.getInstance();
        this.userLookupService = userLookupService;
        this.discoverIdpHelper = new DiscoverIdpHelper(this.hostApp, userLookupService, idpConfManager);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        Option<String> maybeUsername = Option.of(req.getParameter("username"));
        Map data = ((HashMap)((HashMap)maybeUsername.map(username -> this.getProvidersByUsername(req, (String)username)).getOrElse(() -> this.getProviders(req)).merge(this.discoverIdpHelper.discoverIdpProviders(maybeUsername.getOrElse("")).isEmpty() ? HashMap.of("fallbacks", this.getIdentityProviders(req, this.idpConfManager.getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy.FALLBACK))) : HashMap.empty())).merge(!this.idpConfManager.isKnownAutoRedirect() ? HashMap.of("manual", this.getIdentityProviders(req, this.idpConfManager.getProvidersByRedirectPolicy(EnumSet.of(IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN, IdpConfiguration.RedirectPolicy.USER_DIRECTORY, IdpConfiguration.RedirectPolicy.USER_GROUP)))) : HashMap.empty())).merge((Map)(this.hasPreviouslyKnownLogin(req) ? HashMap.of("last", this.getPreviouslyKnownLoginId(req).map(this.idpConfManager::getEnabledIdentityProviderById).filter(Objects::nonNull).filter(idp -> idp.getRedirectPolicy() != IdpConfiguration.RedirectPolicy.NONE).map(idp -> io.vavr.collection.List.ofAll(this.getIdentityProviders(req, io.vavr.collection.List.of(idp).asJava()))).getOrElse(io.vavr.collection.List.empty()).map(providerMap -> HashMap.ofAll(providerMap).merge((Map)this.getPreviouslyKnownLoginUsername(req).map(username -> HashMap.of("account", username)).getOrElse(HashMap.empty()))).getOrElse(HashMap.empty()).toJavaMap()) : HashMap.empty()));
        JsonMapping.Write.mapAsJson(data.toJavaMap()).mapTry(JSONObject::toString).andThenTry(jsonString -> {
            PrintWriter w = resp.getWriter();
            w.print((String)jsonString);
        }).onSuccess(_jsonString -> resp.setStatus(200)).onFailure(_e -> resp.setStatus(204));
    }

    @NotNull
    private HashMap<String, Object> getProviders(HttpServletRequest req) {
        return HashMap.of("auto", this.getIdentityProviders(req, this.idpConfManager.getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy.ALL)), "manual", this.getIdentityProviders(req, this.idpConfManager.getProvidersByRedirectPolicy(EnumSet.of(IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN, IdpConfiguration.RedirectPolicy.USER_DIRECTORY, IdpConfiguration.RedirectPolicy.USER_GROUP))), "visible", this.getIdentityProviders(req, this.idpConfManager.getProvidersByVisibility(true)), "enableWorkAccount", !this.idpConfManager.getProvidersByRedirectPolicy(EnumSet.of(IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN, IdpConfiguration.RedirectPolicy.USER_DIRECTORY, IdpConfiguration.RedirectPolicy.USER_GROUP, IdpConfiguration.RedirectPolicy.FALLBACK, IdpConfiguration.RedirectPolicy.ALL)).isEmpty(), "isAuthenticated", this.hostApp.isLoggedIn(req), "redirectProgressDelay", 1000 * this.idpConfManager.getRedirectProgressDelay());
    }

    @NotNull
    private HashMap<String, Object> getProvidersByUsername(HttpServletRequest req, String username) {
        return HashMap.of("matches", this.getIdentityProviders(req, this.discoverIdpHelper.discoverIdpProviders(username)), "isSystemAdmin", Option.of(this.userManager.getUserProfile(username)).map(user -> this.userManager.isSystemAdmin(user.getUserKey())).getOrElse(false));
    }

    private Option<String> getPreviouslyKnownLoginId(HttpServletRequest req) {
        return Option.of(req.getCookies()).map(Stream::of).getOrElse(Stream.empty()).filter(cookie -> "sml_lst_act".equals(cookie.getName())).map(Cookie::getValue).map(value -> value.contains(":") ? value.substring(0, value.indexOf(":")) : value).headOption();
    }

    private Option<String> getPreviouslyKnownLoginUsername(HttpServletRequest req) {
        return Option.of(req.getCookies()).map(Stream::of).getOrElse(Stream.empty()).filter(cookie -> "sml_lst_act".equals(cookie.getName())).map(Cookie::getValue).map(value -> value.contains(":") ? value.substring(value.indexOf(":") + 1) : "").headOption();
    }

    private boolean hasPreviouslyKnownLogin(HttpServletRequest req) {
        return this.getPreviouslyKnownLoginId(req).map(this.idpConfManager::getEnabledIdentityProviderById).filter(Objects::nonNull).filter(idp -> idp.getRedirectPolicy() != IdpConfiguration.RedirectPolicy.NONE).map(_idp -> true).getOrElse(false);
    }

    private List<java.util.HashMap<String, String>> getIdentityProviders(HttpServletRequest req, List<IdpConfiguration> idpConfigurations) {
        return io.vavr.collection.List.ofAll(idpConfigurations).map(idp -> this.createProviderMap(req, (IdpConfiguration)idp)).asJava();
    }

    private java.util.HashMap<String, String> createProviderMap(HttpServletRequest req, IdpConfiguration idp) {
        return ((HashMap)HashMap.of("id", idp.getId(), "loginUrl", this.idpConfManager.getServiceProviderLoginURL(req, idp.getId()), "name", idp.getName(), "useHostedDomain", Boolean.valueOf(idp.isHostedDomain()).toString(), "sendLoginHint", Boolean.valueOf(idp.isSendLoginHint()).toString()).merge(!idp.getKnownDomains().isEmpty() ? HashMap.of("hostedDomain", idp.getKnownDomains().stream().findFirst().orElse("")) : HashMap.empty())).toJavaMap();
    }
}

