/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;
import org.kantega.atlaskerb.saml.ServiceProviderFactory;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.springframework.stereotype.Component;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.ls.LSSerializer;

@Component
class AtlSpServletSupport {
    private final IdpConfManager idpConfManager;
    private final ServiceProviderFactory serviceProviderFactory;
    private final TemplateRenderer renderer;

    @Inject
    AtlSpServletSupport(IdpConfManager idpConfManager, ServiceProviderFactory serviceProviderFactory, TemplateRenderer renderer) {
        this.idpConfManager = idpConfManager;
        this.serviceProviderFactory = serviceProviderFactory;
        this.renderer = renderer;
    }

    static String formatXml(Element dom) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HashMap<String, Object> serializerParams = new HashMap<String, Object>();
        boolean canSetPrettyPrint = true;
        LSSerializer serializer = SerializeSupport.getDOMImplementationLS(dom).createLSSerializer();
        if (serializer instanceof DOMConfiguration) {
            DOMConfiguration conf = (DOMConfiguration)((Object)serializer);
            canSetPrettyPrint = conf.canSetParameter("format-pretty-print", true);
        }
        if (canSetPrettyPrint) {
            serializerParams.put("format-pretty-print", true);
        }
        serializerParams.put("xml-declaration", false);
        SerializeSupport.writeNode(dom, os, serializerParams);
        return new String(os.toByteArray(), StandardCharsets.UTF_8);
    }

    static String serializeXml(Element dom) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SerializeSupport.writeNode(dom, os);
        return new String(os.toByteArray(), StandardCharsets.UTF_8);
    }

    static Optional<String> getSpId(HttpServletRequest req, String pathPrefix, String pathPostfix) {
        int start;
        String requestURI = req.getRequestURI();
        int end = requestURI.indexOf(pathPostfix, start = req.getContextPath().length() + pathPrefix.length());
        if (end == -1) {
            return Optional.empty();
        }
        String id = requestURI.substring(start, end);
        String postfix = requestURI.substring(end);
        if (!pathPostfix.equals(postfix)) {
            return Optional.empty();
        }
        return Optional.of(id);
    }

    Optional<ServiceProviderSpi> getServiceProviderSpi(String id) {
        return Optional.ofNullable((SAMLIdpConfiguration)this.idpConfManager.getEnabledIdentityProviderById(id)).map(this.serviceProviderFactory::getInstance);
    }

    Optional<IdpConfiguration> getIdpConfig(String id) {
        return Optional.ofNullable(this.idpConfManager.getEnabledIdentityProviderById(id));
    }

    public void renderNotFound(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setStatus(404);
        resp.setContentType("text/html");
        resp.setHeader("Cache-Control", "private, max-age=0, no-cache");
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("providerURL", req.getRequestURI());
        new PluginKey();
        String pluginKey = PluginKey.getPluginKey();
        model.put("pluginKey", pluginKey);
        model.put("pluginResource", pluginKey + ":atlaskerb");
        this.renderer.render("templates/saml/login-error-not-found.vm", model, (Writer)resp.getWriter());
    }
}

