/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.codec.binary.Base64;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.AssertionConsumerServiceBuilder;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.KeyDescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.SPSSODescriptorBuilder;
import org.opensaml.saml.saml2.metadata.impl.SingleLogoutServiceBuilder;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.impl.KeyInfoBuilder;
import org.opensaml.xmlsec.signature.impl.X509CertificateBuilder;
import org.opensaml.xmlsec.signature.impl.X509DataBuilder;

@Scanned
public class AtlSpMetadataServlet
extends HttpServlet {
    private final IdpConfManager idpConfManager;

    @Inject
    public AtlSpMetadataServlet(IdpConfManager idpConfManager) {
        this.idpConfManager = idpConfManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestURI = req.getRequestURI();
        String id = requestURI.substring(requestURI.lastIndexOf("/sp/") + "/sp/".length(), requestURI.lastIndexOf("/"));
        if (!this.idpConfManager.isProviderOrDraft(id)) {
            resp.sendError(404);
            return;
        }
        EntityDescriptor descriptor = new EntityDescriptorBuilder().buildObject();
        descriptor.setEntityID(this.idpConfManager.getServiceProviderLoginURL(req, id));
        SPSSODescriptor ssoDesc = new SPSSODescriptorBuilder().buildObject();
        ssoDesc.setWantAssertionsSigned(true);
        ssoDesc.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        ArrayList<byte[]> signingCerts = new ArrayList<byte[]>();
        signingCerts.add(this.idpConfManager.getSigningCert());
        for (java.security.cert.X509Certificate cert : this.idpConfManager.getStandbyCertificates()) {
            try {
                signingCerts.add(cert.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        for (byte[] bytes : signingCerts) {
            KeyDescriptor signingKeyDescriptor = new KeyDescriptorBuilder().buildObject();
            signingKeyDescriptor.setUse(UsageType.SIGNING);
            KeyInfo keyInfo = new KeyInfoBuilder().buildObject();
            X509Data x509 = new X509DataBuilder().buildObject();
            X509Certificate cert = new X509CertificateBuilder().buildObject();
            cert.setValue(Base64.encodeBase64String(bytes));
            x509.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(x509);
            signingKeyDescriptor.setKeyInfo(keyInfo);
            ssoDesc.getKeyDescriptors().add(signingKeyDescriptor);
            if (!this.idpConfManager.isEncryptedAssertionsRequiredForIdpOrDraft(id)) continue;
            KeyDescriptor encryptionKeyDescriptor = new KeyDescriptorBuilder().buildObject();
            encryptionKeyDescriptor.setUse(UsageType.ENCRYPTION);
            KeyInfo keyInfoEnc = new KeyInfoBuilder().buildObject();
            X509Data x509Enc = new X509DataBuilder().buildObject();
            X509Certificate certEnc = new X509CertificateBuilder().buildObject();
            certEnc.setValue(Base64.encodeBase64String(bytes));
            x509Enc.getX509Certificates().add(certEnc);
            keyInfoEnc.getX509Datas().add(x509Enc);
            encryptionKeyDescriptor.setKeyInfo(keyInfoEnc);
            ssoDesc.getKeyDescriptors().add(encryptionKeyDescriptor);
        }
        if (this.idpConfManager.isSingleLogoutEnabledForIdpOrDraft(id)) {
            SingleLogoutService logoutServiceRedir = new SingleLogoutServiceBuilder().buildObject();
            logoutServiceRedir.setLocation(this.idpConfManager.getServiceProviderLogoutServiceURL(req, id));
            logoutServiceRedir.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            ssoDesc.getSingleLogoutServices().add(logoutServiceRedir);
            SingleLogoutService logoutServicePost = new SingleLogoutServiceBuilder().buildObject();
            logoutServicePost.setLocation(this.idpConfManager.getServiceProviderLogoutServiceURL(req, id));
            logoutServicePost.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            ssoDesc.getSingleLogoutServices().add(logoutServicePost);
        }
        AssertionConsumerService assetionConsumerService = new AssertionConsumerServiceBuilder().buildObject();
        assetionConsumerService.setIsDefault(true);
        assetionConsumerService.setIndex(0);
        assetionConsumerService.setLocation(this.idpConfManager.getServiceProviderLoginURL(req, id));
        assetionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        ssoDesc.getAssertionConsumerServices().add(assetionConsumerService);
        descriptor.getRoleDescriptors().add(ssoDesc);
        try {
            resp.setContentType("application/samlmetadata+xml");
            SerializeSupport.writeNode(XMLObjectSupport.marshall(descriptor), (OutputStream)resp.getOutputStream());
        }
        catch (MarshallingException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

