/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.jsonmapping.JsonMapping;
import com.kantegasso.oidc.OidcProcedureData;
import io.vavr.Value;
import io.vavr.collection.HashSet;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.TestKerberosAction;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.FingerprintSSLSocketFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.IdpMetadataServlet;
import org.kantega.atlaskerb.saml.MetadataParser;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class AddIdpAction
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(AddIdpAction.class);
    private static final Set<String> PARAMETER_NAMES = new LinkedHashSet<String>(Arrays.asList("kind", "id", "importSource", "adfsServer", "azureTenantDomainName", "metadataURL", "metadataImported", "importMetadataURL", "metadataTlsFingerprint", "name", "location", "usePostBinding", "importedSigningCert", "signingCerts", "userNotFoundPolicy", "userUpdatePolicy", "userActivatePolicy", "defaultGroups", "ssoProtocol", "oidcDiscoveryUrl", "clientId", "clientSecret", "savedIdpUrlVariables", "scopesSupported", "defaultScopes", "oidcScopes", "singleLogoutServiceURL"));
    private final StepManager stepManager = new StepManager();
    private final HostApp hostApp;
    private final TemplateRenderer templateRenderer;
    private final IdpConfManager confManager;
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper;

    @Inject
    public AddIdpAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.confManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.oidcProcedureFactoryWrapper = bucket.getOidcProcedureFactoryWrapper();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String r = req.getRequestURI();
        String id = r.substring(r.lastIndexOf("/") + 1);
        Properties draft = this.confManager.readProviderDraft(id);
        if (draft == null) {
            resp.sendRedirect(this.confManager.getIdpConfigUrl(req));
        } else {
            HashMap<String, String> copyState = new HashMap<String, String>();
            for (String name : PARAMETER_NAMES) {
                String value = draft.getProperty(name);
                if (value == null) continue;
                copyState.put(name, value);
            }
            Map<String, Object> model = this.newModel(req);
            model.putAll(copyState);
            model.put("copyState", copyState);
            model.remove("topMenu");
            Step step = this.stepManager.get(draft.getProperty("step"));
            step.render(req, resp, model, copyState);
        }
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        MultipartHttpRequest req = this.getMultipartRequest(request, 1000000L);
        Map<String, Object> model = this.newModel((HttpServletRequest)req);
        model.remove("topMenu");
        Map<String, String> copyState = this.copyState((HttpServletRequest)req, model);
        Step step = this.stepManager.get(req.getParameter("step"));
        if (req.getParameter("cancel") != null) {
            this.confManager.deleteProviderDraft(copyState.get("id"));
            resp.sendRedirect(this.confManager.getIdpConfigUrl((HttpServletRequest)req));
            return;
        }
        if (req.getParameter("later") != null) {
            resp.sendRedirect(this.confManager.getIdpConfigUrl((HttpServletRequest)req));
            return;
        }
        if (step != null) {
            if ("true".equals(req.getParameter("showStep"))) {
                step.render((HttpServletRequest)req, resp, model, copyState);
            } else {
                boolean processResult;
                IdpConfiguration.Kind kind = IdpConfiguration.Kind.valueOf(copyState.get("kind"));
                Step targetStep = req.getParameter("back") != null ? step.previous(kind) : ((processResult = step.process(req, resp, model, copyState)) ? step.next(kind) : step);
                if (targetStep != null) {
                    targetStep.render((HttpServletRequest)req, resp, model, copyState);
                }
            }
            return;
        }
        resp.sendRedirect("setup-idp");
    }

    public String getParameter(String name, HttpServletRequest request) {
        String value = request.getParameter(name);
        if (value == null) {
            value = request.getParameter("copyState_" + name);
            if ("name".equals(name) && value != null) {
                value = new String(Base64.decodeBase64(value));
            }
        }
        return value;
    }

    private Map<String, String> copyState(HttpServletRequest req, Map<String, Object> model) {
        HashMap<String, String> copyState = new HashMap<String, String>();
        for (String parameterName : PARAMETER_NAMES) {
            String value = req.getParameter(parameterName);
            if (value != null) {
                model.put(parameterName, value);
            } else {
                value = req.getParameter("copyState_" + parameterName);
            }
            if (value == null) continue;
            if ("name".equals(parameterName)) {
                value = new String(Base64.decodeBase64(value));
            }
            copyState.put(parameterName, value);
        }
        model.put("copyState", copyState);
        return copyState;
    }

    private void addX509Certs(Map<String, Object> model, String signingCertsString) {
        List<byte[]> signingCerts = this.decodeBase64EncodedCerts(signingCertsString);
        CertTool certTool = new CertTool();
        List validationCerts = io.vavr.collection.List.ofAll(signingCerts).map(bytes -> {
            X509Certificate cert = certTool.parse((byte[])bytes);
            JSONObject certJson = new JSONObject();
            certJson.put("subjectDn", cert.getSubjectDN().getName());
            certJson.put("issuerDn", cert.getIssuerDN().getName());
            certJson.put("notBefore", cert.getNotBefore().toString());
            certJson.put("notAfter", cert.getNotAfter().toString());
            certJson.put("sigAlgName", cert.getSigAlgName());
            certJson.put("keySize", String.valueOf(certTool.getKeySize(cert)));
            certJson.put("fingerPrint", certTool.fingerPrint((byte[])bytes));
            return certJson;
        }).asJava();
        model.put("validationCerts", validationCerts);
    }

    private List<byte[]> decodeBase64EncodedCerts(String signingCerts) {
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        if (signingCerts != null && !signingCerts.isEmpty()) {
            for (String base64 : signingCerts.split(",")) {
                certs.add(Base64.decodeBase64(base64));
            }
        }
        return certs;
    }

    private IdpConfiguration.UsernameAttribute getUsernameAttribute(MultipartHttpRequest req) {
        String usernameAttribute = this.getParameter("usernameAttribute", (HttpServletRequest)req);
        if (usernameAttribute != null && !usernameAttribute.isEmpty()) {
            return IdpConfiguration.UsernameAttribute.valueOf(usernameAttribute);
        }
        return IdpConfiguration.UsernameAttribute.UPN;
    }

    private IdpConfiguration.UsernamePolicy getUsernamePolicy(MultipartHttpRequest req) {
        String usernamePolicyAttribute = this.getParameter("usernamePolicy", (HttpServletRequest)req);
        if (usernamePolicyAttribute != null && !usernamePolicyAttribute.isEmpty()) {
            return IdpConfiguration.UsernamePolicy.valueOf(usernamePolicyAttribute);
        }
        return IdpConfiguration.UsernamePolicy.ANY;
    }

    private IdpConfiguration.UserNotFoundPolicy getUserNotFound(Map<String, Object> model) {
        String userNotFound = (String)model.get("userNotFound");
        if (userNotFound != null && !userNotFound.isEmpty()) {
            return IdpConfiguration.UserNotFoundPolicy.valueOf(userNotFound);
        }
        return IdpConfiguration.UserNotFoundPolicy.REJECT;
    }

    private Set<String> parseSet(String list) {
        LinkedHashSet<String> groups2 = new LinkedHashSet<String>();
        if (list != null) {
            for (String g : list.split(",")) {
                if ((g = g.trim()).isEmpty()) continue;
                groups2.add(g);
            }
        }
        return groups2;
    }

    private String toString(Set<String> defaultGroups) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator2 = defaultGroups.iterator();
        while (iterator2.hasNext()) {
            sb.append(iterator2.next());
            if (!iterator2.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    class SummaryStep
    extends Step {
        public SummaryStep(StepManager stepManager) {
            super("summary", stepManager);
        }

        @Override
        boolean process(MultipartHttpRequest req, HttpServletResponse resp, Map<String, Object> model, Map<String, String> copyState) {
            Object config;
            IdpConfiguration.Kind kind = IdpConfiguration.Kind.valueOf(AddIdpAction.this.getParameter("kind", (HttpServletRequest)req));
            String id = copyState.get("id");
            String name = AddIdpAction.this.getParameter("name", (HttpServletRequest)req);
            IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy = IdpConfiguration.UserNotFoundPolicy.REJECT;
            String userNotFoundPolicyStr = AddIdpAction.this.getParameter("userNotFoundPolicy", (HttpServletRequest)req);
            if (userNotFoundPolicyStr != null) {
                userNotFoundPolicy = IdpConfiguration.UserNotFoundPolicy.valueOf(userNotFoundPolicyStr);
            }
            IdpConfiguration.UserUpdatePolicy userUpdatePolicy = userNotFoundPolicy == IdpConfiguration.UserNotFoundPolicy.CREATE ? IdpConfiguration.UserUpdatePolicy.UPDATE : IdpConfiguration.UserUpdatePolicy.NONE;
            IdpConfiguration.UserActivatePolicy userActivatePolicy = IdpConfiguration.UserActivatePolicy.NONE;
            IdpConfiguration.UsernamePolicy usernamePolicy = IdpConfiguration.UsernamePolicy.ANY;
            IdpConfiguration.UserLookupAttribute userLookupAttribute = IdpConfiguration.UserLookupAttribute.USERNAME;
            if (kind == IdpConfiguration.Kind.ADFS) {
                userLookupAttribute = IdpConfiguration.UserLookupAttribute.USER_PRINCIPAL_NAME;
            }
            Set defaultGroups = AddIdpAction.this.parseSet(AddIdpAction.this.getParameter("defaultGroups", (HttpServletRequest)req));
            if (StringUtils.equalsIgnoreCase("SAML", copyState.get("ssoProtocol"))) {
                String location = AddIdpAction.this.getParameter("location", (HttpServletRequest)req);
                boolean usePostBinding = StringUtils.equals("true", AddIdpAction.this.getParameter("usePostBinding", (HttpServletRequest)req));
                String idpSingleLogoutServiceURL = AddIdpAction.this.getParameter("singleLogoutServiceURL", (HttpServletRequest)req);
                String idpSingleLogoutReturnURL = AddIdpAction.this.getParameter("singleLogoutReturnURL", (HttpServletRequest)req);
                List signingCerts = AddIdpAction.this.decodeBase64EncodedCerts(AddIdpAction.this.getParameter("signingCerts", (HttpServletRequest)req));
                String metadataURL = AddIdpAction.this.getParameter("metadataURL", (HttpServletRequest)req);
                String fingerprint = AddIdpAction.this.getParameter("metadataTlsFingerprint", (HttpServletRequest)req);
                IdpConfigurationBuilder.SAML samlBuilder = (IdpConfigurationBuilder.SAML)((IdpConfigurationBuilder.SAML)((IdpConfigurationBuilder.SAML)((IdpConfigurationBuilder.SAML)((IdpConfigurationBuilder.SAML)((IdpConfigurationBuilder.SAML)((IdpConfigurationBuilder.SAML)((IdpConfigurationBuilder.SAML)((IdpConfigurationBuilder.SAML)((IdpConfigurationBuilder.SAML)((IdpConfigurationBuilder.SAML)IdpConfigurationBuilder.saml(id, kind).setName(name)).setIdpUrl(location).setUsePostBinding(usePostBinding).setIdpSingleLogoutServiceURL(idpSingleLogoutServiceURL).setSingleLogoutReturnURL(idpSingleLogoutReturnURL)).setSigningCerts(signingCerts).setUsernameAttribute(kind.getDefaultUsernameAttribute(IdpConfiguration.SSOProtocol.SAML))).setCustomUsernameAttributeName(kind.getSamlCustomUsernameAttributeName())).setUsernamePolicy(usernamePolicy)).setUserNotFoundPolicy(userNotFoundPolicy)).setUserUpdatePolicy(userUpdatePolicy)).setUserActivatePolicy(userActivatePolicy)).setDefaultGroups(defaultGroups)).setServerName(req.getServerName())).setUserLookupAttribute(userLookupAttribute);
                if (StringUtils.isNotBlank(metadataURL)) {
                    samlBuilder.setMetadataURL(metadataURL);
                    if (StringUtils.isNotBlank(fingerprint)) {
                        samlBuilder.setTlsFingerprint(fingerprint);
                    }
                }
                AddIdpAction.this.hostApp.getDefaultJitDirectory().ifPresent(directory -> {
                    IdpConfigurationBuilder.SAML cfr_ignored_0 = (IdpConfigurationBuilder.SAML)samlBuilder.setJitDirectory(directory.getId());
                });
                config = samlBuilder.build();
            } else {
                String oidcDiscoveryUrl = AddIdpAction.this.getParameter("oidcDiscoveryUrl", (HttpServletRequest)req);
                String oidcClientId = AddIdpAction.this.getParameter("clientId", (HttpServletRequest)req);
                String oidcClientSecret = AddIdpAction.this.getParameter("clientSecret", (HttpServletRequest)req);
                String oidcScopesString = AddIdpAction.this.getParameter("oidcScopes", (HttpServletRequest)req);
                Set oidcScopes = HashSet.of(oidcScopesString).toJavaSet();
                IdpConfiguration.UsernameAttribute usernameAttribute = kind.getDefaultUsernameAttribute(IdpConfiguration.SSOProtocol.OIDC);
                IdpConfigurationBuilder.OIDC builder = ((IdpConfigurationBuilder.OIDC)((IdpConfigurationBuilder.OIDC)((IdpConfigurationBuilder.OIDC)((IdpConfigurationBuilder.OIDC)((IdpConfigurationBuilder.OIDC)((IdpConfigurationBuilder.OIDC)((IdpConfigurationBuilder.OIDC)((IdpConfigurationBuilder.OIDC)((IdpConfigurationBuilder.OIDC)IdpConfigurationBuilder.oidc(id, kind).setName(name)).setUsernameAttribute(usernameAttribute)).setUsernamePolicy(usernamePolicy)).setUserNotFoundPolicy(userNotFoundPolicy)).setUserUpdatePolicy(userUpdatePolicy)).setUserActivatePolicy(userActivatePolicy)).setCustomUsernameAttributeName(kind.getOidcCustomUsernameAttributeName())).setUserLookupAttribute(userLookupAttribute)).setDefaultGroups(defaultGroups)).setOidcDiscoveryUrl(oidcDiscoveryUrl).setOidcClientId(oidcClientId).setOidcClientSecret(oidcClientSecret).setScopes(oidcScopes);
                AddIdpAction.this.hostApp.getDefaultJitDirectory().ifPresent(directory -> {
                    IdpConfigurationBuilder.OIDC cfr_ignored_0 = (IdpConfigurationBuilder.OIDC)builder.setJitDirectory(directory.getId());
                });
                config = builder.build();
            }
            AddIdpAction.this.confManager.addIdpConfiguration((IdpConfiguration)config);
            AddIdpAction.this.confManager.deleteProviderDraft(((IdpConfiguration)config).getId());
            try {
                resp.sendRedirect(AddIdpAction.this.confManager.getServiceProviderNonAdminTestURL((HttpServletRequest)req, id) + "?added");
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void addToModel(HttpServletRequest req, Map<String, Object> model) {
            AddIdpAction.this.addX509Certs(model, AddIdpAction.this.getParameter("signingCerts", req));
            model.put("defaultGroupsSet", AddIdpAction.this.parseSet(AddIdpAction.this.getParameter("defaultGroups", req)));
        }
    }

    class UsersStep
    extends Step {
        public UsersStep(StepManager stepManager) {
            super("users", stepManager);
        }

        @Override
        boolean process(MultipartHttpRequest req, HttpServletResponse resp, Map<String, Object> model, Map<String, String> copyState) {
            String defaultGroups = AddIdpAction.this.confManager.commaSeparated(AddIdpAction.this.parseSet(AddIdpAction.this.getParameter("defaultGroups", (HttpServletRequest)req)));
            copyState.put("defaultGroups", defaultGroups);
            return true;
        }

        @Override
        public void addToModel(HttpServletRequest req, Map<String, Object> model) {
            IdpConfiguration.UserNotFoundPolicy userNotFoundPolicyEnum = IdpConfiguration.UserNotFoundPolicy.REJECT;
            String userNotFoundPolicy = (String)model.get("userNotFoundPolicy");
            if (userNotFoundPolicy != null) {
                userNotFoundPolicyEnum = IdpConfiguration.UserNotFoundPolicy.valueOf(userNotFoundPolicy);
            }
            model.put("userNotFoundPolicyEnum", (Object)userNotFoundPolicyEnum);
            model.put("canAddUser", AddIdpAction.this.hostApp.canAddUser());
            IdpConfiguration.Kind kind = IdpConfiguration.Kind.valueOf((String)model.get("kind"));
            model.put("kind", (Object)kind);
            model.put("connectorTypes", AddIdpAction.this.connectorConfManager.getConnectorTypes());
            model.put("matchingConnectors", AddIdpAction.this.connectorConfManager.findMatchingConnectors(kind));
            model.put("matchingConnectorType", AddIdpAction.this.connectorConfManager.findMatchingConnectorType(kind));
        }
    }

    class CertificateStep
    extends Step {
        public CertificateStep(StepManager stepManager) {
            super("certificate", stepManager);
        }

        @Override
        boolean process(MultipartHttpRequest req, HttpServletResponse resp, Map<String, Object> model, Map<String, String> copyState) {
            if (StringUtils.equalsIgnoreCase("SAML", copyState.get("ssoProtocol"))) {
                String certChoice = req.getParameter("certChoice");
                StringBuilder certs = new StringBuilder();
                String signingCerts = AddIdpAction.this.getParameter("signingCerts", (HttpServletRequest)req);
                if (signingCerts != null) {
                    certs.append(signingCerts);
                }
                if (req.getParameter("uploadSubmit") != null) {
                    byte[] signingCertFile = req.getFile("signingCertFile");
                    if (signingCertFile != null) {
                        try {
                            AddIdpAction.this.confManager.parseCert(signingCertFile);
                        }
                        catch (Exception e) {
                            return false;
                        }
                        if (certs.length() > 0) {
                            certs.append(",");
                        }
                        certs.append(Base64.encodeBase64String(signingCertFile));
                        copyState.put("signingCerts", certs.toString());
                    }
                    return false;
                }
                if (req.getParameter("pasteSubmit") != null) {
                    String pastedSigningCert = req.getParameter("pastedSigningCert");
                    if (pastedSigningCert == null || pastedSigningCert.trim().isEmpty()) {
                        return false;
                    }
                    pastedSigningCert = CertTool.unwrapCert(pastedSigningCert);
                    try {
                        AddIdpAction.this.confManager.parseCert(Base64.decodeBase64(pastedSigningCert));
                    }
                    catch (Exception e) {
                        return false;
                    }
                    if (certs.length() > 0) {
                        certs.append(",");
                    }
                    certs.append(pastedSigningCert);
                    copyState.put("signingCerts", certs.toString());
                    return false;
                }
                return certs.length() != 0;
            }
            if (StringUtils.equalsIgnoreCase("OIDC", copyState.get("ssoProtocol"))) {
                String clientId = req.getParameter("clientId").trim();
                String clientSecret = req.getParameter("clientSecret").trim();
                if (clientId.isEmpty() || clientSecret.isEmpty()) {
                    return false;
                }
                copyState.put("clientId", clientId);
                copyState.put("clientSecret", clientSecret);
            }
            return true;
        }

        @Override
        public void addToModel(HttpServletRequest req, Map<String, Object> model) {
            AddIdpAction.this.addX509Certs(model, (String)model.get("signingCerts"));
        }
    }

    class LocationStep
    extends Step {
        public LocationStep(StepManager stepManager) {
            super("location", stepManager);
        }

        @Override
        boolean process(MultipartHttpRequest req, HttpServletResponse resp, Map<String, Object> model, Map<String, String> copyState) {
            String name = (String)model.get("name");
            if (name == null || name.trim().isEmpty()) {
                model.put("nameRequired", true);
                return false;
            }
            if (StringUtils.equalsIgnoreCase("SAML", copyState.get("ssoProtocol"))) {
                String location = (String)model.get("location");
                if (location == null || location.trim().isEmpty()) {
                    model.put("locationRequired", true);
                    return false;
                }
                if (!this.validateURL(location)) {
                    model.put("locationInvalid", true);
                    return false;
                }
            }
            if (StringUtils.equalsIgnoreCase("OIDC", copyState.get("ssoProtocol"))) {
                String oidcScopesString = AddIdpAction.this.getParameter("oidcScopes", (HttpServletRequest)req);
                copyState.put("oidcScopes", oidcScopesString);
                copyState.put("oidcScopes", oidcScopesString);
            }
            return true;
        }

        private boolean validateURL(String url) {
            try {
                URI uri = new URI(url);
                String scheme = uri.getScheme();
                return scheme != null && (scheme.equals("https") || scheme.equals("http"));
            }
            catch (URISyntaxException e) {
                return false;
            }
        }

        @Override
        public void addToModel(HttpServletRequest req, Map<String, Object> model) {
        }
    }

    class ImportStep
    extends Step {
        private final MetadataParser metadataParser;

        public ImportStep(StepManager stepManager) {
            super("import", stepManager);
            this.metadataParser = new MetadataParser();
        }

        @Override
        boolean process(MultipartHttpRequest req, HttpServletResponse resp, Map<String, Object> model, Map<String, String> copyState) {
            IdpConfiguration.Kind kind = IdpConfiguration.Kind.valueOf(copyState.get("kind"));
            if (StringUtils.equalsIgnoreCase("OIDC", copyState.get("ssoProtocol"))) {
                Value maybeDiscoveryUrl = Option.of(copyState.get("oidcDiscoveryUrl")).map(StringUtils::trim);
                Either<String, OidcProcedureData> maybeOidcProcedureData = AddIdpAction.this.oidcProcedureFactoryWrapper.createOidcProcedure(io.vavr.collection.HashMap.of("discovery_url", maybeDiscoveryUrl.getOrElse(""), "workaround", kind.getOidcLibRepresentation()));
                String discoveryUrl = "";
                if (maybeOidcProcedureData.isLeft() || maybeDiscoveryUrl.isEmpty()) {
                    log.warn("Invalid discovery: " + maybeDiscoveryUrl.getOrElse("Empty_Discovery_URL") + " (" + maybeOidcProcedureData.getLeft() + ")");
                    model.put("invalidDiscoveryUrl", true);
                    return false;
                }
                if (kind != IdpConfiguration.Kind.GITHUB) {
                    discoveryUrl = (String)maybeDiscoveryUrl.get();
                    Either maybeDiscovery = maybeOidcProcedureData.flatMap(OidcProcedureData::discover);
                    if (maybeDiscovery.isLeft()) {
                        log.warn("Unable to fetch a valid discovery document from the provided URL: " + maybeDiscoveryUrl.getOrElse("") + " (" + maybeDiscovery.getLeft() + ")");
                        model.put("invalidDiscoveryUrl", true);
                        return false;
                    }
                    maybeOidcProcedureData = maybeDiscovery;
                }
                io.vavr.collection.List<String> scopesSupported = maybeOidcProcedureData.get().getScopesSupported();
                copyState.put("oidcDiscoveryUrl", discoveryUrl);
                copyState.put("metadataImported", "true");
                copyState.put("name", kind.defaultName());
                copyState.put("scopesSupported", new JSONArray(scopesSupported.toJavaList()).toString());
                HashSet<String> upgradeScopes = HashSet.of("openid", "address", "email", "profile", "phone", "name", "groups", "read:user", "user:email");
                copyState.put("defaultScopes", new JSONArray(scopesSupported.filter(upgradeScopes::contains).toJavaSet()).toString());
                model.put("metadataImported", true);
                return true;
            }
            try {
                if (req.getParameter("skipImport") != null) {
                    copyState.remove("metadataImported");
                    model.remove("metadataImported");
                    return true;
                }
                String importSource = AddIdpAction.this.getParameter("importSource", (HttpServletRequest)req);
                String metadataURL = null;
                String defaultName = null;
                if ("importFromADFS".equals(importSource)) {
                    String adfsServer = AddIdpAction.this.getParameter("adfsServer", (HttpServletRequest)req).trim();
                    if (adfsServer.isEmpty()) {
                        model.put("hostRequired", true);
                        return false;
                    }
                    if (adfsServer.toLowerCase().startsWith("https://")) {
                        adfsServer = adfsServer.substring("https://".length());
                    } else if (adfsServer.toLowerCase().startsWith("http://")) {
                        adfsServer = adfsServer.substring("http://".length());
                    }
                    model.put("adfsServer", adfsServer);
                    metadataURL = "https://" + adfsServer + "/federationmetadata/2007-06/federationmetadata.xml";
                    defaultName = kind.defaultName();
                } else if ("importFromAzureTenant".equals(importSource)) {
                    String azureTenantDomainName = AddIdpAction.this.getParameter("azureTenantDomainName", (HttpServletRequest)req);
                    metadataURL = "https://login.microsoftonline.com/" + azureTenantDomainName + "/FederationMetadata/2007-06/FederationMetadata.xml";
                    defaultName = kind.defaultName();
                } else if ("importFromURL".equals(importSource)) {
                    metadataURL = AddIdpAction.this.getParameter("importMetadataURL", (HttpServletRequest)req);
                    model.put("metadataURL", metadataURL);
                    URI uri = new URI(metadataURL);
                    defaultName = kind.defaultName();
                }
                String fingerprint = AddIdpAction.this.getParameter("metadataTlsFingerprint", (HttpServletRequest)req);
                InputStream metadataInputStream = null;
                if (metadataURL != null && !metadataURL.isEmpty()) {
                    model.put("attemptedMetadataURL", metadataURL);
                    metadataURL = metadataURL.trim();
                    URL url = new URL(metadataURL);
                    HttpURLConnection con = (HttpURLConnection)url.openConnection();
                    con.setConnectTimeout(10000);
                    con.setReadTimeout(30000);
                    if (fingerprint != null) {
                        fingerprint = IdpMetadataServlet.cleanString(fingerprint.toUpperCase());
                        model.put("metadataFingerprint", fingerprint);
                    }
                    if (con instanceof HttpsURLConnection) {
                        HttpsURLConnection cons = (HttpsURLConnection)con;
                        cons.setSSLSocketFactory(new FingerprintSSLSocketFactory(fingerprint));
                    }
                    try {
                        metadataInputStream = con.getInputStream();
                    }
                    catch (SSLHandshakeException e) {
                        model.put("untrustedServer", url.getProtocol() + "://" + url.getHost());
                        new PluginKey();
                        model.put("pluginKey", PluginKey.getPluginKey());
                        if (e.getCause() instanceof FingerprintSSLSocketFactory.FingerPrintException) {
                            X509Certificate[] certs = ((FingerprintSSLSocketFactory.FingerPrintException)e.getCause()).getX509Certificates();
                            List validationCerts = io.vavr.collection.List.ofAll(Arrays.asList(certs)).map(cert -> {
                                JSONObject certJson = new JSONObject();
                                certJson.put("subjectDn", cert.getSubjectDN().getName());
                                return certJson;
                            }).asJava();
                            model.put("untrustedCerts", validationCerts);
                        }
                        if (fingerprint != null) {
                            model.put("wrongFingerPrint", fingerprint);
                        }
                        return false;
                    }
                }
                if (metadataInputStream == null && "importFromPaste".equals(importSource)) {
                    String paste = req.getParameter("paste");
                    metadataInputStream = new ByteArrayInputStream(paste.getBytes(StandardCharsets.UTF_8));
                }
                if (metadataInputStream == null) {
                    String filename;
                    byte[] bytes = req.getFile("file");
                    if (kind == IdpConfiguration.Kind.GOOGLE && (filename = req.getFilename("file")) != null) {
                        String metadataPrefix = "GoogleIDPMetadata-";
                        int start = filename.indexOf(metadataPrefix);
                        int end = filename.indexOf(".xml");
                        if (start != -1 && end != -1) {
                            String appName = filename.substring(start + metadataPrefix.length(), end);
                            if (appName.contains(" (")) {
                                appName = appName.substring(0, appName.indexOf(" ("));
                            }
                            defaultName = kind.defaultName();
                        }
                    }
                    if (bytes != null && bytes.length > 0) {
                        metadataInputStream = new ByteArrayInputStream(bytes);
                    }
                }
                if (metadataInputStream != null) {
                    EntityDescriptor metadata;
                    try {
                        metadata = this.metadataParser.parse(metadataInputStream);
                    }
                    catch (Exception e) {
                        model.put("parseException", e);
                        return false;
                    }
                    IDPSSODescriptor idp = this.metadataParser.getIDPDescriptorForSaml(metadata);
                    if (idp == null) {
                        model.put("missingIdp", true);
                        return false;
                    }
                    List<byte[]> signingCerts = this.metadataParser.getSigningCerts(idp);
                    MetadataParser.IdpSsoLocation idpLocation = this.metadataParser.getIdpSsoLocation(idp);
                    if (idpLocation == null) {
                        model.put("idpLocationRequired", true);
                        return false;
                    }
                    String idpSingleLogoutServiceURL = this.metadataParser.getIdpSingleLogoutServiceURL(idp);
                    if (idpSingleLogoutServiceURL != null) {
                        copyState.put("singleLogoutServiceURL", idpSingleLogoutServiceURL);
                    }
                    if (defaultName == null) {
                        defaultName = kind.defaultName();
                    }
                    if (defaultName != null) {
                        copyState.put("name", defaultName);
                    }
                    copyState.put("location", idpLocation.getLocation());
                    copyState.put("usePostBinding", "" + idpLocation.usePostBinding());
                    copyState.put("signingCerts", this.formatImportedCerts(signingCerts));
                    if (metadataURL != null) {
                        copyState.put("metadataURL", metadataURL);
                    }
                    copyState.put("metadataImported", "true");
                    return true;
                }
                return false;
            }
            catch (IOException | URISyntaxException e) {
                model.put("ioException", e);
                return false;
            }
        }

        private String formatImportedCerts(List<byte[]> signingCerts) {
            StringBuilder sb = new StringBuilder();
            for (byte[] signingCert : signingCerts) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(Base64.encodeBase64String(signingCert));
            }
            return sb.toString();
        }

        private List<String> getNeededIdpUrlVariables(String discoveryUrl) {
            String[] matches = StringUtils.substringsBetween(discoveryUrl, "{", "}");
            if (matches != null) {
                return Arrays.asList(matches);
            }
            return new ArrayList<String>();
        }

        private Map<String, String> getSavedIdpUrlVariables(Map<String, Object> model, String defaultDiscoveryUrl) {
            String savedIdpUrlVariablesJson = (String)model.get("savedIdpUrlVariables");
            return (Map)JsonMapping.Read.stringMapFromJson(savedIdpUrlVariablesJson).getOrNull();
        }

        private String getDiscoveryUrl(Map<String, Object> model, IdpConfiguration.Kind kind) {
            return (String)model.getOrDefault("oidcDiscoveryUrl", kind.getSuggestedWellknownUrl());
        }

        @Override
        public void addToModel(HttpServletRequest req, Map<String, Object> model) {
            IdpConfiguration.Kind kind = IdpConfiguration.Kind.valueOf((String)model.get("kind"));
            String discoveryUrl = this.getDiscoveryUrl(model, kind);
            String defaultDiscoveryUrl = kind.getSuggestedWellknownUrl();
            model.put("savedIdpUrlVariables", this.getSavedIdpUrlVariables(model, defaultDiscoveryUrl));
            model.put("oidcDiscoveryUrl", discoveryUrl);
            model.put("defaultDiscoveryUrl", defaultDiscoveryUrl);
            model.put("neededIdpUrlVariables", this.getNeededIdpUrlVariables(defaultDiscoveryUrl));
            model.put("kindName", kind.defaultName());
            super.addToModel(req, model);
        }
    }

    class PrepareStep
    extends Step {
        public PrepareStep(StepManager stepManager) {
            super("prepare", stepManager);
        }

        @Override
        boolean process(MultipartHttpRequest req, HttpServletResponse resp, Map<String, Object> model, Map<String, String> copyState) {
            return true;
        }

        @Override
        public void addToModel(HttpServletRequest req, Map<String, Object> model) {
            IdpConfiguration.Kind kind = IdpConfiguration.Kind.valueOf((String)model.get("kind"));
            model.put("connectorTypes", AddIdpAction.this.connectorConfManager.getConnectorTypes());
            model.put("matchingConnectors", AddIdpAction.this.connectorConfManager.findMatchingConnectors(kind));
            model.put("matchingConnectorType", AddIdpAction.this.connectorConfManager.findMatchingConnectorType(kind));
            model.put("kindEnum", (Object)kind);
            model.put("oidcCallbackUrl", ResumeOidcLoginServlet.getCallbackUrl(AddIdpAction.this.applicationProperties));
            String id = (String)model.get("id");
            String serviceProviderLoginURL = AddIdpAction.this.confManager.getServiceProviderLoginURL(req, id);
            model.put("providerId", id);
            model.put("serverName", req.getServerName());
            model.put("acsUrl", serviceProviderLoginURL);
            model.put("metadataURL", AddIdpAction.this.confManager.getServiceProviderMetadataURL(req, id));
            model.put("downloadCertURL", AddIdpAction.this.confManager.getSAMLRequestCertURL(req));
            model.put("certPem", new CertTool().formatCertificate(Base64.encodeBase64String(AddIdpAction.this.confManager.getSigningCert())));
            model.put("oneLoginAcsURLValidator", "^" + serviceProviderLoginURL.replace(".", "\\.").replace("/", "\\/") + "$");
            model.put("insecure", !"https".equals(req.getScheme()));
        }

        @Override
        public Step next(IdpConfiguration.Kind kind) {
            return super.next(kind);
        }

        @Override
        public Step previous(IdpConfiguration.Kind kind) {
            return super.previous(kind);
        }
    }

    class ProtocolStep
    extends Step {
        public ProtocolStep(StepManager stepManager) {
            super("protocol", stepManager);
        }

        @Override
        public void addToModel(HttpServletRequest req, Map<String, Object> model) {
            IdpConfiguration.Kind kind = IdpConfiguration.Kind.valueOf((String)model.get("kind"));
            Set<IdpConfiguration.SSOProtocol> supportedProtocols = kind.getSupportedProtocols();
            model.put("supportsSaml", supportedProtocols.contains((Object)IdpConfiguration.SSOProtocol.SAML));
            model.put("supportsOidc", supportedProtocols.contains((Object)IdpConfiguration.SSOProtocol.OIDC));
            model.put("kind", (Object)kind);
            super.addToModel(req, model);
        }

        @Override
        boolean process(MultipartHttpRequest req, HttpServletResponse resp, Map<String, Object> model, Map<String, String> copyState) {
            String id = copyState.get("id");
            String ssoProtocol = AddIdpAction.this.getParameter("ssoProtocol", (HttpServletRequest)req);
            if (ssoProtocol == null) {
                return false;
            }
            copyState.put("ssoProtocol", ssoProtocol);
            return true;
        }
    }

    class KindStep
    extends Step {
        public KindStep(StepManager stepManager) {
            super("kind", stepManager);
        }

        @Override
        boolean process(MultipartHttpRequest req, HttpServletResponse resp, Map<String, Object> model, Map<String, String> copyState) {
            Set<IdpConfiguration.SSOProtocol> supportedProtocols;
            AddIdpAction.this.confManager.ensureKeysExist(req.getServerName());
            if (!copyState.containsKey("id")) {
                copyState.put("id", AddIdpAction.this.confManager.nextId());
            }
            if ((supportedProtocols = IdpConfiguration.Kind.valueOf(copyState.get("kind")).getSupportedProtocols()).size() == 1) {
                for (IdpConfiguration.SSOProtocol ssoProtocol : supportedProtocols) {
                    copyState.put("ssoProtocol", ssoProtocol.name());
                }
            }
            return true;
        }

        @Override
        public void addToModel(HttpServletRequest req, Map<String, Object> model) {
            model.put("kinds", IdpConfiguration.Kind.values());
        }
    }

    abstract class Step {
        private final String name;
        private final StepManager stepManager;

        public Step(String name, StepManager stepManager) {
            this.name = name;
            this.stepManager = stepManager;
        }

        abstract boolean process(MultipartHttpRequest var1, HttpServletResponse var2, Map<String, Object> var3, Map<String, String> var4);

        public String getName() {
            return this.name;
        }

        public void addToModel(HttpServletRequest req, Map<String, Object> model) {
        }

        public Step next(IdpConfiguration.Kind kind) {
            return this.stepManager.getNextStep(this);
        }

        public Step previous(IdpConfiguration.Kind kind) {
            return this.stepManager.getPreviousStep(this);
        }

        public void render(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model, Map<String, String> copyState) {
            try {
                model.put("step", this.getName());
                model.put("displayName", AddIdpAction.this.applicationProperties.getDisplayName());
                for (String parameterName : PARAMETER_NAMES) {
                    String value = req.getParameter(parameterName);
                    if (value == null) {
                        value = copyState.get(parameterName);
                    }
                    if (value == null) continue;
                    if ("name".equals(parameterName)) {
                        copyState.put("name", Base64.encodeBase64String(value.getBytes()));
                    }
                    model.put(parameterName, value);
                }
                this.addToModel(req, model);
                String id = copyState.get("id");
                if (AddIdpAction.this.confManager.getIdentityProviderById(id) != null) {
                    resp.sendRedirect(AddIdpAction.this.confManager.getProviderOverviewURL(id, req));
                } else {
                    AddIdpAction.this.confManager.saveProviderDraft(copyState, this);
                    if (!req.getRequestURI().contains("setup-idp/")) {
                        resp.sendRedirect("setup-idp/" + id);
                    } else {
                        resp.setContentType("text/html");
                        TestKerberosAction.checkSupportedBrowser(model, req.getHeader("User-Agent"));
                        AddIdpAction.this.templateRenderer.render("templates/saml/setup-idp.vm", model, (Writer)resp.getWriter());
                    }
                }
            }
            catch (Exception e) {
                log.error("An error occured when showing step in setup: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    class StepManager {
        private final List<Step> steps = new ArrayList<Step>();

        public StepManager() {
            this.steps.add(new KindStep(this));
            this.steps.add(new ProtocolStep(this));
            this.steps.add(new UsersStep(this));
            this.steps.add(new PrepareStep(this));
            this.steps.add(new ImportStep(this));
            this.steps.add(new LocationStep(this));
            this.steps.add(new CertificateStep(this));
            this.steps.add(new SummaryStep(this));
        }

        protected Step getPreviousStep(Step step) {
            for (int i = this.steps.size() - 1; i >= 1; --i) {
                Step next = this.steps.get(i);
                if (next != step) continue;
                return this.steps.get(i - 1);
            }
            return null;
        }

        protected Step getNextStep(Step step) {
            Iterator<Step> iterator2 = this.steps.iterator();
            while (iterator2.hasNext()) {
                Step next = iterator2.next();
                if (next != step || !iterator2.hasNext()) continue;
                return iterator2.next();
            }
            return null;
        }

        protected Step get(String name) {
            for (Step step : this.steps) {
                if (!step.getName().equals(name)) continue;
                return step;
            }
            return null;
        }
    }
}

