/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.regextranformation;

import com.atlassian.json.jsonorg.JSONObject;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RegexTransformationResult {
    private final String textInput;
    private final String result;
    private final String errorMessage;
    private final String regexPattern;
    private final String regexReplacement;

    public RegexTransformationResult(String textInput, String result, String errorMessage, String regexPattern, String regexReplacement) {
        this.textInput = textInput;
        this.result = result;
        this.errorMessage = errorMessage;
        this.regexPattern = regexPattern;
        this.regexReplacement = regexReplacement;
    }

    public String getTextInput() {
        return this.textInput;
    }

    @Nullable
    public String getResult() {
        return this.result;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public String getRegexPattern() {
        return this.regexPattern;
    }

    @Nullable
    public String getRegexReplacement() {
        return this.regexReplacement;
    }

    public boolean equals(Object o) {
        boolean errorEquals;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexTransformationResult other = (RegexTransformationResult)o;
        boolean resultEquals = other.getResult() == null && this.result == null;
        boolean bl = errorEquals = other.getErrorMessage() == null && this.errorMessage == null;
        if (!StringUtils.isAnyBlank(other.result, this.result)) {
            resultEquals = other.getResult().equals(this.result);
        }
        if (!StringUtils.isAnyBlank(other.getErrorMessage(), this.errorMessage)) {
            errorEquals = other.getErrorMessage().equals(this.errorMessage);
        }
        return this.textInput.equals(other.getTextInput()) && resultEquals && errorEquals && this.regexPattern.equals(other.getRegexPattern()) && this.regexReplacement.equals(other.getRegexReplacement());
    }

    public String toString() {
        return "RegexTransformationResult{textInput='" + this.textInput + '\'' + ", result='" + this.result + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", regexPattern='" + this.regexPattern + '\'' + ", regexReplacement='" + this.regexReplacement + '\'' + '}';
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("textInput", this.textInput);
        json.put("result", this.result);
        json.put("errorMessage", this.errorMessage);
        json.put("regexPattern", this.regexPattern);
        json.put("regexReplacement", this.regexReplacement);
        return json;
    }
}

