/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc.evaluation;

import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.Date;
import java.util.Properties;
import org.joda.time.format.ISODateTimeFormat;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.saml.TestRecord;

public class OidcTestRecord
extends TestRecord {
    private final String id;
    private final Date lastModified;
    private final Properties props;

    public OidcTestRecord(String id, Date lastModified, Properties props) {
        super(id, lastModified, props);
        this.id = id;
        this.lastModified = lastModified;
        this.props = props;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    public String getTargetUrl() {
        return this.props.getProperty("targetUrl");
    }

    @Override
    public String getResponseAddress() {
        return this.props.getProperty("responseAddress");
    }

    public String getErrorCode() {
        return this.props.getProperty("errorCode");
    }

    public String getErrorMessage() {
        return this.props.getProperty("errorMessage");
    }

    public String getError() {
        return this.props.getProperty("error");
    }

    @Override
    public Date getRequestTime() {
        return (Date)Option.of(this.props.getProperty("requestTime")).map(time -> ISODateTimeFormat.dateTimeParser().parseDateTime((String)time).toDate()).getOrNull();
    }

    @Override
    public Date getResponseTime() {
        String responseTime = this.props.getProperty("responseTime");
        return responseTime == null ? null : ISODateTimeFormat.dateTimeParser().parseDateTime(responseTime).toDate();
    }

    @Override
    public ResponseEvaluationCode getCode() {
        String code = this.props.getProperty("code");
        if (code == null) {
            return ResponseEvaluationCode.WAITING_FOR_RESPONSE;
        }
        return Try.of(() -> ResponseEvaluationCode.valueOf(code)).getOrElse(ResponseEvaluationCode.UNKNOWN);
    }

    @Override
    public String getUsername() {
        return this.props.getProperty("username");
    }

    @Override
    public String getFullname() {
        return this.props.getProperty("fullname");
    }
}

