/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectoryProperties;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.kantegasso.jsonmapping.JsonMapping;
import com.kantegasso.oidc.OidcProcedureData;
import io.vavr.collection.HashMap;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PrincipalEntry;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.GroupEvaluation;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCStateCache;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OIDCResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OIDCResponseEvaluator;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.util.ErrorPageRenderer;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.TestUtils;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class ResumeOidcLoginServlet
extends HttpServlet {
    private final ApplicationProperties applicationProperties;
    private static final String RELATIVE_SERVLET_URL = "/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin/callback";
    private static final Logger log = LoggerFactory.getLogger(ResumeOidcLoginServlet.class);
    private final KerbConfManager kerbConfManager;
    private final UserManager userManager;
    private final OIDCStateCache oidcStateCache;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final AuditLogFacade auditLogFacade;
    private final OIDCResponseEvaluator responseEvaluator;
    private final ConnectorConfManager connectorConfManager;
    private final OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper;
    private final String USERNAME_ATTR = ServiceProviderSpi.class.getName() + "_username";
    public static final String SESSION_IDENTIFICATION_KEY = "sessionIdentification";
    private final SafeRedirect safeRedirect;
    private final ErrorPageRenderer errorPageRenderer;

    @Inject
    public ResumeOidcLoginServlet(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport UserManager userManager, OIDCStateCache oidcStateCache, IdpConfManager idpConfManager, AuditLogFacade auditLogFacade, KerbConfManager kerbConfManager, OIDCResponseEvaluator responseEvaluator, ConnectorConfManager connectorConfManager, SafeRedirect safeRedirect, HostAppFactory hostAppFactory, OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper, ErrorPageRenderer errorPageRenderer) {
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
        this.oidcStateCache = oidcStateCache;
        this.idpConfManager = idpConfManager;
        this.kerbConfManager = kerbConfManager;
        this.auditLogFacade = auditLogFacade;
        this.connectorConfManager = connectorConfManager;
        this.responseEvaluator = responseEvaluator;
        this.safeRedirect = safeRedirect;
        this.hostApp = hostAppFactory.getInstance();
        this.oidcProcedureFactoryWrapper = oidcProcedureFactoryWrapper;
        this.errorPageRenderer = errorPageRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ArrayList<String> errors = new ArrayList<String>();
        String state = req.getParameter("state");
        String code = req.getParameter("code");
        String error = req.getParameter("error");
        String errorDescription = req.getParameter("error_description");
        if (StringUtils.isBlank(state) || StringUtils.isBlank(code)) {
            if (error != null) {
                errors.add(error);
            }
            if (errorDescription != null) {
                errors.add(errorDescription);
            }
            if (errors.isEmpty()) {
                errors.add(ErrorUtils.createErrorMessage("KSSO-B7O6HYJBLH", "Did not retrieve a valid state and code pair from OpenID Connect provider."));
            }
            this.errorPageRenderer.renderErrors(Response.Status.BAD_REQUEST, Collections.singletonList(StringUtils.join(errors, "; ")), null, resp);
            return;
        }
        Option<OIDCStateCache.ResumeState> maybeResumeState = this.oidcStateCache.pop(state);
        if (maybeResumeState.isEmpty()) {
            this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, ErrorUtils.createErrorMessage(" KSSO-CIK2G41VZA", "Unable to resume login. Try logging in again."), null, resp);
            return;
        }
        OIDCStateCache.ResumeState resumeState = maybeResumeState.get();
        String idpConfigurationId = resumeState.getIdpId();
        OIDCIdpConfiguration idpConfiguration = (OIDCIdpConfiguration)this.idpConfManager.getIdentityProviderById(idpConfigurationId);
        boolean isTest = resumeState.isTest();
        String targetUrl = resumeState.getTargetUrl();
        Option<String> maybeTestId = Option.of(state).filter(_s -> isTest);
        Either<String, OidcProcedureData> maybeOidcProcedureDataResumption = this.toResumptionConfig(resumeState, idpConfiguration, state);
        Either maybeOidcProcedureDataDiscovery = maybeOidcProcedureDataResumption.flatMap(data -> data.get("discovery_url").filter(StringUtils::isNotBlank).isDefined() ? data.discover() : Either.right(data)).peekLeft(leftMessage -> {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError("KSSO-99ZUZRG26S", "Error OIDC resume login, failed discovery: " + leftMessage);
            log.error(kssoError.asMessage());
            if (isTest) {
                TestUtils.recordTestFailedAfterResponse(idpConfiguration, this.idpConfManager, maybeOidcProcedureDataResumption, maybeTestId, kssoError, ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage("KSSO-AXCAGRJWPI", "Error recording test result: " + throwable.getMessage())));
            }
        });
        if (maybeOidcProcedureDataDiscovery.isLeft()) {
            if (isTest && maybeTestId.isDefined()) {
                TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, maybeTestId.get());
            } else {
                String message = ErrorUtils.createErrorMessage("KSSO-99ZUZRG26S", "Error resume OIDC login, failed discovery: " + maybeOidcProcedureDataDiscovery.getLeft());
                this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, message, null, resp);
            }
            return;
        }
        Either<String, OidcProcedureData> maybeResumed = maybeOidcProcedureDataDiscovery.flatMap(data -> data.resume(state, code)).peekLeft(leftMessage -> {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError("KSSO-I54BMS31JV", "Failed OIDC resume login: " + leftMessage);
            log.error(kssoError.asMessage());
            if (isTest) {
                TestUtils.recordTestFailedAfterResponse(idpConfiguration, this.idpConfManager, maybeOidcProcedureDataDiscovery, maybeTestId, kssoError, ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage("KSSO-TP7XLL997P", "Error recording test result: " + throwable.getMessage())));
            }
        });
        if (maybeResumed.isLeft()) {
            if (isTest && maybeTestId.isDefined()) {
                TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, maybeTestId.get());
            } else {
                String message = ErrorUtils.createErrorMessage("KSSO-I54BMS31JV", "Failed OIDC resume login: " + maybeResumed.getLeft());
                this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, message, null, resp);
            }
            return;
        }
        OidcProcedureData resumedOidcProcedureData = (OidcProcedureData)maybeResumed.get();
        Option<JSONObject> maybeProfileJson = resumedOidcProcedureData.getProfile();
        if (maybeProfileJson.isEmpty()) {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError("KSSO-5B9PSJG932", "profile is empty.");
            log.error(kssoError.asMessage());
            if (isTest && maybeTestId.isDefined()) {
                TestUtils.recordTestFailedAfterResponse(idpConfiguration, this.idpConfManager, maybeResumed, maybeTestId, kssoError, ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage("KSSO-PS9T75D3O2", "Error recording test result: " + throwable.getMessage())));
                TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, maybeTestId.get());
            } else {
                this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, kssoError.asMessage(), null, resp);
            }
            return;
        }
        JSONObject profileJson = maybeProfileJson.get();
        Either<String, OIDCResponseEvaluationResult> maybeEvaluationResult = this.responseEvaluator.evaluate(idpConfiguration, profileJson, idpConfiguration.getUsernameAttribute(), idpConfiguration.getUserLookupAttribute(), idpConfiguration.getUserLookupTransform(), idpConfiguration.getCustomNameAttribute(), idpConfiguration.getCustomEmailAttribute(), idpConfiguration.getCustomUsernameAttributeName(), true);
        if (maybeEvaluationResult.isLeft()) {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError("KSSO-W7OR4T3R8R", "Response evaluation failed: " + maybeEvaluationResult.getLeft());
            log.error(kssoError.asMessage());
            if (isTest && maybeTestId.isDefined()) {
                TestUtils.recordTestFailedAfterResponse(idpConfiguration, this.idpConfManager, maybeResumed, maybeTestId, kssoError, ResponseEvaluationCode.FAILED_OIDC_RESUME_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage("KSSO-9G5KATZURV", "Error recording test result: " + throwable.getMessage())));
                TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, maybeTestId.get());
            } else {
                this.errorPageRenderer.renderError(Response.Status.BAD_REQUEST, kssoError.asMessage(), null, resp);
            }
            return;
        }
        OIDCResponseEvaluationResult evaluationResult = maybeEvaluationResult.get();
        if (isTest) {
            this.idpConfManager.recordOIDCTestResult(idpConfigurationId, state, evaluationResult, profileJson);
            TestUtils.recordTestProcedureAfterResponse(idpConfiguration, this.idpConfManager, maybeResumed, maybeTestId, evaluationResult.getCode());
            TestUtils.renderTestResult(req, resp, idpConfiguration, this.idpConfManager, this.userManager, maybeTestId.get());
        } else {
            this.performAtlassianLogin(resumedOidcProcedureData, profileJson, targetUrl, evaluationResult, idpConfiguration, req, resp);
        }
    }

    private Either<String, OidcProcedureData> toResumptionConfig(OIDCStateCache.ResumeState resumeState, OIDCIdpConfiguration idpConfiguration, String state) {
        String callbackUrl = ResumeOidcLoginServlet.getCallbackUrl(this.applicationProperties);
        String clientSecret = idpConfiguration.getClientSecret();
        String clientId = idpConfiguration.getClientId();
        String discoveryUrl = idpConfiguration.getDiscoveryUrl();
        String workaround = idpConfiguration.getKind().getOidcLibRepresentation();
        String[] issuerAllowList = idpConfiguration.getIssuerAllowList();
        return Try.of(resumeState::getOidcProcedureDataJSONString).flatMapTry(JsonMapping.Read::objectMapFromJson).mapTry(jsonData -> HashMap.of("client_id", clientId, "client_secret", clientSecret, "discovery_url", discoveryUrl, "redirect_uri", callbackUrl, "workaround", workaround, "nonce", jsonData.get("nonce"), "state", state, "issuer_allowlist", issuerAllowList)).fold(throwable -> Either.left(ErrorUtils.createErrorMessage("KSSO-10OYL11R4R", "Failed to resume OIDC login.")), this.oidcProcedureFactoryWrapper::createOidcProcedure);
    }

    private void performAtlassianLogin(OidcProcedureData oidcProcedureData, JSONObject profileJson, String requestedUrl, OIDCResponseEvaluationResult evaluationResult, OIDCIdpConfiguration idpConfiguration, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.idpConfManager.isLicenseValid()) {
            this.errorPageRenderer.renderError(Response.Status.UNAUTHORIZED, "Kantega SSO Plugin license is not valid", requestedUrl, resp);
            return;
        }
        PrincipalEntry principalEntry = evaluationResult.getResolvedPrincipalEntry();
        AttributeInfo configuredUsernameAttribute = evaluationResult.getConfiguredUsernameAttributeInfo();
        if (configuredUsernameAttribute == null && !profileJson.has("preferred_username")) {
            errors.add("The response did not contain the expected OIDC username attribute");
        } else if (evaluationResult.isUserDomainRejected()) {
            String userDomain = evaluationResult.getUserDomain();
            if (userDomain != null) {
                errors.add("Identity provider does not allow logging in users from domain @" + userDomain);
                this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Identity provider does not allow logging in users from domain");
            } else {
                errors.add("Identity provider configuration restricts login to usernames with a known domain. The authenticated username does not end with a domain");
                this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Identity provider configuration restricts login to usernames with a known domain. The authenticated username does not end with a domain");
            }
        } else {
            String username = evaluationResult.getSearchedUsername();
            Set<String> idpGroupParameters = idpConfiguration.getIdpGroupsAttributes();
            HashSet<String> appGroupAssertions = new HashSet<String>();
            for (String gp : idpGroupParameters) {
                try {
                    appGroupAssertions.addAll(profileJson.getJSONArray(gp).toList().stream().map(Object::toString).collect(Collectors.toList()));
                }
                catch (JSONException jSONException) {}
            }
            this.responseEvaluator.evaluateGroups(username, idpConfiguration.getManagedGroups(), appGroupAssertions, evaluationResult.getGroupEvaluation(), idpConfiguration.isCreateAllIncomingGroups());
            UserRecipe userRecipe = evaluationResult.getUserRecipe();
            Optional<Directory> jitDirectory = this.hostApp.findJitDirectory(idpConfiguration.getJitDirectory());
            if (jitDirectory.isPresent()) {
                if (principalEntry == null) {
                    if (idpConfiguration.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE) {
                        principalEntry = this.createUser(jitDirectory.get(), idpConfiguration, errors, evaluationResult, principalEntry, userRecipe, username);
                    } else {
                        if (idpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                            this.addAuthenticatedAnonymousBrowsingSession(idpConfiguration, req, resp, username);
                            return;
                        }
                        errors.add("Account not found in " + this.applicationProperties.getDisplayName());
                        this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Account not found in " + this.applicationProperties.getDisplayName());
                    }
                } else if (this.userExistInJITDirectory(jitDirectory.get(), evaluationResult)) {
                    if ((principalEntry.getUserState() == PrincipalEntry.UserState.FOUND || principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) && idpConfiguration.getUserUpdatePolicy() == IdpConfiguration.UserUpdatePolicy.UPDATE) {
                        this.updateUser(jitDirectory.get(), errors, userRecipe, principalEntry.getUserState() != PrincipalEntry.UserState.INACTIVE);
                    }
                    if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE && idpConfiguration.getUserActivatePolicy() == IdpConfiguration.UserActivatePolicy.ACTIVATE) {
                        this.updateUser(jitDirectory.get(), errors, userRecipe, true);
                        Principal p = principalEntry.getPrincipal().get();
                        principalEntry = new PrincipalEntry(p, PrincipalEntry.UserState.FOUND);
                    }
                }
            } else {
                if (idpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                    this.addAuthenticatedAnonymousBrowsingSession(idpConfiguration, req, resp, username);
                    return;
                }
                errors.add("Count not create or update user with Just-in-time provisioning (JIT). JIT directory is not specified.");
            }
            if (principalEntry != null && principalEntry.getPrincipal().isPresent()) {
                Principal principal = principalEntry.getPrincipal().get();
                Directory userDirectory = evaluationResult.getResolvedUserDirectory();
                if (userDirectory != null && userDirectory.getType() == DirectoryType.CROWD) {
                    try {
                        this.authenticateUserInCrowdSSO(principal, userDirectory);
                    }
                    catch (OperationFailedException e) {
                        this.errorPageRenderer.renderError(Response.Status.UNAUTHORIZED, "Failed to authenticate user in remote Crowd directory", requestedUrl, resp);
                        this.auditLogFacade.loginFailed(principal.getName(), "OIDC", "Failed to authenticate user in remote Crowd directory.");
                        return;
                    }
                }
                if (!this.updateGroupMemberships(evaluationResult, principal, idpConfiguration, username)) {
                    errors.add("Failed updating group memberships for user");
                    this.auditLogFacade.loginFailed(principal.getName(), "OIDC", "Failed updating group memberships for user.");
                } else {
                    boolean canLogin;
                    boolean isPrincipalFound;
                    boolean bl = isPrincipalFound = principalEntry.getUserState() == PrincipalEntry.UserState.FOUND;
                    if (isPrincipalFound) {
                        this.hostApp.publishUserAuthenticatedEvent(principalEntry.getPrincipal().get());
                    }
                    if ((canLogin = this.hostApp.canLogin(principal, req)) && isPrincipalFound) {
                        String cookieVal = idpConfiguration.getId();
                        HttpSession session = req.getSession();
                        String sessionUsername = (String)session.getAttribute(this.USERNAME_ATTR);
                        session.removeAttribute(this.USERNAME_ATTR);
                        if (sessionUsername != null) {
                            cookieVal = cookieVal + ":" + sessionUsername;
                        }
                        int maxAge = 31536000;
                        String discoverPath = req.getContextPath() + "/plugins/servlet/no.kantega.saml/discover";
                        this.setLastSamlAccountCookie(cookieVal, maxAge, discoverPath, resp);
                        session.setAttribute("ksso.oidc.idtoken", (Object)oidcProcedureData.get("id_token").get());
                        session.setAttribute("ksso.oidc.idp.id", (Object)idpConfiguration.getId());
                        this.hostApp.authenticateWithProduct(req, resp, principal);
                        if (this.kerbConfManager.isRemembermeCookieEnabled()) {
                            this.hostApp.setRememberMeCookie(req, resp, principal.getName());
                        }
                        if (!StringUtils.isBlank(requestedUrl)) {
                            this.safeRedirect.sendRedirect(requestedUrl, req, resp);
                        } else {
                            resp.sendRedirect(req.getContextPath() + "/");
                        }
                        this.auditLogFacade.loginSuccess(principal.getName(), "OIDC");
                        return;
                    }
                    if (!canLogin) {
                        errors.add(String.format("Account does not have permission to use %s", this.applicationProperties.getDisplayName()));
                        this.auditLogFacade.loginFailed(principal.getName(), "OIDC", String.format("Account does not have permission to use %s", this.applicationProperties.getDisplayName()));
                    }
                    if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) {
                        errors.add(String.format("User %s is not active", principal.getName()));
                        this.auditLogFacade.loginFailed(principal.getName(), "OIDC", "User is not active.");
                    }
                }
            } else {
                if (idpConfiguration.isAuthenticatedAnonymousBrowsingEnabled()) {
                    this.addAuthenticatedAnonymousBrowsingSession(idpConfiguration, req, resp, username);
                    return;
                }
                errors.add("Principal (account) not found. Unable to authenticate user");
            }
        }
        this.errorPageRenderer.renderErrors(Response.Status.BAD_REQUEST, errors, requestedUrl, resp);
    }

    private void addAuthenticatedAnonymousBrowsingSession(OIDCIdpConfiguration idpConfiguration, HttpServletRequest req, HttpServletResponse resp, String username) throws IOException {
        this.hostApp.addAuthenticatedAnonymousBrowsingSession(username, idpConfiguration, req, resp);
        this.auditLogFacade.loginSuccess(Option.of(username).getOrElse("[anonymous]"), "Authenticated anonymous browsing OIDC");
    }

    private boolean userExistInJITDirectory(Directory directory, OIDCResponseEvaluationResult evaluationResult) {
        return directory.getId().equals(evaluationResult.getResolvedUserDirectory().getId());
    }

    private PrincipalEntry createUser(Directory directory, OIDCIdpConfiguration idpConfiguration, List<String> errors, OIDCResponseEvaluationResult evaluationResult, PrincipalEntry principalEntry, UserRecipe userRecipe, String usernameFromIdp) {
        block9: {
            if (userRecipe != null && userRecipe.isComplete()) {
                try {
                    if (IdpConfManager.hasRequiredGroupsForCreation(idpConfiguration, evaluationResult.getGroupEvaluation().getManagedGroups())) {
                        this.addUser(userRecipe, directory, idpConfiguration, usernameFromIdp);
                        principalEntry = new PrincipalEntry(this.userManager.resolve(userRecipe.getUsername().getValue()), PrincipalEntry.UserState.FOUND);
                        break block9;
                    }
                    errors.add("Account could not be created. User did not have any managed groups in the user info endpoint from " + idpConfiguration.getName());
                    this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Account could not be created. User did not have any managed groups in the user info endpoint from " + idpConfiguration.getName());
                }
                catch (Exception e) {
                    UUID uuid = UUID.randomUUID();
                    String message = "Failed creating account for OIDC user " + userRecipe.getUsername().getValue() + " in directory \"" + directory.getName() + "\" (Log correlation ID: " + uuid + ")";
                    this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", message);
                    log.error(message, (Throwable)e);
                    errors.add(message);
                }
            } else if (userRecipe == null) {
                errors.add("Account cannot be created because of missing user recipe");
                this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Account can not be created because of missing user recipe.");
            } else {
                if (userRecipe.getName() == null) {
                    errors.add("Account cannot be created because no name attributes were included in the user info endpoint");
                    this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Account can not be created because configured name attribute was not included in the user info endpoint.");
                }
                if (userRecipe.getEmail() == null) {
                    errors.add("Account cannot be created because no email attribute was included in the user info endpoint");
                    this.auditLogFacade.loginFailed(evaluationResult.getSearchedUsername(), "OIDC", "Account can not be created because configured email attribute was not included in the user info endpoint.");
                }
            }
        }
        return principalEntry;
    }

    private void updateUser(Directory directory, List<String> errors, UserRecipe userRecipe, boolean isActive) {
        if (userRecipe != null && userRecipe.isComplete()) {
            String username = this.hostApp.normalizeUsername(userRecipe.getUsername().getValue());
            String fullname = userRecipe.getName().getValue();
            String email = userRecipe.getEmail().getValue();
            this.hostApp.updateUser(directory, username, fullname, email, isActive);
        } else if (userRecipe == null) {
            errors.add("Account cannot be updated because of missing user recipe");
        } else {
            if (userRecipe.getName() == null) {
                errors.add("Account cannot be updated because no name attributes were included in the user info endpoint");
            }
            if (userRecipe.getEmail() == null) {
                errors.add("Account cannot be updated because no email attribute was included in the user info endpoint");
            }
        }
    }

    private void authenticateUserInCrowdSSO(Principal principal, Directory userDirectory) throws OperationFailedException {
        String appName = (String)userDirectory.getAttributes().get("application.name");
        if (appName != null && this.connectorConfManager.getDirectory(appName) == null) {
            try {
                SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth groupSyncMode = SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.forDirectory((Attributes)userDirectory);
                if (groupSyncMode == SynchronisableDirectoryProperties.SyncGroupMembershipsAfterAuth.ALWAYS) {
                    DbCachingRemoteDirectoryInstanceLoader instanceLoader = (DbCachingRemoteDirectoryInstanceLoader)ComponentLocator.getComponent(DbCachingRemoteDirectoryInstanceLoader.class);
                    DbCachingRemoteDirectory directory = (DbCachingRemoteDirectory)instanceLoader.getDirectory(userDirectory);
                    RemoteCrowdDirectory crowdDirectory = (RemoteCrowdDirectory)this.hostApp.getAuthorativeDirectory(directory);
                    try {
                        String token = crowdDirectory.getCrowdClient().authenticateSSOUserWithoutValidatingPassword(new UserAuthenticationContext(principal.getName(), null, new ValidationFactor[0], null));
                        crowdDirectory.getCrowdClient().invalidateSSOToken(token);
                    }
                    catch (OperationFailedException e) {
                        log.debug("REST-call failed. Likely because of a remote jira");
                    }
                    catch (ApplicationAccessDeniedException | ApplicationPermissionException | InactiveAccountException | InvalidAuthenticationException e) {
                        log.error("Error authenticating user remotely", e);
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                log.debug("Unable to perform user sync on login since Crowd API is too old and not compatible with triggering this. Sync will happen on next scheduled synchronisation");
            }
        }
    }

    void setLastSamlAccountCookie(String cookieVal, int maxAge, String discoverPath, HttpServletResponse response) {
        boolean needsSupportForTomcat8 = true;
        if (!needsSupportForTomcat8) {
            Cookie cookie = new Cookie("sml_lst_act", cookieVal);
            cookie.setPath(discoverPath);
            cookie.setComment("HttpOnly");
            cookie.setVersion(0);
            cookie.setMaxAge(maxAge);
            response.addCookie(cookie);
        } else {
            Date expiresDate = new Date(System.currentTimeMillis() + (long)maxAge * 1000L);
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            StringBuilder sb = new StringBuilder();
            sb.append("sml_lst_act=\"").append(cookieVal).append("\"; Version=1; Comment=HttpOnly; Max-Age=").append(maxAge).append("; Expires=").append(df.format(expiresDate)).append("; Path=").append(discoverPath);
            String setCookie = sb.toString();
            response.addHeader("Set-Cookie", setCookie);
        }
    }

    public static String getCallbackUrl(ApplicationProperties applicationProperties) {
        String baseUrl = applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        return ResumeOidcLoginServlet.getCallbackUrl(baseUrl);
    }

    public static String getCallbackUrl(String baseUrl) {
        return URI.create(baseUrl + RELATIVE_SERVLET_URL).toString();
    }

    private void addUser(UserRecipe userRecipe, Directory dir, OIDCIdpConfiguration idpConfiguration, String usernameFromIdp) {
        this.hostApp.addUser(dir, this.hostApp.normalizeUsername(userRecipe.getUsername().getValue()), userRecipe.getName().getValue(), userRecipe.getEmail().getValue(), idpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp));
    }

    boolean updateGroupMemberships(OIDCResponseEvaluationResult evaluationResult, Principal principal, OIDCIdpConfiguration idpConfiguration, String usernameFromIdp) {
        GroupEvaluation groupEvaluation = evaluationResult.getGroupEvaluation();
        if (idpConfiguration.isCreateAllIncomingGroups() && groupEvaluation.syncUserIdpGroups(this.hostApp, principal, idpConfiguration.isRemoveNonIdpGroupsFromUser(), idpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp))) {
            return false;
        }
        if (groupEvaluation.setManagedGroups(this.hostApp, principal)) {
            return groupEvaluation.setDefaultGroups(this.hostApp, principal, idpConfiguration.getDefaultGroupsFilteredForUser(usernameFromIdp));
        }
        return false;
    }
}

