/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import io.vavr.control.Option;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;

public class OIDCIdpConfiguration
extends IdpConfiguration {
    private final String clientId;
    private final String clientSecret;
    private final Long clientSecretExpiry;
    private final String discoveryUrl;
    private final Set<String> scopes;
    private final String[] issuerAllowList;
    public static final String ID_TOKEN_SESSION_KEY = "ksso.oidc.idtoken";
    public static final String IDP_ID_SESSION_KEY = "ksso.oidc.idp.id";

    public OIDCIdpConfiguration(Set<String> defaultGroups, Map<String, String> defaultGroupsRules, boolean autoUpdateKnownDomains, String customEmailAttribute, String customNameAttribute, String customUsernameAttributeName, boolean enabled, String id, Optional<Long> jitDirectory, IdpConfiguration.Kind kind, LinkedHashSet<String> knownDomains, boolean knownAutoRedirect, boolean createAllIncomingGroups, boolean removeNonIdpGroupsFromUser, List<ManagedGroup> managedGroups, boolean managedGroupsRequiredForJITCreation, Set<Long> matchedUserDirectoryIds, String name, String notificationEmails, Set<String> redirectGroups, IdpConfiguration.RedirectPolicy redirectPolicy, List<Pair<String, String>> userTransformationRegexes, boolean singleLogoutEnabled, String singleLogoutReturnURL, IdpConfiguration.UserActivatePolicy userActivatePolicy, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UsernamePolicy usernamePolicy, IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy, IdpConfiguration.UserUpdatePolicy userUpdatePolicy, boolean visible, boolean hostedDomain, String selectedUsernameAttributeInfo, Set<String> idpGroupsAttribute, boolean sendLoginHint, boolean authenticatedAnonymousBrowsingEnabled, String clientId, String clientSecret, Long clientSecretExpiry, String discoveryUrl, Set<String> scopes, String[] issuerAllowList) {
        super(defaultGroups, defaultGroupsRules, autoUpdateKnownDomains, customEmailAttribute, customNameAttribute, customUsernameAttributeName, enabled, id, jitDirectory, kind, knownDomains, knownAutoRedirect, createAllIncomingGroups, removeNonIdpGroupsFromUser, managedGroups, managedGroupsRequiredForJITCreation, matchedUserDirectoryIds, name, notificationEmails, redirectGroups, redirectPolicy, userTransformationRegexes, singleLogoutEnabled, userActivatePolicy, userLookupAttribute, userLookupTransform, usernameAttribute, usernamePolicy, userNotFoundPolicy, userUpdatePolicy, visible, hostedDomain, selectedUsernameAttributeInfo, idpGroupsAttribute, singleLogoutReturnURL, sendLoginHint, authenticatedAnonymousBrowsingEnabled);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientSecretExpiry = clientSecretExpiry;
        this.discoveryUrl = discoveryUrl;
        this.scopes = scopes;
        this.issuerAllowList = issuerAllowList;
    }

    @Override
    public IdpConfiguration.SSOProtocol getProtocol() {
        return IdpConfiguration.SSOProtocol.OIDC;
    }

    @Override
    public boolean isOIDC() {
        return true;
    }

    @Override
    public boolean isSAML() {
        return false;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Long getClientSecretExpiry() {
        return this.clientSecretExpiry;
    }

    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public String[] getIssuerAllowList() {
        return Option.of(this.issuerAllowList).getOrElse(new String[0]);
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = super.asJson();
        json.put("clientId", this.getClientId());
        json.put("clientSecret", this.getClientSecret());
        json.put("clientSecretExpiry", this.getClientSecretExpiry());
        json.put("discoveryUrl", this.getDiscoveryUrl());
        json.put("scopes", new JSONArray(this.getScopes()));
        json.put("issuerAllowList", new JSONArray(this.getIssuerAllowList()));
        return json;
    }
}

