/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;
import org.kantega.samllib.validation.SAMLSessionIdentification;

public abstract class IdpConfigurationBuilder<V, T extends IdpConfiguration> {
    private final String id;
    private final IdpConfiguration.Kind kind;
    private String customEmailAttribute;
    private String customNameAttribute;
    private String customUsernameAttributeName;
    private Long jitDirectory;
    private boolean knownAutoRedirect;
    private boolean managedGroupsRequiredForJITCreation;
    private String name;
    private String notificationEmails;
    private boolean singleLogoutEnabled;
    private String singleLogoutReturnURL;
    private IdpConfiguration.UsernameAttribute usernameAttribute;
    private IdpConfiguration.UserUpdatePolicy userUpdatePolicy;
    private String selectedUsernameAttributeInfo;
    private Set<String> defaultGroups = Collections.emptySet();
    private Map<String, String> defaultGroupsRules = Collections.emptyMap();
    private Set<String> idpGroupsAttributes = Collections.emptySet();
    private LinkedHashSet<String> knownDomains = new LinkedHashSet();
    private List<ManagedGroup> managedGroups = Collections.emptyList();
    private Set<Long> matchedUserDirectoryIds = Collections.emptySet();
    private Set<String> redirectGroups = Collections.emptySet();
    private List<Pair<String, String>> userTransformationRegexes = Collections.emptyList();
    private boolean autoUpdateKnownDomains = false;
    boolean createAllIncomingGroups = false;
    boolean removeNonIdpGroupsFromUser = false;
    private boolean enabled = true;
    private boolean visible = true;
    private boolean hostedDomain = true;
    private boolean sendLoginHint = true;
    private IdpConfiguration.RedirectPolicy redirectPolicy = IdpConfiguration.RedirectPolicy.ALL;
    private IdpConfiguration.UserLookupTransform userLookupTransform = IdpConfiguration.UserLookupTransform.NONE;
    private IdpConfiguration.UserLookupAttribute userLookupAttribute = IdpConfiguration.UserLookupAttribute.USERNAME;
    private IdpConfiguration.UserActivatePolicy userActivatePolicy = IdpConfiguration.UserActivatePolicy.NONE;
    private IdpConfiguration.UsernamePolicy usernamePolicy = IdpConfiguration.UsernamePolicy.ANY;
    private IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy = IdpConfiguration.UserNotFoundPolicy.REJECT;
    private String serverName;
    private boolean authenticatedAnonymousBrowsingEnabled = false;

    protected IdpConfigurationBuilder(String id, IdpConfiguration.Kind kind) {
        this.id = id;
        this.kind = kind;
        this.customUsernameAttributeName = kind.getSamlCustomUsernameAttributeName();
    }

    protected IdpConfigurationBuilder(IdpConfiguration source2) {
        this(source2.getId(), source2.getKind());
        this.defaultGroups = source2.getDefaultGroups();
        this.defaultGroupsRules = source2.getDefaultGroupsRules();
        this.autoUpdateKnownDomains = source2.isAutoUpdateKnownDomains();
        this.customEmailAttribute = source2.getCustomEmailAttribute();
        this.customNameAttribute = source2.getCustomNameAttribute();
        this.customUsernameAttributeName = source2.getCustomUsernameAttributeName();
        this.enabled = source2.isEnabled();
        this.jitDirectory = source2.getJitDirectory().orElse(null);
        this.knownDomains = source2.getKnownDomains();
        this.knownAutoRedirect = source2.isKnownAutoRedirect();
        this.managedGroups = source2.getManagedGroups();
        this.createAllIncomingGroups = source2.isCreateAllIncomingGroups();
        this.removeNonIdpGroupsFromUser = source2.isRemoveNonIdpGroupsFromUser();
        this.managedGroupsRequiredForJITCreation = source2.isManagedGroupsRequiredForJITCreation();
        this.matchedUserDirectoryIds = source2.getMatchedUserDirectoryIds();
        this.name = source2.getName();
        this.notificationEmails = source2.getNotificationEmails();
        this.redirectGroups = source2.getRedirectGroups();
        this.redirectPolicy = source2.getRedirectPolicy();
        this.userTransformationRegexes = source2.getUserTransformationRegexes();
        this.singleLogoutEnabled = source2.isSingleLogoutEnabled();
        this.singleLogoutReturnURL = source2.getSingleLogoutReturnURL();
        this.userActivatePolicy = source2.getUserActivatePolicy();
        this.userLookupAttribute = source2.getUserLookupAttribute();
        this.userLookupTransform = source2.getUserLookupTransform();
        this.usernameAttribute = source2.getUsernameAttribute();
        this.usernamePolicy = source2.getUsernamePolicy();
        this.userNotFoundPolicy = source2.getUserNotFoundPolicy();
        this.userUpdatePolicy = source2.getUserUpdatePolicy();
        this.visible = source2.isVisible();
        this.hostedDomain = source2.isHostedDomain();
        this.selectedUsernameAttributeInfo = source2.getSelectedUsernameAttributeInfo();
        this.idpGroupsAttributes = source2.getIdpGroupsAttributes();
        this.sendLoginHint = source2.isSendLoginHint();
        this.authenticatedAnonymousBrowsingEnabled = source2.isAuthenticatedAnonymousBrowsingEnabled();
    }

    public static SAML saml(String id, IdpConfiguration.Kind kind) {
        return new SAML(id, kind);
    }

    public static OIDC oidc(String id, IdpConfiguration.Kind kind) {
        return new OIDC(id, kind);
    }

    public T build() {
        return this.buildInternal();
    }

    abstract T buildInternal();

    abstract V getThis();

    public static OIDC of(OIDCIdpConfiguration source2) {
        return new OIDC(source2);
    }

    public static SAML of(SAMLIdpConfiguration source2) {
        return new SAML(source2);
    }

    public static IdpConfigurationBuilder<?, ?> ofGeneric(IdpConfiguration config) {
        return config.fold(oidc -> IdpConfigurationBuilder.of(oidc), saml -> IdpConfigurationBuilder.of(saml));
    }

    public Optional<Long> getJitDirectory() {
        return Optional.ofNullable(this.jitDirectory);
    }

    public String getId() {
        return this.id;
    }

    public IdpConfiguration.Kind getKind() {
        return this.kind;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public V setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this.getThis();
    }

    public Set<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    public V setDefaultGroups(Set<String> defaultGroups) {
        this.defaultGroups = defaultGroups;
        return this.getThis();
    }

    public Map<String, String> getDefaultGroupsRules() {
        return this.defaultGroupsRules;
    }

    public V setDefaultGroupsRules(Map<String, String> defaultGroupsRules) {
        this.defaultGroupsRules = defaultGroupsRules;
        return this.getThis();
    }

    public boolean isAutoUpdateKnownDomains() {
        return this.autoUpdateKnownDomains;
    }

    public V setAutoUpdateKnownDomains(boolean autoUpdateKnownDomains) {
        this.autoUpdateKnownDomains = autoUpdateKnownDomains;
        return this.getThis();
    }

    public boolean isCreateAllIncomingGroups() {
        return this.createAllIncomingGroups;
    }

    public V setCreateAllIncomingGroups(boolean createAllIncomingGroups) {
        this.createAllIncomingGroups = createAllIncomingGroups;
        return this.getThis();
    }

    public boolean isRemoveNonIdpGroupsFromUser() {
        return this.removeNonIdpGroupsFromUser;
    }

    public V setremoveNonIdpGroupsFromUser(boolean removeNonIdpGroupsFromUser) {
        this.removeNonIdpGroupsFromUser = removeNonIdpGroupsFromUser;
        return this.getThis();
    }

    public V setAuthenticatedAnonymousBrowsingEnabled(boolean authenticatedAnonymousBrowsingEnabled) {
        this.authenticatedAnonymousBrowsingEnabled = authenticatedAnonymousBrowsingEnabled;
        return this.getThis();
    }

    public boolean isAuthenticatedAnonymousBrowsingEnabled() {
        return this.authenticatedAnonymousBrowsingEnabled;
    }

    public String getCustomEmailAttribute() {
        return this.customEmailAttribute;
    }

    public V setCustomEmailAttribute(String customEmailAttribute) {
        this.customEmailAttribute = customEmailAttribute;
        return this.getThis();
    }

    public String getCustomNameAttribute() {
        return this.customNameAttribute;
    }

    public V setCustomNameAttribute(String customNameAttribute) {
        this.customNameAttribute = customNameAttribute;
        return this.getThis();
    }

    public String getCustomUsernameAttributeName() {
        return this.customUsernameAttributeName;
    }

    public V setCustomUsernameAttributeName(String customUsernameAttributeName) {
        this.customUsernameAttributeName = customUsernameAttributeName;
        return this.getThis();
    }

    public Set<String> getIdpGroupsAttributes() {
        return this.idpGroupsAttributes;
    }

    public V setIdpGroupsAttributes(Set<String> idpGroupsAttributes) {
        this.idpGroupsAttributes = idpGroupsAttributes;
        return this.getThis();
    }

    public V setJitDirectory(Long jitDirectory) {
        this.jitDirectory = jitDirectory;
        return this.getThis();
    }

    public LinkedHashSet<String> getKnownDomains() {
        return this.knownDomains;
    }

    public V setKnownDomains(LinkedHashSet<String> knownDomains) {
        this.knownDomains = knownDomains;
        return this.getThis();
    }

    public boolean isKnownAutoRedirect() {
        return this.knownAutoRedirect;
    }

    public V setKnownAutoRedirect(boolean knownAutoRedirect) {
        this.knownAutoRedirect = knownAutoRedirect;
        return this.getThis();
    }

    public List<ManagedGroup> getManagedGroups() {
        return this.managedGroups;
    }

    public V setManagedGroups(List<ManagedGroup> managedGroups) {
        this.managedGroups = managedGroups;
        return this.getThis();
    }

    public boolean isManagedGroupsRequiredForJITCreation() {
        return this.managedGroupsRequiredForJITCreation;
    }

    public V setManagedGroupsRequiredForJITCreation(boolean managedGroupsRequiredForJITCreation) {
        this.managedGroupsRequiredForJITCreation = managedGroupsRequiredForJITCreation;
        return this.getThis();
    }

    public Set<Long> getMatchedUserDirectoryIds() {
        return this.matchedUserDirectoryIds;
    }

    public V setMatchedUserDirectoryIds(Set<Long> matchedUserDirectoryIds) {
        this.matchedUserDirectoryIds = matchedUserDirectoryIds;
        return this.getThis();
    }

    public String getName() {
        return this.name;
    }

    public V setName(String name) {
        this.name = name;
        return this.getThis();
    }

    public String getNotificationEmails() {
        return this.notificationEmails;
    }

    public V setNotificationEmails(String notificationEmails) {
        this.notificationEmails = notificationEmails;
        return this.getThis();
    }

    public Set<String> getRedirectGroups() {
        return this.redirectGroups;
    }

    public V setRedirectGroups(Set<String> redirectGroups) {
        this.redirectGroups = redirectGroups;
        return this.getThis();
    }

    public IdpConfiguration.RedirectPolicy getRedirectPolicy() {
        return this.redirectPolicy;
    }

    public V setRedirectPolicy(IdpConfiguration.RedirectPolicy redirectPolicy) {
        this.redirectPolicy = redirectPolicy;
        return this.getThis();
    }

    public List<Pair<String, String>> getUserTransformationRegexes() {
        return this.userTransformationRegexes;
    }

    public V setUserTransformationRegexes(List<Pair<String, String>> userTransformationRegexes) {
        this.userTransformationRegexes = userTransformationRegexes;
        return this.getThis();
    }

    public boolean isSingleLogoutEnabled() {
        return this.singleLogoutEnabled;
    }

    public V setSingleLogoutEnabled(boolean singleLogoutEnabled) {
        this.singleLogoutEnabled = singleLogoutEnabled;
        return this.getThis();
    }

    public Optional<String> getSingleLogoutReturnURL() {
        return Optional.ofNullable(this.singleLogoutReturnURL);
    }

    public V setSingleLogoutReturnURL(String singleLogoutReturnURL) {
        this.singleLogoutReturnURL = singleLogoutReturnURL;
        return this.getThis();
    }

    public IdpConfiguration.UserActivatePolicy getUserActivatePolicy() {
        return this.userActivatePolicy;
    }

    public V setUserActivatePolicy(IdpConfiguration.UserActivatePolicy userActivatePolicy) {
        this.userActivatePolicy = userActivatePolicy;
        return this.getThis();
    }

    public IdpConfiguration.UserLookupAttribute getUserLookupAttribute() {
        return this.userLookupAttribute;
    }

    public V setUserLookupAttribute(IdpConfiguration.UserLookupAttribute userLookupAttribute) {
        this.userLookupAttribute = userLookupAttribute;
        return this.getThis();
    }

    public IdpConfiguration.UserLookupTransform getUserLookupTransform() {
        return this.userLookupTransform;
    }

    public V setUserLookupTransform(IdpConfiguration.UserLookupTransform userLookupTransform) {
        this.userLookupTransform = userLookupTransform;
        return this.getThis();
    }

    public IdpConfiguration.UsernameAttribute getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public V setUsernameAttribute(IdpConfiguration.UsernameAttribute usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
        return this.getThis();
    }

    public IdpConfiguration.UsernamePolicy getUsernamePolicy() {
        return this.usernamePolicy;
    }

    public V setUsernamePolicy(IdpConfiguration.UsernamePolicy usernamePolicy) {
        this.usernamePolicy = usernamePolicy;
        return this.getThis();
    }

    public boolean isHostedDomain() {
        return this.hostedDomain;
    }

    public V setHostedDomain(boolean hostedDomain) {
        this.hostedDomain = hostedDomain;
        return this.getThis();
    }

    public boolean isSendLoginHint() {
        return this.sendLoginHint;
    }

    public V setSendLoginHint(boolean sendLoginHint) {
        this.sendLoginHint = sendLoginHint;
        return this.getThis();
    }

    public IdpConfiguration.UserNotFoundPolicy getUserNotFoundPolicy() {
        return this.userNotFoundPolicy;
    }

    public V setUserNotFoundPolicy(IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy) {
        this.userNotFoundPolicy = userNotFoundPolicy;
        return this.getThis();
    }

    public IdpConfiguration.UserUpdatePolicy getUserUpdatePolicy() {
        return this.userUpdatePolicy;
    }

    public V setUserUpdatePolicy(IdpConfiguration.UserUpdatePolicy userUpdatePolicy) {
        this.userUpdatePolicy = userUpdatePolicy;
        return this.getThis();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public V setVisible(boolean visible) {
        this.visible = visible;
        return this.getThis();
    }

    public String getSelectedUsernameAttributeInfo() {
        return this.selectedUsernameAttributeInfo;
    }

    public V setSelectedUsernameAttributeInfo(String selectedUsernameAttributeInfo) {
        this.selectedUsernameAttributeInfo = selectedUsernameAttributeInfo;
        return this.getThis();
    }

    public V setServerName(String serverName) {
        this.serverName = serverName;
        return this.getThis();
    }

    public String getServerName() {
        return this.serverName;
    }

    public static class SAML
    extends IdpConfigurationBuilder<SAML, SAMLIdpConfiguration> {
        private String idpUrl;
        private String idpSingleLogoutServiceURL;
        private List<byte[]> signingCerts;
        private String metadataURL;
        private String tlsFingerprint;
        private String customNameIdFormat;
        private String issuer;
        private boolean encryptedAssertionsRequired = false;
        private boolean usePostBinding = false;
        private boolean autoRefreshMetadataEnabled = false;
        private String authnCtxClassRef = "urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport";
        private IdpConfiguration.AllowCreate allowCreate = IdpConfiguration.AllowCreate.TRUE;
        private SAMLIdpConfiguration.IssuerPolicy issuerPolicy = SAMLIdpConfiguration.IssuerPolicy.DEFAULT;
        private IdpConfiguration.NameIdFormat nameIdFormat = IdpConfiguration.NameIdFormat.DEFAULT;
        private SAMLSessionIdentification.ValidationPolicy sessionIdValidationPolicy = SAMLSessionIdentification.ValidationPolicy.getDefault();
        private SAMLIdpConfiguration.RequestedAuthnContextComparison requestedAuthnContextComparison = SAMLIdpConfiguration.RequestedAuthnContextComparison.EXACT;
        private SAMLIdpConfiguration.RequestedAuthnContextPolicy requestedAuthnContextPolicy = SAMLIdpConfiguration.RequestedAuthnContextPolicy.DO_NOT_SEND;

        public SAML(SAMLIdpConfiguration source2) {
            super(source2);
            this.idpUrl = source2.getIdpURL();
            this.signingCerts = source2.getSigningCerts();
            this.encryptedAssertionsRequired = source2.isEncryptedAssertionsRequired();
            this.usePostBinding = source2.isUsePostBinding();
            this.metadataURL = source2.getMetadataURL();
            this.idpSingleLogoutServiceURL = source2.getSingleLogoutServiceURL();
            this.tlsFingerprint = source2.getTlsFingerprint();
            this.requestedAuthnContextPolicy = source2.getRequestedAuthnContextPolicy();
            this.requestedAuthnContextComparison = source2.getRequestedAuthnContextComparison();
            this.authnCtxClassRef = source2.getAuthnContextClassRef();
            this.issuerPolicy = source2.getIssuerPolicy();
            this.issuer = source2.getIssuer();
            this.allowCreate = source2.getAllowCreate();
            this.customNameIdFormat = source2.getCustomNameIdFormat();
            this.sessionIdValidationPolicy = source2.getSessionIdentificationValidationPolicy();
            this.autoRefreshMetadataEnabled = source2.isAutoRefreshMetadataEnabled();
        }

        public SAML(String id, IdpConfiguration.Kind kind) {
            super(id, kind);
        }

        @Override
        protected SAMLIdpConfiguration buildInternal() {
            return new SAMLIdpConfiguration(this.getAllowCreate(), this.getDefaultGroups(), this.getDefaultGroupsRules(), this.isAutoUpdateKnownDomains(), this.getCustomEmailAttribute(), this.getCustomNameAttribute(), this.getCustomUsernameAttributeName(), this.isEnabled(), this.getId(), this.getJitDirectory(), this.getKind(), this.getKnownDomains(), this.isKnownAutoRedirect(), this.isCreateAllIncomingGroups(), this.isRemoveNonIdpGroupsFromUser(), this.getManagedGroups(), this.isManagedGroupsRequiredForJITCreation(), this.getMatchedUserDirectoryIds(), this.getName(), this.getNotificationEmails(), this.getRedirectGroups(), this.getRedirectPolicy(), this.getUserTransformationRegexes(), this.isSingleLogoutEnabled(), this.getUserActivatePolicy(), this.getUserLookupAttribute(), this.getUserLookupTransform(), this.getUsernameAttribute(), this.getUsernamePolicy(), this.getUserNotFoundPolicy(), this.getUserUpdatePolicy(), this.isVisible(), this.isHostedDomain(), this.getSelectedUsernameAttributeInfo(), this.getIdpGroupsAttributes(), this.isSendLoginHint(), this.isAuthenticatedAnonymousBrowsingEnabled(), this.getAuthnCtxClassRef(), this.getCustomNameIdFormat().orElse(null), this.isEncryptedAssertionsRequired(), this.isUsePostBinding(), this.getIdpUrl(), this.getIssuer().orElse(null), this.getIssuerPolicy(), this.getMetadataURL().orElse(null), this.getNameIdFormat(), this.getSessionIdValidationPolicy().orElse(null), this.getSigningCerts(), this.getIdpSingleLogoutServiceURL().orElse(null), this.getSingleLogoutReturnURL().orElse(null), this.getTlsFingerprint(), this.getRequestedAuthnContextComparison(), this.getRequestedAuthnContextPolicy(), this.isAutoRefreshMetadataEnabled());
        }

        @Override
        SAML getThis() {
            return this;
        }

        public SAML setIdpUrl(String idpUrl) {
            this.idpUrl = idpUrl;
            return this;
        }

        public String getIdpUrl() {
            return this.idpUrl;
        }

        public SAML setIdpSingleLogoutServiceURL(String idpSingleLogoutServiceURL) {
            this.idpSingleLogoutServiceURL = idpSingleLogoutServiceURL;
            return this;
        }

        public Optional<String> getIdpSingleLogoutServiceURL() {
            return Optional.ofNullable(this.idpSingleLogoutServiceURL);
        }

        public SAML setSigningCerts(List<byte[]> signingCerts) {
            this.signingCerts = signingCerts;
            return this;
        }

        public List<byte[]> getSigningCerts() {
            return this.signingCerts;
        }

        public SAML setEncryptedAssertionsRequired(boolean encryptedAssertionsRequired) {
            this.encryptedAssertionsRequired = encryptedAssertionsRequired;
            return this;
        }

        public boolean isEncryptedAssertionsRequired() {
            return this.encryptedAssertionsRequired;
        }

        public SAML setUsePostBinding(boolean userPostBinding) {
            this.usePostBinding = userPostBinding;
            return this;
        }

        public boolean isUsePostBinding() {
            return this.usePostBinding;
        }

        public SAML setMetadataURL(String metadataURL) {
            this.metadataURL = metadataURL;
            return this;
        }

        public Optional<String> getMetadataURL() {
            return Optional.ofNullable(this.metadataURL);
        }

        public SAML setTlsFingerprint(String tlsFingerprint) {
            this.tlsFingerprint = tlsFingerprint;
            return this;
        }

        public String getTlsFingerprint() {
            return this.tlsFingerprint;
        }

        public IdpConfiguration.AllowCreate getAllowCreate() {
            return this.allowCreate;
        }

        public SAML setAllowCreate(IdpConfiguration.AllowCreate allowCreate) {
            this.allowCreate = allowCreate;
            return this;
        }

        public String getAuthnCtxClassRef() {
            return this.authnCtxClassRef;
        }

        public SAML setAuthnCtxClassRef(String authnCtxClassRef) {
            this.authnCtxClassRef = authnCtxClassRef;
            return this;
        }

        public Optional<String> getCustomNameIdFormat() {
            return Optional.ofNullable(this.customNameIdFormat);
        }

        public SAML setCustomNameIdFormat(String customNameIdFormat) {
            this.customNameIdFormat = customNameIdFormat;
            return this;
        }

        public Optional<String> getIssuer() {
            return Optional.ofNullable(this.issuer);
        }

        public SAML setIssuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public SAMLIdpConfiguration.IssuerPolicy getIssuerPolicy() {
            return this.issuerPolicy;
        }

        public SAML setIssuerPolicy(SAMLIdpConfiguration.IssuerPolicy issuerPolicy) {
            this.issuerPolicy = issuerPolicy;
            return this;
        }

        public IdpConfiguration.NameIdFormat getNameIdFormat() {
            return this.nameIdFormat;
        }

        public SAML setNameIdFormat(IdpConfiguration.NameIdFormat nameIdFormat) {
            this.nameIdFormat = nameIdFormat;
            return this;
        }

        public Optional<SAMLSessionIdentification.ValidationPolicy> getSessionIdValidationPolicy() {
            return Optional.ofNullable(this.sessionIdValidationPolicy);
        }

        public SAML setSessionIdValidationPolicy(SAMLSessionIdentification.ValidationPolicy sessionIdValidationPolicy) {
            this.sessionIdValidationPolicy = sessionIdValidationPolicy;
            return this;
        }

        public SAMLIdpConfiguration.RequestedAuthnContextComparison getRequestedAuthnContextComparison() {
            return this.requestedAuthnContextComparison;
        }

        public SAML setRequestedAuthnContextComparison(SAMLIdpConfiguration.RequestedAuthnContextComparison requestedAuthnContextComparison) {
            this.requestedAuthnContextComparison = requestedAuthnContextComparison;
            return this;
        }

        public SAMLIdpConfiguration.RequestedAuthnContextPolicy getRequestedAuthnContextPolicy() {
            return this.requestedAuthnContextPolicy;
        }

        public SAML setRequestedAuthnContextPolicy(SAMLIdpConfiguration.RequestedAuthnContextPolicy requestedAuthnContextPolicy) {
            this.requestedAuthnContextPolicy = requestedAuthnContextPolicy;
            return this;
        }

        public SAML setAutoRefreshMetadataEnabled(boolean autoRefreshMetadataEnabled) {
            this.autoRefreshMetadataEnabled = autoRefreshMetadataEnabled;
            return this;
        }

        public boolean isAutoRefreshMetadataEnabled() {
            return this.autoRefreshMetadataEnabled;
        }
    }

    public static class OIDC
    extends IdpConfigurationBuilder<OIDC, OIDCIdpConfiguration> {
        private String oidcDiscoveryUrl;
        private String oidcClientId;
        private String oidcClientSecret;
        private Long clientSecretExpiry = 0L;
        private Set<String> scopes;
        private String[] issuerAllowList;

        public OIDC(OIDCIdpConfiguration source2) {
            super(source2);
            this.oidcDiscoveryUrl = source2.getDiscoveryUrl();
            this.oidcClientId = source2.getClientId();
            this.oidcClientSecret = source2.getClientSecret();
            this.clientSecretExpiry = source2.getClientSecretExpiry();
            this.scopes = source2.getScopes();
            this.issuerAllowList = source2.getIssuerAllowList();
        }

        public OIDC(String id, IdpConfiguration.Kind kind) {
            super(id, kind);
        }

        @Override
        OIDCIdpConfiguration buildInternal() {
            return new OIDCIdpConfiguration(this.getDefaultGroups(), this.getDefaultGroupsRules(), this.isAutoUpdateKnownDomains(), this.getCustomEmailAttribute(), this.getCustomNameAttribute(), this.getCustomUsernameAttributeName(), this.isEnabled(), this.getId(), this.getJitDirectory(), this.getKind(), this.getKnownDomains(), this.isKnownAutoRedirect(), this.isCreateAllIncomingGroups(), this.isRemoveNonIdpGroupsFromUser(), this.getManagedGroups(), this.isManagedGroupsRequiredForJITCreation(), this.getMatchedUserDirectoryIds(), this.getName(), this.getNotificationEmails(), this.getRedirectGroups(), this.getRedirectPolicy(), this.getUserTransformationRegexes(), this.isSingleLogoutEnabled(), this.getSingleLogoutReturnURL().orElse(null), this.getUserActivatePolicy(), this.getUserLookupAttribute(), this.getUserLookupTransform(), this.getUsernameAttribute(), this.getUsernamePolicy(), this.getUserNotFoundPolicy(), this.getUserUpdatePolicy(), this.isVisible(), this.isHostedDomain(), this.getSelectedUsernameAttributeInfo(), this.getIdpGroupsAttributes(), this.isSendLoginHint(), this.isAuthenticatedAnonymousBrowsingEnabled(), this.getOidcClientId(), this.getOidcClientSecret(), this.getClientSecretExpiry(), this.getOidcDiscoveryUrl(), this.getScopes(), this.getIssuerAllowList());
        }

        @Override
        OIDC getThis() {
            return this;
        }

        public OIDC setOidcDiscoveryUrl(String oidcDiscoveryUrl) {
            this.oidcDiscoveryUrl = oidcDiscoveryUrl;
            return this;
        }

        public String getOidcDiscoveryUrl() {
            return this.oidcDiscoveryUrl;
        }

        public OIDC setOidcClientId(String oidcClientId) {
            this.oidcClientId = oidcClientId;
            return this;
        }

        public String getOidcClientId() {
            return this.oidcClientId;
        }

        public OIDC setOidcClientSecret(String oidcClientSecret) {
            this.oidcClientSecret = oidcClientSecret;
            return this;
        }

        public String getOidcClientSecret() {
            return this.oidcClientSecret;
        }

        public Long getClientSecretExpiry() {
            return this.clientSecretExpiry;
        }

        public OIDC setClientSecretExpiry(Long clientSecretExpiry) {
            this.clientSecretExpiry = clientSecretExpiry;
            return this;
        }

        public Set<String> getScopes() {
            return this.scopes;
        }

        public OIDC setScopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public String[] getIssuerAllowList() {
            return this.issuerAllowList;
        }

        public void setIssuerAllowList(String[] issuerAllowList) {
            this.issuerAllowList = issuerAllowList;
        }
    }
}

