/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import com.google.common.collect.Sets;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.control.Option;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;

public abstract class IdpConfiguration
implements DebugInfo {
    public static final String KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID = "KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID";
    public static final String KSSO_AUTH_ANONYMOUS_BROWSING_USER = "KSSO_AUTH_ANONYMOUS_BROWSING_USER";
    private final Set<String> defaultGroups;
    private final Map<String, String> defaultGroupsRules;
    private final boolean autoUpdateKnownDomains;
    private final String customEmailAttribute;
    private final String customNameAttribute;
    private final String customUsernameAttributeName;
    private final boolean enabled;
    private final String id;
    private final Set<String> idpGroupsAttributes;
    private final Optional<Long> jitDirectory;
    private final Kind kind;
    private final LinkedHashSet<String> knownDomains;
    private final boolean knownAutoRedirect;
    boolean createAllIncomingGroups;
    boolean removeNonIdpGroupsFromUser;
    private final List<ManagedGroup> managedGroups;
    private final boolean managedGroupsRequiredForJITCreation;
    private final Set<Long> matchedUserDirectoryIds;
    private final String name;
    private final String notificationEmails;
    private final Set<String> redirectGroups;
    private final RedirectPolicy redirectPolicy;
    private final List<Pair<String, String>> userTransformationRegexes;
    private final boolean singleLogoutEnabled;
    private final String singleLogoutReturnURL;
    private final UserActivatePolicy userActivatePolicy;
    private final UserLookupAttribute userLookupAttribute;
    private final UserLookupTransform userLookupTransform;
    private final UsernameAttribute usernameAttribute;
    private final UsernamePolicy usernamePolicy;
    private final UserNotFoundPolicy userNotFoundPolicy;
    private final UserUpdatePolicy userUpdatePolicy;
    private final boolean visible;
    private final boolean hostedDomain;
    private final String selectedUsernameAttributeInfo;
    private final boolean sendLoginHint;
    private final boolean authenticatedAnonymousBrowsingEnabled;

    protected IdpConfiguration(Set<String> defaultGroups, Map<String, String> defaultGroupsRules, boolean autoUpdateKnownDomains, String customEmailAttribute, String customNameAttribute, String customUsernameAttributeName, boolean enabled, String id, Optional<Long> jitDirectory, Kind kind, LinkedHashSet<String> knownDomains, boolean knownAutoRedirect, boolean createAllIncomingGroups, boolean removeNonIdpGroupsFromUser, List<ManagedGroup> managedGroups, boolean managedGroupsRequiredForJITCreation, Set<Long> matchedUserDirectoryIds, String name, String notificationEmails, Set<String> redirectGroups, RedirectPolicy redirectPolicy, List<Pair<String, String>> userTransformationRegexes, boolean singleLogoutEnabled, UserActivatePolicy userActivatePolicy, UserLookupAttribute userLookupAttribute, UserLookupTransform userLookupTransform, UsernameAttribute usernameAttribute, UsernamePolicy usernamePolicy, UserNotFoundPolicy userNotFoundPolicy, UserUpdatePolicy userUpdatePolicy, boolean visible, boolean hostedDomain, String selectedUsernameAttributeInfo, Set<String> idpGroupsAttributes, String singleLogoutReturnURL, boolean sendLoginHint, boolean authenticatedAnonymousBrowsingEnabled) {
        this.defaultGroups = defaultGroups;
        this.defaultGroupsRules = defaultGroupsRules;
        this.autoUpdateKnownDomains = autoUpdateKnownDomains;
        this.customEmailAttribute = customEmailAttribute;
        this.customNameAttribute = customNameAttribute;
        this.customUsernameAttributeName = customUsernameAttributeName;
        this.enabled = enabled;
        this.id = id;
        this.idpGroupsAttributes = idpGroupsAttributes;
        this.jitDirectory = jitDirectory;
        this.kind = kind;
        this.knownDomains = knownDomains;
        this.knownAutoRedirect = knownAutoRedirect;
        this.createAllIncomingGroups = createAllIncomingGroups;
        this.removeNonIdpGroupsFromUser = removeNonIdpGroupsFromUser;
        this.managedGroups = managedGroups;
        this.managedGroupsRequiredForJITCreation = managedGroupsRequiredForJITCreation;
        this.matchedUserDirectoryIds = matchedUserDirectoryIds;
        this.name = name;
        this.notificationEmails = notificationEmails;
        this.redirectGroups = redirectGroups;
        this.redirectPolicy = redirectPolicy;
        this.userTransformationRegexes = userTransformationRegexes;
        this.singleLogoutEnabled = singleLogoutEnabled;
        this.singleLogoutReturnURL = singleLogoutReturnURL;
        this.userActivatePolicy = userActivatePolicy;
        this.userLookupAttribute = userLookupAttribute;
        this.userLookupTransform = userLookupTransform;
        this.usernameAttribute = usernameAttribute;
        this.usernamePolicy = usernamePolicy;
        this.userNotFoundPolicy = userNotFoundPolicy;
        this.userUpdatePolicy = userUpdatePolicy;
        this.visible = visible;
        this.hostedDomain = hostedDomain;
        this.selectedUsernameAttributeInfo = selectedUsernameAttributeInfo;
        this.sendLoginHint = sendLoginHint;
        this.authenticatedAnonymousBrowsingEnabled = authenticatedAnonymousBrowsingEnabled;
    }

    public String getSingleLogoutReturnURL() {
        return this.singleLogoutReturnURL;
    }

    public Set<Long> getMatchedUserDirectoryIds() {
        return this.matchedUserDirectoryIds;
    }

    public <T> T fold(Function<OIDCIdpConfiguration, T> ifOidc, Function<SAMLIdpConfiguration, T> ifSaml) {
        if (this instanceof SAMLIdpConfiguration) {
            return ifSaml.apply((SAMLIdpConfiguration)this);
        }
        return ifOidc.apply((OIDCIdpConfiguration)this);
    }

    public void ifOidc(Consumer<OIDCIdpConfiguration> consumer) {
        this.fold(cfg -> {
            consumer.accept((OIDCIdpConfiguration)cfg);
            return null;
        }, ignored -> null);
    }

    public void ifSaml(Consumer<SAMLIdpConfiguration> consumer) {
        this.fold(ignored -> null, cfg -> {
            consumer.accept((SAMLIdpConfiguration)cfg);
            return null;
        });
    }

    public String getId() {
        return this.id;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Set<String> getIdpGroupsAttributes() {
        return Option.of(this.idpGroupsAttributes).getOrElse(Collections.emptySet());
    }

    public abstract SSOProtocol getProtocol();

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        json.put("id", this.getId());
        json.put("name", this.getName());
        json.put("kind", this.getKind().toString());
        json.put("enabled", this.isEnabled());
        json.put("defaultGroups", new JSONArray(this.getDefaultGroups()));
        json.put("defaultGroupsRules", JsonMapping.Write.mapAsJson(this.getDefaultGroupsRules()).getOrElse(new JSONObject()));
        json.put("autoUpdateKnownDomains", this.isAutoUpdateKnownDomains());
        json.put("customEmailAttribute", this.getCustomEmailAttribute());
        json.put("customNameAttribute", this.getCustomNameAttribute());
        json.put("customUsernameAttributeName", this.getCustomUsernameAttributeName());
        json.put("idpGroupsAttributes", new JSONArray(this.getIdpGroupsAttributes()));
        json.put("jitDirectory", (Object)this.getJitDirectory().orElse(null));
        json.put("knownDomains", new JSONArray(this.getKnownDomains()));
        json.put("knownAutoRedirect", this.isKnownAutoRedirect());
        json.put("sendLoginHint", this.isSendLoginHint());
        json.put("createAllIncomingGroups", this.isCreateAllIncomingGroups());
        json.put("removeNonIdpGroupsFromUser", this.isRemoveNonIdpGroupsFromUser());
        json.put("managedGroups", new JSONArray(this.getManagedGroups().stream().map(ManagedGroup::getName).collect(Collectors.toList())));
        json.put("managedGroupsRequiredForJITCreation", this.isManagedGroupsRequiredForJITCreation());
        json.put("matchedUserDirectoryIds", new JSONArray(this.getMatchedUserDirectoryIds()));
        json.put("notificationEmails", this.getNotificationEmails());
        json.put("redirectGroups", new JSONArray(this.getRedirectGroups()));
        json.put("redirectPolicy", this.getRedirectPolicy().name());
        json.put("userTransformationRegexes", new JSONArray(this.getUserTransformationRegexes().stream().map(pair -> new JSONArray(new String[]{(String)pair.getLeft(), (String)pair.getRight()})).collect(Collectors.toList())));
        json.put("singleLogoutEnabled", this.isSingleLogoutEnabled());
        json.put("singleLogoutReturnURL", this.getSingleLogoutReturnURL());
        json.put("userActivatePolicy", this.getUserActivatePolicy().name());
        json.put("userLookupAttribute", this.getUserLookupAttribute().name());
        json.put("userLookupTransform", this.getUserLookupTransform().name());
        json.put("usernameAttribute", this.getUsernameAttribute().name());
        json.put("usernamePolicy", this.getUsernamePolicy().name());
        json.put("userNotFoundPolicy", this.getUserNotFoundPolicy().name());
        json.put("userUpdatePolicy", this.getUserUpdatePolicy().name());
        json.put("visible", this.isVisible());
        json.put("hostedDomain", this.isHostedDomain());
        json.put("selectedUsernameAttributeInfo", this.getSelectedUsernameAttributeInfo());
        json.put("authenticatedAnonymousBrowsingEnabled", this.isAuthenticatedAnonymousBrowsingEnabled());
        return json;
    }

    public abstract boolean isOIDC();

    public abstract boolean isSAML();

    public boolean isDomainAllowed(String domain) {
        if (this.getUsernamePolicy() == UsernamePolicy.ANY) {
            return true;
        }
        return domain != null && this.getKnownDomains().contains(domain.toLowerCase());
    }

    public UserNotFoundPolicy getUserNotFoundPolicy() {
        return this.userNotFoundPolicy;
    }

    public UserUpdatePolicy getUserUpdatePolicy() {
        return this.userUpdatePolicy;
    }

    public UserActivatePolicy getUserActivatePolicy() {
        return this.userActivatePolicy;
    }

    public Set<String> getDefaultGroups() {
        return this.defaultGroups;
    }

    public Map<String, String> getDefaultGroupsRules() {
        return this.defaultGroupsRules;
    }

    public Set<String> getDefaultGroupsFilteredForUser(String usernameFromIdp) {
        HashSet<String> filteredGroups = new HashSet<String>();
        for (String group : this.getDefaultGroups()) {
            String groupRule = this.getDefaultGroupsRules().get(group);
            if (StringUtils.isBlank(groupRule)) {
                filteredGroups.add(group);
                continue;
            }
            if (!StringUtils.isNotBlank(groupRule) || usernameFromIdp == null || !usernameFromIdp.matches(groupRule)) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    public LinkedHashSet<String> getKnownDomains() {
        return this.knownDomains;
    }

    public Optional<Long> getJitDirectory() {
        return this.jitDirectory;
    }

    public Set<String> getRedirectGroups() {
        return this.redirectGroups;
    }

    public UsernameAttribute getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public UserLookupAttribute getUserLookupAttribute() {
        if (this.userNotFoundPolicy == UserNotFoundPolicy.CREATE) {
            return UserLookupAttribute.USERNAME;
        }
        return this.userLookupAttribute;
    }

    public UserLookupTransform getUserLookupTransform() {
        return this.userLookupTransform;
    }

    public String getNotificationEmails() {
        return this.notificationEmails;
    }

    public UsernamePolicy getUsernamePolicy() {
        return this.usernamePolicy;
    }

    public boolean isAutoUpdateKnownDomains() {
        return this.autoUpdateKnownDomains;
    }

    public RedirectPolicy getRedirectPolicy() {
        return this.redirectPolicy;
    }

    public String getCustomNameAttribute() {
        return StringUtils.trimToNull(this.customNameAttribute);
    }

    public String getCustomEmailAttribute() {
        return StringUtils.trimToNull(this.customEmailAttribute);
    }

    public boolean isCreateAllIncomingGroups() {
        return this.createAllIncomingGroups;
    }

    public boolean isRemoveNonIdpGroupsFromUser() {
        return this.removeNonIdpGroupsFromUser;
    }

    public List<ManagedGroup> getManagedGroups() {
        return this.managedGroups;
    }

    public boolean isManagedGroupsRequiredForJITCreation() {
        return this.managedGroupsRequiredForJITCreation;
    }

    public boolean isKnownAutoRedirect() {
        return this.knownAutoRedirect;
    }

    public boolean isHostedDomain() {
        return this.hostedDomain;
    }

    public boolean isSingleLogoutEnabled() {
        return this.singleLogoutEnabled;
    }

    public String getCustomUsernameAttributeName() {
        return StringUtils.trimToEmpty(this.customUsernameAttributeName);
    }

    public List<Pair<String, String>> getUserTransformationRegexes() {
        return this.userTransformationRegexes;
    }

    public String getSelectedUsernameAttributeInfo() {
        return this.selectedUsernameAttributeInfo;
    }

    public boolean isSendLoginHint() {
        return this.sendLoginHint;
    }

    public boolean isAuthenticatedAnonymousBrowsingEnabled() {
        return this.authenticatedAnonymousBrowsingEnabled;
    }

    public static enum AllowCreate {
        TRUE,
        FALSE;

    }

    public static enum NameIdFormat {
        DEFAULT,
        CUSTOM;

    }

    public static enum RedirectPolicy {
        MANUAL,
        FALLBACK,
        ALL,
        HARD,
        NONE,
        KNOWN_DOMAIN,
        USER_DIRECTORY,
        USER_GROUP;

    }

    public static enum UserLookupTransform {
        NONE,
        NAME_PART,
        REGEX;

    }

    public static enum UserLookupAttribute {
        USERNAME("Username", "username", false),
        MAIL("Mail", "mail", true),
        USER_PRINCIPAL_NAME("User Principal Name", "userPrincipalName", true),
        SAMACCOUNTNAME("SAM Account Name", "sAMAccountName", true),
        EMPLOYEEID("Employee-ID", "employeeId", true);

        private final String attributeName;
        private final String displayName;
        private final boolean ldapOnly;

        private UserLookupAttribute(String displayName, String attributeName, boolean ldapOnly) {
            this.displayName = displayName;
            this.attributeName = attributeName;
            this.ldapOnly = ldapOnly;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public boolean isLdapOnly() {
            return this.ldapOnly;
        }
    }

    public static enum UsernamePolicy {
        ANY,
        KNOWN_DOMAINS;

    }

    public static enum UserActivatePolicy {
        NONE,
        ACTIVATE;

    }

    public static enum UserUpdatePolicy {
        NONE,
        UPDATE;

    }

    public static enum UserNotFoundPolicy {
        REJECT,
        CREATE;

    }

    public static enum UsernameAttribute {
        UPN("User Principal Name"),
        MAIL("E-Mail"),
        NAME_ID("Subject's Name ID"),
        NAME("Name"),
        WINDOWS_ACCOUNT_NAME("Windows Account Name"),
        SUB("sub"),
        PREFERRED_USERNAME("preferred_username"),
        CUSTOM_SAML_ATTRIBUTE_NAME("Custom username attribute");

        private final String displayName;

        private UsernameAttribute(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum SSOProtocol {
        SAML("SAML"),
        OIDC("OpenID Connect");

        private String name;

        private SSOProtocol(String name) {
            this.name = name;
        }
    }

    public static enum KindCategory {
        CLOUD("Cloud"),
        SERVER("On-Premise"),
        GENERIC("General");

        private String displayName;

        private KindCategory(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static enum Kind {
        ADFS("AD FS", "AD FS (Active Directory Federation Services)", UsernameAttribute.UPN, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, "upn", "upn", KindCategory.SERVER, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://{host url}/adfs/.well-known/openid-configuration"),
        AUTH0("Auth0", "Auth0", UsernameAttribute.NAME_ID, "username", KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://{identity server}/.well-known/openid-configuration"),
        AUTHANVIL("AuthAnvil", "AuthAnvil", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML}), "https://{identity server}/.well-known/openid-configuration"),
        AWS_COGNITO("AWS Cognito", "AWS Cognito", "username", "username", KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC}), "https://cognito-idp.{region}.amazonaws.com/{userPoolId}/.well-known/openid-configuration"),
        AZURE_AD("Azure AD", "Azure AD", UsernameAttribute.NAME, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, "unique_name", "preferred_username", KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC, SSOProtocol.SAML}), "https://login.microsoftonline.com/{tenant}/v2.0/.well-known/openid-configuration", "azure_ad"),
        BITIUM("Bitium", "Bitium", UsernameAttribute.NAME_ID, KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML})),
        CENTRIFY("Centrify", "Centrify", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC, SSOProtocol.SAML}), "https://{subdomain}.my.centrify.com/oidc/2/.well-known/openid-configuration"),
        DUO("Duo", "Duo", UsernameAttribute.NAME_ID, KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML})),
        GITHUB("GitHub", "GitHub", "login", "login", KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC}), null, "github"),
        GITLAB("GitLab", "GitLab", "nickname", "nickname", KindCategory.SERVER, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC}), "https://{host url}/.well-known/openid-configuration"),
        GOOGLE("Google GSuite", "Google GSuite", UsernameAttribute.NAME_ID, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, "email", "email", KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC, SSOProtocol.SAML}), "https://accounts.google.com/.well-known/openid-configuration", "google"),
        KEYCLOAK("Keycloak", "Keycloak", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.SERVER, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://{host url}/auth/realms/{realm}/.well-known/openid-configuration"),
        OKTA("Okta", "Okta", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC, SSOProtocol.SAML}), "https://{host url}/.well-known/openid-configuration"),
        ONELOGIN("OneLogin", "OneLogin", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.OIDC, SSOProtocol.SAML}), "https://{subdomain}.onelogin.com/oidc/2/.well-known/openid-configuration"),
        PINGONE("Ping One", "PingOne", UsernameAttribute.NAME_ID, KindCategory.CLOUD, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML})),
        PINGFEDERATE("Ping Federate", "Ping Federate", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.SERVER, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://{host url}/.well-known/openid-configuration"),
        SALESFORCE("Salesforce", "Salesforce", UsernameAttribute.NAME_ID, UsernameAttribute.PREFERRED_USERNAME, KindCategory.CLOUD, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://login.salesforce.com/.well-known/openid-configuration"),
        WSO2("WSO2", "WSO2", UsernameAttribute.NAME_ID, KindCategory.SERVER, Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML})),
        UNSPECIFIED("", "Other", UsernameAttribute.NAME_ID, UsernameAttribute.SUB, KindCategory.GENERIC, (Set<SSOProtocol>)Sets.newHashSet((Object[])new SSOProtocol[]{SSOProtocol.SAML, SSOProtocol.OIDC}), "https://{identity server}/.well-known/openid-configuration");

        private final String defaultName;
        private final String displayName;
        private final UsernameAttribute samlDefaultUsernameAttribute;
        private final UsernameAttribute oidcDefaultUsernameAttribute;
        private final String samlCustomUsernameAttributeName;
        private final String oidcCustomUsernameAttributeName;
        private final String suggestedWellknownUrl;
        private final KindCategory category;
        private final Set<SSOProtocol> supportedProtocols;
        private final String oidcLibRepresentation;

        private Kind(String defaultName, String displayName, UsernameAttribute samlDefaultUsernameAttribute, UsernameAttribute oidcDefaultUsernameAttribute, String samlCustomUsernameAttributeName, String oidcCustomUsernameAttributeName, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl, String oidcLibRepresentation) {
            this.defaultName = defaultName;
            this.displayName = displayName;
            this.samlDefaultUsernameAttribute = samlDefaultUsernameAttribute;
            this.oidcDefaultUsernameAttribute = oidcDefaultUsernameAttribute;
            this.samlCustomUsernameAttributeName = samlCustomUsernameAttributeName;
            this.oidcCustomUsernameAttributeName = oidcCustomUsernameAttributeName;
            this.category = category;
            this.supportedProtocols = supportedProtocols;
            this.suggestedWellknownUrl = suggestedWellknownUrl;
            this.oidcLibRepresentation = oidcLibRepresentation;
        }

        private Kind(String defaultName, String displayName, UsernameAttribute samlDefaultUsernameAttribute, UsernameAttribute oidcDefaultUsernameAttribute, String samlCustomUsernameAttributeName, String oidcCustomUsernameAttributeName, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl) {
            this(defaultName, displayName, samlDefaultUsernameAttribute, oidcDefaultUsernameAttribute, samlCustomUsernameAttributeName, oidcCustomUsernameAttributeName, category, supportedProtocols, suggestedWellknownUrl, null);
        }

        private Kind(String defaultName, String displayName, UsernameAttribute defaultUsernameAttribute, KindCategory category, Set<SSOProtocol> supportedProtocols) {
            this(defaultName, displayName, defaultUsernameAttribute, defaultUsernameAttribute, null, null, category, supportedProtocols, null, null);
        }

        private Kind(String defaultName, String displayName, UsernameAttribute samlDefaultUsernameAttribute, UsernameAttribute oidcDefaultUsernameAttribute, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl) {
            this(defaultName, displayName, samlDefaultUsernameAttribute, oidcDefaultUsernameAttribute, null, null, category, supportedProtocols, suggestedWellknownUrl, null);
        }

        private Kind(String defaultName, String displayName, UsernameAttribute samlDefaultUsernameAttribute, String oidcDefaultUsernameAttribute, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl) {
            this(defaultName, displayName, samlDefaultUsernameAttribute, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, null, oidcDefaultUsernameAttribute, category, supportedProtocols, suggestedWellknownUrl, null);
        }

        private Kind(String defaultName, String displayName, String samlCustomUsernameAttributeName, String oidcCustomUsernameAttributeName, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl) {
            this(defaultName, displayName, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, samlCustomUsernameAttributeName, oidcCustomUsernameAttributeName, category, supportedProtocols, suggestedWellknownUrl, null);
        }

        private Kind(String defaultName, String displayName, String samlCustomUsernameAttributeName, String oidcCustomUsernameAttributeName, KindCategory category, Set<SSOProtocol> supportedProtocols, String suggestedWellknownUrl, String oidcLibRepresentation) {
            this(defaultName, displayName, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME, samlCustomUsernameAttributeName, oidcCustomUsernameAttributeName, category, supportedProtocols, suggestedWellknownUrl, oidcLibRepresentation);
        }

        public String defaultName() {
            return this.defaultName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public UsernameAttribute getDefaultUsernameAttribute(SSOProtocol protocol) {
            if (protocol.equals((Object)SSOProtocol.OIDC)) {
                return this.oidcDefaultUsernameAttribute;
            }
            return this.samlDefaultUsernameAttribute;
        }

        public KindCategory getCategory() {
            return this.category;
        }

        public Set<SSOProtocol> getSupportedProtocols() {
            return this.supportedProtocols;
        }

        public String getSamlCustomUsernameAttributeName() {
            return this.samlCustomUsernameAttributeName == null ? "" : this.samlCustomUsernameAttributeName;
        }

        public String getOidcCustomUsernameAttributeName() {
            return this.oidcCustomUsernameAttributeName == null ? "" : this.oidcCustomUsernameAttributeName;
        }

        public String getSuggestedWellknownUrl() {
            return this.suggestedWellknownUrl;
        }

        public String getOidcLibRepresentation() {
            return this.oidcLibRepresentation;
        }
    }
}

