/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import io.vavr.control.Option;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RemembermeUtils;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.UserdetailsInCommentRequestWrapper;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.hostapp.StatusPreservingResponse;
import org.kantega.atlaskerb.utils.CryptoUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraHostApp
extends DefaultHostApp {
    private static final String COMMENT_REST_URL = "/rest/api/2/issue/.*/comment";
    private static final String COMMENT_POST_URL = "/secure/AddComment.jspa";
    private final Method recordLoginMethod;
    private final Object loginComponent;
    private final Method fromUser;
    private boolean useApplicationUser;
    private final Logger log;

    public JiraHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager) {
        Method fromUser;
        Object loginComponent;
        Method recordLoginMethod;
        block4: {
            super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager);
            this.log = LoggerFactory.getLogger(this.getClass());
            this.hasRestApi = true;
            recordLoginMethod = null;
            loginComponent = null;
            fromUser = null;
            try {
                ClassLoader ccl = this.getClass().getClassLoader().getParent();
                if (ccl == null) break block4;
                Class<?> loginStoreClass = ccl.loadClass("com.atlassian.jira.security.login.LoginStore");
                Class<?> applicationUserClass = ccl.loadClass("com.atlassian.jira.user.ApplicationUser");
                Class<?> applicationUsersClass = ccl.loadClass("com.atlassian.jira.user.ApplicationUsers");
                Class<User> crowdEmbeddedUserClass = User.class;
                try {
                    recordLoginMethod = loginStoreClass.getMethod("recordLoginAttempt", applicationUserClass, Boolean.TYPE);
                    this.useApplicationUser = true;
                    fromUser = applicationUsersClass.getMethod("from", User.class);
                }
                catch (NoSuchMethodException e) {
                    recordLoginMethod = loginStoreClass.getMethod("recordLoginAttempt", crowdEmbeddedUserClass, Boolean.TYPE);
                    this.useApplicationUser = false;
                }
                loginComponent = ComponentLocator.getComponent(loginStoreClass);
            }
            catch (Exception e) {
                this.log.warn("Could not load JIRA LoginStore. Login count / time update disabled", (Throwable)e);
            }
        }
        this.recordLoginMethod = recordLoginMethod;
        this.loginComponent = loginComponent;
        this.fromUser = fromUser;
        this.preemptivePathMappings.add("/issues/*");
        this.preemptivePathMappings.add("/browse/*");
        this.preemptivePathMappings.add("/secure/CreateIssue*");
        this.preemptivePathMappings.add("/secure/QuickSearch.jspa*");
        this.preemptivePathMappings.add("/secure/BrowseProjects.jspa*");
        this.preemptivePathMappings.add("/secure/BulkCreateSetupPage!default.jspa*");
        this.preemptivePathMappings.add("/secure/ConfigurePortalPages.jspa*");
        this.preemptivePathMappings.add("/secure/ManageFilters.jspa*");
        this.preemptivePathMappings.add("/sr/jira.issueviews:searchrequest-printable*");
        this.preemptivePathMappings.add("/secure/StructureBoard*");
        this.preemptivePathMappings.add("/plugins/servlet/jeditor_file_provider*");
        this.preemptivePathMappings.add("/secure/CommentAssignIssue*");
    }

    private boolean isRootRequest(HttpServletRequest req) {
        return req.getRequestURI().equals(req.getContextPath() + "/");
    }

    @Override
    public boolean isProductMatch(String product) {
        return "jira".equals(product);
    }

    @Override
    public boolean urlInAdditionalBuiltInApiRequest(HttpServletRequest req) {
        return StringUtils.startsWith(HttpUrlUtils.getInternalPath(req), "/sr/jira.issueviews");
    }

    @Override
    public boolean isRequestMapped(HttpServletRequest req, String r) {
        return this.isPageWithLoginForm(req, r);
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequest req, String requestUrl) {
        return this.isMainLoginPage(requestUrl) || requestUrl.equals("/secure/Dashboard.jspa") || requestUrl.equals("/secure/MyJiraHome.jspa") || requestUrl.equals("/secure/") || this.isRootRequest(req) || this.kerbConfManager.isKerberosJsmEnabled() && this.isServiceDesk(requestUrl) && !this.isServiceDeskLogout(req) || this.kerbConfManager.isUserdetailsInCommentsEnabled() && (requestUrl.matches(COMMENT_REST_URL) || requestUrl.startsWith(COMMENT_POST_URL));
    }

    @Override
    public boolean isMainLoginPage(String requestUrl) {
        return requestUrl.equals("/login.jsp");
    }

    private boolean isServiceDeskLogout(HttpServletRequest r) {
        return StringUtils.equals(r.getParameter("logout"), "true");
    }

    private boolean isGadgetLoginRequest(HttpServletRequest req, String r) {
        return r.startsWith("/rest/gadget/") && r.endsWith("/login") && "POST".equals(req.getMethod());
    }

    @Override
    public boolean isPreemptiveRequestMapped(HttpServletRequest req) {
        if (this.isForwarded(req)) {
            return false;
        }
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return super.isPreemptiveRequestMapped(req) || r.startsWith("/issues/") || r.startsWith("/browse/") || r.startsWith("/secure/CreateIssue") || r.startsWith("/secure/QuickSearch.jspa") || r.startsWith("/secure/BrowseProjects.jspa") || r.startsWith("/secure/BulkCreateSetupPage!default.jspa") || r.startsWith("/secure/ConfigurePortalPages.jspa") || r.startsWith("/secure/ManageFilters.jspa") || r.startsWith("/sr/jira.issueviews:searchrequest-printable") || r.startsWith("/secure/StructureBoard") || r.startsWith("/plugins/servlet/jeditor_file_provider") || r.startsWith("/secure/CommentAssignIssue");
    }

    @Override
    public boolean isLoginRequest(HttpServletRequest req) {
        if (this.isForwarded(req)) {
            return false;
        }
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if ("POST".equals(req.getMethod()) && "/login.jsp".equals(requestPath)) {
            return true;
        }
        if (this.isGadgetLoginRequest(req, requestPath)) {
            return true;
        }
        return this.isServiceDesk(requestPath) && "POST".equals(req.getMethod());
    }

    @Override
    public String getLoginRequestUsername(HttpServletRequest req) {
        return req.getParameter("os_username");
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        String userAgent = Optional.ofNullable(req.getHeader("User-Agent")).orElse("");
        if ((this.isServiceDesk(r) || this.isForwardedServiceDesk(req)) && this.checkTempCookie(req, res, "krb_custport_logout")) {
            return true;
        }
        if (r.equals("/login.jsp") && req.getQueryString() == null && !userAgent.startsWith("JIRA/") && !userAgent.startsWith("AtlassianMobileApp")) {
            return true;
        }
        return super.shouldLoginManually(req, res);
    }

    private boolean isForwardedServiceDesk(HttpServletRequest req) {
        String forwardedUri = (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (forwardedUri == null) {
            return false;
        }
        return this.isServiceDesk(forwardedUri.substring(req.getContextPath().length()));
    }

    @Override
    public void dispatchToLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        String qs = req.getQueryString();
        this.log.debug("dispatchToLogin() requestPath: '{}', qs: '{}'", (Object)requestPath, (Object)qs);
        this.log.debug("isKeytabConfigured: {}, isPreemptiveAuthEnabled: {}, isSendToLoginEnabled: {}, isTraditionalLoginDisabled: {}", new Object[]{this.kerbConfManager.isKeytabConfigured(), this.kerbConfManager.isPreemptiveAuthEnabled(), this.kerbConfManager.isSendToLoginEnabled(), this.kerbConfManager.isTraditionalLoginDisabled()});
        if (requestPath.matches(COMMENT_REST_URL) || requestPath.startsWith(COMMENT_POST_URL)) {
            this.addUserdetailsInAnonymousJiraComment(chain, req, resp);
            return;
        }
        if (this.isForwarded(req) && "/login.jsp".equals(requestPath)) {
            this.log.debug("isForwarded()");
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (this.isServiceDesk(requestPath)) {
            String absolute;
            this.log.debug("isServiceDesk()");
            String url = "login?nokerberos";
            String dest = req.getParameter("destination");
            if (dest != null) {
                url = url + "&destination=" + HttpUrlUtils.urlEncode(dest);
            }
            if ("true".equals(absolute = req.getParameter("absolute"))) {
                url = url + "&absolute=true";
            }
            if (req.getParameter("nokerberos") != null) {
                this.log.debug("isServiceDesk() + nokerberos");
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            } else {
                this.log.debug("isServiceDesk() + metaRefresh, url: '{}'", (Object)url);
                this.metaRefresh(resp, url);
            }
        } else if (!this.isForwarded(req) && requestPath.startsWith("/secure/") && !requestPath.startsWith("/secure/CreateIssue")) {
            this.log.debug("isDashboardOrJiraHome -> sendRedirect");
            resp.sendRedirect(req.getContextPath() + "/login.jsp?os_destination=" + HttpUrlUtils.urlEncode(requestPath) + "%3F" + HttpUrlUtils.urlEncode(qs));
        } else if (requestPath.equals("/")) {
            this.log.debug("is call to path /");
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        } else if (this.isRestApi(requestPath)) {
            this.log.debug("isRestApi()");
            chain.doFilter((ServletRequest)req, (ServletResponse)new StatusPreservingResponse(resp));
        } else if (this.shouldDispatchToLoginPage()) {
            this.log.debug("shouldDispatchToLoginPage()");
            String encodedQuery = HttpUrlUtils.urlEncode(qs);
            if (!"/login.jsp".equals(requestPath) && !requestPath.contains("logout%3FSAMLResponse")) {
                this.log.debug("shouldDispatchToLoginPage() + login.jsp, encodedQuery: '{}'", (Object)encodedQuery);
                req.getRequestDispatcher("/login.jsp?os_destination=" + requestPath + "%3F" + encodedQuery).forward((ServletRequest)req, (ServletResponse)resp);
            } else {
                this.log.debug("shouldDispatchToLoginPage() + else, encodedQuery: '{}'", (Object)encodedQuery);
                req.getRequestDispatcher("/login.jsp?" + encodedQuery).forward((ServletRequest)req, (ServletResponse)resp);
            }
        } else {
            this.log.debug("dispatchToLogin default");
            if ("/login.jsp".equals(requestPath) && StringUtils.contains((CharSequence)qs, "logout%3FSAMLResponse")) {
                this.log.debug("login.jsp?os_destination={} qs: {}", (Object)requestPath, (Object)qs);
                req.getRequestDispatcher("/login.jsp?os_destination=").forward((ServletRequest)req, (ServletResponse)resp);
            } else {
                this.log.debug("else doFilter: {}, qs: {}: ", (Object)requestPath, (Object)qs);
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
        }
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if (this.isServiceDesk(requestPath)) {
            this.preventCaching(res);
            String destination = req.getParameter("destination");
            if (destination != null) {
                String absolute = req.getParameter("absolute");
                String url = destination;
                if (!"true".equals(absolute)) {
                    url = req.getContextPath() + "/servicedesk/customer/" + url;
                }
                this.safeRedirect.sendRedirect(url, req, res);
            } else {
                res.sendRedirect(req.getContextPath() + "/servicedesk/customer/");
            }
        } else if (this.isRestApi(requestPath)) {
            this.preventCaching(res);
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        } else {
            super.postSuccessfulLoginWithKerberosAction(user, req, res, chain);
        }
    }

    @Override
    public boolean shouldRequireCanLogin(HttpServletRequest req) {
        return !this.isServiceDesk(req.getRequestURI().substring(req.getContextPath().length()));
    }

    private boolean isServiceDesk(String requestPath) {
        return requestPath.startsWith("/servicedesk/customer/") && requestPath.endsWith("/user/login") || requestPath.equals("/servicedesk/customer/user/login");
    }

    @Override
    public String getRedirectTarget(HttpServletRequest req) {
        String destination;
        if (this.isServiceDesk(req.getRequestURI().substring(req.getContextPath().length())) && (destination = req.getParameter("destination")) != null) {
            if (StringUtils.startsWith(destination, "/servicedesk/customer")) {
                return req.getContextPath() + destination;
            }
            return req.getContextPath() + "/servicedesk/customer/" + destination;
        }
        return super.getRedirectTarget(req);
    }

    @Override
    public String optionallyDecryptLdapPassword(String ldapPasswordParameter) {
        if (CryptoUtils.secretIndicatesEncryptedValue(ldapPasswordParameter)) {
            String encryptorClassName = "com.atlassian.jira.crowd.embedded.encryptors.JiraEncryptor";
            String componentManagerClassName = "com.atlassian.jira.component.pico.ComponentManager";
            return this.decryptLdapPassword(ldapPasswordParameter, "com.atlassian.jira.crowd.embedded.encryptors.JiraEncryptor", "com.atlassian.jira.component.pico.ComponentManager").getOrElse(ldapPasswordParameter);
        }
        return super.optionallyDecryptLdapPassword(ldapPasswordParameter);
    }

    @Override
    public RemoteDirectory getAuthorativeDirectory(DbCachingRemoteDirectory directoryInstance) {
        RemoteDirectory authoritativeDirectory = super.getAuthorativeDirectory(directoryInstance);
        try {
            Method getKeysMethod = authoritativeDirectory.getClass().getMethod("getKeys", new Class[0]);
            getKeysMethod.setAccessible(true);
            Method getValueMethod = authoritativeDirectory.getClass().getMethod("getValue", String.class);
            getValueMethod.setAccessible(true);
            HashMap<String, String> updatedAttributes = new HashMap<String, String>();
            for (String key : authoritativeDirectory.getKeys()) {
                String value = authoritativeDirectory.getValue(key);
                if ("ldap.password".equals(key)) {
                    value = this.optionallyDecryptLdapPassword(value);
                }
                updatedAttributes.put(key, value);
            }
            authoritativeDirectory.setAttributes(updatedAttributes);
        }
        catch (NoSuchMethodException e) {
            this.log.warn("Problem getting 'ldap.password' from RemoteDirectory");
        }
        catch (Exception e) {
            this.log.warn("Problem decrypting 'ldap.password' from RemoteDirectory");
        }
        return authoritativeDirectory;
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user) {
        this.seraphLikeInvalidateSession(req);
        req.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)user);
        req.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        this.registerSuccessfulLoginInLoginStore(user);
        return user;
    }

    private void registerSuccessfulLoginInLoginStore(Principal user) {
        if (this.recordLoginMethod != null && this.loginComponent != null) {
            try {
                Object applicationUser = this.useApplicationUser && this.fromUser != null ? this.fromUser.invoke(null, user) : user;
                this.recordLoginMethod.invoke(this.loginComponent, applicationUser, true);
            }
            catch (Exception e) {
                this.log.warn("Failed invoking JIRA LoginStore.recordLoginAttempt");
            }
        }
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return "com.atlassian.jira.security.login.JiraSeraphAuthenticator";
    }

    @Override
    public String getUserManagerLink() {
        return "/secure/admin/user/UserBrowser.jspa";
    }

    @Override
    public String getLoginPage() {
        return "/secure/Dashboard.jspa";
    }

    @Override
    public String getLogoutPage() {
        return "/secure/Logout!default.jspa";
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5501;
    }

    @Override
    public boolean isJiraCrowdRequest(HttpServletRequest req) {
        String internalPath = HttpUrlUtils.getInternalPath(req);
        String authHeader = req.getHeader("Authorization");
        boolean isJiraCrowdAuth = StringUtils.startsWith(authHeader, "Basic ") && !StringUtils.contains((CharSequence)authHeader, ":");
        return isJiraCrowdAuth && Option.of(internalPath).map(path -> path.startsWith("/rest/usermanagement/1/")).getOrElse(false) != false;
    }

    @Override
    public void setRememberMeCookie(HttpServletRequest request, HttpServletResponse response, String username) {
        RemembermeUtils.setRememberMeCookie(request, response, username);
    }

    @Override
    public boolean shouldCheckUserAccess() {
        return true;
    }

    @Override
    public boolean isSyncDirCompatible() {
        String version = this.applicationProperties.getVersion();
        String[] versionArray = version.split("\\.");
        boolean isVersion8 = false;
        boolean isVersionLowerThan8 = false;
        boolean isHigherThan8 = false;
        boolean isMinorLowerThan14 = false;
        boolean isMinorHigherThan15 = false;
        try {
            if (versionArray.length > 1) {
                int major = Integer.parseInt(versionArray[0]);
                isVersion8 = major == 8;
                isVersionLowerThan8 = major < 8;
                boolean bl = isHigherThan8 = major > 8;
            }
            if (versionArray.length > 2) {
                int minor = Integer.parseInt(versionArray[1]);
                isMinorLowerThan14 = minor < 14;
                isMinorHigherThan15 = minor >= 15;
            }
            return isVersionLowerThan8 || isHigherThan8 || isVersion8 && isMinorLowerThan14 || isVersion8 && isMinorHigherThan15;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean addUserdetailsInAnonymousJiraComment(FilterChain chain, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.kerbConfManager.isUserdetailsInCommentsEnabled()) {
            String userdetails = (String)req.getAttribute("usernameAnonymousUser");
            if (userdetails != null) {
                User user = this.crowdService.getUser(userdetails);
                if (user != null) {
                    userdetails = "[" + user.getDisplayName() + "|mailto:" + user.getEmailAddress() + "]";
                }
                this.log.debug("Adding user details to anonymous comment: " + userdetails);
            }
            req.getSession().removeAttribute("lockout_timestamp");
            chain.doFilter((ServletRequest)new UserdetailsInCommentRequestWrapper(req, userdetails, HttpUrlUtils.getInternalPath(req).matches(COMMENT_REST_URL)), (ServletResponse)new StatusPreservingResponse(res));
            return true;
        }
        return false;
    }

    public static class CanUseStatus {
        private final ApplicationUser user;
        private boolean hasGlobalAdminPermission;
        private boolean hasAnyRole;

        public CanUseStatus(String username) {
            this.user = this.createApplicationUser(username);
        }

        @NotNull
        private ApplicationUser createApplicationUser(final String userName) {
            return new ApplicationUser(){

                public String getKey() {
                    return userName;
                }

                public String getUsername() {
                    return userName;
                }

                public String getName() {
                    return userName;
                }

                public long getDirectoryId() {
                    return 0L;
                }

                public boolean isActive() {
                    return true;
                }

                public String getEmailAddress() {
                    return null;
                }

                public String getDisplayName() {
                    return null;
                }

                public User getDirectoryUser() {
                    return null;
                }

                public Long getId() {
                    return null;
                }
            };
        }

        public boolean hasGlobalAdminPermission() {
            return this.hasGlobalAdminPermission;
        }

        public boolean hasAnyRole() {
            return this.hasAnyRole;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CanUseStatus invoke() {
            Thread ct = Thread.currentThread();
            ClassLoader oldCcl = ct.getContextClassLoader();
            try {
                GlobalPermissionManager globalPermissionManager = (GlobalPermissionManager)ComponentLocator.getComponent(GlobalPermissionManager.class);
                ct.setContextClassLoader(GlobalPermissionManager.class.getClassLoader());
                this.hasGlobalAdminPermission = globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.user);
                ApplicationRoleManager applicationRoleManager = (ApplicationRoleManager)ComponentLocator.getComponent(ApplicationRoleManager.class);
                this.hasAnyRole = applicationRoleManager.hasAnyRole(this.user);
            }
            finally {
                ct.setContextClassLoader(oldCcl);
            }
            return this;
        }
    }
}

