/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.confluence.event.events.user.UserCreateEvent;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.rememberme.ConfluenceRememberMeTokenDao;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Optional;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RemembermeUtils;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.hostapp.StatusPreservingResponse;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfluenceHostApp
extends DefaultHostApp {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final Method onSuccessfulLoginAttemptMethod;
    private final Object loginManager;
    private final ConfluenceAccessManager confluenceAccessManager;
    private final PermissionManager permissionManager;

    public ConfluenceHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager);
        this.hasRestApi = true;
        Method onSuccessfulLoginAttemptMethod = null;
        Object loginManager = null;
        try {
            ClassLoader classLoader = this.getClass().getClassLoader().getParent();
            if (classLoader != null) {
                Class<?> loginManagerClass = classLoader.loadClass("com.atlassian.confluence.security.login.LoginManager");
                loginManager = ComponentLocator.getComponent(loginManagerClass);
                onSuccessfulLoginAttemptMethod = loginManagerClass.getMethod("onSuccessfulLoginAttempt", String.class, HttpServletRequest.class);
            }
        }
        catch (Exception e) {
            this.log.warn("Could not load Confluence LoginManager. Login count / time update disabled", (Throwable)e);
        }
        this.onSuccessfulLoginAttemptMethod = onSuccessfulLoginAttemptMethod;
        this.loginManager = loginManager;
        this.preemptivePathMappings.add("/");
        this.preemptivePathMappings.add("/index.action*");
        this.preemptivePathMappings.add("/dashboard*");
        this.preemptivePathMappings.add("/display/*");
        this.preemptivePathMappings.add("/dosearchsite.action*");
        this.preemptivePathMappings.add("/labels/*");
        this.preemptivePathMappings.add("/mail/archive/viewmailarchive.action*");
        this.preemptivePathMappings.add("/pages/*");
        this.preemptivePathMappings.add("/spaces/*");
        this.preemptivePathMappings.add("/spacedirectory/*");
        this.preemptivePathMappings.add("/users/*");
        this.preemptivePathMappings.add("/viewpage.action*");
        this.preemptivePathMappings.add("/plugins/inlinetasks/mytasks.action*");
        this.preemptivePathMappings.add("/plugins/servlet/sitemapservlet*");
        this.confluenceAccessManager = this.tryToGetConfluenceAccessManager();
        this.permissionManager = (PermissionManager)ComponentLocator.getComponent(PermissionManager.class);
    }

    @Override
    public boolean isPreemptiveRequestMapped(HttpServletRequest req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return super.isPreemptiveRequestMapped(req) || r.equals("/") || r.startsWith("/index.action") || r.startsWith("/dashboard") || r.startsWith("/display/") || r.startsWith("/labels/") || r.startsWith("/mail/archive/viewmailarchive.action") || r.startsWith("/pages/") || r.startsWith("/spaces/") || r.startsWith("/spacedirectory/") || r.startsWith("/users/") || r.startsWith("/viewpage.action") || r.startsWith("/plugins/inlinetasks/mytasks.action") || r.startsWith("/plugins/servlet/sitemapservlet") || r.startsWith("/dosearchsite.action");
    }

    @Override
    public boolean shouldDisableHardRedirect(HttpServletRequest req) {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if (requestPath.startsWith("/plugins/servlet/remotepageview")) {
            return true;
        }
        return super.shouldDisableHardRedirect(req);
    }

    private ConfluenceAccessManager tryToGetConfluenceAccessManager() {
        try {
            Class<?> camClass = Thread.currentThread().getContextClassLoader().loadClass("com.atlassian.confluence.security.access.ConfluenceAccessManager");
            return (ConfluenceAccessManager)ComponentLocator.getComponent(camClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public boolean isProductMatch(String product) {
        return "confluence".equals(product);
    }

    @Override
    public boolean isRequestMapped(HttpServletRequest req, String r) {
        return this.isPageWithLoginForm(req, r) || this.isWebdavRequest(req) && this.kerbConfManager.isKeytabConfigured() && this.kerbConfManager.isKerberosEnabled() && this.kerbConfManager.isWebdavEnabled() || this.kerbConfManager.isKerberosKnowledgeBaseEnabled() && r.startsWith("/plugins/servlet/remotepageview");
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequest req, String requestUrl) {
        String qs = req.getQueryString();
        return (this.isMainLoginPage(requestUrl) || requestUrl.startsWith("/m/login/login.action")) && this.avoidSSOForUserAvatar(qs);
    }

    @Override
    public boolean isMainLoginPage(String requestUrl) {
        return requestUrl.startsWith("/login.action");
    }

    private boolean avoidSSOForUserAvatar(String qs) {
        return this.kerbConfManager.isSSOEnabledForUserAvatar() || !this.isUserAvatar(qs);
    }

    private boolean isUserAvatar(String qs) {
        return StringUtils.isNotBlank(qs) && qs.matches(".*%2Fdownload%2Fattachments%2F.*%2Fuser-avatar.*");
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        if ("true".equals(req.getParameter("logout"))) {
            return true;
        }
        return this.isWebdavRequest(req) && !this.kerbConfManager.isWebdavEnabled();
    }

    private boolean isWebdavRequest(HttpServletRequest req) {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        return requestPath.startsWith("/plugins/servlet/confluence");
    }

    @Override
    public boolean isLoginRequest(HttpServletRequest req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        return "/dologin.action".equals(r) && "POST".equals(req.getMethod());
    }

    @Override
    public String getLoginRequestUsername(HttpServletRequest req) {
        return req.getParameter("os_username");
    }

    @Override
    public void dispatchToLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        String qs = Optional.ofNullable(req.getQueryString()).orElse("");
        if (requestPath.startsWith("/plugins/servlet/remotepageview")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        } else if (!this.isWebdavRequest(req)) {
            if (this.isRestApi(requestPath)) {
                chain.doFilter((ServletRequest)req, (ServletResponse)new StatusPreservingResponse(resp));
            } else if (requestPath.startsWith("/login.action") || requestPath.startsWith("/m/login/login.action")) {
                if (qs.contains("logout%3FSAMLResponse")) {
                    resp.sendRedirect(req.getContextPath() + "/login.action?os_destination=");
                } else {
                    chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                }
            } else if (this.shouldDispatchToLoginPage()) {
                String returnUrl = requestPath;
                returnUrl = returnUrl + (StringUtils.isNotBlank(qs) ? "?" + qs : "");
                resp.sendRedirect(req.getContextPath() + "/login.action?os_destination=" + HttpUrlUtils.urlEncode(returnUrl));
            } else {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
        }
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user) {
        this.seraphLikeInvalidateSession(req);
        req.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)user);
        req.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        this.recordSuccessfulLoginEventWithLoginManager(user, req);
        return user;
    }

    private void recordSuccessfulLoginEventWithLoginManager(Principal user, HttpServletRequest req) {
        if (this.onSuccessfulLoginAttemptMethod != null && this.loginManager != null) {
            try {
                this.onSuccessfulLoginAttemptMethod.invoke(this.loginManager, user.getName(), req);
            }
            catch (Exception e) {
                this.log.warn("Failing registering successful login in Confluence", (Throwable)e);
            }
        }
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        if (this.isWebdavRequest(req) || this.isRestApi(requestPath)) {
            UserAccessor accessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
            User confluenceUser = accessor.getUser(user.getName());
            AuthenticatedUserThreadLocal.setUser((User)confluenceUser);
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        } else {
            super.postSuccessfulLoginWithKerberosAction(user, req, res, chain);
        }
    }

    @Override
    public boolean isPublicAccessEnabled() {
        if (this.confluenceAccessManager == null) {
            this.log.warn("No ConfluenceAccessManager available, unable to determine public access");
            return super.isPublicAccessEnabled();
        }
        AccessStatus userAccessStatus = this.confluenceAccessManager.getUserAccessStatus(null);
        return userAccessStatus.hasAnonymousAccess() || userAccessStatus.hasUnlicensedAuthenticatedAccess();
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return "com.atlassian.confluence.user.ConfluenceAuthenticator";
    }

    @Override
    public boolean canLogin(Principal user, HttpServletRequest request) {
        UserAccessor accessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        User confluenceUser = accessor.getUser(user.getName());
        if (this.confluenceAccessManager != null) {
            AccessStatus userAccessStatus = this.confluenceAccessManager.getUserAccessStatus(confluenceUser);
            return userAccessStatus.canUseConfluence();
        }
        if (this.permissionManager != null) {
            return this.permissionManager.hasPermission(confluenceUser, Permission.VIEW, PermissionManager.TARGET_APPLICATION);
        }
        return false;
    }

    @Override
    public String getUserManagerLink() {
        return "/admin/users/browseusers.action";
    }

    @Override
    public boolean supportsRemoveAllRememberMeTokens() {
        return true;
    }

    @Override
    public void removeAllRememberMeTokens() {
        ConfluenceRememberMeTokenDao component = (ConfluenceRememberMeTokenDao)ComponentLocator.getComponent(ConfluenceRememberMeTokenDao.class);
        component.removeAll();
    }

    @Override
    public void addUser(Directory directory, final String username, final String fullName, final String email, Set<String> groups2) {
        super.addUser(directory, username, fullName, email, groups2);
        User user = new User(){

            public String getFullName() {
                return fullName;
            }

            public String getEmail() {
                return email;
            }

            public String getName() {
                return username;
            }
        };
        UserCreateEvent event = new UserCreateEvent((Object)this, user);
        this.eventPublisher.publish((Object)event);
    }

    @Override
    public String getLoginPage() {
        return "/login.action";
    }

    @Override
    public String getLogoutPage() {
        return "/login.action?logout=true";
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5502;
    }

    @Override
    public void setRememberMeCookie(HttpServletRequest request, HttpServletResponse response, String username) {
        RemembermeUtils.setRememberMeCookie(request, response, username);
    }
}

