/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.azure;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import java.util.HashMap;
import java.util.Set;
import org.kantega.atlaskerb.connector.ConnectorHttpClient;
import org.kantega.atlaskerb.connector.ConnectorURIBuilder;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.api.ConnectorApiException;
import org.kantega.atlaskerb.connector.api.GroupHandler;
import org.kantega.atlaskerb.connector.api.MembershipHandler;
import org.kantega.atlaskerb.connector.api.UserHandler;
import org.kantega.atlaskerb.connector.azure.AzureAdBatchHandler;
import org.kantega.atlaskerb.connector.azure.AzureGraphHttpClient;
import org.kantega.atlaskerb.connector.model.SecurityGroupFilter;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureGraphApi
implements ConnectorAPI {
    private final AzureGraphHttpClient client;
    private final Logger log = LoggerFactory.getLogger(AzureGraphApi.class);
    private final String adminBaseUrl;
    private final int top;
    private SecurityGroupFilter securityGroupsOnly = SecurityGroupFilter.SECURITY_GROUPS_ONLY;

    public AzureGraphApi(String tenantId, String applicationId, String clientSecret) {
        String loginBaseUrl = System.getProperty("connector.azure.login.url", "https://login.microsoftonline.com");
        this.adminBaseUrl = System.getProperty("connector.azure.graph.url", "https://graph.microsoft.com");
        this.top = Integer.parseInt(System.getProperty("connector.azure.top", "-1"));
        this.client = new AzureGraphHttpClient(loginBaseUrl, tenantId, applicationId, clientSecret);
    }

    public AzureGraphApi(String tenantId, String applicationId, String clientSecret, SecurityGroupFilter securityGroupsOnly) {
        this(tenantId, applicationId, clientSecret);
        this.securityGroupsOnly = securityGroupsOnly;
    }

    private String getUserSelectionAttributes() {
        return "id,userPrincipalName,mail,givenName,surname,displayName,accountEnabled,userType";
    }

    @Override
    public void findAllUsers(UserHandler userHandler) throws InterruptedException {
        ConnectorURIBuilder uriBuilder = this.requestUriBuilder("/v1.0/users").queryParam("$select", this.getUserSelectionAttributes());
        String url = uriBuilder.toString();
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllUsers aborting");
            }
            ConnectorHttpClient.Response response = this.client.httpGet(url);
            JSONObject json = response.getAsJSONObject();
            url = json.isNull("@odata.nextLink") ? null : json.getString("@odata.nextLink");
            JSONArray jsonUsers = (JSONArray)json.get("value");
            for (int i = 0; i < jsonUsers.length(); ++i) {
                JSONObject jsonUser = (JSONObject)jsonUsers.get(i);
                UserItem userItem = this.toUserItem(jsonUser);
                if (userItem == null) continue;
                userHandler.handleUser(userItem);
            }
        } while (url != null);
    }

    @Override
    public void findAllGroups(GroupHandler groupHandler) throws InterruptedException {
        ConnectorURIBuilder uriBuilder = this.requestUriBuilder("/v1.0/groups");
        if (this.securityGroupsOnly == SecurityGroupFilter.SECURITY_GROUPS_ONLY) {
            uriBuilder = uriBuilder.queryParam("$filter", "securityEnabled eq true");
        }
        String url = uriBuilder.toString();
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("findAllGroups aborting");
            }
            ConnectorHttpClient.Response response = this.client.httpGet(url);
            JSONObject json = response.getAsJSONObject();
            url = json.isNull("@odata.nextLink") ? null : json.getString("@odata.nextLink");
            JSONArray jsonGroups = (JSONArray)json.get("value");
            for (int i = 0; i < jsonGroups.length(); ++i) {
                JSONObject jsonGroup = (JSONObject)jsonGroups.get(i);
                GroupItem group = new GroupItem();
                group.setName(jsonGroup.getString("displayName"));
                if (!jsonGroup.isNull("description")) {
                    group.setDescription(jsonGroup.getString("description"));
                }
                group.setId(jsonGroup.getString("id"));
                group.setActive(true);
                groupHandler.handleGroup(group);
            }
        } while (url != null);
    }

    @Override
    public void findAllMemberships(Set<UserItem> includedUsers, Set<GroupItem> includedGroups, final MembershipHandler membershipHandler) throws InterruptedException {
        final HashMap userNameById = new HashMap();
        HashMap<String, String> groupNameById = new HashMap<String, String>();
        UserHandler userHandler = user -> userNameById.put(user.getKey(), user.getName());
        includedUsers.forEach(userHandler::handleUser);
        GroupHandler groupHandler = group -> groupNameById.put(group.getId(), group.getName());
        includedGroups.forEach(groupHandler::handleGroup);
        AzureAdBatchHandler aadBatchHandler = new AzureAdBatchHandler(this.adminBaseUrl, this.client){

            @Override
            public void onSuccess(String groupName, JSONArray values2) {
                MembershipItem membershipItem = new MembershipItem();
                membershipItem.setName(groupName);
                for (int j = 0; j < values2.length(); ++j) {
                    JSONObject jsonMember = (JSONObject)values2.get(j);
                    if (!"#microsoft.graph.user".equals(jsonMember.getString("@odata.type"))) continue;
                    String userId = jsonMember.getString("id");
                    String username = AzureGraphApi.this.getUsername(jsonMember);
                    if (userNameById.containsKey(userId)) {
                        UserMember mem = new UserMember();
                        mem.setName((String)userNameById.get(userId));
                        membershipItem.getUserCollection().getUsers().add(mem);
                        continue;
                    }
                    AzureGraphApi.this.log.debug("User {}/{} is member of {} but not present in filtered user list; skipping.", new Object[]{userId, username, groupName});
                }
                membershipHandler.handleMembership(membershipItem);
            }

            @Override
            public void onError(String requestReference, int status, JSONObject responseBody) {
                AzureGraphApi.this.throwConnectorException(status, "Batch request " + requestReference + " failed to execute", responseBody);
            }
        };
        groupNameById.forEach((groupId, groupName) -> aadBatchHandler.registerRequest((String)groupName, this.requestUriBuilder("/groups/" + groupId + "/members").toString(true)));
        aadBatchHandler.run();
    }

    private UserItem toUserItem(JSONObject jsonUser) {
        String userName = this.getUsername(jsonUser);
        if (userName != null) {
            String userPrincipalName = jsonUser.isNull("userPrincipalName") ? null : jsonUser.getString("userPrincipalName");
            String mail = jsonUser.isNull("mail") ? null : jsonUser.getString("mail");
            UserItem user = new UserItem();
            user.setFirstName(jsonUser.getString("givenName"));
            user.setLastName(jsonUser.getString("surname"));
            user.setDisplayName(jsonUser.getString("displayName"));
            user.setUserType(UserItem.UserType.fromAzure(jsonUser.getString("userType")));
            user.setEmail(mail != null ? mail : userPrincipalName);
            user.setActive(jsonUser.getBoolean("accountEnabled"));
            user.setKey(jsonUser.getString("id"));
            String name = user.getUserType() == UserItem.UserType.GUEST ? user.getEmail() : (userPrincipalName != null ? userPrincipalName : mail);
            user.setName(name);
            return user;
        }
        return null;
    }

    private String getUsername(JSONObject jsonUser) {
        if (!jsonUser.isNull("userPrincipalName")) {
            return jsonUser.getString("userPrincipalName");
        }
        if (!jsonUser.isNull("mail")) {
            return jsonUser.getString("mail");
        }
        return null;
    }

    private ConnectorURIBuilder requestUriBuilder(String path) {
        ConnectorURIBuilder builder = ConnectorURIBuilder.builder(this.adminBaseUrl + path);
        if (this.top > 0 && !path.endsWith("$batch")) {
            builder.queryParam("$top", String.valueOf(this.top));
        }
        return builder;
    }

    private void throwConnectorException(int status, String message, JSONObject responseItem) {
        throw new ConnectorApiException(status, message, responseItem);
    }
}

