/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.TestKerberosAction;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.model.ObjectTypeFilter;
import org.kantega.atlaskerb.connector.model.UserLookupTransform;
import org.kantega.atlaskerb.connector.model.filters.GroupFilter;
import org.kantega.atlaskerb.connector.model.filters.UserMembershipFilter;
import org.kantega.atlaskerb.connector.model.filters.UserTypeSelectionFilter;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.saml.CertTool;

@Scanned
public class EditConnectorAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;

    @Inject
    public EditConnectorAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ConnectorType connectorType;
        Map<String, Object> model = this.newModel(req);
        TestKerberosAction.checkSupportedBrowser(model, req.getHeader("User-Agent"));
        Directory directory = null;
        String kind = req.getParameter("kind");
        if (kind != null) {
            connectorType = this.connectorConfManager.getConnectorTypes().get(kind);
        } else {
            String id = req.getParameter("id");
            if (id != null) {
                directory = this.connectorConfManager.getDirectory(id);
                connectorType = this.connectorConfManager.getConnectorTypes().get(directory.getKind());
                model.put("connectorId", directory.getId());
                model.put("currentConnector", directory);
            } else {
                throw new IllegalArgumentException("Missing id or kind parameter");
            }
        }
        connectorType.editDirectory(req, directory, model);
        this.renderPage(connectorType, resp, model);
    }

    private void renderPage(ConnectorType connectorType, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        model.put("kind", connectorType.getKey());
        this.renderTemplate(resp, model, "templates/atlaskerb/connector/" + connectorType.getEditDirectoryTemplate());
    }

    private void renderTemplate(HttpServletResponse resp, Map<String, Object> model, String template) throws IOException {
        model.put("topMenu", "connectors");
        model.put("menuItem", "editConnector");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("certTool", new CertTool());
        resp.setContentType("text/html");
        this.renderer.render(template, model, (Writer)resp.getWriter());
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ObjectTypeFilter objectTypeFilter;
        UserLookupTransform usernameTransformation;
        UserTypeSelectionFilter userTypeFilter;
        GroupFilter groupFilter;
        UserMembershipFilter userMembershipFilter;
        Set<String> remoteAddresses;
        String password;
        String kind;
        String id;
        MultipartHttpRequest mreq;
        Map<String, Object> model = this.newModel(req);
        long maxSize = 10000000L;
        try {
            mreq = this.hostApp.getMultipartRequest(req, maxSize);
        }
        catch (IOException e) {
            model.put("uploadException", e);
            model.put("maxSize", maxSize / 1000L);
            this.renderTemplate(resp, model, "templates/atlaskerb/connector/upload-error.vm");
            return;
        }
        ConnectorType connectorType = this.connectorConfManager.getConnectorTypes().get(mreq.getParameter("kind"));
        String connectorId = mreq.getParameter("connectorId");
        Directory existingConnector = null;
        if (StringUtils.isNotBlank(connectorId)) {
            existingConnector = this.connectorConfManager.getDirectory(connectorId);
            model.put("connectorId", existingConnector.getId());
            model.put("currentConnector", existingConnector);
        }
        if (existingConnector != null) {
            id = existingConnector.getId();
            kind = existingConnector.getKind();
            password = existingConnector.getPassword();
            remoteAddresses = existingConnector.getRemoteAddresses();
            userMembershipFilter = existingConnector.getUserMembershipFilter();
            groupFilter = existingConnector.getGroupFilter();
            userTypeFilter = existingConnector.getUserTypeSelectionFilter();
            usernameTransformation = existingConnector.getUsernameTransformation();
            objectTypeFilter = existingConnector.getObjectTypeFilter();
        } else {
            id = this.connectorConfManager.nextId();
            kind = connectorType.getKey();
            password = connectorType.getKey();
            remoteAddresses = Collections.singleton("127.0.0.1");
            userMembershipFilter = UserMembershipFilter.ALL;
            groupFilter = GroupFilter.ALL;
            userTypeFilter = new UserTypeSelectionFilter(UserTypeSelectionFilter.SelectionMode.MEMBERS_ONLY);
            usernameTransformation = UserLookupTransform.NONE;
            objectTypeFilter = ObjectTypeFilter.USERS_GROUPS_MEMBERSHIPS;
        }
        Directory.Common common = new Directory.Common(id, kind, password, remoteAddresses, userMembershipFilter, groupFilter, userTypeFilter, objectTypeFilter, usernameTransformation);
        Directory dir = connectorType.processEditDirectoryPost(mreq, model, existingConnector, common);
        if (dir != null) {
            this.connectorConfManager.saveOrEdit(dir);
            resp.sendRedirect("connector/" + dir.getId());
        } else {
            this.renderPage(connectorType, resp, model);
        }
    }
}

