/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.admin;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.hostapp.HostApp;

@Scanned
public class DirectoryGroupsAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;
    private final TemplateRenderer renderer;
    private final HostApp hostApp;

    @Inject
    public DirectoryGroupsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        String id = req.getParameter("id");
        String filter = req.getParameter("filter");
        Directory dir = this.connectorConfManager.getDirectory(id);
        if (dir == null) {
            resp.sendError(404);
            return;
        }
        int startIndex = 0;
        if (req.getParameter("start-index") != null) {
            startIndex = Integer.parseInt(req.getParameter("start-index"));
        }
        model.put("currentConnector", dir);
        model.put("topMenu", "connectors");
        model.put("menuItem", "directoryGroups");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("connectorType", this.connectorConfManager.getConnectorTypes().get(dir.getKind()));
        model.put("groupFilter", filter);
        Object filterRestriction = filter == null || filter.trim().isEmpty() ? NullRestrictionImpl.INSTANCE : new TermRestriction(GroupTermKeys.NAME, MatchMode.CONTAINS, (Object)filter);
        this.render(dir, resp, model, (SearchRestriction)filterRestriction, startIndex);
    }

    private void render(Directory dir, HttpServletResponse resp, Map<String, Object> model, SearchRestriction restriction, int startIndex) throws IOException {
        try {
            boolean isFirst;
            com.atlassian.crowd.embedded.api.Directory cd = new CrowdDirectoryFinder(this.hostApp).findDirectory(dir.getId());
            DirectoryManager directoryManager = this.hostApp.getDirectoryManager();
            int maxResults = 50;
            EntityQuery groupQuery = QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).with(restriction).startingAt(startIndex).returningAtMost(maxResults);
            List groups2 = directoryManager.searchGroups(cd.getId().longValue(), groupQuery);
            model.put("directoryGroups", groups2);
            model.put("firstIndex", startIndex + 1);
            model.put("lastIndex", startIndex + groups2.size());
            boolean isMore = maxResults == groups2.size();
            boolean bl = isFirst = startIndex == 0;
            if (isMore) {
                model.put("nextIndex", startIndex + groups2.size());
            }
            if (!isFirst) {
                model.put("prevIndex", startIndex - maxResults);
            }
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            this.renderer.render("templates/atlaskerb/connector/groups.vm", model, (Writer)resp.getWriter());
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }
}

