/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.azure.AzureAdConnectorType;
import org.kantega.atlaskerb.connector.gsuite.GSuiteConnectorType;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.model.ObjectTypeFilter;
import org.kantega.atlaskerb.connector.model.SecurityGroupFilter;
import org.kantega.atlaskerb.connector.model.UserLookupTransform;
import org.kantega.atlaskerb.connector.model.filters.ConnectorFilter;
import org.kantega.atlaskerb.connector.model.filters.GroupFilter;
import org.kantega.atlaskerb.connector.model.filters.UserMembershipFilter;
import org.kantega.atlaskerb.connector.model.filters.UserTypeSelectionFilter;
import org.kantega.atlaskerb.connector.okta.OktaConnectorType;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Component
public class ConnectorConfManager
implements DebugInfo {
    private static final String CONNECTOR_ELEM = "connector";
    private static final String FILTERS_ELEM = "filters";
    private static final String OBJECT_TYPE_FILTER_ELEM = "objectTypeFilter";
    private static final String GROUP_FILTER_ELEM = "groupFilter";
    private static final String GROUP_MEMBERSHIP_FILTER_ELEM = "groupMembershipFilter";
    private static final String USERTYPE_FILTER_ELEM = "userTypeFilter";
    private static final String KIND_ATTR = "kind";
    private static final String PASSWORD_ATTR = "password";
    private static final String USERNAME_TRANSFORMATION = "usernameTransformation";
    private static final String SECURITY_GROUPS_ELEM = "securityGroupFilter";
    private static final String SECURITY_GROUPS_FILTER = "securityGroupFilter";
    private static final String REMOTE_ADDRESSES = "remoteAddresses";
    private static final String GROUP_FILTER_MODE = "groupFilterMode";
    private static final String GROUP_FILTER_INCLUDE_SET = "groupFilterIncludeSet";
    private static final String GROUP_FILTER_EXCLUDE_SET = "groupFilterExcludeSet";
    private static final String GROUP_MEMBERSHIP_FILTER_MODE = "groupMembershipFilterMode";
    private static final String GROUP_MEMBERSHIP_FILTER_INCLUDE_SET = "groupMembershipFilterIncludeSet";
    private static final String GROUP_MEMBERSHIP_FILTER_EXCLUDE_SET = "groupMembershipFilterExcludeSet";
    private static final String USER_TYPE_FILTER = "userTypeFilter";
    private static final String OBJECT_TYPE_FILTER = "objectTypeFilter";
    private final Map<String, ConnectorType> connectors;
    private final PluginSettings settings;
    private final HostApp hostApp;
    private SecureRandom secureRandom = new SecureRandom();
    private AtomicReference<DirectoryConfigState> state = new AtomicReference();
    private static final Logger log = LoggerFactory.getLogger(IdpConfManager.class);

    @Inject
    public ConnectorConfManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, HostAppFactory hostAppFactory) {
        this.connectors = new LinkedHashMap<String, ConnectorType>();
        List<ConnectorType> connectorTypes = Arrays.asList(new AzureAdConnectorType(this), new GSuiteConnectorType(this), new OktaConnectorType(this));
        for (ConnectorType connectorType : connectorTypes) {
            this.connectors.put(connectorType.getKey(), connectorType);
        }
        this.settings = pluginSettingsFactory.createGlobalSettings();
        this.hostApp = hostAppFactory.getInstance();
        this.readState();
    }

    public Map<String, String> getSettings() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (KEYS keys2 : KEYS.values()) {
            Object value = this.settings.get(keys2.key);
            if (!(value instanceof String)) continue;
            result.put(keys2.key, (String)value);
        }
        return result;
    }

    public void restoreSettings(Properties props) {
        for (KEYS keys2 : KEYS.values()) {
            this.settings.remove(keys2.key);
        }
        for (KEYS keys2 : KEYS.values()) {
            String value = props.getProperty(keys2.key);
            if (value == null) continue;
            this.settings.put(keys2.key, (Object)value);
        }
        this.updateStateId();
        this.currentState();
    }

    public List<Directory> getDirectories() {
        return new ArrayList<Directory>(this.currentState().getDirectories());
    }

    public Directory saveOrEdit(Directory directory) {
        this.persistDirectory(directory);
        return directory;
    }

    private File getConfigHomeDir() {
        return new File(this.hostApp.getHomeDirectory(), "user-connectors");
    }

    public File getConnectorConfigDir(String id) {
        return new File(this.getConfigHomeDir(), id);
    }

    private void persistDirectory(Directory directory) {
        File xmlFile = this.getConnectorXmlFile(this.getConnectorConfigDir(directory.getId()));
        xmlFile.getParentFile().mkdirs();
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element provider = document.createElement(CONNECTOR_ELEM);
            provider.setAttribute(KIND_ATTR, directory.getKind());
            provider.setAttribute(PASSWORD_ATTR, directory.getPassword());
            provider.setAttribute(REMOTE_ADDRESSES, this.commaSeparated(directory.getRemoteAddresses()));
            provider.setAttribute(USERNAME_TRANSFORMATION, directory.getUsernameTransformation().name());
            Element filters = document.createElement(FILTERS_ELEM);
            Element objectTypeFilter = document.createElement("objectTypeFilter");
            objectTypeFilter.setAttribute("objectTypeFilter", directory.getObjectTypeFilter().name());
            filters.appendChild(objectTypeFilter);
            Element groupFilter = document.createElement(GROUP_FILTER_ELEM);
            groupFilter.setAttribute(GROUP_FILTER_MODE, directory.getUserMembershipFilter().getMode().name());
            groupFilter.setAttribute(GROUP_FILTER_INCLUDE_SET, this.commaSeparated(directory.getUserMembershipFilter().getIncludedGroups()));
            groupFilter.setAttribute(GROUP_FILTER_EXCLUDE_SET, this.commaSeparated(directory.getUserMembershipFilter().getExcludedGroups()));
            filters.appendChild(groupFilter);
            Element groupMembershipFilter = document.createElement(GROUP_MEMBERSHIP_FILTER_ELEM);
            if (directory.getGroupFilter() != null) {
                groupMembershipFilter.setAttribute(GROUP_MEMBERSHIP_FILTER_MODE, directory.getGroupFilter().getMode().name());
                groupMembershipFilter.setAttribute(GROUP_MEMBERSHIP_FILTER_INCLUDE_SET, this.commaSeparated(directory.getGroupFilter().getIncludedGroups()));
                groupMembershipFilter.setAttribute(GROUP_MEMBERSHIP_FILTER_EXCLUDE_SET, this.commaSeparated(directory.getGroupFilter().getExcludedGroups()));
                filters.appendChild(groupMembershipFilter);
            }
            if (directory.getSecurityGroupFilter() != null) {
                Element securityGroupFilter = document.createElement("securityGroupFilter");
                securityGroupFilter.setAttribute("securityGroupFilter", directory.getSecurityGroupFilter().name());
                filters.appendChild(securityGroupFilter);
            }
            Element userTypeFilter = document.createElement("userTypeFilter");
            userTypeFilter.setAttribute("userTypeFilter", directory.getUserTypeSelectionFilter().getMode().name());
            filters.appendChild(userTypeFilter);
            provider.appendChild(filters);
            this.getConnectorTypes().get(directory.getKind()).persist(directory, provider);
            document.appendChild(provider);
            this.persistDirectoryDocument(xmlFile, document);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void persistDirectoryDocument(File providerXml, Document document) {
        try {
            File tempFile = new File(providerXml.getParentFile(), "_" + providerXml.getName());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(tempFile);
                transformer.transform(new DOMSource(document), new StreamResult(out));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.renameFile(tempFile, providerXml);
            this.updateStateId();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private void renameFile(File sourceFile, File destFile) {
        try {
            Files.move(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getConnectorXmlFile(File connectorDirectory) {
        return new File(connectorDirectory, "connector.xml");
    }

    public String nextId() {
        return Long.toString(Math.abs(this.secureRandom.nextLong()), 36);
    }

    public String randomPassword() {
        return this.nextId();
    }

    public Directory getDirectory(String id) {
        for (Directory directory : this.currentState().getDirectories()) {
            if (!id.equals(directory.getId())) continue;
            return directory;
        }
        log.debug("No Connector with id '{}'", (Object)id);
        return null;
    }

    public Map<String, ConnectorType> getConnectorTypes() {
        return this.connectors;
    }

    public void readState() {
        this.state.set(this.readState(this.currentStateId()));
    }

    private void updateStateId() {
        String nextId = UUID.randomUUID().toString();
        this.settings.put(KEYS.DIRECTORY_STATE_ID.key, (Object)nextId);
    }

    private DirectoryConfigState readState(String stateId) {
        return new DirectoryConfigState(stateId, new ArrayList<Directory>(this.readDirectories()));
    }

    private List<Directory> readDirectories() {
        File providersDir = this.getConfigHomeDir();
        if (!providersDir.exists()) {
            return Collections.emptyList();
        }
        File[] providerDirs = providersDir.listFiles(file -> file.isDirectory() && this.getConnectorXmlFile(this.getConnectorConfigDir(file.getName())).exists());
        if (providerDirs == null) {
            return Collections.emptyList();
        }
        ArrayList<Directory> configurations = new ArrayList<Directory>();
        for (File connectorDirectory : providerDirs) {
            File providerXmlFile = this.getConnectorXmlFile(connectorDirectory);
            try {
                Directory directory = this.parseDirectory(providerXmlFile);
                configurations.add(directory);
            }
            catch (Exception e) {
                log.error("Exception parsing provider xml file: " + providerXmlFile.getAbsolutePath(), (Throwable)e);
            }
        }
        Collections.sort(configurations, new Comparator<Directory>(){

            @Override
            public int compare(Directory o1, Directory o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return configurations;
    }

    private Directory parseDirectory(File providerXmlFile) throws XPathExpressionException {
        Document doc = this.parseDirectoryDocument(providerXmlFile);
        Element connectorElement = doc.getDocumentElement();
        String kind = connectorElement.getAttribute(KIND_ATTR);
        String password = connectorElement.getAttribute(PASSWORD_ATTR);
        SortedSet<String> remoteAddresses = this.getSetFromAttribute(connectorElement, REMOTE_ADDRESSES);
        String usernameTransformationStr = connectorElement.getAttribute(USERNAME_TRANSFORMATION);
        UserLookupTransform usernameTransformation = UserLookupTransform.NONE;
        if (!StringUtils.isBlank(usernameTransformationStr)) {
            usernameTransformation = UserLookupTransform.valueOf(usernameTransformationStr);
        }
        ObjectTypeFilter objectTypeFilter = null;
        ConnectorFilter userMembershipFilter = null;
        GroupFilter groupFilter = null;
        UserTypeSelectionFilter userTypeFilter = null;
        SecurityGroupFilter securityGroupFilter = SecurityGroupFilter.SECURITY_GROUPS_ONLY;
        for (int i = 0; i < connectorElement.getChildNodes().getLength(); ++i) {
            Node n = connectorElement.getChildNodes().item(i);
            if (!StringUtils.equals(n.getNodeName(), FILTERS_ELEM)) continue;
            for (int j = 0; j < n.getChildNodes().getLength(); ++j) {
                Set excludeSet;
                Set includeSet;
                String excludeSetStr;
                String includeSetStr;
                String mode;
                Node filter = n.getChildNodes().item(j);
                if (StringUtils.equals(filter.getNodeName(), "objectTypeFilter")) {
                    objectTypeFilter = ObjectTypeFilter.valueOf(filter.getAttributes().getNamedItem("objectTypeFilter").getTextContent());
                    continue;
                }
                if (StringUtils.equals(filter.getNodeName(), GROUP_FILTER_ELEM)) {
                    mode = filter.getAttributes().getNamedItem(GROUP_FILTER_MODE).getTextContent();
                    includeSetStr = filter.getAttributes().getNamedItem(GROUP_FILTER_INCLUDE_SET).getTextContent();
                    excludeSetStr = filter.getAttributes().getNamedItem(GROUP_FILTER_EXCLUDE_SET).getTextContent();
                    includeSet = Arrays.stream(StringUtils.split(includeSetStr, ",")).collect(Collectors.toCollection(LinkedHashSet::new));
                    excludeSet = Arrays.stream(StringUtils.split(excludeSetStr, ",")).collect(Collectors.toCollection(LinkedHashSet::new));
                    ConnectorFilter.SelectionMode selectionMode = ConnectorFilter.SelectionMode.ofString(mode);
                    userMembershipFilter = new UserMembershipFilter(selectionMode, includeSet, excludeSet);
                    continue;
                }
                if (StringUtils.equals(filter.getNodeName(), GROUP_MEMBERSHIP_FILTER_ELEM)) {
                    mode = filter.getAttributes().getNamedItem(GROUP_MEMBERSHIP_FILTER_MODE).getTextContent();
                    includeSetStr = filter.getAttributes().getNamedItem(GROUP_MEMBERSHIP_FILTER_INCLUDE_SET).getTextContent();
                    excludeSetStr = filter.getAttributes().getNamedItem(GROUP_MEMBERSHIP_FILTER_EXCLUDE_SET).getTextContent();
                    includeSet = Arrays.stream(StringUtils.split(includeSetStr, ",")).collect(Collectors.toCollection(LinkedHashSet::new));
                    excludeSet = Arrays.stream(StringUtils.split(excludeSetStr, ",")).collect(Collectors.toCollection(LinkedHashSet::new));
                    groupFilter = new GroupFilter(ConnectorFilter.SelectionMode.ofString(mode), includeSet, excludeSet);
                    continue;
                }
                if (StringUtils.equals(filter.getNodeName(), "userTypeFilter")) {
                    mode = filter.getAttributes().getNamedItem("userTypeFilter").getTextContent();
                    userTypeFilter = new UserTypeSelectionFilter(UserTypeSelectionFilter.SelectionMode.valueOf(mode));
                    continue;
                }
                if (!StringUtils.equals(filter.getNodeName(), "securityGroupFilter")) continue;
                String securityGroupFilterStr = filter.getAttributes().getNamedItem("securityGroupFilter").getTextContent();
                securityGroupFilter = SecurityGroupFilter.valueOf(securityGroupFilterStr);
            }
        }
        if (userMembershipFilter == null) {
            userMembershipFilter = new UserMembershipFilter(ConnectorFilter.SelectionMode.ALL, Collections.emptySet(), Collections.emptySet());
        }
        if (groupFilter == null) {
            groupFilter = userMembershipFilter.getMode() == ConnectorFilter.SelectionMode.INCLUDE_SUBSET || userMembershipFilter.getMode() == ConnectorFilter.SelectionMode.EXCLUDE_SUBSET ? new GroupFilter(userMembershipFilter.getMode(), userMembershipFilter.getIncludedGroups(), userMembershipFilter.getExcludedGroups()) : GroupFilter.ALL;
        }
        if (userTypeFilter == null) {
            userTypeFilter = new UserTypeSelectionFilter(UserTypeSelectionFilter.SelectionMode.ALL);
        }
        String id = providerXmlFile.getParentFile().getName();
        Directory.Common common = new Directory.Common(id, kind, password, remoteAddresses, (UserMembershipFilter)userMembershipFilter, groupFilter, userTypeFilter, objectTypeFilter, usernameTransformation);
        Directory dir = this.getConnectorTypes().get(kind).parse(connectorElement, common);
        dir.setSecurityGroupFilter(securityGroupFilter);
        return dir;
    }

    private Document parseDirectoryDocument(File directoryFile) {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(directoryFile);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private String currentStateId() {
        return (String)this.settings.get(KEYS.DIRECTORY_STATE_ID.key);
    }

    DirectoryConfigState currentState() {
        String currentStateId;
        DirectoryConfigState cachedState = this.state.get();
        if (!cachedState.isCurrent(currentStateId = this.currentStateId())) {
            DirectoryConfigState nextState = this.readState(currentStateId);
            if (this.state.compareAndSet(cachedState, nextState)) {
                return nextState;
            }
            return this.state.get();
        }
        return cachedState;
    }

    public void deleteConnector(String deleteConnector) {
        File connectorDirectory = this.getConnectorConfigDir(deleteConnector);
        try {
            FileUtils.deleteDirectory((File)connectorDirectory);
            this.updateStateId();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addRemoteAddress(String id, String newAddress) {
        if (!StringUtils.isBlank(newAddress)) {
            this.addSetMembers(id, Collections.singletonList(newAddress.trim()), REMOTE_ADDRESSES);
        }
    }

    public void removeRemoteAddress(String id, String removeAddress) {
        if (!StringUtils.isBlank(removeAddress)) {
            this.removeSetMembers(id, Collections.singletonList(removeAddress.trim()), REMOTE_ADDRESSES);
        }
    }

    public SortedSet<String> getSetMembers(String id, String attributeName) {
        File connectorXmlFile = this.getConnectorXmlFile(this.getConnectorConfigDir(id));
        Document document = this.parseDirectoryDocument(connectorXmlFile);
        Element elem = document.getDocumentElement();
        return this.getSetFromAttribute(elem, attributeName);
    }

    void addSetMembers(String id, List<String> newValues, String attributeName) {
        File connectorXmlFile = this.getConnectorXmlFile(this.getConnectorConfigDir(id));
        Document document = this.parseDirectoryDocument(connectorXmlFile);
        Element elem = document.getDocumentElement();
        SortedSet<String> values2 = this.getSetFromAttribute(elem, attributeName);
        values2.addAll(newValues);
        elem.setAttribute(attributeName, this.commaSeparated(values2));
        this.persistDirectoryDocument(connectorXmlFile, document);
    }

    void removeSetMembers(String id, List<String> removeValues, String attributeName) {
        File connectorXmlFile = this.getConnectorXmlFile(this.getConnectorConfigDir(id));
        Document document = this.parseDirectoryDocument(connectorXmlFile);
        Element elem = document.getDocumentElement();
        SortedSet<String> addresses = this.getSetFromAttribute(elem, attributeName);
        addresses.removeAll(removeValues);
        elem.setAttribute(attributeName, this.commaSeparated(addresses));
        this.persistDirectoryDocument(connectorXmlFile, document);
    }

    void removeAllSetMembers(String id, String attributeName) {
        File connectorXmlFile = this.getConnectorXmlFile(this.getConnectorConfigDir(id));
        Document document = this.parseDirectoryDocument(connectorXmlFile);
        Element elem = document.getDocumentElement();
        elem.removeAttribute(attributeName);
        this.persistDirectoryDocument(connectorXmlFile, document);
    }

    @NotNull
    SortedSet<String> getSetFromAttribute(Element elem, String attributeName) {
        TreeSet<String> addresses = new TreeSet<String>();
        for (String address : elem.getAttribute(attributeName).split(",")) {
            if (address.trim().isEmpty()) continue;
            addresses.add(address.trim());
        }
        return addresses;
    }

    private String commaSeparated(Set<String> addresses) {
        StringBuilder sb = new StringBuilder();
        for (String address : addresses) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(address);
        }
        return sb.toString();
    }

    public ConnectorType findMatchingConnectorType(IdpConfiguration.Kind kind) {
        for (ConnectorType connectorType : this.getConnectorTypes().values()) {
            if (connectorType.getIdentityProviderKind() != kind) continue;
            return connectorType;
        }
        return null;
    }

    public List<Directory> findMatchingConnectors(IdpConfiguration.Kind kind) {
        ArrayList<Directory> matches = new ArrayList<Directory>();
        for (Directory directory : this.getDirectories()) {
            if (this.getConnectorTypes().get(directory.getKind()).getIdentityProviderKind() != kind) continue;
            matches.add(directory);
        }
        return matches;
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        json.put("settings", this.getSettings());
        return json;
    }

    private class DirectoryConfigState {
        private String stateId;
        private Collection<Directory> directories;

        public DirectoryConfigState(String stateId, Collection<Directory> directories) {
            this.stateId = stateId;
            this.directories = directories;
        }

        public Collection<Directory> getDirectories() {
            return this.directories;
        }

        public boolean isCurrent(String stateId) {
            if (stateId == null) {
                return this.stateId == null;
            }
            return stateId.equals(this.stateId);
        }
    }

    private static enum KEYS {
        DIRECTORY_STATE_ID("no.kantega.directoryStateId");

        private final String key;

        private KEYS(String key) {
            this.key = key;
        }
    }
}

