/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.apitokens.ApiTokenObject;
import org.kantega.atlaskerb.apitokens.ApiTokenService;

public class ApiTokenUtil {

    public static class Validation {
        public static final String TOKEN_PREFIX = "API_TOKEN_";

        public static Try<Long> tryParseTokenTimeLimit(String tokenTimeLimit) {
            return Try.of(() -> Long.parseLong(tokenTimeLimit));
        }

        public static boolean isValidDuration(long duration) {
            return DatePair.durationOptionsDays.stream().anyMatch(d -> ((DatePair)d).duration == duration);
        }

        public static boolean validTokenTimeLimit(String tokenTimeLimit) {
            return Validation.tryParseTokenTimeLimit(tokenTimeLimit).mapTry(Validation::isValidDuration).getOrElse(false);
        }

        public static boolean isValidDurationRestricted(long duration, long maximumDurationRestriction) {
            return Validation.isValidDuration(duration) && (duration <= maximumDurationRestriction || maximumDurationRestriction == -1L);
        }

        public static String removePrefixFromApiToken(String token) {
            if (Validation.apiTokenHasPrefix(token)) {
                return token.substring(TOKEN_PREFIX.length());
            }
            return token;
        }

        public static boolean apiTokenHasPrefix(String apiToken) {
            return Option.of(apiToken).filter(token -> token.length() > TOKEN_PREFIX.length()).map(token -> token.substring(0, TOKEN_PREFIX.length())).map(prefixFromToken -> prefixFromToken.equals(TOKEN_PREFIX)).getOrElse(false);
        }
    }

    public static enum TokenUserPermission {
        NO_USERS,
        ALL_USERS,
        USER_GROUPS;

    }

    public static class DatePair {
        private final Long duration;
        private final String englishDuration;
        static final long day = 86400000L;
        static final List<DatePair> durationOptionsDays = Arrays.asList(new DatePair(2592000000L, "30 Days"), new DatePair(7776000000L, "90 Days"), new DatePair(15552000000L, "180 Days"), new DatePair(31104000000L, "360 Days"), new DatePair(-1L, "Forever"));

        private DatePair(Long duration, String englishDuration) {
            this.duration = duration;
            this.englishDuration = englishDuration;
        }

        public Long getDuration() {
            return this.duration;
        }

        public Long getDurationAsDays() {
            if (this.duration == -1L) {
                return this.duration;
            }
            return this.duration / 86400000L;
        }

        public String getEnglishDuration() {
            return this.englishDuration;
        }

        public static List<DatePair> getDurationOptionsRestricted(long maximumDurationRestriction) {
            if (maximumDurationRestriction == -1L) {
                return durationOptionsDays;
            }
            return durationOptionsDays.stream().filter(d -> d.duration != -1L).filter(d -> d.duration <= maximumDurationRestriction).collect(Collectors.toList());
        }

        public static List<DatePair> getDurationOptions() {
            return durationOptionsDays;
        }
    }

    public static class ApiTokenRepresentation {
        private final int id;
        private final String alias;
        private final String username;
        private final long createdAt;
        private final long validFor;
        private final boolean active;

        public ApiTokenRepresentation(ApiTokenObject t, UserManager userManager, KerbConfManager kerbConfManager, ApiTokenService apiTokenService) {
            this.id = t.getID();
            this.alias = t.getAlias();
            this.validFor = t.getValidFor();
            this.createdAt = t.getCreatedAt();
            Try<String> maybeUserKey = Try.of(t::getUserKey);
            this.username = maybeUserKey.mapTry(UserKey::new).mapTry(arg_0 -> ((UserManager)userManager).getUserProfile(arg_0)).mapTry(UserProfile::getUsername).getOrElse("N/A");
            boolean isSystemAdmin = maybeUserKey.mapTry(UserKey::new).mapTry(arg_0 -> ((UserManager)userManager).isSystemAdmin(arg_0)).getOrElse(false);
            boolean isInAllowedGroups = apiTokenService.isApiTokenUserInAllowedGroups(this.username);
            TokenUserPermission permission = kerbConfManager.getApiTokenUserPermission();
            this.active = permission == TokenUserPermission.ALL_USERS || permission == TokenUserPermission.USER_GROUPS && isInAllowedGroups || isSystemAdmin;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getExpiryDate(String dateformat) {
            if (this.validFor < 0L) {
                return "Never";
            }
            return new SimpleDateFormat(dateformat).format(new Date(this.createdAt + this.validFor));
        }

        public boolean isExpired() {
            return this.validFor > 0L && System.currentTimeMillis() > this.createdAt + this.validFor;
        }

        public int getId() {
            return this.id;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getUsername() {
            return this.username;
        }

        public long getValidFor() {
            return this.validFor;
        }
    }
}

