/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.Tuple2;
import io.vavr.collection.LinearSeq;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import net.java.ao.ActiveObjectsException;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apitokens.ApiToken;
import org.kantega.atlaskerb.apitokens.ApiTokenObject;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiTokenServiceImpl
implements ApiTokenService {
    private static final String AUTHORIZED_API_TOKEN_PROFILE = "authorized_api_token_profile";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final ActiveObjects ao;
    private final SecureRandom secureRandom;
    private final UserManager userManager;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final TransactionTemplate transactionTemplate;

    @Inject
    public ApiTokenServiceImpl(RequireAdminServletDependencyBucket bucket) {
        this.ao = bucket.getActiveObjects();
        this.userManager = bucket.getUserManager();
        this.secureRandom = new SecureRandom();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.transactionTemplate = bucket.getTransactionTemplate();
    }

    @Override
    public String addToken(String userKey, String alias, long validFor) {
        return this.addToken(userKey, alias, validFor, null, null);
    }

    private String addToken(String userKey, String alias, long validFor, byte[] salt, byte[] hashedSecret) {
        int entropyFactor = 16;
        int bitsOfEntropyInSecret = 40 * entropyFactor;
        int bytesOfEntropy = bitsOfEntropyInSecret / 8;
        String secret = BaseEncoding.base32().encode(this.generateSecret(bytesOfEntropy));
        if (salt == null || hashedSecret == null) {
            salt = this.generateSecret(16);
            hashedSecret = this.hash(secret, salt);
        }
        String saltBase64 = Base64.getEncoder().encodeToString(salt);
        String hashedSecretBase64 = Base64.getEncoder().encodeToString(hashedSecret);
        ApiTokenObject apiTokenObject = (ApiTokenObject)this.ao.create(ApiTokenObject.class, new DBParam[0]);
        apiTokenObject.setAlias(alias);
        apiTokenObject.setUserKey(userKey);
        apiTokenObject.setCreatedAt(System.currentTimeMillis());
        apiTokenObject.setValidFor(validFor);
        apiTokenObject.setHashed(hashedSecretBase64);
        apiTokenObject.setSalt(saltBase64);
        apiTokenObject.save();
        return secret;
    }

    @Override
    public List<ApiTokenObject> findAllTokens() {
        this.convertOldTokens();
        return Lists.newArrayList((Object[])this.ao.find(ApiTokenObject.class, Query.select().order("ALIAS ASC")));
    }

    private void convertOldTokens() {
        if (this.kerbConfManager.isKssoVersionChangedBreakingApiTokens()) {
            try {
                ArrayList listOfOld = Lists.newArrayList((Object[])this.ao.find(ApiToken.class, Query.select().order("ALIAS ASC")));
                if (listOfOld.size() > 0) {
                    this.log.info("Upgrading {} tokens to new format.", (Object)listOfOld.size());
                }
                for (ApiToken old : listOfOld) {
                    this.addToken(old.getUserKey(), old.getAlias(), old.getValidFor(), old.getSalt(), old.getHashed());
                    this.ao.delete(new RawEntity[]{old});
                }
            }
            catch (ActiveObjectsException e) {
                this.log.warn("Unable to convert old API tokens: '" + (Object)((Object)e) + "'. This might be because there were no API tokens to convert in a certain version.");
            }
            catch (Exception e) {
                this.log.warn("Something went wrong while converting old API tokens: '" + e + "'");
            }
        }
    }

    @Override
    public List<ApiTokenObject> findTokensByUserKey(String userKey) {
        return (List)this.transactionTemplate.execute(() -> Try.of(() -> Lists.newArrayList((Object[])this.ao.find(ApiTokenObject.class, Query.select().where("USER_KEY = ?", new Object[]{userKey}).order("ALIAS DESC")))).getOrElse(new ArrayList()));
    }

    @Override
    @Nullable
    public ApiTokenObject findTokensByIdAndUserKey(String id, String userKey) {
        ApiTokenObject[] apiTokenObjects = Try.of(() -> (ApiTokenObject[])this.ao.find(ApiTokenObject.class, Query.select().where("ID = ? AND USER_KEY = ?", new Object[]{Integer.parseInt(id), userKey}).order("ALIAS DESC"))).getOrElse(new ApiTokenObject[0]);
        if (apiTokenObjects.length == 1) {
            return apiTokenObjects[0];
        }
        return null;
    }

    @Override
    @Nullable
    public ApiTokenObject findTokenById(String id) {
        ApiTokenObject[] apiTokenObjects = Try.of(() -> (ApiTokenObject[])this.ao.find(ApiTokenObject.class, Query.select().where("ID = ?", new Object[]{Integer.parseInt(id)}).order("ALIAS DESC"))).getOrElse(new ApiTokenObject[0]);
        if (apiTokenObjects.length == 1) {
            return apiTokenObjects[0];
        }
        return null;
    }

    @Override
    public void delete(ApiTokenObject token) {
        this.ao.delete(new RawEntity[]{token});
    }

    private boolean isInAllowedGroups(String username, List<String> allowedUserGroups) {
        if (username == null) {
            return false;
        }
        return allowedUserGroups.stream().anyMatch(g -> this.hostApp.isUserInGroup(username, (String)g));
    }

    @Override
    public Validation<String, UserProfile> verifyApiToken(HttpServletRequest request) {
        UserProfile userProfile = (UserProfile)request.getAttribute(AUTHORIZED_API_TOKEN_PROFILE);
        if (userProfile != null) {
            return Validation.valid(userProfile);
        }
        Option<Tuple2<String, String>> userNameAndToken = this.getUserNameAndToken(request);
        if (userNameAndToken.isDefined()) {
            String username = userNameAndToken.get()._1();
            String token = userNameAndToken.get()._2();
            if (username != null && token != null && (userProfile = this.userManager.getUserProfile(username)) != null && userProfile.getUserKey() != null) {
                boolean isTokenAuthorized;
                IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
                String ipAddress = this.kerbConfManager.getRemoteIpAddress(request);
                boolean requestHasValidIpAddress = ipRestrictionConfig.getApiTokenFilter().isRemoteAddressEnabled(ipAddress);
                boolean isUserInAllowedGroup = this.isApiTokenUserInAllowedGroups(username);
                boolean isValidApiToken = this.verifyApiToken(userProfile.getUserKey().getStringValue(), token);
                boolean bl = isTokenAuthorized = requestHasValidIpAddress && isUserInAllowedGroup && isValidApiToken;
                if (isTokenAuthorized) {
                    request.setAttribute(AUTHORIZED_API_TOKEN_PROFILE, (Object)userProfile);
                    return Validation.valid(userProfile);
                }
            }
        }
        return Validation.invalid("Invalid API token or basic auth with password");
    }

    @Override
    public boolean requestHasApiToken(HttpServletRequest request) {
        return this.getUserNameAndToken(request).map(usernameAndToken -> this.isApiToken((String)usernameAndToken._1(), (String)usernameAndToken._2())).getOrElse(false);
    }

    private boolean isApiToken(String maybeUsername, String maybeToken) {
        String token = Option.of(maybeToken).map(ApiTokenUtil.Validation::removePrefixFromApiToken).getOrElse("");
        return Try.of(() -> maybeUsername).mapTry(arg_0 -> ((UserManager)this.userManager).getUserProfile(arg_0)).mapTry(UserProfile::getUserKey).mapTry(UserKey::getStringValue).mapTry(this::findTokensByUserKey).mapTry(Collection::stream).mapTry(tokens -> tokens.anyMatch(t -> this.validateHash((ApiTokenObject)t, token))).getOrElse(false);
    }

    private Option<Tuple2<String, String>> getUserNameAndToken(HttpServletRequest request) {
        return HttpUrlUtils.credentialsWithBasicAuthSingleHeader(request);
    }

    @Override
    public boolean isApiTokenUserInAllowedGroups(String username) {
        ApiTokenUtil.TokenUserPermission tokenUserPermission = this.kerbConfManager.getApiTokenUserPermission();
        List<String> allowedUserGroups = this.kerbConfManager.getApiTokenAllowedUserGroups();
        Try<UserProfile> maybeUserProfile = Try.of(() -> this.userManager.getUserProfile(username));
        boolean isSystemAdmin = maybeUserProfile.mapTry(UserProfile::getUserKey).mapTry(arg_0 -> ((UserManager)this.userManager).isSystemAdmin(arg_0)).getOrElse(false);
        return tokenUserPermission == ApiTokenUtil.TokenUserPermission.ALL_USERS || tokenUserPermission == ApiTokenUtil.TokenUserPermission.USER_GROUPS && this.isInAllowedGroups(username, allowedUserGroups) || isSystemAdmin;
    }

    private boolean verifyApiToken(String userKey, String secret) {
        this.convertOldTokens();
        if (!StringUtils.isBlank(userKey) && !StringUtils.isBlank(secret)) {
            return this.findTokensByUserKey(userKey).stream().anyMatch(t -> !this.isExpired((ApiTokenObject)t) && this.validateHash((ApiTokenObject)t, secret));
        }
        return false;
    }

    @Override
    public Option<String> createAndPersistToken(HttpServletRequest req) {
        UserKey remoteUserKey = this.userManager.getRemoteUserKey(req);
        if (remoteUserKey != null && req.getParameterMap().containsKey("tokenName") && req.getParameterMap().containsKey("validFor")) {
            String userKey = remoteUserKey.getStringValue();
            String alias = req.getParameter("tokenName");
            Try maybeValidFor = ApiTokenUtil.Validation.tryParseTokenTimeLimit(req.getParameter("validFor")).toTry();
            if (maybeValidFor.isFailure()) {
                return Option.none();
            }
            boolean isSystemAdmin = this.userManager.isSystemAdmin(remoteUserKey);
            if (!isSystemAdmin ? !ApiTokenUtil.Validation.isValidDurationRestricted((Long)maybeValidFor.get(), this.kerbConfManager.getApiTokensUserMaxTimeRestriction()) : !ApiTokenUtil.Validation.isValidDuration((Long)maybeValidFor.get())) {
                return Option.none();
            }
            return Option.of(this.addToken(userKey, alias, (Long)maybeValidFor.get()));
        }
        return Option.none();
    }

    private byte[] hash(String secret, byte[] salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(salt);
            md.update(secret.getBytes(StandardCharsets.UTF_8));
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not create hash for token secret");
        }
    }

    private byte[] generateSecret(int bytes) {
        byte[] randomBytes = new byte[bytes];
        this.secureRandom.nextBytes(randomBytes);
        return randomBytes;
    }

    private boolean isExpired(ApiTokenObject token) {
        return token.getValidFor() > 0L && System.currentTimeMillis() > token.getCreatedAt() + token.getValidFor();
    }

    private boolean validateHash(ApiTokenObject savedToken, String tokenFromRequest) {
        if (savedToken == null || tokenFromRequest == null) {
            return false;
        }
        String tokenToValidate = ApiTokenUtil.Validation.removePrefixFromApiToken(tokenFromRequest);
        byte[] savedHash = Base64.getDecoder().decode(savedToken.getHashed());
        byte[] reqHash = this.hash(tokenToValidate, Base64.getDecoder().decode(savedToken.getSalt()));
        return Arrays.equals(savedHash, reqHash);
    }

    @Override
    public String getAllTokensAsJson() {
        return Try.of(() -> {
            LinearSeq apiTokensInJson = io.vavr.collection.List.ofAll(this.findAllTokens()).map(token -> JsonMapping.Write.objectAsJson(token, ApiTokenObject.class).mapTry(JSONObject::toString).onFailure(throwable -> {
                throw new ErrorUtils.KssoException("Failed to write ApiTokenObject JSON", (Throwable)throwable);
            }).getOrElse(""));
            JSONObject allTokens = new JSONObject();
            allTokens.put("allTokens", apiTokensInJson.toJavaList());
            return allTokens.toString();
        }).onFailure(throwable -> this.log.error(ErrorUtils.createErrorMessage("KSSO-7NXXWSWKZ1", "Could not transform API tokens to JSON for backup: "), throwable)).getOrElse("");
    }

    @Override
    public void restoreTokens(Properties props) {
        try {
            String json = props.getProperty("apiTokens");
            List apiTokensFromJSON = JsonMapping.Write.stringAsJson(json).flatMapTry(JsonMapping.Read::mapFromJsonObject).mapTry(jsonMap -> jsonMap.get("allTokens")).mapTry(listOfTokens -> (ArrayList)listOfTokens).onFailure(e -> this.log.error(ErrorUtils.createErrorMessage("KSSO-BHEVRY1NP0", "Unable to restore API tokens from backup: "), e)).getOrElse(new ArrayList());
            this.restoreTokens(apiTokensFromJSON);
        }
        catch (Exception e2) {
            this.log.error(ErrorUtils.createErrorMessage("KSSO-BHEVRY1NP0", "Unable to restore API tokens from backup: "), (Throwable)e2);
        }
    }

    private void restoreTokens(List<String> restoredTokens) {
        List<ApiTokenObject> apiTokens = this.findAllTokens();
        ArrayList<Try<Void>> tryList = new ArrayList<Try<Void>>();
        for (String tokenJson : restoredTokens) {
            tryList.add(this.addTokenFromJson(tokenJson));
        }
        boolean someFailed = tryList.stream().map(Try::isFailure).reduce(true, (a, b) -> a != false || b != false);
        if (!someFailed) {
            this.deleteTokens(apiTokens);
        } else {
            this.log.error(ErrorUtils.createErrorMessage("KSSO-1ETXL3KHST", "Not deleting existing tokens since import of some tokens failed from backup."));
        }
    }

    private void deleteTokens(List<ApiTokenObject> apiTokens) {
        try {
            for (ApiTokenObject o : apiTokens) {
                this.delete(o);
            }
        }
        catch (Exception e) {
            this.log.error(ErrorUtils.createErrorMessage("KSSO-UE32MM7DYS", "Could not delete API tokens upon import from backup: "), (Throwable)e);
        }
    }

    private Try<Void> addTokenFromJson(String json) {
        return Try.run(() -> {
            ApiTokenObject apiTokenObject = (ApiTokenObject)this.ao.create(ApiTokenObject.class, new DBParam[0]);
            JsonMapping.Write.stringAsJson(json).flatMapTry(jsonObject -> JsonMapping.Read.populateInstanceFromJson(jsonObject, apiTokenObject, ApiTokenObject.class)).onFailure(throwable -> this.log.warn(ErrorUtils.createErrorMessage("KSSO-V99Q54K9LP", "Failed to restore data from JSON: "), throwable));
            apiTokenObject.save();
        }).onFailure(throwable -> this.log.warn(ErrorUtils.createErrorMessage("KSSO-ICMNAHI3W7", "Unable to restore token from backup: "), throwable));
    }
}

