/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apiserver;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.kantega.atlaskerb.apiserver.ApiServer;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiServerConfigJobRunner
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(ApiServerConfigJobRunner.class);
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(ApiServerConfigJobRunner.class + ".job"));
    private final ApiServerConfManager apiServerConfManager;
    private final ApiServer apiServer;

    @Inject
    public ApiServerConfigJobRunner(ApiServerConfManager apiServerConfManager, ApiServer apiServer) {
        this.apiServerConfManager = apiServerConfManager;
        this.apiServer = apiServer;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            this.apiServer.configChanged(this.apiServerConfManager.getConfig());
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            log.error("Exception updating API server state", (Throwable)e);
            return JobRunnerResponse.failed((String)("Exception updating API server state: " + e.getClass() + ": " + e.getMessage()));
        }
    }
}

