/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apiserver;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.inject.Inject;
import org.kantega.atlaskerb.apiserver.ApiServerConfigState;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiServerConfManager {
    private final PluginSettings settings;
    private final HostApp hostApp;

    @Inject
    public ApiServerConfManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, HostAppFactory hostAppFactory) {
        this.settings = pluginSettingsFactory.createGlobalSettings();
        this.hostApp = hostAppFactory.getInstance();
    }

    public ApiServerConfigState getConfig() {
        return new ApiServerConfigState((String)this.settings.get(KEYS.API_SERVER_STATE.key), this.isApiServerEnabled(), this.getApiServerListenAddress(), this.getApiServerPort());
    }

    boolean isApiServerEnabled() {
        return "true".equals(this.settings.get(KEYS.API_SERVER_ENABLED.key));
    }

    int getApiServerPort() {
        String port = (String)this.settings.get(KEYS.API_SERVER_PORT.key);
        return port == null ? this.hostApp.getDefaultApiServerPort() : Integer.parseInt(port);
    }

    String getApiServerListenAddress() {
        String address = (String)this.settings.get(KEYS.API_SERVER_ADDRESS.key);
        return address == null ? "0.0.0.0" : address;
    }

    public String getCrowdServerUrl() {
        return this.getServerUrl() + "/rest/";
    }

    public String getServerUrl() {
        String apiServerAddress = this.getApiServerListenAddress();
        if ("0.0.0.0".equals(apiServerAddress)) {
            apiServerAddress = "127.0.0.1";
        }
        return "http://" + apiServerAddress + ":" + this.getApiServerPort();
    }

    public ApiServerConfigState setApiServerConfig(boolean enabled, String address, int port) {
        this.settings.put(KEYS.API_SERVER_ENABLED.key, (Object)Boolean.toString(enabled));
        this.settings.put(KEYS.API_SERVER_PORT.key, (Object)Integer.toString(port));
        this.settings.put(KEYS.API_SERVER_ADDRESS.key, (Object)address);
        String stateId = UUID.randomUUID().toString();
        this.settings.put(KEYS.API_SERVER_STATE.key, (Object)stateId);
        return this.getConfig();
    }

    public void restoreSettings(Properties props) {
        List.of(KEYS.values()).forEach(key -> {
            String k = ((KEYS)key).key;
            this.settings.remove(k);
            Option.of(props.getProperty(k)).peek(value -> this.settings.put(k, value));
        });
    }

    public Map<String, String> getSettings() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (KEYS key : KEYS.values()) {
            Object value = this.settings.get(key.key);
            if (!(value instanceof String)) continue;
            result.put(key.key, (String)value);
        }
        return result;
    }

    private static enum KEYS {
        API_SERVER_ADDRESS("no.kantega.crowdApiServer.address"),
        API_SERVER_PORT("no.kantega.crowdApiServer.port"),
        API_SERVER_ENABLED("no.kantega.crowdApiServer.enabled"),
        API_SERVER_STATE("no.kantega.crowdApiServer.state");

        private final String key;

        private KEYS(String key) {
            this.key = key;
        }
    }
}

