/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserNameLookup {
    private static final Logger log = LoggerFactory.getLogger(UserNameLookup.class);
    private final Map<String, String> attributes;
    private final HostApp hostApp;

    public UserNameLookup(Map<String, String> attributes, HostApp hostApp) {
        this.attributes = attributes;
        this.hostApp = hostApp;
    }

    String lookupUserNameFromSamAccountNameAtRealm(String principalName) {
        String username = principalName.substring(0, principalName.lastIndexOf("@"));
        String realm = principalName.substring(principalName.lastIndexOf("@") + 1);
        return this.lookupUserName("samAccountName", username, realm);
    }

    String lookupUserNameFromUserPrincipalName(String value) {
        return this.lookupUserName("userPrincipalName", value, null);
    }

    public String lookupUserNameFromAttribute(String attributeName, String value) {
        return this.lookupUserName(attributeName, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String lookupUserName(String searchAttribute, String searchValue, String realm) {
        String ldapUrl = this.attributes.get("ldap.url");
        String ldapUserDn = this.attributes.get("ldap.userdn");
        String ldapPassword = this.hostApp.optionallyDecryptLdapPassword(this.attributes.get("ldap.password"));
        String ldapBaseDn = this.attributes.get("ldap.basedn");
        String ldapUserBaseDn = this.attributes.get("ldap.user.dn");
        String ldapUserNameAttribute = this.attributes.get("ldap.user.username");
        String ldapFollowReferral = this.attributes.get("ldap.referral");
        if (ldapUrl == null) return null;
        if (ldapUserDn == null) return null;
        if (ldapPassword == null) return null;
        if (ldapBaseDn == null) {
            return null;
        }
        String searchBase = ldapBaseDn;
        if (ldapUserBaseDn != null && !ldapUserBaseDn.trim().isEmpty()) {
            searchBase = ldapUserBaseDn + "," + ldapBaseDn;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.principal", ldapUserDn);
        env.put("java.naming.security.credentials", ldapPassword);
        if ("true".equals(ldapFollowReferral)) {
            env.put("java.naming.referral", "follow");
        }
        DirContext context = null;
        String logDetails = "searchAttribute='" + searchAttribute + "', searchValue='" + searchValue + "', domainDn='" + realm + "'";
        try {
            context = this.createContext(env);
            if (StringUtils.isNotBlank(realm) && !UserLookupService.isRealmMatchesLdapName(realm, ldapBaseDn, searchBase)) {
                log.debug("Skipping lookup for '{}': Doesn't match KrbTicket domain/dn '{}'", (Object)ldapBaseDn, (Object)realm);
                String string = null;
                return string;
            }
            SearchControls sc = new SearchControls();
            sc.setSearchScope(2);
            sc.setReturningAttributes(new String[]{searchAttribute, ldapUserNameAttribute});
            NamingEnumeration<SearchResult> answer = context.search(searchBase, "(" + searchAttribute + "=" + searchValue + ")", sc);
            while (answer.hasMoreElements()) {
                SearchResult next = answer.next();
                Attribute userNameAttr = next.getAttributes().get(ldapUserNameAttribute);
                if (userNameAttr == null || userNameAttr.size() <= 0) continue;
                String string = (String)userNameAttr.get(0);
                return string;
            }
            log.debug("No user found, using search params {}", (Object)logDetails);
            String string = null;
            return string;
        }
        catch (NamingException e) {
            log.warn("NamingException during user lookup, using search params {}", (Object)logDetails, (Object)e);
            String string = null;
            return string;
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    DirContext createContext(Hashtable<String, String> env) throws NamingException {
        return new InitialDirContext(env);
    }
}

