/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

@Scanned
public class UsageCountersAction
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final KerbConfManager kerbConfManager;

    @Inject
    public UsageCountersAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.kerbConfManager = bucket.getKerbConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("stats", this.kerbConfManager.getStats());
        model.put("applicationProperties", this.kerbConfManager.getApplicationProperties());
        model.put("manualLoginLogEnabled", this.kerbConfManager.isManualLoginLogEnabled());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/stats.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean manualLoginLog = StringUtils.equalsIgnoreCase("on", req.getParameter("manualLoginLog"));
        if (manualLoginLog) {
            this.kerbConfManager.setManualLoginLogEnabled(true);
        } else {
            this.kerbConfManager.setManualLoginLogEnabled(false);
        }
        resp.sendRedirect("counters");
    }
}

