/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.AtlDirectoryManager;
import org.kantega.atlaskerb.DomainDirectory;
import org.kantega.atlaskerb.ExceptionTool;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.Keytab;
import org.kantega.atlaskerb.LdapPrincipalSearcher;
import org.kantega.atlaskerb.LdapTestResult;
import org.kantega.atlaskerb.LdapTestTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.SetupAction;
import org.simplericity.serberuhs.keytab.KeytabInfo;
import org.simplericity.serberuhs.keytab.KeytabParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class TestLdapAction
extends RequireAdminServlet {
    private static final Logger log = LoggerFactory.getLogger(TestLdapAction.class);
    private final LdapPrincipalSearcher ldapPrincipalSearcher;
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final AtlDirectoryManager directoryManager;

    @Inject
    public TestLdapAction(RequireAdminServletDependencyBucket bucket, LdapPrincipalSearcher ldapPrincipalSearcher, AtlDirectoryManager directoryManager) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userManager = bucket.getUserManager();
        this.ldapPrincipalSearcher = ldapPrincipalSearcher;
        this.directoryManager = directoryManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        TestLdapAction.checkLdapSrv(model, this.getDomainFromKeytab());
        resp.setContentType("text/html");
        model.put("keytab", new Keytab(this.kerbConfManager.getKeytabInfos()));
        model.put("realms", this.getRealms());
        model.put("userDirectories", this.directoryManager.getActiveMsAdDirectories());
        model.put("followReferrals", false);
        this.renderer.render("templates/atlaskerb/ldaptestresult.vm", model, (Writer)resp.getWriter());
    }

    private String getDomainFromKeytab() {
        KeytabInfo keytabInfo = this.kerbConfManager.getKeytabInfos().get(0);
        String domain = keytabInfo.getRealm();
        while (domain.indexOf(".") != -1 && domain.indexOf(".", domain.indexOf(".") + 1) != -1) {
            domain = domain.substring(domain.indexOf(".") + 1);
        }
        return domain;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("userDirectories", this.directoryManager.getActiveMsAdDirectories());
        model.put("exceptionTool", new ExceptionTool());
        model.put("ldapResults", Boolean.TRUE);
        model.put("keytab", new Keytab(this.kerbConfManager.getKeytabInfos()));
        model.put("realms", this.getRealms());
        String host = null;
        try {
            host = new URI(req.getRequestURL().toString()).getHost();
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.ldapTest(model, req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/ldaptestresult.vm", model, (Writer)resp.getWriter());
    }

    private Set<String> getRealms() {
        LinkedHashSet<String> realms = new LinkedHashSet<String>();
        for (KeytabInfo keytabInfo : this.kerbConfManager.getKeytabInfos()) {
            realms.add(keytabInfo.getRealm());
        }
        return realms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ldapTest(Map<String, Object> model, HttpServletRequest req) {
        String ldapServerUrl = req.getParameter("ldapServerUrl");
        String ldapUsername = req.getParameter("ldapUsername");
        String ldapPassword = req.getParameter("ldapPassword");
        boolean followReferrals = req.getParameter("followReferrals") != null;
        String directory = req.getParameter("directory");
        model.put("tool", new LdapTestTool());
        model.put("directory", req.getParameter("directory"));
        model.put("ldapServerUrl", ldapServerUrl);
        model.put("ldapUsername", ldapUsername);
        model.put("followReferrals", followReferrals);
        if ("custom".equals(directory)) {
            if (ldapPassword == null || ldapPassword.isEmpty()) {
                model.put("passwordMissing", Boolean.TRUE);
                return;
            }
            if (ldapUsername == null || ldapUsername.isEmpty()) {
                model.put("usernameMissing", Boolean.TRUE);
                return;
            }
        }
        Keytab keytab = new Keytab(Collections.emptyList());
        Set<Integer> encTypesInKeytab = this.findKeytabEncTypes();
        model.put("keytabSupportedEncTypes", encTypesInKeytab);
        TreeMap<String, List<LdapTestResult>> results = new TreeMap<String, List<LdapTestResult>>();
        Hashtable<Object, Object> env = null;
        if (!"custom".equals(directory)) {
            for (DomainDirectory domainDirectory : this.directoryManager.getActiveMsAdDirectories()) {
                if (!domainDirectory.getDirectory().getId().toString().equals(directory)) continue;
                env = this.directoryManager.getEnvForDirectory(domainDirectory.getDirectory());
                model.put("ldapUsername", env != null ? env.get("java.naming.security.principal") : "<not found>");
                model.put("ldapServerUrl", env != null ? env.get("java.naming.provider.url") : "<not found>");
                break;
            }
        } else {
            env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", SetupAction.addLdapProtocol(ldapServerUrl));
            env.put("java.naming.security.principal", ldapUsername);
            env.put("java.naming.security.credentials", ldapPassword);
        }
        String ldapRealm = StringUtils.upperCase(StringUtils.substringAfter((String)env.get("java.naming.security.principal"), "@"));
        TreeSet<String> servicePrincipalNames = new TreeSet<String>();
        for (KeytabInfo keytabInfo : this.kerbConfManager.getKeytabInfos()) {
            if (!"HTTP".equals(keytabInfo.getServicePart().toUpperCase()) || keytabInfo.getHostPart() == null || !keytabInfo.getRealm().equals(ldapRealm)) continue;
            servicePrincipalNames.add(keytab.nameWithoutRealm(keytabInfo));
        }
        if (followReferrals) {
            env.put("java.naming.referral", "follow");
        }
        InitialDirContext context = null;
        try {
            context = new InitialDirContext(env);
            String defaultNamingContext = this.getDefaultNamingContext(context);
            List<LdapTestResult> readOnlyDomainControllers = this.ldapPrincipalSearcher.findReadOnlyDomainControllers(context, defaultNamingContext);
            this.findDomainFunctionality(model, context);
            this.findServiceUsers(model, servicePrincipalNames, results, context, defaultNamingContext, readOnlyDomainControllers);
            model.put("results", results);
        }
        catch (AuthenticationException e) {
            model.put("ldapAuthenticationFailed", true);
        }
        catch (CommunicationException e) {
            model.put("ldapCommunicationException", e);
        }
        catch (NamingException e) {
            model.put("namingException", e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void findDomainFunctionality(Map<String, Object> model, DirContext context) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(0);
        NamingEnumeration<SearchResult> search = context.search("", "(objectClass=*)", sc);
        if (search.hasMoreElements()) {
            SearchResult rootDse = search.next();
            Attributes attributes = rootDse.getAttributes();
            this.addAttr(model, attributes, "domainFunctionality");
            this.addAttr(model, attributes, "domainControllerFunctionality");
            this.addAttr(model, attributes, "forestFunctionality");
        }
    }

    private void addAttr(Map<String, Object> model, Attributes attributes, String attrName) throws NamingException {
        Attribute attr = attributes.get(attrName);
        if (attr != null) {
            String value = (String)attr.get();
            model.put(attrName, value);
        }
    }

    private void findServiceUsers(Map<String, Object> model, Set<String> servicePrincipalNames, Map<String, List<LdapTestResult>> results, DirContext context, String defaultNamingContext, List<LdapTestResult> readOnlyDomainControllers) throws NamingException {
        model.put("defaultNamingContext", defaultNamingContext);
        for (String servicePrincipalName : servicePrincipalNames) {
            List<LdapTestResult> result = this.ldapPrincipalSearcher.findAccountsForSpn(context, defaultNamingContext, servicePrincipalName);
            this.checkRevealedToReadOnlyDomainController(readOnlyDomainControllers, result, context, defaultNamingContext);
            results.put(servicePrincipalName, result);
        }
    }

    private void checkRevealedToReadOnlyDomainController(List<LdapTestResult> readOnlyDomainControllers, List<LdapTestResult> result, DirContext context, String defaultNamingContext) throws NamingException {
        if (!readOnlyDomainControllers.isEmpty() && result.size() == 1) {
            LdapTestResult account = result.get(0);
            for (LdapTestResult controller : readOnlyDomainControllers) {
                Set<String> allowGroups = this.getPrpGroups(controller, "msDS-RevealOnDemandGroup");
                Set<String> denyGroups = this.getPrpGroups(controller, "msDS-NeverRevealGroup");
                boolean isDenied = this.ldapPrincipalSearcher.checkMembership(context, defaultNamingContext, account.getServicePrincipalUsername(), denyGroups);
                if (isDenied) {
                    account.passwordReplicatonDenied(controller, true);
                    continue;
                }
                boolean isAllowed = this.ldapPrincipalSearcher.checkMembership(context, defaultNamingContext, account.getServicePrincipalUsername(), allowGroups);
                if (isAllowed) continue;
                account.passwordReplicatonDenied(controller, false);
            }
        }
    }

    private Set<String> getPrpGroups(LdapTestResult readOnlyDomainController, String attributeName) throws NamingException {
        HashSet<String> groups2 = new HashSet<String>();
        Attribute attribute = readOnlyDomainController.getAdditionalAttributes().get(attributeName);
        if (attribute != null) {
            for (int i = 0; i < attribute.size(); ++i) {
                groups2.add(attribute.get(i).toString());
            }
        }
        return groups2;
    }

    private String getDefaultNamingContext(DirContext context) throws NamingException {
        Attribute namingContext;
        SearchResult next;
        Attributes attrs;
        NamingEnumeration<SearchResult> search;
        SearchControls sc = new SearchControls();
        sc.setSearchScope(0);
        if (context != null && (search = context.search("", "(objectClass=*)", sc)) != null && search.hasMore() && (attrs = (next = search.next()).getAttributes()).size() > 0 && (namingContext = attrs.get("defaultNamingContext")) != null) {
            return (String)namingContext.get();
        }
        return null;
    }

    private Set<Integer> findKeytabEncTypes() {
        try {
            TreeSet<Integer> enctypes = new TreeSet<Integer>();
            List<KeytabInfo> list = new KeytabParser().parse(new FileInputStream(this.kerbConfManager.getKeytabFile()));
            for (KeytabInfo keytabInfo : list) {
                enctypes.add(keytabInfo.getEncType());
            }
            return enctypes;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkLdapSrv(Map<String, Object> model, String domain) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        DirContext context = null;
        try {
            context = (DirContext)ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)ComponentLocator.class.getClassLoader(), () -> {
                try {
                    return new InitialDirContext(env);
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            });
            model.put("dnsProvider", context.getEnvironment().get("java.naming.provider.url"));
            Attributes enumeration = context.getAttributes("_kerberos._tcp." + domain, new String[]{"SRV"});
            if (enumeration.size() == 0) {
                model.put("ldapServerNotFound", true);
            } else {
                String srv = enumeration.get("SRV").get().toString();
                String[] comps = srv.split(" ");
                String ldapServerName = comps[3];
                while (ldapServerName.endsWith(".")) {
                    ldapServerName = ldapServerName.substring(0, ldapServerName.length() - 1);
                }
            }
        }
        catch (NameNotFoundException e) {
            model.put("ldapServerNotFound", true);
            model.put("ldapServerNotFoundMessage", e.getMessage());
        }
        catch (Exception e) {
            log.debug("Kerberos DNS discovery failed", (Throwable)e);
            model.put("ldapServerNotFound", true);
            model.put("problemFindingLdapServerMessage", String.format("%s: %s", e.getClass().getSimpleName(), e.getMessage()));
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {}
            }
        }
    }
}

