/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import io.vavr.control.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.SnapshotInfo;
import org.kantega.atlaskerb.apiserver.ApiServer;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.springframework.stereotype.Component;

@Component
public class SnapshotService {
    public static final String SNAPSHOT_DIR = "SNAPSHOT/";
    public static final String PLUGIN_SETTINGS_PROPERTIES = "SNAPSHOT/plugin-settings.properties";
    public static final String SNAPSHOT_PROPERTIES = "SNAPSHOT/snapshot.properties";
    private HostApp hostApp;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final ConnectorConfManager connectorConfManager;
    private final ApiServerConfManager apiServerConfManager;
    private final ApiServer apiServer;
    private final ApplicationProperties applicationProperties;
    private final ApiTokenService apiTokenService;
    private final TokenEndpointService tokenEndpointService;

    @Inject
    public SnapshotService(@ComponentImport ApplicationProperties applicationProperties, HostAppFactory hostAppFactory, KerbConfManager kerbConfManager, IdpConfManager idpConfManager, ConnectorConfManager connectorConfManager, ApiServerConfManager apiServerConfManager, ApiServer apiServer, ApiTokenService apiTokenService, TokenEndpointService tokenEndpointService) {
        this.hostApp = hostAppFactory.getInstance();
        this.kerbConfManager = kerbConfManager;
        this.idpConfManager = idpConfManager;
        this.connectorConfManager = connectorConfManager;
        this.apiServerConfManager = apiServerConfManager;
        this.apiServer = apiServer;
        this.applicationProperties = applicationProperties;
        this.apiTokenService = apiTokenService;
        this.tokenEndpointService = tokenEndpointService;
    }

    public void restoreFromFile(File snapshotFile, boolean makeSnapshot) {
        if (makeSnapshot) {
            File file = this.createSnapshot("Before restore of " + snapshotFile.getName());
        }
        File homeDirectory = this.hostApp.getHomeDirectory();
        File unpackDir = new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_restore");
        File oldHomeDir = new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_oldhome");
        try {
            ZipInputStream in = new ZipInputStream(new FileInputStream(snapshotFile));
            ZipEntry entry = null;
            Properties props = new Properties();
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                if (entry.getName().equals(PLUGIN_SETTINGS_PROPERTIES)) {
                    props.load(in);
                    continue;
                }
                if (entry.getName().startsWith(SNAPSHOT_DIR)) continue;
                File file = new File(unpackDir, entry.getName());
                file.getParentFile().mkdirs();
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            FileUtils.deleteDirectory((File)oldHomeDir);
            homeDirectory.renameTo(oldHomeDir);
            unpackDir.renameTo(homeDirectory);
            FileUtils.deleteDirectory((File)oldHomeDir);
            List<Directory> needsUpdate = this.apiServer.findConnectorDirectoriesToUpdate();
            this.kerbConfManager.restoreSettings(props);
            this.idpConfManager.restoreSettings(props);
            this.connectorConfManager.restoreSettings(props);
            this.apiServerConfManager.restoreSettings(props);
            this.apiTokenService.restoreTokens(props);
            this.tokenEndpointService.restoreEndpoints(props);
            this.kerbConfManager.flushCaches();
            this.apiServer.configChanged(this.apiServerConfManager.getConfig());
            this.apiServer.updateConnectorDirectories(needsUpdate, this.apiServerConfManager.getCrowdServerUrl());
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)unpackDir);
            }
            catch (IOException iOException) {}
        }
    }

    public File createSnapshot(String description) {
        SnapshotInfo snapshotInfo = this.getSnapshotInfo(description);
        final File homeDirectory = this.hostApp.getHomeDirectory();
        File snapshotsDirectory = this.getSnapshotsDirectory();
        File tempFile = new File(snapshotsDirectory, "_snapshot_zip.tmp");
        tempFile.getParentFile().mkdirs();
        try {
            final ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempFile));
            this.writeMetadata(out, snapshotInfo);
            this.writeDbSettings(out);
            if (homeDirectory.exists()) {
                Files.walkFileTree(homeDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        ZipEntry entry = new ZipEntry(homeDirectory.toPath().relativize(path).toString());
                        out.putNextEntry(entry);
                        Files.copy(path, out);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            out.close();
            String filename = this.filename();
            File snapshotFile = new File(tempFile.getParentFile(), filename);
            tempFile.renameTo(snapshotFile);
            File file = snapshotFile;
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            tempFile.delete();
        }
    }

    @NotNull
    private SnapshotInfo getSnapshotInfo(String description) {
        new PluginKey();
        return new SnapshotInfo(this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), PluginKey.getVersion(), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE), System.currentTimeMillis(), description, this.filename());
    }

    @NotNull
    public String filename() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH_mm_ss");
        return "sso-snapshot-" + df.format(new Date()) + ".zip";
    }

    private void writeDbSettings(ZipOutputStream out) throws IOException {
        ZipEntry propsFile = new ZipEntry(PLUGIN_SETTINGS_PROPERTIES);
        out.putNextEntry(propsFile);
        Properties props = this.getDbSettings();
        props.store(out, null);
    }

    private void writeMetadata(ZipOutputStream out, SnapshotInfo snapshotInfo) throws IOException {
        ZipEntry propsFile = new ZipEntry(SNAPSHOT_PROPERTIES);
        out.putNextEntry(propsFile);
        Properties settings = snapshotInfo.getProperties();
        settings.store(out, null);
    }

    private Properties getDbSettings() {
        Properties props = new Properties();
        props.putAll(this.kerbConfManager.getSettings());
        props.putAll(this.idpConfManager.getSettings());
        props.putAll(this.connectorConfManager.getSettings());
        props.putAll(this.apiServerConfManager.getSettings());
        props.put("apiTokens", this.apiTokenService.getAllTokensAsJson());
        props.put("restrictAPIEndpoints", this.tokenEndpointService.getAllEndpointsAsJson());
        return props;
    }

    public File getSnapshotsDirectory() {
        File homeDirectory = this.hostApp.getHomeDirectory();
        return new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_snapshots");
    }

    public List<SnapshotInfo> getSnapshots() {
        File[] files = this.getSnapshotsDirectory().listFiles(pathname -> pathname.getName().endsWith(".zip"));
        if (files == null) {
            return Collections.emptyList();
        }
        Arrays.sort(files, (o1, o2) -> Long.compare(o2.lastModified(), o1.lastModified()));
        ArrayList<SnapshotInfo> result = new ArrayList<SnapshotInfo>();
        for (File file : files) {
            if (!file.canRead()) {
                result.add(new SnapshotInfo(file.getName(), false));
                continue;
            }
            try (ZipFile zip2 = new ZipFile(file);){
                ZipEntry metaEntry = zip2.getEntry(SNAPSHOT_PROPERTIES);
                ZipEntry settingsEntry = zip2.getEntry(PLUGIN_SETTINGS_PROPERTIES);
                if (metaEntry == null || settingsEntry == null) continue;
                Properties props = new Properties();
                props.load(zip2.getInputStream(metaEntry));
                SnapshotInfo info = SnapshotInfo.fromProperties(props, file.getName());
                result.add(info);
                Properties settings = new Properties();
                settings.load(zip2.getInputStream(settingsEntry));
                info.setSettings(settings);
                TreeSet<String> paths = new TreeSet<String>();
                Enumeration<? extends ZipEntry> entries = zip2.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || entry.getName().startsWith(SNAPSHOT_DIR)) continue;
                    paths.add(entry.getName());
                }
                info.getPaths().addAll(paths);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public boolean isSnapshot(String filename) {
        return io.vavr.collection.List.ofAll(this.getSnapshots()).find(snapshotInfo -> snapshotInfo.getFilename().equals(filename)).isDefined();
    }

    public SnapshotInfo findSnapshot(String filename) {
        return (SnapshotInfo)io.vavr.collection.List.ofAll(this.getSnapshots()).find(snapshotInfo -> snapshotInfo.getFilename().equals(filename)).getOrNull();
    }

    public Option<File> getSnapshotFile(String filename) {
        return io.vavr.collection.List.ofAll(this.getSnapshots()).find(snapshotInfo -> snapshotInfo.getFilename().equals(filename)).map(snapshotInfo -> new File(this.getSnapshotsDirectory(), snapshotInfo.getFilename()));
    }
}

