/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.SnapshotInfo;
import org.kantega.atlaskerb.SnapshotService;

@Scanned
public class RestoreSnapshotAction
extends RequireAdminServlet {
    private final SnapshotService snapshotService;
    private final TemplateRenderer renderer;

    @Inject
    public RestoreSnapshotAction(RequireAdminServletDependencyBucket bucket, SnapshotService snapshotService) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.snapshotService = snapshotService;
    }

    private void renderPage(HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        model.put("topMenu", "dashboard");
        model.put("menuItem", "snapshots");
        model.put("dateTool", new DateTool());
        this.renderer.render("templates/atlaskerb/restore-snapshot.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        String filenameInput = FilenameUtils.getName((String)req.getParameter("filename"));
        Option<File> maybeSnapshotFile = this.snapshotService.getSnapshotFile(filenameInput);
        if (maybeSnapshotFile.isDefined()) {
            File snapshotFile = maybeSnapshotFile.get();
            if (!snapshotFile.canRead()) {
                model.put("unreadable", true);
                this.renderPage(resp, model);
                return;
            }
            SnapshotInfo snapshot = this.snapshotService.findSnapshot(filenameInput);
            if (snapshot != null) {
                if (req.getParameter("restore") != null) {
                    this.snapshotService.restoreFromFile(snapshotFile, req.getParameter("makeSnapshot") != null);
                    resp.sendRedirect("snapshots?restored");
                } else {
                    String pluginVersion = PluginKey.getVersion();
                    model.put("pluginVersion", pluginVersion);
                    boolean canRestore = pluginVersion.contains("-SNAPSHOT") || pluginVersion.equals(snapshot.getPluginVersion());
                    model.put("canRestore", canRestore);
                    model.put("snapshot", snapshot);
                    this.renderPage(resp, model);
                }
                return;
            }
        }
        resp.sendRedirect("snapshots");
    }
}

