/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.util.Option;
import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.kantega.atlaskerb.ConfigureIpRestrictionsAction;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.RequireLoggedInUserServlet;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.saml.Fingerprint;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequireAdminServlet
extends RequireLoggedInUserServlet {
    private static final Logger log = LoggerFactory.getLogger(RequireAdminServlet.class);
    final UserManager userManager;
    final TemplateRenderer templateRenderer;
    final WebSudoManager webSudoManager;
    final PluginLicenseManager pluginLicenseManager;
    final HostApp hostApp;
    final UserLookupService userLookupService;
    final ApplicationProperties applicationProperties;
    final PluginAccessor pluginAccessor;
    final KerbConfManager kerbConfManager;
    final ScimConfManager scimConfManager;
    final IdpConfManager idpConfManager;
    final ConnectorConfManager connectorConfManager;
    final OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper;
    private final SecureRandom random = new SecureRandom();

    public RequireAdminServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket.getUserManager(), bucket.getLoginUriProvider());
        this.userManager = bucket.getUserManager();
        this.templateRenderer = bucket.getTemplateRenderer();
        this.webSudoManager = bucket.getWebSudoManager();
        this.pluginLicenseManager = bucket.getPluginLicenseManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.userLookupService = bucket.getUserLookupService();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.scimConfManager = bucket.getScimConfManager();
        this.oidcProcedureFactoryWrapper = bucket.getOidcProcedureFactoryWrapper();
        this.applicationProperties = bucket.getApplicationProperties();
        this.pluginAccessor = bucket.getPluginAccessor();
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "private, max-age=0, no-cache");
        UserKey remoteUserKey = this.userManager.getRemoteUserKey(request);
        if (remoteUserKey == null) {
            this.redirectToLogin(request, response);
            return;
        }
        if (!this.userManager.isSystemAdmin(remoteUserKey)) {
            response.setContentType("text/html");
            response.sendError(401, "Page requires system administrator access");
            return;
        }
        this.ensureCsrfTokenInSession(request);
        try {
            if (!this.expectsMultipart() && !this.checkCsrf(request)) {
                this.renderCsrfFailed(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            super.service(request, response);
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
        catch (CsrfException e) {
            this.renderCsrfFailed(request, response);
        }
    }

    private void renderCsrfFailed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setStatus(400);
        this.templateRenderer.render("templates/atlaskerb/csrf-failed.vm", this.newModel(request), (Writer)response.getWriter());
    }

    private boolean checkCsrf(HttpServletRequest request) {
        HttpSession httpSession = request.getSession();
        if (this.isSafeHttpMethod(request)) {
            return true;
        }
        this.ensureCsrfTokenInSession(request);
        String token_param = request.getParameter("krb_token");
        String token = (String)httpSession.getAttribute("krb_csrf_token");
        boolean tokenIsValid = token != null && token.equals(token_param);
        return tokenIsValid && this.isSameOriginOrReferer(request);
    }

    private boolean isSameOriginOrReferer(HttpServletRequest request) {
        Try<String> expectedOrigin = Try.of(() -> new URI(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).getAuthority());
        return Try.of(() -> (String)List.of("Origin", "Referer").map(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)).filter(Objects::nonNull).peek()).mapTry(requestOrigin -> new URI((String)requestOrigin).getAuthority().equals(expectedOrigin.get())).onFailure(throwable -> log.warn("[KSSO CSRF] NOT OK | " + String.format("Origin: %s | Referer: %s | Expected: %s | Application Base URL: %s", request.getHeader("Origin"), request.getHeader("Referer"), expectedOrigin.getOrElse("Not able to parse."), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)))).getOrElse(false);
    }

    private boolean isSafeHttpMethod(HttpServletRequest request) {
        return List.of("GET", "HEAD", "OPTIONS", "TRACE").contains(request.getMethod());
    }

    private void ensureCsrfTokenInSession(HttpServletRequest request) {
        if (request.getSession().getAttribute("krb_csrf_token") == null) {
            byte[] passwordBytes = new byte[32];
            this.random.nextBytes(passwordBytes);
            String token = Fingerprint.sha1Fingerprint(passwordBytes);
            request.getSession().setAttribute("krb_csrf_token", (Object)token);
        }
    }

    @Override
    protected Map<String, Object> newModel(HttpServletRequest req) {
        Map<String, Object> model = super.newModel(req);
        String contextPath = req.getContextPath();
        model.put("pluginAdminPath", contextPath + "/plugins/servlet/no.kantega.kerberosauth.kerberosauth-plugin");
        Option maybeLicense = this.pluginLicenseManager.getLicense();
        if (maybeLicense.isDefined()) {
            model.put("pluginLicense", maybeLicense.get());
        }
        String installedPluginVersion = io.vavr.control.Option.of(this.pluginAccessor).map(pluginAccessor -> pluginAccessor.getPlugin(this.pluginLicenseManager.getPluginKey())).map(Plugin::getPluginInformation).map(PluginInformation::getVersion).getOrElse("UNKNOWN");
        model.put("installedPluginVersion", installedPluginVersion);
        String requestURI = req.getRequestURI();
        if (requestURI.contains("/saml/")) {
            model.put("topMenu", "SAML");
            model.put("samlEnabled", this.idpConfManager.isSamlEnabled());
            model.put("connectorTool", new ConnectorTool(this.connectorConfManager));
        } else {
            model.put("topMenu", "Kerberos");
            model.put("supportsRemoveAllRememberMeTokens", this.hostApp.supportsRemoveAllRememberMeTokens());
            model.put("hasRestApi", this.hostApp.hasRestApi());
            model.put("hasWritableCrowd", this.userLookupService.hasWritableCrowdDirectory());
            model.put("kerberosEnabled", this.kerbConfManager.isKerberosEnabled());
            model.put("preemptivePaths", this.hostApp.getPreemptivePathMappings());
            IpRestrictionConfig restrictionCfg = this.kerbConfManager.getIpRestrictionConfig();
            ConfigureIpRestrictionsAction.populateModel(model, restrictionCfg);
        }
        model.put("displaySingleLogout", !this.hostApp.isProductMatch("fecru"));
        model.put("applicationProperties", this.kerbConfManager.getApplicationProperties());
        model.put("isKerberosConfigured", this.kerbConfManager.isKeytabConfigured());
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.put("isSamlConfigured", !this.idpConfManager.getIdentityProviders().isEmpty() || !this.idpConfManager.getProviderDrafts().isEmpty());
        model.put("isCloudConnectorsConfigured", !this.connectorConfManager.getDirectories().isEmpty() || !this.scimConfManager.getTenantConfigs().isEmpty());
        model.put("crowdDirectoryFinder", new CrowdDirectoryFinder(this.hostApp));
        model.put("isScimEnabled", this.scimConfManager.isScimEnabled());
        String page = requestURI.substring(requestURI.lastIndexOf("/") + 1);
        if (!page.isEmpty()) {
            model.put("menuItem", page);
        }
        model.put("backUrl", this.validateURLInput(req.getParameter("backUrl")));
        model.put("backLinkDescription", req.getParameter("backLinkDescription"));
        model.put("isJsdInstalled", this.kerbConfManager.isJsdInstalled());
        return model;
    }

    private String validateURLInput(String backUrl) {
        if (backUrl != null) {
            try {
                URI uri = new URI(backUrl);
                return uri.getQuery() != null ? uri.getPath() + "?" + uri.getQuery() : uri.getPath();
            }
            catch (URISyntaxException e) {
                log.error("Not valid backlink url", (Throwable)e);
            }
        }
        return null;
    }

    protected TemplateRenderer getTemplateRenderer() {
        return this.templateRenderer;
    }

    protected boolean expectsMultipart() {
        return false;
    }

    protected MultipartHttpRequest getMultipartRequest(HttpServletRequest request, long maxSize) throws IOException {
        if (!this.expectsMultipart()) {
            throw new IllegalArgumentException("Servlet has not declared that it expects multipart/form-data");
        }
        MultipartHttpRequest multipartRequest = this.hostApp.getMultipartRequest(request, maxSize);
        if (!this.checkCsrf((HttpServletRequest)multipartRequest)) {
            throw new CsrfException();
        }
        return multipartRequest;
    }

    public static class ConnectorTool {
        private final ConnectorConfManager connectorConfManager;

        ConnectorTool(ConnectorConfManager connectorConfManager) {
            this.connectorConfManager = connectorConfManager;
        }

        public boolean hasConnectorForKind(IdpConfiguration.Kind kind) {
            for (ConnectorType connectorType : this.connectorConfManager.getConnectorTypes().values()) {
                if (connectorType.getIdentityProviderKind() != kind) continue;
                return true;
            }
            return false;
        }
    }

    private static class CsrfException
    extends SecurityException {
        private CsrfException() {
        }
    }
}

