/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class OnboardAction
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final IdpConfManager idpConfManager;
    private final PluginLicenseManager pluginLicenseManager;
    private final HostApp hostApp;
    private final ConnectorConfManager connectorConfManager;
    private final KerbConfManager kerbConfManager;

    @Inject
    public OnboardAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.idpConfManager = bucket.getIdpConfManager();
        this.pluginLicenseManager = bucket.getPluginLicenseManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.showStep(req, resp, "start");
    }

    private void showStep(HttpServletRequest req, HttpServletResponse resp, String step) throws IOException {
        Map<String, Object> model = this.newModel(req);
        this.idpConfManager.readState();
        this.connectorConfManager.readState();
        resp.setContentType("text/html");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("providerKinds", IdpConfiguration.Kind.values());
        model.put("onboardStep", step);
        this.renderer.render("templates/atlaskerb/onboard.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean onboardSkip = req.getParameter("onboard_skip") != null;
        boolean onboardStart = req.getParameter("onboard_start") != null;
        boolean onboardSaml = req.getParameter("onboard_saml") != null;
        this.kerbConfManager.setShowWelcomeMessage(false);
        if (onboardSkip) {
            resp.sendRedirect("dashboard");
            return;
        }
        if (onboardStart) {
            this.showStep(req, resp, "type");
            return;
        }
        if (onboardSaml) {
            this.showStep(req, resp, "samlIdp");
            return;
        }
        resp.sendRedirect("onboard");
    }
}

