/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.kantega.atlaskerb.EncryptionType;
import org.kantega.atlaskerb.LdapTestResult;
import org.springframework.stereotype.Component;

@Component
public class LdapPrincipalSearcher {
    public boolean checkMembership(DirContext context, String defaultNamingContext, String username, Set<String> groups2) throws NamingException {
        StringBuilder groupsFilter = new StringBuilder();
        for (String group : groups2) {
            groupsFilter.append("(memberOf:1.2.840.113556.1.4.1941:=").append(group).append(")");
        }
        String gp = groups2.size() > 1 ? "(|" + groupsFilter.toString() + ")" : groupsFilter.toString();
        return !this.findAccountsByFilter(context, defaultNamingContext, "(&(samAccountName=" + username + ")" + gp + ")").isEmpty();
    }

    public List<LdapTestResult> findReadOnlyDomainControllers(DirContext context, String defaultNamingContext) throws NamingException {
        String defaultDomainControllerContext = "OU=Domain Controllers," + defaultNamingContext;
        try {
            context.lookup(defaultDomainControllerContext);
        }
        catch (NameNotFoundException e) {
            return Collections.emptyList();
        }
        return this.findAccountsByFilter(context, defaultDomainControllerContext, "(msDS-RevealOnDemandGroup=*)", new String[]{"msDS-RevealOnDemandGroup", "msDS-NeverRevealGroup"});
    }

    public List<LdapTestResult> findAccountsForSpn(DirContext context, String defaultNamingContext, String servicePrincipalName) throws NamingException {
        List<LdapTestResult> accountsByFilter = this.findAccountsByFilter(context, defaultNamingContext, "(servicePrincipalName=" + servicePrincipalName + ")");
        for (LdapTestResult result : accountsByFilter) {
            result.getServicePrincipalAliases().remove(servicePrincipalName);
            result.setServicePrincipalName(servicePrincipalName);
        }
        return accountsByFilter;
    }

    public List<LdapTestResult> findAccountsForAccountName(DirContext context, String defaultNamingContext, String accountName) throws NamingException {
        return this.findAccountsByFilter(context, defaultNamingContext, "(samAccountName=" + accountName + ")");
    }

    private List<LdapTestResult> findAccountsByFilter(DirContext context, String defaultNamingContext, String filter) throws NamingException {
        return this.findAccountsByFilter(context, defaultNamingContext, filter, new String[0]);
    }

    private List<LdapTestResult> findAccountsByFilter(DirContext context, String defaultNamingContext, String filter, String[] additionalAttributes) throws NamingException {
        ArrayList<LdapTestResult> results = new ArrayList<LdapTestResult>();
        SearchControls sc2 = new SearchControls();
        sc2.setSearchScope(2);
        ArrayList<String> returningAttributes = new ArrayList<String>();
        returningAttributes.addAll(Arrays.asList("sAMAccountName", "msDS-KeyVersionNumber", "userAccountControl", "userPrincipalName", "servicePrincipalName", "msDS-SupportedEncryptionTypes"));
        returningAttributes.addAll(Arrays.asList(additionalAttributes));
        sc2.setReturningAttributes(returningAttributes.toArray(new String[returningAttributes.size()]));
        NamingEnumeration<SearchResult> answer = context.search(defaultNamingContext, filter, sc2);
        List<EncryptionType> encryptionTypes = EncryptionType.getKnownEncryptionTypes();
        while (answer.hasMoreElements()) {
            Attribute supportedAttributeTypesAttr;
            LdapTestResult result = new LdapTestResult();
            SearchResult next = answer.next();
            String nameInNamespace = next.getNameInNamespace();
            result.setDn(nameInNamespace);
            result.setDn(nameInNamespace);
            Attributes attributes = next.getAttributes();
            result.setServicePrincipalUsername(attributes.get("sAMAccountName").get().toString());
            this.inspectUserAccountControl(result, attributes);
            this.inspectKeyVersionNumber(result, attributes);
            Attribute userPrincipalName = attributes.get("userPrincipalName");
            if (userPrincipalName != null) {
                result.setUserPrincipalName(userPrincipalName.get().toString());
            }
            if ((supportedAttributeTypesAttr = attributes.get("msDS-SupportedEncryptionTypes")) != null) {
                int supportedEncryptionTypes = Integer.parseInt((String)supportedAttributeTypesAttr.get());
                result.setSupportedEnctypeDefault(supportedEncryptionTypes == 0);
                for (EncryptionType encryptionType : encryptionTypes) {
                    if ((supportedEncryptionTypes & encryptionType.getMask()) == 0) continue;
                    result.getSupportedEncryptionTypes().add(encryptionType);
                }
            } else {
                result.setSupportedEnctypeDefault(true);
            }
            Attribute principalName = attributes.get("servicePrincipalName");
            if (principalName != null) {
                for (int i = 0; i < principalName.size(); ++i) {
                    String name = principalName.get(i).toString();
                    result.addServicePrincipalAlias(name);
                }
            }
            for (String additionalAttribute : additionalAttributes) {
                Attribute attribute = attributes.get(additionalAttribute);
                result.addAttribute(additionalAttribute, attribute);
            }
            results.add(result);
        }
        return results;
    }

    private void inspectKeyVersionNumber(LdapTestResult result, Attributes attributes) throws NamingException {
        Attribute attr = attributes.get("msDS-KeyVersionNumber");
        if (attr != null) {
            result.setLdapKeyVersionNumber(Integer.parseInt((String)attr.get()));
        } else {
            result.addUnreadableAttribute("msDS-KeyVersionNumber");
        }
    }

    private void inspectUserAccountControl(LdapTestResult result, Attributes attributes) throws NamingException {
        Attribute attr = attributes.get("userAccountControl");
        if (attr != null) {
            int userAccountControl = Integer.parseInt((String)attr.get());
            result.setAccountDisabled((userAccountControl & 2) != 0);
            result.setAccountPasswordNeverExpires((userAccountControl & 0x10000) != 0);
            result.setAccountPasswordHasExpired((userAccountControl & 0x800000) != 0);
            result.setAccountDesOnly((userAccountControl & 0x200000) != 0);
        } else {
            result.addUnreadableAttribute("userAccountControl");
        }
    }
}

