/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.kantega.atlaskerb.KerbConfManager;

@Scanned
public class KerberosScmFilter
implements Filter {
    private final KerbConfManager kerbConfManager;

    @Inject
    public KerberosScmFilter(KerbConfManager kerbConfManager) {
        this.kerbConfManager = kerbConfManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.kerbConfManager.isBitbucketKerberosScmUrlsEnabled()) {
            HttpServletRequest req = (HttpServletRequest)request;
            String requestURI = req.getRequestURI().substring(req.getContextPath().length()).substring("/kerberos-scm".length());
            req.getRequestDispatcher("/scm" + requestURI).forward(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

