/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.Organization;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.HomeDirectoryResolver;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.Keytab;
import org.kantega.atlaskerb.Stats;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.jaas.JaasConfig;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.kantega.atlaskerb.utils.Version;
import org.simplericity.serberuhs.DecodedKerberosToken;
import org.simplericity.serberuhs.SpNego;
import org.simplericity.serberuhs.keytab.KeytabInfo;
import org.simplericity.serberuhs.keytab.KeytabParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KerbConfManager
implements DebugInfo {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final PluginMetadataManager pluginMetadataManager;
    private static final String KEYTAB_INFO_KEY = "keytabInfo";
    private static final String key = "atlaskerb";
    private static final String disableLoginFileName = "disable_username_password_login.txt";
    private final PluginLicenseManager licenseManager;
    private final Stats stats;
    public static String[] defaultDisabledUserAgents = Arrays.asList("HttpClient", "Java/", "JIRA-", "JIRA/", "Bitbucket-", "Confluence-", "Confluence/", "FishEye-", "Bamboo-", "Axis/", "Monitoring Agent", "BB10", "BlackBerry", "AtlassianMobileApp", "AtlassianCompanion", "GoEdit").toArray(new String[0]);
    private HomeDirectoryResolver homeDirectoryResolver;
    private final Cache<String, Object> oneMinuteCache;
    private final Cache<String, Subject> subjectCache;
    final String isTraditionalLoginEnabledJSDContent = "isTraditionalLoginEnabledJSD=true";
    final String isBasicAuthDisabledContent = "isBasicAuthDisabled=true";
    final String traditionalLoginDisabledFileContent = "The existence of this file disables traditional username / password login. If you need to enable traditional login, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
    final String restApiRestrictedToApiTokenFileContent = "The existence of this file disables certain REST endpoints to only work with API token authentication. This may affect login mechanisms or other Atlassian functionality if not configured carefully. If you need to restore the original functionality, delete this file. No server restart is required. It may take up to one minute for the change to take effect.";
    public final String restApiRestrictedFilename = "restrict_rest_api_to_api_tokens.txt";
    final String completeLockdownContent = "completeLockdown=true";

    @Inject
    public KerbConfManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginMetadataManager pluginMetadataManager) {
        this.applicationProperties = applicationProperties;
        this.licenseManager = licenseManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.stats = new Stats();
        this.pluginAccessor = pluginAccessor;
        this.pluginMetadataManager = pluginMetadataManager;
        this.oneMinuteCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
        this.subjectCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    public boolean isLicenseDefined() {
        return this.licenseManager.getLicense().isDefined();
    }

    Stats getStats() {
        return this.stats;
    }

    public Subject getSubject(DecodedKerberosToken decodedKerberosToken) {
        if (decodedKerberosToken == null) {
            return null;
        }
        Keytab keytab = new Keytab(this.getKeytabInfos());
        String tokenPrincipal = this.getPrincipalForSubject(decodedKerberosToken, keytab);
        try {
            return (Subject)this.subjectCache.get((Object)tokenPrincipal, () -> (Subject)ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)ComponentLocator.class.getClassLoader(), () -> {
                JaasConfig config = new JaasConfig(this.getKeytabFile(), tokenPrincipal);
                CallbackHandler cbh = callbacks -> this.log.info("{} callbacks: {}", (Object)callbacks.length, (Object)callbacks);
                LoginContext ctx = new LoginContext(key, null, cbh, config);
                ctx.login();
                return ctx.getSubject();
            }));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to obtain Subject", e);
        }
    }

    public DecodedKerberosToken decodeKerberosToken(HttpServletRequest request) throws Exception {
        String atz = request.getHeader("Authorization");
        if (atz == null) {
            return null;
        }
        if (!atz.startsWith("Negotiate")) {
            return null;
        }
        return KerbConfManager.decodeKerberosToken(atz);
    }

    public static DecodedKerberosToken decodeKerberosToken(String tokenString) throws Exception {
        if (tokenString == null || !tokenString.startsWith("Negotiate ") || tokenString.length() < 11) {
            return null;
        }
        byte[] token = Base64.decodeBase64(((Charset)Charset.availableCharsets().get("utf-8")).encode(tokenString.substring("Negotiate ".length())).array());
        byte[] kerberosToken = new SpNego().getKerberosToken(token);
        return DecodedKerberosToken.fromToken(kerberosToken);
    }

    private String getPrincipalForSubject(DecodedKerberosToken decodedKerberosToken, Keytab keytab) {
        String tokenPrincipal = decodedKerberosToken.getService() + "/" + decodedKerberosToken.getHost() + "@" + decodedKerberosToken.getRealm();
        String oldConfiguredPrincipal = (String)this.settings().get(KEYS.PRINCIPAL.key);
        if (oldConfiguredPrincipal != null && keytab.getEntries().size() == 1 && !oldConfiguredPrincipal.equals(tokenPrincipal)) {
            return oldConfiguredPrincipal;
        }
        return tokenPrincipal;
    }

    synchronized void flushKeytabCaches() {
        this.oneMinuteCache.invalidate((Object)KEYTAB_INFO_KEY);
        this.subjectCache.invalidateAll();
    }

    boolean isUserNameAttributeLookupEnabled() {
        Object userNameAttributeLookupEnabled = this.settings().get(KEYS.USERNAME_ATTR_LOOKUP_ENABLED.key);
        return "true".equals(userNameAttributeLookupEnabled) || "true".equals(this.settings().get(KEYS.USER_PRINCIPAL_ATTR_LOOKUP_ENABLED.key));
    }

    void setUserNameAttributeLookupEnabled(boolean userNameAttributeLookupEnabled) {
        this.settings().put(KEYS.USERNAME_ATTR_LOOKUP_ENABLED.key, (Object)Boolean.toString(userNameAttributeLookupEnabled));
        this.settings().remove(KEYS.USER_PRINCIPAL_ATTR_LOOKUP_ENABLED.key);
    }

    public boolean isKerberosEnabled() {
        return !"false".equals(this.settings().get(KEYS.KERBEROS_ENABLED.key));
    }

    void setKerberosEnabled(boolean manualLoginLogEnabled) {
        this.settings().put(KEYS.KERBEROS_ENABLED.key, (Object)Boolean.toString(manualLoginLogEnabled));
    }

    boolean showWelcomeMessage() {
        return !"false".equals(this.settings().get(KEYS.SHOW_WELCOME_MESSAGE.key));
    }

    void setShowWelcomeMessage(boolean showWelcomeMessage) {
        this.settings().put(KEYS.SHOW_WELCOME_MESSAGE.key, (Object)Boolean.toString(showWelcomeMessage));
    }

    boolean isManualLoginLogEnabled() {
        return "true".equals(this.settings().get(KEYS.MANUAL_LOGIN_LOG_ENABLED.key));
    }

    void setManualLoginLogEnabled(boolean manualLoginLogEnabled) {
        this.settings().put(KEYS.MANUAL_LOGIN_LOG_ENABLED.key, (Object)Boolean.toString(manualLoginLogEnabled));
    }

    public boolean isPreemptiveAuthEnabled() {
        return "true".equals(this.settings().get(KEYS.PREEMPTIVE_AUTH_ENABLED.key));
    }

    public boolean isSendToLoginEnabled() {
        return "true".equals(this.settings().get(KEYS.SEND_TO_LOGIN_ENABLED.key));
    }

    void setPreemptiveAuthEnabled(boolean preemptiveAuthConfigured) {
        this.settings().put(KEYS.PREEMPTIVE_AUTH_ENABLED.key, (Object)Boolean.toString(preemptiveAuthConfigured));
    }

    void setSendToLoginEnabled(boolean sendToLoginEnabledConfigured) {
        this.settings().put(KEYS.SEND_TO_LOGIN_ENABLED.key, (Object)Boolean.toString(sendToLoginEnabledConfigured));
    }

    public boolean isTraditionalLoginDisabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginDisabled", () -> {
                File disableLoginFile = new File(this.homeDirectoryResolver.getHomeDirectory(), disableLoginFileName);
                return disableLoginFile.exists() && disableLoginFile.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking username password disable status", e.getCause());
            return false;
        }
    }

    public boolean isTraditionalLoginDisabledJSD() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isTraditionalLoginDisabledJSD", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableLoginFileName);
                if (file.exists() && file.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)file);
                    return !fileContents.contains("isTraditionalLoginEnabledJSD=true");
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isTraditionalLoginDisabled status", e.getCause());
            return true;
        }
    }

    public boolean isBasicAuthDisabled() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isBasicAuthDisabled", () -> {
                File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableLoginFileName);
                if (file.exists() && file.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)file);
                    return fileContents.contains("isBasicAuthDisabled=true");
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isBasicAuthDisabled status", e.getCause());
            return false;
        }
    }

    void setTraditionalLoginDisabled(boolean traditionalLoginDisabled, boolean basicAuthDisabled, boolean traditionalLoginDisabledJSD) {
        try {
            File file = new File(this.homeDirectoryResolver.getHomeDirectory(), disableLoginFileName);
            if (traditionalLoginDisabled) {
                String content = "The existence of this file disables traditional username / password login. If you need to enable traditional login, simply delete this file. No server restart is required. It takes up to one minute for the change to have effect.";
                if (basicAuthDisabled) {
                    content = content + "\n\nisBasicAuthDisabled=true";
                }
                if (!traditionalLoginDisabledJSD) {
                    content = content + "\n\nisTraditionalLoginEnabledJSD=true";
                }
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])content.getBytes());
            } else {
                file.delete();
            }
            this.oneMinuteCache.invalidateAll();
        }
        catch (IOException e) {
            String action = traditionalLoginDisabled ? "create" : "delete";
            this.log.error("Unable to " + action + " file: " + disableLoginFileName, (Throwable)e);
        }
    }

    public void setRestApiRestrictedToApiTokens(boolean restApiRestricted, boolean completeLockdown) {
        try {
            File file = new File(this.homeDirectoryResolver.getHomeDirectory(), "restrict_rest_api_to_api_tokens.txt");
            if (restApiRestricted) {
                String content = "The existence of this file disables certain REST endpoints to only work with API token authentication. This may affect login mechanisms or other Atlassian functionality if not configured carefully. If you need to restore the original functionality, delete this file. No server restart is required. It may take up to one minute for the change to take effect.";
                if (completeLockdown) {
                    content = content + "\n\ncompleteLockdown=true";
                }
                file.getParentFile().mkdirs();
                FileUtils.writeByteArrayToFile((File)file, (byte[])content.getBytes());
            } else {
                file.delete();
            }
            this.oneMinuteCache.invalidateAll();
        }
        catch (IOException e) {
            String action = restApiRestricted ? "create" : "delete";
            this.log.error("Unable to " + action + " file: " + "restrict_rest_api_to_api_tokens.txt", (Throwable)e);
        }
    }

    public boolean isRestApiRestrictedToApiTokens() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isRestApiRestrictedToApiTokens", () -> {
                File restApiRestrictedFile = new File(this.homeDirectoryResolver.getHomeDirectory(), "restrict_rest_api_to_api_tokens.txt");
                return restApiRestrictedFile.exists() && restApiRestrictedFile.isFile();
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isRestApiRestrictedToTokens status", e.getCause());
            return false;
        }
    }

    public boolean isRestApiCompleteLockdown() {
        try {
            return (Boolean)this.oneMinuteCache.get((Object)"isRestApiCompleteLockdown", () -> {
                File restApiRestrictedFile = new File(this.homeDirectoryResolver.getHomeDirectory(), "restrict_rest_api_to_api_tokens.txt");
                if (restApiRestrictedFile.exists() && restApiRestrictedFile.isFile()) {
                    String fileContents = FileUtils.readFileToString((File)restApiRestrictedFile);
                    return fileContents.contains("completeLockdown=true");
                }
                return false;
            });
        }
        catch (ExecutionException e) {
            this.log.error("Unexpected error checking isRestApiCompleteLockdown status", e.getCause());
            return false;
        }
    }

    public void setLockedRestApiErrorPageMessage(String message) {
        Option.of(message).peek(msg -> this.settings().put(KEYS.LOCKED_REST_API_ERROR_PAGE_MESSAGE.key, msg));
    }

    @Nullable
    public String getLockedRestApiErrorPageMessage() {
        return (String)this.settings().get(KEYS.LOCKED_REST_API_ERROR_PAGE_MESSAGE.key);
    }

    public String getTemplateLockedRestApiErrorPageMessage() {
        return String.format("REST URL <requested REST URL> has been blocked for non-API token access by your Administrator in Kantega SSO. To open this endpoint, either do so under Rest API access in Kantega SSO, or remove the file %s on the server", "restrict_rest_api_to_api_tokens.txt");
    }

    public String getDefaultLockedRestApiErrorPageMessage(String maybeRequestUri) {
        String requestedUri = Option.of(maybeRequestUri).getOrElse("<REST API endpoint>");
        return String.format("The REST URL %s has been blocked for non-API token access by your Administrator in Kantega SSO. To open this endpoint, either do so under Rest API access in Kantega SSO, or remove the file '%s' on the server", requestedUri, "restrict_rest_api_to_api_tokens.txt");
    }

    public String getKerberosHomeDirectoryPath() {
        if (this.homeDirectoryResolver != null && this.homeDirectoryResolver.getHomeDirectory() != null) {
            return this.homeDirectoryResolver.getHomeDirectory().getPath();
        }
        return "";
    }

    void setErrorPageMessage(String message) {
        this.settings().put(KEYS.ERROR_PAGE_MESSAGE.key, (Object)message);
    }

    public String getErrorPageMessage() {
        if (this.settings().get(KEYS.ERROR_PAGE_MESSAGE.key) != null) {
            return (String)this.settings().get(KEYS.ERROR_PAGE_MESSAGE.key);
        }
        return this.getDefaultErrorPageMessage();
    }

    String getTraditionalLoginDisabledDefaultMessage() {
        return "<html><body><h2 style=\"padding-top:20px\">Username / password login is disabled by your administrator.</h2> \n\n<br><br>Return to the <a href=\"%s%s\">login page</a> and try again.</body></html>";
    }

    void setTraditionalLoginDisabledMessage(String message) {
        this.settings().put(KEYS.TRADITIONALLOGINDISABLEDMESSAGE.key, (Object)message);
    }

    public String getTraditionalLoginDisabledMessage() {
        if (this.settings().get(KEYS.TRADITIONALLOGINDISABLEDMESSAGE.key) != null) {
            return (String)this.settings().get(KEYS.TRADITIONALLOGINDISABLEDMESSAGE.key);
        }
        return this.getTraditionalLoginDisabledDefaultMessage();
    }

    void setSamlLoginUsernamePlaceholder(String placeholder) {
        this.settings().put(KEYS.SAML_LOGIN_USERNAME_PLACEHOLDER.key, (Object)placeholder);
    }

    public String getSamlLoginUsernamePlaceholder() {
        if (this.settings().get(KEYS.SAML_LOGIN_USERNAME_PLACEHOLDER.key) != null) {
            return (String)this.settings().get(KEYS.SAML_LOGIN_USERNAME_PLACEHOLDER.key);
        }
        return this.getDefaultSamlLoginUsernamePlaceholder();
    }

    void setUsernameFieldText(String usernameFieldText) {
        this.settings().put(KEYS.USERNAME_FIELD_TEXT.key, (Object)usernameFieldText);
    }

    public String getUsernameFieldText() {
        if (this.settings().get(KEYS.USERNAME_FIELD_TEXT.key) != null) {
            return (String)this.settings().get(KEYS.USERNAME_FIELD_TEXT.key);
        }
        return this.getDefaultUsernameFieldText();
    }

    public String getDefaultUsernameFieldText() {
        return "Username";
    }

    void setNextButtonText(String nextButtonText) {
        this.settings().put(KEYS.NEXT_BUTTON_TEXT.key, (Object)nextButtonText);
    }

    public String getNextButtonText() {
        if (this.settings().get(KEYS.NEXT_BUTTON_TEXT.key) != null) {
            return (String)this.settings().get(KEYS.NEXT_BUTTON_TEXT.key);
        }
        return this.getDefaultNextButtonText();
    }

    public String getDefaultNextButtonText() {
        return "Next";
    }

    void setIdpListTitleText(String idpListTitleText) {
        this.settings().put(KEYS.IDP_LIST_TITLE_TEXT.key, (Object)idpListTitleText);
    }

    public String getIdpListTitleText() {
        if (this.settings().get(KEYS.IDP_LIST_TITLE_TEXT.key) != null) {
            return (String)this.settings().get(KEYS.IDP_LIST_TITLE_TEXT.key);
        }
        return this.getDefaultIdpListTitleText();
    }

    public String getDefaultIdpListTitleText() {
        return "Log in with";
    }

    String getDefaultSamlLoginUsernamePlaceholder() {
        return "user.name@example.com";
    }

    String getDefaultErrorPageMessage() {
        return "This can occur for a variety of reasons, but most likely you just need to try logging in again. If this fails, please try closing your browser completely before trying again. If the issue persists, please contact your administrator.";
    }

    void setHeaderUsernameIpUnblockedlist(String unblockedlist) {
        if (unblockedlist != null && unblockedlist.isEmpty()) {
            unblockedlist = null;
        }
        this.settings().put(KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST.key, (Object)unblockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public String[] getHeaderUsernameIpUnblockedlist() {
        return KerbConfManager.parseList((String)this.settings().get(KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST.key));
    }

    String getHeaderUsernameIpUnblockedlistAsString() {
        return (String)this.settings().get(KEYS.HEADER_USERNAME_IP_UNBLOCKEDLIST.key);
    }

    void setHeaderUsernameAttribute(String username) {
        if (username != null && username.isEmpty()) {
            username = null;
        }
        this.settings().put(KEYS.HEADER_USERNAME_ATTRIBUTE.key, (Object)username);
        this.oneMinuteCache.invalidateAll();
    }

    void setHeaderEmailAttribute(String email) {
        if (email != null && email.isEmpty()) {
            email = null;
        }
        this.settings().put(KEYS.HEADER_EMAIL_ATTRIBUTE.key, (Object)email);
        this.oneMinuteCache.invalidateAll();
    }

    public String getHeaderUsernameAttribute() {
        return (String)this.settings().get(KEYS.HEADER_USERNAME_ATTRIBUTE.key);
    }

    public String getHeaderEmailAttribute() {
        return (String)this.settings().get(KEYS.HEADER_EMAIL_ATTRIBUTE.key);
    }

    public boolean isHeaderauthUseXForwardedFor() {
        Object isHeaderauthUseXForwardedFor = this.settings().get(KEYS.HEADERAUTH_USE_X_FORWARDED_FOR.key);
        return "true".equals(isHeaderauthUseXForwardedFor);
    }

    void setHeaderauthUseXForwardedFor(boolean headerauthUseXForwardedFor) {
        this.settings().put(KEYS.HEADERAUTH_USE_X_FORWARDED_FOR.key, (Object)Boolean.toString(headerauthUseXForwardedFor));
    }

    public void addPreemptiveAuthExcludedPaths(String url) {
        Set<String> urls2 = this.getPreemptiveAuthExcludedPaths();
        urls2.add(url);
        this.settings().put(KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls2));
    }

    public void removePreemptiveAuthExcludedPaths(String url) {
        Set<String> urls2 = this.getPreemptiveAuthExcludedPaths();
        urls2.remove(url);
        this.settings().put(KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls2));
    }

    Set<String> getPreemptiveAuthExcludedPaths() {
        return ListParseUtils.parseSetFromCommaseparated((String)this.settings().get(KEYS.PREEMPTIVE_AUTH_EXCLUDED_PATHS.key));
    }

    void setRestExcludedPaths(Set<String> excludedPaths) {
        StringBuilder sb = new StringBuilder();
        for (String path : excludedPaths) {
            if (!StringUtils.startsWith(path, "/")) {
                path = "/" + path;
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(path);
        }
        this.settings().put(KEYS.REST_EXCLUDED_PATHS.key, (Object)sb.toString());
    }

    public Set<String> getRestExcludedPaths() {
        String excludedPaths = (String)this.settings().get(KEYS.REST_EXCLUDED_PATHS.key);
        if (excludedPaths == null || excludedPaths.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(excludedPaths.split(",")));
    }

    public boolean isBitbucketScmUrlsEnabled() {
        Object bitbucketScmUrlsEnabled = this.settings().get(KEYS.BITBUCKET_SCM_URLS_ENABLED.key);
        return "true".equals(bitbucketScmUrlsEnabled);
    }

    boolean isBitbucketScmUrlsUsed() {
        Object bitbucketScmUrlsEnabled = this.settings().get(KEYS.BITBUCKET_SCM_URLS_ENABLED.key);
        return bitbucketScmUrlsEnabled != null;
    }

    public boolean isBitbucketKerberosScmUrlsDefault() {
        return "true".equals(this.settings().get(KEYS.BITBUCKET_SCM_URLS_DEFAULT.key));
    }

    void setBitbucketKerberosScmUrlsDefault(boolean bitbucketKerberosScmUrlsDefault) {
        this.settings().put(KEYS.BITBUCKET_SCM_URLS_DEFAULT.key, (Object)Boolean.toString(bitbucketKerberosScmUrlsDefault));
    }

    public boolean isRestAuthEnabled() {
        Object jiraRestAuthEnabled = this.settings().get(KEYS.JIRA_REST_AUTH_ENABLED.key);
        Object restAuthEnabled = this.settings().get(KEYS.REST_AUTH_ENABLED.key);
        return "true".equals(jiraRestAuthEnabled) || "true".equals(restAuthEnabled);
    }

    public void setRestAuthEnabled(boolean restAuthEnabled) {
        this.settings().put(KEYS.REST_AUTH_ENABLED.key, (Object)Boolean.toString(restAuthEnabled));
        this.settings().remove(KEYS.JIRA_REST_AUTH_ENABLED.key);
    }

    void setBitbucketScmUrlsEnabled(boolean bitbucketScmUrlsEnabled) {
        this.settings().put(KEYS.BITBUCKET_SCM_URLS_ENABLED.key, (Object)Boolean.toString(bitbucketScmUrlsEnabled));
    }

    public boolean isBitbucketKerberosScmUrlsEnabled() {
        Object bitbucketScmUrlsEnabled = this.settings().get(KEYS.BITBUCKET_KERBEROS_SCM_URLS_ENABLED.key);
        return "true".equals(bitbucketScmUrlsEnabled);
    }

    void setBitbucketKerberosScmUrlsEnabled(boolean bitbucketKerberosScmUrlsEnabled) {
        this.settings().put(KEYS.BITBUCKET_KERBEROS_SCM_URLS_ENABLED.key, (Object)Boolean.toString(bitbucketKerberosScmUrlsEnabled));
    }

    public boolean isWebdavEnabled() {
        return "true".equals(this.settings().get(KEYS.WEBDAV_ENABLED.key));
    }

    void setWebdavEnabled(boolean webdavEnabled) {
        this.settings().put(KEYS.WEBDAV_ENABLED.key, (Object)Boolean.toString(webdavEnabled));
    }

    public boolean isClientFailureCollectionEnabled() {
        return "true".equals(this.settings().get(KEYS.FAILURE_COLLECTION.key));
    }

    void setClientFailureCollectionEnabled(boolean enabled) {
        this.settings().put(KEYS.FAILURE_COLLECTION.key, (Object)Boolean.toString(enabled));
    }

    public void setHomeDirectoryResolver(HomeDirectoryResolver homeDirectoryResolver) {
        this.homeDirectoryResolver = homeDirectoryResolver;
    }

    public boolean isKeytabConfigured() {
        File keytabFile = this.getKeytabFile();
        if (keytabFile == null) {
            return false;
        }
        return keytabFile.exists() && keytabFile.isFile();
    }

    boolean isKeytabUploaded() {
        return "true".equals(this.settings().get(KEYS.KEYTAB_UPLOADED.key));
    }

    void setKeytabFile(File path) {
        this.settings().put(KEYS.KEYTAB_FILE.key, (Object)path.getAbsolutePath());
        this.settings().put(KEYS.KEYTAB_UPLOADED.key, (Object)"false");
        this.settings().remove(KEYS.PRINCIPAL.key);
        this.flushKeytabCaches();
    }

    File getKeytabFile() {
        if (this.isKeytabUploaded()) {
            return this.getUploadedKeytabFile();
        }
        String keytabFile = KerbConfManager.nullsafe(this.settings().get(KEYS.KEYTAB_FILE.key));
        return keytabFile == null ? null : new File(keytabFile);
    }

    private static String nullsafe(Object param) {
        return param == null ? null : param.toString();
    }

    public Set<String> getRequiredGroups() {
        String requiredGroups = (String)this.settings().get(KEYS.REQUIRED_GROUP.key);
        if (StringUtils.isBlank(requiredGroups)) {
            return Collections.emptySet();
        }
        String[] groups2 = requiredGroups.trim().split("\\n");
        for (int i = 0; i < groups2.length; ++i) {
            groups2[i] = groups2[i].trim();
        }
        return new TreeSet<String>(Arrays.asList(groups2));
    }

    void setRequiredGroups(String requiredGroups) {
        if (StringUtils.isBlank(requiredGroups)) {
            this.settings().remove(KEYS.REQUIRED_GROUP.key);
        } else {
            this.settings().put(KEYS.REQUIRED_GROUP.key, (Object)requiredGroups);
        }
    }

    public String getCrowdAutoAddGroups() {
        return (String)this.settings().get(KEYS.CROWD_AUTO_ADD_GROUPS.key);
    }

    void setCrowdAutoAddGroups(String crowdAutoAddGroups) {
        this.settings().put(KEYS.CROWD_AUTO_ADD_GROUPS.key, (Object)crowdAutoAddGroups);
    }

    String getAdditionalUserSuffix() {
        return (String)this.settings().get(KEYS.ADDITIONAL_USER_SUFFIX.key);
    }

    void setAdditionalUserSuffix(String additionalUserSuffix) {
        this.settings().put(KEYS.ADDITIONAL_USER_SUFFIX.key, (Object)additionalUserSuffix);
    }

    public String getRegexLookup() {
        return (String)this.settings().get(KEYS.REGEX_LOOKUP.key);
    }

    public void setRegexLookup(String regexLookup) {
        this.settings().put(KEYS.REGEX_LOOKUP.key, (Object)regexLookup);
    }

    public String getRegexReplacement() {
        return (String)this.settings().get(KEYS.REGEX_REPLACEMENT.key);
    }

    public void setRegexReplacement(String regexReplacement) {
        this.settings().put(KEYS.REGEX_REPLACEMENT.key, (Object)regexReplacement);
    }

    public boolean isRegexLookupEnabled() {
        return "true".equals(this.settings().get(KEYS.REGEX_LOOKUP_ENABLED.key));
    }

    public void setRegexLookupEnabled(boolean enabled) {
        this.settings().put(KEYS.REGEX_LOOKUP_ENABLED.key, (Object)Boolean.toString(enabled));
    }

    public List<KeytabInfo> getKeytabInfos() {
        try {
            return (List)this.oneMinuteCache.get((Object)KEYTAB_INFO_KEY, () -> {
                File file = this.getKeytabFile();
                if (file != null && file.exists() && file.isFile()) {
                    try (FileInputStream is = new FileInputStream(file);){
                        List<KeytabInfo> list = new KeytabParser().parse(is);
                        return list;
                    }
                }
                return Collections.emptyList();
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed reading keytab info", e);
        }
    }

    public Map<String, String> getSettings() {
        PluginSettings settings = this.settings();
        HashMap<String, String> result = new HashMap<String, String>();
        for (KEYS keys2 : KEYS.values()) {
            Object value = settings.get(keys2.key);
            if (!(value instanceof String)) continue;
            result.put(keys2.key, (String)value);
        }
        return result;
    }

    void restoreSettings(Properties props) {
        PluginSettings settings = this.settings();
        for (KEYS keys2 : KEYS.values()) {
            settings.remove(keys2.key);
        }
        for (KEYS keys2 : KEYS.values()) {
            String value = props.getProperty(keys2.key);
            if (value == null) continue;
            settings.put(keys2.key, (Object)value);
        }
    }

    synchronized void flushCaches() {
        this.oneMinuteCache.invalidateAll();
        this.flushKeytabCaches();
    }

    private PluginSettings settings() {
        PluginSettings settingsForKey;
        String dn = this.applicationProperties.getDisplayName().toLowerCase();
        if ((dn.contains("jira") || dn.contains("confluence")) && this.settingsForKeyHasProperties(settingsForKey = this.pluginSettingsFactory.createSettingsForKey(key))) {
            return settingsForKey;
        }
        return this.pluginSettingsFactory.createGlobalSettings();
    }

    private boolean settingsForKeyHasProperties(PluginSettings settingsForKey) {
        return settingsForKey.get(KEYS.KEYTAB_UPLOADED.key) != null || settingsForKey.get(KEYS.KEYTAB_FILE.key) != null;
    }

    public PluginLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public static String[] parseList(String listString) {
        return ListParseUtils.parseArrayFromNewlines(listString);
    }

    public static String arrayToString(String[] array) {
        return ListParseUtils.arrayToStringWithNewlines(array);
    }

    public String getRemoteIpAddress(HttpServletRequest req) {
        String remoteAddr = req.getRemoteAddr();
        String forwardedFor = req.getHeader("x-forwarded-for");
        if (forwardedFor != null && !forwardedFor.equals(remoteAddr) && this.getPreferredProxyHeader() != null) {
            return forwardedFor;
        }
        return remoteAddr;
    }

    String[] getDisabledUserAgents() {
        IpRestrictionConfig restrictionCfg = this.getIpRestrictionConfig();
        return ArrayUtils.addAll(defaultDisabledUserAgents, restrictionCfg.getCustomDisabledUserAgents());
    }

    public IpRestrictionConfig getIpRestrictionConfig() {
        try {
            return (IpRestrictionConfig)this.oneMinuteCache.get((Object)IpRestrictionConfig.class.getName(), () -> new IpRestrictionConfig(this.settings()));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Couldn't read restriction configuration", e);
        }
    }

    public String getPreferredProxyHeader() {
        return (String)this.settings().get(KEYS.PREFERRED_PROXY_HEADER.key);
    }

    public void setPreferredProxyHeader(String preferredProxyHeader) {
        this.settings().put(KEYS.PREFERRED_PROXY_HEADER.key, (Object)preferredProxyHeader);
    }

    void setglobalIpUnblockedlist(String unblockedlist) {
        if (unblockedlist != null && unblockedlist.isEmpty()) {
            unblockedlist = null;
        }
        this.settings().put(KEYS.GLOBAL_IP_UNBLOCKEDLIST.key, (Object)unblockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    void setglobalIpBlockedlist(String blockedlist) {
        if (blockedlist != null && blockedlist.isEmpty()) {
            blockedlist = null;
        }
        this.settings().put(KEYS.GLOBAL_IP_BLOCKEDLIST.key, (Object)blockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    void setGlobalIpRestrictionType(IpRestrictionType ipRestrictionType) {
        this.settings().put(KEYS.GLOBAL_IP_RESTRICTION_TYPE.key, (Object)ipRestrictionType.name());
        this.oneMinuteCache.invalidateAll();
    }

    void setrestIpUnblockedlist(String ipUnblockedlist) {
        if (ipUnblockedlist != null && ipUnblockedlist.isEmpty()) {
            ipUnblockedlist = null;
        }
        this.settings().put(KEYS.REST_IP_UNBLOCKEDLIST.key, (Object)ipUnblockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    void setrestIpBlockedlist(String blockedlist) {
        if (blockedlist != null && blockedlist.isEmpty()) {
            blockedlist = null;
        }
        this.settings().put(KEYS.REST_IP_BLOCKEDLIST.key, (Object)blockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    void setRestIpRestrictionType(IpRestrictionType type) {
        this.settings().put(KEYS.REST_IP_RESTRICTION_TYPE.key, (Object)type.name());
        this.oneMinuteCache.invalidateAll();
    }

    void setCustomDisabledUserAgents(String[] userAgents) {
        if (userAgents != null && userAgents.length == 0) {
            userAgents = null;
        }
        this.settings().put(KEYS.CUSTOM_DISABLED_USER_AGENTS.key, (Object)StringUtils.join((Object[])userAgents, "\n"));
        this.oneMinuteCache.invalidateAll();
    }

    void setRemembermeCookieEnabled(boolean value) {
        this.settings().put(KEYS.REMEMBERME_COOKIE_ENABLED.key, (Object)Boolean.toString(value));
    }

    public boolean isRemembermeCookieEnabled() {
        return "true".equals(this.settings().get(KEYS.REMEMBERME_COOKIE_ENABLED.key));
    }

    public void setApiTokensEnabled(boolean value) {
        this.settings().put(KEYS.API_TOKENS_ENABLED.key, (Object)Boolean.toString(value));
    }

    public boolean isApiTokensEnabled() {
        return "true".equals(this.settings().get(KEYS.API_TOKENS_ENABLED.key));
    }

    public void setApiTokenUserPermission(ApiTokenUtil.TokenUserPermission value) {
        this.settings().put(KEYS.API_TOKEN_USER_PERMISSION.key, (Object)value.name());
    }

    public ApiTokenUtil.TokenUserPermission getApiTokenUserPermission() {
        String tokenUserPermission = (String)this.settings().get(KEYS.API_TOKEN_USER_PERMISSION.key);
        if (tokenUserPermission != null) {
            return ApiTokenUtil.TokenUserPermission.valueOf(tokenUserPermission);
        }
        ApiTokenUtil.TokenUserPermission allUsers = this.checkOldConfigUserPermission();
        if (allUsers != null) {
            return allUsers;
        }
        return ApiTokenUtil.TokenUserPermission.NO_USERS;
    }

    @Nullable
    private ApiTokenUtil.TokenUserPermission checkOldConfigUserPermission() {
        String oldConfigTokenUserPermission = (String)this.settings().get(KEYS.USER_API_TOKEN_ENABLED.key);
        if (oldConfigTokenUserPermission != null && "true".equals(this.settings().get(KEYS.USER_API_TOKEN_ENABLED.key))) {
            return ApiTokenUtil.TokenUserPermission.ALL_USERS;
        }
        return null;
    }

    public void setApiTokenAllowedUserGroups(String commaSeparatedAllowedGroups) {
        if (StringUtils.isBlank(commaSeparatedAllowedGroups)) {
            this.settings().remove(KEYS.API_TOKEN_ALLOWED_USER_GROUPS.key);
        } else {
            this.settings().put(KEYS.API_TOKEN_ALLOWED_USER_GROUPS.key, (Object)commaSeparatedAllowedGroups);
        }
    }

    public List<String> getApiTokenAllowedUserGroups() {
        String commaSeparatedAllowedGroups = (String)this.settings().get(KEYS.API_TOKEN_ALLOWED_USER_GROUPS.key);
        return ListParseUtils.parseListFromCommaSeparated(commaSeparatedAllowedGroups);
    }

    public void setApiTokenIpUnblockedlist(String unblockedlist) {
        if (unblockedlist != null && unblockedlist.isEmpty()) {
            unblockedlist = null;
        }
        this.settings().put(KEYS.API_TOKEN_IP_UNBLOCKEDLIST.key, (Object)unblockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public void setApiTokenIpBlockedlist(String blockedlist) {
        if (blockedlist != null && blockedlist.isEmpty()) {
            blockedlist = null;
        }
        this.settings().put(KEYS.API_TOKEN_IP_BLOCKEDLIST.key, (Object)blockedlist);
        this.oneMinuteCache.invalidateAll();
    }

    public void setApiTokenIpRestrictionType(IpRestrictionType ipRestrictionType) {
        this.settings().put(KEYS.API_TOKEN_IP_RESTRICTION_TYPE.key, (Object)ipRestrictionType.name());
        this.oneMinuteCache.invalidateAll();
    }

    public void setApiTokensUserMaxTimeRestriction(String maxAllowedTime) {
        Try<Long> maxAllowed = ApiTokenUtil.Validation.tryParseTokenTimeLimit(maxAllowedTime);
        if (maxAllowed.isSuccess()) {
            this.settings().put(KEYS.API_TOKEN_USER_MAX_TIME_RESTRICTION.key, (Object)maxAllowed.get().toString());
        }
    }

    public long getApiTokensUserMaxTimeRestriction() {
        Try<Long> maybeRestriction = ApiTokenUtil.Validation.tryParseTokenTimeLimit((String)this.settings().get(KEYS.API_TOKEN_USER_MAX_TIME_RESTRICTION.key));
        return maybeRestriction.getOrElse(-1L);
    }

    public void setSSOEnabledForUserAvatar(boolean isSSOEnabledForUserAvatar) {
        this.settings().put(KEYS.SSO_ENABLED_FOR_USER_AVATAR.key, (Object)Boolean.toString(isSSOEnabledForUserAvatar));
    }

    public boolean isSSOEnabledForUserAvatar() {
        return "true".equals(this.settings().get(KEYS.SSO_ENABLED_FOR_USER_AVATAR.key));
    }

    public boolean isUserAgentEnabled(String userAgent) {
        return this.isUserAgentEnabled(userAgent, this.getDisabledUserAgents());
    }

    public boolean isUserAgentEnabledByCustomList(String userAgent) {
        IpRestrictionConfig restrictionCfg = this.getIpRestrictionConfig();
        restrictionCfg.getCustomDisabledUserAgents();
        return this.isUserAgentEnabled(userAgent, restrictionCfg.getCustomDisabledUserAgents());
    }

    public boolean isUserAgentEnabledByDefaultList(String userAgent) {
        return this.isUserAgentEnabled(userAgent, defaultDisabledUserAgents);
    }

    private boolean isUserAgentEnabled(String userAgent, String[] listOfDisabledUserAgentNames) {
        if (userAgent == null) {
            return false;
        }
        if (listOfDisabledUserAgentNames != null) {
            for (String disabledUserAgent : Arrays.asList(listOfDisabledUserAgentNames)) {
                if (!userAgent.contains(disabledUserAgent)) continue;
                return false;
            }
        }
        return true;
    }

    synchronized void setKeytabContent(byte[] bytes) {
        File keytabFile = this.getUploadedKeytabFile();
        keytabFile.getParentFile().mkdirs();
        try {
            FileUtils.writeByteArrayToFile((File)keytabFile, (byte[])bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PluginSettings settings = this.settings();
        settings.put(KEYS.KEYTAB_UPLOADED.key, (Object)"true");
        settings.remove(KEYS.KEYTAB_FILE.key);
        settings.remove(KEYS.PRINCIPAL.key);
        this.flushKeytabCaches();
    }

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    void resetConfiguration() {
        PluginSettings settings = this.settings();
        for (KEYS key : KEYS.values()) {
            settings.remove(key.key);
        }
    }

    private File getUploadedKeytabFile() {
        return new File(this.homeDirectoryResolver.getHomeDirectory(), "kerberos.keytab");
    }

    public boolean isJsdInstalled() {
        if ("JIRA".equals(this.applicationProperties.getDisplayName())) {
            for (Plugin plugin : this.pluginAccessor.getPlugins()) {
                String key = plugin.getKey();
                if (key == null || !key.startsWith("com.atlassian.servicedesk")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isKerberosJsmEnabled() {
        Object kerberosJsmEnabled = this.settings().get(KEYS.KERBEROS_JSM_ENABLED.key);
        return "true".equals(kerberosJsmEnabled) || kerberosJsmEnabled == null;
    }

    public void setKerberosJsmEnabled(boolean kerberosJsmEnabled) {
        this.settings().put(KEYS.KERBEROS_JSM_ENABLED.key, (Object)Boolean.toString(kerberosJsmEnabled));
    }

    public void setKerberosKnowledgeBaseEnabled(boolean kerberosKnowledgeBaseEnabled) {
        this.settings().put(KEYS.KERBEROS_KNOWLEDGEBASE_ENABLED.key, (Object)Boolean.toString(kerberosKnowledgeBaseEnabled));
    }

    public boolean isKerberosKnowledgeBaseEnabled() {
        Object kerberosKnowledgeBaseEnabled = this.settings().get(KEYS.KERBEROS_KNOWLEDGEBASE_ENABLED.key);
        return "true".equals(kerberosKnowledgeBaseEnabled) || kerberosKnowledgeBaseEnabled == null;
    }

    public Option<Version> getSavedKssoVersion() {
        return Try.of(() -> (String)this.settings().get(KEYS.KSSO_VERSION.key)).map(Version::new).toOption();
    }

    public Option<Version> getRunningKssoVersion() {
        return Option.of(KerbConfManager.getBuildInfo().getProperty("build.version")).map(Version::new);
    }

    public void setKssoVersion(String version) {
        this.settings().put(KEYS.KSSO_VERSION.key, (Object)version);
    }

    public boolean isKssoVersionChanged() {
        Option<Version> maybeRunningVersion = this.getRunningKssoVersion();
        Option<Version> maybeKssoVersion = this.getSavedKssoVersion();
        try {
            if (maybeRunningVersion.isEmpty() && maybeKssoVersion.isEmpty()) {
                return true;
            }
            if (maybeKssoVersion.isEmpty()) {
                this.setKssoVersion(maybeRunningVersion.getOrElse((Version)Version.empty()).value);
                return true;
            }
            if (maybeKssoVersion.getOrElse(Version.empty()).compareTo(maybeRunningVersion.getOrElse(Version.empty())) == 0) {
                return false;
            }
            this.setKssoVersion(maybeRunningVersion.getOrElse((Version)Version.empty()).value);
            return true;
        }
        catch (IllegalStateException i) {
            return true;
        }
    }

    public boolean isKssoVersionChangedBreakingApiTokens() {
        boolean oneOfTheVersionsHasOldApiTokens = this.versionBeforeUpgradeHasOldApiTokens(this.getSavedKssoVersion().getOrElse(Version.empty()), this.getRunningKssoVersion().getOrElse(Version.empty()));
        if (!oneOfTheVersionsHasOldApiTokens) {
            return false;
        }
        return this.isKssoVersionChanged();
    }

    private boolean versionBeforeUpgradeHasOldApiTokens(Version savedVersion, Version runningVersion) {
        Version lastVersionBeforeBreakingApiToken = new Version("4.3.0");
        return savedVersion.compareTo(lastVersionBeforeBreakingApiToken) <= 0 && runningVersion.compareTo(lastVersionBeforeBreakingApiToken) > 0;
    }

    public static Properties getBuildInfo() {
        Properties buildInfo = new Properties();
        try (InputStream is = KerbConfManager.class.getResourceAsStream("/build-info.properties");){
            buildInfo.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buildInfo;
    }

    public void setUserdetailsInCommentsEnabled(boolean userdetailsInComments) {
        this.settings().put(KEYS.USER_DETAILS_IN_COMMENTS_ENABLED.key, (Object)Boolean.toString(userdetailsInComments));
    }

    public boolean isUserdetailsInCommentsEnabled() {
        Object kerberosKnowledgeBaseEnabled = this.settings().get(KEYS.USER_DETAILS_IN_COMMENTS_ENABLED.key);
        return "true".equals(kerberosKnowledgeBaseEnabled);
    }

    public Set<String> getAllowTraditionalLoginGroups() {
        return ListParseUtils.parseSetFromCommaseparated((String)this.settings().get(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key));
    }

    void setAllowTraditionalLoginGroups(Set<String> groups2) {
        this.settings().put(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    void addAllowTraditionalLoginGroups(String group) {
        Set<String> groups2 = this.getAllowTraditionalLoginGroups();
        groups2.add(group);
        this.settings().put(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    void removeAllowTraditionalLoginGroups(String group) {
        Set<String> groups2 = this.getAllowTraditionalLoginGroups();
        groups2.remove(group);
        this.settings().put(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    Set<String> emptyAllowTraditionalLoginGroups() {
        Set<String> groups2 = this.getAllowTraditionalLoginGroups();
        this.settings().remove(KEYS.ALLOW_TRADITIONAL_LOGIN_GROUPS.key);
        return groups2;
    }

    public Set<String> getAllowKerberosLoginGroups() {
        return ListParseUtils.parseSetFromCommaseparated((String)this.settings().get(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key));
    }

    void setAllowKerberosLoginGroups(Set<String> groups2) {
        this.settings().put(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    void addAllowKerberosLoginGroups(String group) {
        Set<String> groups2 = this.getAllowKerberosLoginGroups();
        groups2.add(group);
        this.settings().put(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    void removeAllowKerberosLoginGroups(String group) {
        Set<String> groups2 = this.getAllowKerberosLoginGroups();
        groups2.remove(group);
        this.settings().put(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    Set<String> emptyAllowKerberosLoginGroups() {
        Set<String> groups2 = this.getAllowKerberosLoginGroups();
        this.settings().remove(KEYS.ALLOW_KERBEROS_LOGIN_GROUPS.key);
        return groups2;
    }

    public Set<String> getDisallowTraditionalLoginGroups() {
        return ListParseUtils.parseSetFromCommaseparated((String)this.settings().get(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key));
    }

    void addDisallowTraditionalLoginGroups(String group) {
        Set<String> groups2 = this.getDisallowTraditionalLoginGroups();
        groups2.add(group);
        this.settings().put(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    void setDisallowTraditionalLoginGroups(Set<String> groups2) {
        this.settings().put(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    void removeDisallowTraditionalLoginGroups(String group) {
        Set<String> groups2 = this.getDisallowTraditionalLoginGroups();
        groups2.remove(group);
        this.settings().put(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    Set<String> emptyDisallowTraditionalLoginGroups() {
        Set<String> urls2 = this.getDisallowTraditionalLoginGroups();
        this.settings().remove(KEYS.DISALLOW_TRADITIONAL_LOGIN_GROUPS.key);
        return urls2;
    }

    public Set<String> getDisallowKerberosLoginGroups() {
        return ListParseUtils.parseSetFromCommaseparated((String)this.settings().get(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key));
    }

    void addDisallowKerberosLoginGroups(String group) {
        Set<String> groups2 = this.getDisallowKerberosLoginGroups();
        groups2.add(group);
        this.settings().put(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    void setDisallowKerberosLoginGroups(Set<String> groups2) {
        this.settings().put(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    void removeDisallowKerberosLoginGroups(String group) {
        Set<String> groups2 = this.getDisallowKerberosLoginGroups();
        groups2.remove(group);
        this.settings().put(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(groups2));
    }

    Set<String> emptyDisallowKerberosLoginGroups() {
        Set<String> urls2 = this.getDisallowKerberosLoginGroups();
        this.settings().remove(KEYS.DISALLOW_KERBEROS_LOGIN_GROUPS.key);
        return urls2;
    }

    public Set<String> getApiTokenAccessUrls() {
        return ListParseUtils.parseSetFromCommaseparated((String)this.settings().get(KEYS.API_TOKEN_ACCESS_URLS.key));
    }

    public void addApiTokenAccessUrls(String url) {
        Set<String> urls2 = this.getApiTokenAccessUrls();
        urls2.add(url);
        this.settings().put(KEYS.API_TOKEN_ACCESS_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls2));
    }

    public void removeApiTokenAccessUrls(String url) {
        Set<String> urls2 = this.getApiTokenAccessUrls();
        urls2.remove(url);
        this.settings().put(KEYS.API_TOKEN_ACCESS_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls2));
    }

    public Set<String> getForcedSsoUrls() {
        return ListParseUtils.parseSetFromCommaseparated((String)this.settings().get(KEYS.FORCED_SSO_URLS.key));
    }

    public void addForcedSsoUrls(String url) {
        Set<String> urls2 = this.getForcedSsoUrls();
        urls2.add(url);
        this.settings().put(KEYS.FORCED_SSO_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls2));
    }

    public void removeForcedSsoUrls(String url) {
        Set<String> urls2 = this.getForcedSsoUrls();
        urls2.remove(url);
        this.settings().put(KEYS.FORCED_SSO_URLS.key, (Object)ListParseUtils.iterableToCommaSeparatedString(urls2));
    }

    @Override
    public JSONObject asJson() {
        JSONObject json = new JSONObject();
        JSONArray installedPlugins = new JSONArray(this.pluginAccessor.getPlugins().stream().filter(arg_0 -> ((PluginMetadataManager)this.pluginMetadataManager).isUserInstalled(arg_0)).filter(plugin -> !io.vavr.collection.List.of("Atlassian", "Atlassian Community", "Atlassian Software Systems", "Atlassian Software Systems Pty Ltd", "OSGi Alliance", "The Apache Software Foundation").contains(plugin.getPluginInformation().getVendorName())).map(plugin -> new JSONObject(io.vavr.collection.HashMap.of("key", plugin.getKey(), "name", plugin.getName(), "version", plugin.getPluginInformation().getVersion(), "vendor", plugin.getPluginInformation().getVendorName(), "pluginState", plugin.getPluginState()).toJavaMap())).collect(Collectors.toList()));
        JSONObject licenseJson = new JSONObject();
        licenseJson.put("isActive", this.licenseManager.getLicense().map(PluginLicense::isActive).getOrElse((Object)false));
        licenseJson.put("isAutoRenewal", this.licenseManager.getLicense().map(PluginLicense::isAutoRenewal).getOrElse((Object)false));
        licenseJson.put("isEmbeddedWithinHostLicense", this.licenseManager.getLicense().map(PluginLicense::isEmbeddedWithinHostLicense).getOrElse((Object)false));
        licenseJson.put("isEnterprise", this.licenseManager.getLicense().map(PluginLicense::isEnterprise).getOrElse((Object)false));
        licenseJson.put("isEvaluation", this.licenseManager.getLicense().map(PluginLicense::isEvaluation).getOrElse((Object)false));
        licenseJson.put("isMaintenanceExpired", this.licenseManager.getLicense().map(PluginLicense::isMaintenanceExpired).getOrElse((Object)false));
        licenseJson.put("isSubscription", this.licenseManager.getLicense().map(PluginLicense::isSubscription).getOrElse((Object)false));
        licenseJson.put("isUnlimitedEdition", this.licenseManager.getLicense().map(PluginLicense::isUnlimitedEdition).getOrElse((Object)false));
        licenseJson.put("isValid", this.licenseManager.getLicense().map(PluginLicense::isValid).getOrElse((Object)false));
        licenseJson.put("isUnlimitedNumberOfUsers", this.licenseManager.getLicense().map(PluginLicense::isUnlimitedNumberOfUsers).getOrElse((Object)false));
        licenseJson.put("error", this.licenseManager.getLicense().flatMap(PluginLicense::getError).map(Enum::name).getOrElse((Object)""));
        licenseJson.put("organization", this.licenseManager.getLicense().map(PluginLicense::getOrganization).map(Organization::getName).getOrElse((Object)""));
        licenseJson.put("partner", this.licenseManager.getLicense().flatMap(PluginLicense::getPartner).map(Organization::getName).getOrElse((Object)""));
        licenseJson.put("maxNumberOfUsers", this.licenseManager.getLicense().flatMap(PluginLicense::getMaximumNumberOfUsers).getOrElse((Object)0));
        JSONObject statsJson = new JSONObject();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        statsJson.put("attempts", this.stats.getAttempts());
        statsJson.put("authFailed", this.stats.getAuthFailed());
        statsJson.put("failedDecodingToken", this.stats.getFailedDecodingToken());
        statsJson.put("failedParsingToken", this.stats.getFailedParsingToken());
        statsJson.put("kerberosLockout", this.stats.getKerberosLockout());
        statsJson.put("lacksPermission", this.stats.getLacksPermission());
        statsJson.put("lacksRequiredGroup", this.stats.getLacksRequiredGroup());
        statsJson.put("missingUsers", this.stats.getMissingUsers());
        statsJson.put("since", dateFormat.format(this.stats.getSince().getTime()));
        statsJson.put("successes", this.stats.getSuccesses());
        statsJson.put("wrongTokenBasic", this.stats.getWrongTokenBasic());
        statsJson.put("wrongTokenNotKerberos", this.stats.getWrongTokenNotKerberos());
        statsJson.put("wrongTokenNotNegotiate", this.stats.getWrongTokenNotNegotiate());
        statsJson.put("wrongTokenNtlm", this.stats.getWrongTokenNtlm());
        json.put("stats", statsJson);
        json.put("license", licenseJson);
        json.put("installedPlugins", installedPlugins);
        return json;
    }

    public static enum IpRestrictionType {
        UNRESTRICTED("UNRESTRICTED"),
        UNBLOCKEDLIST("WHITELIST"),
        BLOCKEDLIST("BLACKLIST");

        private String alias;

        private IpRestrictionType(String alias) {
            this.alias = alias;
        }

        public static IpRestrictionType getValueByNameOrAlias(String name) {
            return Arrays.stream(IpRestrictionType.values()).filter(m -> m.name().equals(name) || m.alias.equals(name)).findAny().orElseThrow(IllegalArgumentException::new);
        }

        public String stringValue() {
            switch (this) {
                case UNBLOCKEDLIST: {
                    return "Unblocked list";
                }
                case BLOCKEDLIST: {
                    return "Blocked list";
                }
                case UNRESTRICTED: {
                    return "Unrestricted";
                }
            }
            throw new IllegalArgumentException("Bad type");
        }
    }

    static enum KEYS {
        ADDITIONAL_USER_SUFFIX("additionalUserSuffix"),
        REGEX_LOOKUP("regexLookup"),
        REGEX_REPLACEMENT("regexReplacement"),
        REGEX_LOOKUP_ENABLED("regexLookupEnabled"),
        CROWD_AUTO_ADD_GROUPS("crowdAutoAddGroups"),
        GLOBAL_IP_BLOCKEDLIST("ipblacklist"),
        GLOBAL_IP_UNBLOCKEDLIST("ipwhitelist"),
        GLOBAL_IP_RESTRICTION_TYPE("iprestrictiontype"),
        REST_IP_BLOCKEDLIST("restipblacklist"),
        REST_IP_UNBLOCKEDLIST("restipwhitelist"),
        REST_IP_RESTRICTION_TYPE("restiprestrictiontype"),
        CUSTOM_DISABLED_USER_AGENTS("customDisabledUserAgents"),
        KEYTAB_FILE("keytabFile"),
        PREEMPTIVE_AUTH_EXCLUDED_PATHS("preemptiveAuthExcludedPaths"),
        REST_EXCLUDED_PATHS("RestExcludedPaths"),
        VALID_USER_GROUPS("ValidUserGroups"),
        PREFERRED_PROXY_HEADER("preferredproxyheader"),
        PRINCIPAL("principal"),
        REQUIRED_GROUP("requiredGroup"),
        BITBUCKET_SCM_URLS_DEFAULT("bitbucketScmUrlsDefault"),
        BITBUCKET_SCM_URLS_ENABLED("bitbucketScmUrlsEnabled"),
        BITBUCKET_KERBEROS_SCM_URLS_ENABLED("bitbucketKerberosScmUrlsEnabled"),
        FAILURE_COLLECTION("failurecollection"),
        KERBEROS_ENABLED("kerberosEnabled"),
        KEYTAB_UPLOADED("uploaded"),
        MANUAL_LOGIN_LOG_ENABLED("manualLoginLogEnabled"),
        PREEMPTIVE_AUTH_ENABLED("preemptiveAuthEnabled"),
        SEND_TO_LOGIN_ENABLED("sendToLoginEnabled"),
        JIRA_REST_AUTH_ENABLED("jiraRestAuthEnabled"),
        KERBEROS_JSM_ENABLED("jiraKerberosJsmEnabled"),
        KERBEROS_KNOWLEDGEBASE_ENABLED("jiraKerberosKnowledgeBaseEnabled"),
        REST_AUTH_ENABLED("restAuthEnabled"),
        USERNAME_ATTR_LOOKUP_ENABLED("userNameAttributeLookupEnabled"),
        USER_PRINCIPAL_ATTR_LOOKUP_ENABLED("userPrincipalNameLookupEnabled"),
        WEBDAV_ENABLED("webdavEnabled"),
        SHOW_WELCOME_MESSAGE("showWelcomeMessage"),
        ERROR_PAGE_MESSAGE("errorPageMessage"),
        TRADITIONALLOGINDISABLEDMESSAGE("traditionalLoginDisabledMessage"),
        SAML_LOGIN_USERNAME_PLACEHOLDER("samlLoginUsernamePlaceholder"),
        USERNAME_FIELD_TEXT("usernameFieldText"),
        NEXT_BUTTON_TEXT("nextButtonText"),
        IDP_LIST_TITLE_TEXT("idpListTitleText"),
        HEADER_USERNAME_IP_UNBLOCKEDLIST("headerUsernameIpWhitelist"),
        HEADER_USERNAME_ATTRIBUTE("headerUsernameAttribute"),
        HEADERAUTH_USE_X_FORWARDED_FOR("headerauthUseXForwardedFor"),
        HEADER_EMAIL_ATTRIBUTE("headerEmailAttribute"),
        REMEMBERME_COOKIE_ENABLED("remembermeCookieEnabled"),
        API_TOKENS_ENABLED("apiTokensEnabled"),
        USER_API_TOKEN_ENABLED("userApiTokenEnabled"),
        API_TOKEN_USER_PERMISSION("apiTokenUserPermission"),
        API_TOKEN_ALLOWED_USER_GROUPS("apiTokenAllowedUserGroups"),
        API_TOKEN_IP_BLOCKEDLIST("apiTokenIpBlacklist"),
        API_TOKEN_IP_UNBLOCKEDLIST("apiTokenIpWhitelist"),
        API_TOKEN_IP_RESTRICTION_TYPE("apiTokenIpRestrictionType"),
        API_TOKEN_USER_MAX_TIME_RESTRICTION("apiTokensUserMaxTimeRestriction"),
        SSO_ENABLED_FOR_USER_AVATAR("SSOEnabledForUserAvatar"),
        KSSO_VERSION("kssoVersion"),
        LOCKED_REST_API_ERROR_PAGE_MESSAGE("lockedRestApiErrorPageMessage"),
        USER_DETAILS_IN_COMMENTS_ENABLED("userdetailsInComments"),
        ALLOW_TRADITIONAL_LOGIN_GROUPS("allowTraditionalLoginGroups"),
        DISALLOW_TRADITIONAL_LOGIN_GROUPS("disallowTraditionalLoginGroups"),
        ALLOW_KERBEROS_LOGIN_GROUPS("allowKerberosLoginGroups"),
        DISALLOW_KERBEROS_LOGIN_GROUPS("disallowKerberosLoginGroups"),
        API_TOKEN_ACCESS_URLS("apiTokenAccessUrls"),
        FORCED_SSO_URLS("forcedSsoUrls");

        final String key;

        private KEYS(String key) {
            this.key = key;
        }
    }
}

