/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import java.util.Optional;
import org.kantega.atlaskerb.IpRestrictionFilter;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.utils.ListParseUtils;

public class IpRestrictionConfig {
    private final String[] customDisabledUserAgents;
    private final KerbConfManager.IpRestrictionType globalRestrictionType;
    private final String[] globalIpBlockedlist;
    private final String[] globalIpUnblockedlist;
    private final IpRestrictionFilter globalFilter;
    private final KerbConfManager.IpRestrictionType restRestrictionType;
    private final String[] restIpBlockedlist;
    private final String[] restIpUnblockedlist;
    private final IpRestrictionFilter restFilter;
    private final KerbConfManager.IpRestrictionType apiTokenRestrictionType;
    private final String[] apiTokenIpBlockedList;
    private final String[] apiTokenIpUnblockedList;
    private final IpRestrictionFilter apiTokenFilter;

    public IpRestrictionConfig(PluginSettings settings) {
        this.customDisabledUserAgents = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.CUSTOM_DISABLED_USER_AGENTS.key));
        this.globalRestrictionType = Optional.ofNullable((String)settings.get(KerbConfManager.KEYS.GLOBAL_IP_RESTRICTION_TYPE.key)).map(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).orElse(KerbConfManager.IpRestrictionType.UNRESTRICTED);
        this.globalIpBlockedlist = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.GLOBAL_IP_BLOCKEDLIST.key));
        this.globalIpUnblockedlist = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.GLOBAL_IP_UNBLOCKEDLIST.key));
        this.globalFilter = new IpRestrictionFilter(this.globalIpUnblockedlist, this.globalIpBlockedlist, this.globalRestrictionType);
        this.restRestrictionType = Optional.ofNullable((String)settings.get(KerbConfManager.KEYS.REST_IP_RESTRICTION_TYPE.key)).map(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).orElse(KerbConfManager.IpRestrictionType.UNRESTRICTED);
        this.restIpBlockedlist = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.REST_IP_BLOCKEDLIST.key));
        this.restIpUnblockedlist = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.REST_IP_UNBLOCKEDLIST.key));
        this.restFilter = new IpRestrictionFilter.InheritingFilter(this.restIpUnblockedlist, this.restIpBlockedlist, this.restRestrictionType, this.globalFilter);
        this.apiTokenRestrictionType = Optional.ofNullable((String)settings.get(KerbConfManager.KEYS.API_TOKEN_IP_RESTRICTION_TYPE.key)).map(KerbConfManager.IpRestrictionType::getValueByNameOrAlias).orElse(KerbConfManager.IpRestrictionType.UNRESTRICTED);
        this.apiTokenIpBlockedList = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.API_TOKEN_IP_BLOCKEDLIST.key));
        this.apiTokenIpUnblockedList = ListParseUtils.parseArrayFromNewlines((String)settings.get(KerbConfManager.KEYS.API_TOKEN_IP_UNBLOCKEDLIST.key));
        this.apiTokenFilter = new IpRestrictionFilter(this.apiTokenIpUnblockedList, this.apiTokenIpBlockedList, this.apiTokenRestrictionType);
    }

    public String[] getCustomDisabledUserAgents() {
        return this.customDisabledUserAgents;
    }

    public IpRestrictionFilter globalIpFilter() {
        return this.globalFilter;
    }

    public String[] getGlobalIpBlockedlist() {
        return this.globalIpBlockedlist;
    }

    public String[] getGlobalIpUnblockedlist() {
        return this.globalIpUnblockedlist;
    }

    public KerbConfManager.IpRestrictionType getGlobalRestrictionType() {
        return this.globalRestrictionType;
    }

    public IpRestrictionFilter restIpFilter() {
        return this.restFilter;
    }

    public KerbConfManager.IpRestrictionType getRestRestrictionType() {
        return this.restRestrictionType;
    }

    public String[] getRestIpBlockedlist() {
        return this.restIpBlockedlist;
    }

    public String[] getRestIpUnblockedlist() {
        return this.restIpUnblockedlist;
    }

    public KerbConfManager.IpRestrictionType getApiTokenRestrictionType() {
        return this.apiTokenRestrictionType;
    }

    public String[] getApiTokenIpBlockedList() {
        return this.apiTokenIpBlockedList;
    }

    public String[] getApiTokenIpUnblockedList() {
        return this.apiTokenIpUnblockedList;
    }

    public IpRestrictionFilter getApiTokenFilter() {
        return this.apiTokenFilter;
    }
}

