/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.util.ArrayList;
import java.util.List;

public class EncryptionType {
    private final String humanReadableName;
    private String name;
    private final String ktpassName;
    private int mask;
    private int enctype;
    private final String kerberosKeyName;

    public EncryptionType(String name, String ktpassName, String humanReadableName, int mask, int enctype, String kerberosKeyName) {
        this.humanReadableName = humanReadableName;
        this.name = name.toUpperCase();
        this.ktpassName = ktpassName.toUpperCase();
        this.mask = mask;
        this.enctype = enctype;
        this.kerberosKeyName = kerberosKeyName;
    }

    public String getName() {
        return this.name;
    }

    public String getKtpassName() {
        return this.ktpassName;
    }

    public int getMask() {
        return this.mask;
    }

    public int getEnctype() {
        return this.enctype;
    }

    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    public static List<EncryptionType> getKnownEncryptionTypes() {
        ArrayList<EncryptionType> encryptionTypes = new ArrayList<EncryptionType>();
        encryptionTypes.add(new EncryptionType("des-cbc-crc", "des-cbc-crc", "DES CRC", 1, 1, null));
        encryptionTypes.add(new EncryptionType("des-cbc-md5", "des-cbc-md5", "DES MD5", 2, 3, null));
        encryptionTypes.add(new EncryptionType("rc4-hmac", "rc4-hmac-nt", "RC4-HMAC", 4, 23, "ArcFourHmac"));
        encryptionTypes.add(new EncryptionType("aes128-cts-hmac-sha1-96", "aes128-sha1", "AES 128", 8, 17, "AES128"));
        encryptionTypes.add(new EncryptionType("aes256-cts-hmac-sha1-96", "aes256-sha1", "AES 256", 16, 18, "AES256"));
        return encryptionTypes;
    }

    public static EncryptionType byEncType(int encType) {
        for (EncryptionType encryptionType : EncryptionType.getKnownEncryptionTypes()) {
            if (encryptionType.getEnctype() != encType) continue;
            return encryptionType;
        }
        return null;
    }

    public String getKerberosKeyName() {
        return this.kerberosKeyName;
    }
}

