/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

@Scanned
public class ConfigureRequiredGroupsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public ConfigureRequiredGroupsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("requiredGroups", StringUtils.join(this.kerbConfManager.getRequiredGroups(), "\n"));
        model.put("SSOEnabledForUserAvatar", this.kerbConfManager.isSSOEnabledForUserAvatar());
        model.put("userdetailsInComments", this.kerbConfManager.isUserdetailsInCommentsEnabled());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/required-groups.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.kerbConfManager.setRequiredGroups(req.getParameter("requiredGroups"));
        this.kerbConfManager.setSSOEnabledForUserAvatar("on".equals(req.getParameter("SSOEnabledForUserAvatar")));
        this.kerbConfManager.setUserdetailsInCommentsEnabled("on".equals(req.getParameter("userdetailsInComments")));
        resp.sendRedirect("requiredgroups");
    }
}

