/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;

@Scanned
public class ConfigurePreemptiveAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;

    @Inject
    public ConfigurePreemptiveAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "preemptive");
        model.put("preemptiveEnabled", this.kerbConfManager.isPreemptiveAuthEnabled());
        model.put("sendToLoginEnabled", this.kerbConfManager.isSendToLoginEnabled());
        model.put("preemptivePaths", this.hostApp.getPreemptivePathMappings());
        model.put("forcedSsoUrls", this.kerbConfManager.getForcedSsoUrls());
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        model.put("excludedPaths", this.kerbConfManager.getPreemptiveAuthExcludedPaths());
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/preemptive.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String baseUrl;
        String addUrl;
        String removeUrl;
        if (req.getParameter("save") != null) {
            this.kerbConfManager.setPreemptiveAuthEnabled(req.getParameter("preemptiveEnabled") != null);
            this.kerbConfManager.setSendToLoginEnabled(req.getParameter("sendToLoginEnabled") != null);
        }
        if (StringUtils.isNotBlank((String)(removeUrl = req.getParameter("removeUrl")))) {
            this.kerbConfManager.removeForcedSsoUrls(removeUrl);
            this.kerbConfManager.setPreemptiveAuthEnabled(true);
        }
        if (StringUtils.isNotBlank((String)(removeUrl = req.getParameter("removeExcludedUrl")))) {
            this.kerbConfManager.removePreemptiveAuthExcludedPaths(removeUrl);
            this.kerbConfManager.setPreemptiveAuthEnabled(true);
        }
        if (StringUtils.isNotBlank((String)(addUrl = req.getParameter("addUrl")))) {
            addUrl = addUrl.trim();
            baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
            addUrl = StringUtils.removeStart((String)addUrl, (String)baseUrl);
            addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"https://"));
            if (!StringUtils.startsWith((String)(addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"http://"))), (String)"/")) {
                addUrl = "/" + addUrl;
            }
            this.kerbConfManager.addForcedSsoUrls(addUrl);
            this.kerbConfManager.setPreemptiveAuthEnabled(true);
        }
        if (StringUtils.isNotBlank((String)(addUrl = req.getParameter("excludedUrl")))) {
            addUrl = addUrl.trim();
            baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
            addUrl = StringUtils.removeStart((String)addUrl, (String)baseUrl);
            addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"https://"));
            if (!StringUtils.startsWith((String)(addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"http://"))), (String)"/")) {
                addUrl = "/" + addUrl;
            }
            this.kerbConfManager.addPreemptiveAuthExcludedPaths(addUrl);
            this.kerbConfManager.setPreemptiveAuthEnabled(true);
        }
        resp.sendRedirect("preemptive");
    }
}

