/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RegexValidationUtil;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

@Scanned
public class ConfigureIpRestrictionsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public ConfigureIpRestrictionsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        this.doCommonModelSetup(req, model);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/ip_restrict.vm", model, (Writer)resp.getWriter());
    }

    protected void doCommonModelSetup(HttpServletRequest req, Map<String, Object> model) {
        String enforceIP = this.kerbConfManager.getRemoteIpAddress(req);
        IpRestrictionConfig restrictionCfg = this.kerbConfManager.getIpRestrictionConfig();
        model.put("isIpValidGlobal", restrictionCfg.globalIpFilter().isRemoteAddressEnabled(enforceIP));
        model.put("isIpValidRest", restrictionCfg.restIpFilter().isRemoteAddressEnabled(enforceIP));
        ConfigureIpRestrictionsAction.populateModel(model, restrictionCfg);
        model.put("restAuthEnabled", this.kerbConfManager.isRestAuthEnabled());
        model.put("isProxied", this.kerbConfManager.getPreferredProxyHeader() != null);
        model.put("enforceIP", enforceIP);
        model.put("userIP", req.getRemoteAddr());
        model.put("xForwardedFor", req.getHeader("X-Forwarded-For"));
        model.put("hasRemoteIpValve", HttpUrlUtils.isRemoteIpValveConfigured());
        model.put("displayName", this.applicationProperties.getDisplayName());
    }

    static void populateModel(Map<String, Object> model, IpRestrictionConfig restrictionCfg) {
        model.put("globalIpRestrictionType", restrictionCfg.getGlobalRestrictionType().name());
        model.put("globalIpUnblockedlist", KerbConfManager.arrayToString(restrictionCfg.getGlobalIpUnblockedlist()));
        model.put("globalIpBlockedlist", KerbConfManager.arrayToString(restrictionCfg.getGlobalIpBlockedlist()));
        model.put("restIpRestrictionType", restrictionCfg.getRestRestrictionType().name());
        model.put("restIpUnblockedlist", KerbConfManager.arrayToString(restrictionCfg.getRestIpUnblockedlist()));
        model.put("restIpBlockedlist", KerbConfManager.arrayToString(restrictionCfg.getRestIpBlockedlist()));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("iprestrict") != null) {
            boolean isValidRegex;
            String globalType = req.getParameter("global_type");
            String globalUnblockedList = req.getParameter("global_unblockedlist");
            String globalBlockedList = req.getParameter("global_blockedlist");
            this.kerbConfManager.setGlobalIpRestrictionType(KerbConfManager.IpRestrictionType.getValueByNameOrAlias(globalType));
            Map<String, Object> model = this.newModel(req);
            boolean bl = isValidRegex = RegexValidationUtil.validRegex(globalUnblockedList) && RegexValidationUtil.validRegex(globalBlockedList);
            if (!isValidRegex) {
                model.put("globalRegexError", "true");
            } else {
                this.kerbConfManager.setglobalIpUnblockedlist(globalUnblockedList);
                this.kerbConfManager.setglobalIpBlockedlist(globalBlockedList);
            }
            String restType = req.getParameter("rest_type");
            String restUnblockedList = req.getParameter("rest_unblockedlist");
            String restBlockedList = req.getParameter("rest_blockedlist");
            if (restType != null) {
                this.kerbConfManager.setRestIpRestrictionType(KerbConfManager.IpRestrictionType.getValueByNameOrAlias(restType));
                if (!RegexValidationUtil.validRegex(restUnblockedList) || !RegexValidationUtil.validRegex(restBlockedList)) {
                    isValidRegex = false;
                    model.put("restRegexError", "true");
                } else {
                    this.kerbConfManager.setrestIpUnblockedlist(restUnblockedList);
                    this.kerbConfManager.setrestIpBlockedlist(restBlockedList);
                }
            }
            if (!isValidRegex) {
                this.doCommonModelSetup(req, model);
                model.put("globalIpUnblockedlist", globalUnblockedList);
                model.put("globalIpBlockedlist", globalBlockedList);
                model.put("restIpUnblockedlist", restUnblockedList);
                model.put("restIpBlockedlist", restBlockedList);
                resp.setContentType("text/html");
                this.renderer.render("templates/atlaskerb/ip_restrict.vm", model, (Writer)resp.getWriter());
                return;
            }
            resp.sendRedirect("iprestrict");
            return;
        }
        String forwarded = req.getParameter("forwarded");
        if (forwarded != null) {
            this.kerbConfManager.setPreferredProxyHeader("YES".equals(forwarded) ? "x-forwarded-for" : null);
            resp.sendRedirect("iprestrict");
        }
    }
}

