/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.web;

import com.ksso.scim.HttpMethod;
import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimRequestContext;
import com.ksso.scim.ScimResource;
import com.ksso.scim.ScimResponseCode;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.schema.marshaller.ScimErrorMarshaller;
import com.ksso.scim.schema.marshaller.ScimErrorMarshallerV1;
import com.ksso.scim.schema.marshaller.ScimErrorMarshallerV2;
import com.ksso.scim.service.ScimRequestHandler;
import com.ksso.scim.web.ScimRoute;
import io.vavr.collection.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class ScimRouteBuilder {
    private static final ScimRequestHandler defaultHandler = ctx -> {
        ScimRequest uri = ctx.getScimRequest();
        ScimVersion v = uri.getScimVersion();
        ScimErrorMarshaller errorMarshaller = v.fold(ScimErrorMarshallerV1::new, ScimErrorMarshallerV2::new);
        return errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, "No route for request/invalid endpoint URL: " + uri.getRequestURI());
    };
    private final List<Predicate<ScimRequestContext>> predicateList;
    private final ScimRequestHandler handler;
    private final List<ScimRoute> subRoutes;
    private final String description;

    private ScimRouteBuilder(String description, List<Predicate<ScimRequestContext>> predicateList, List<ScimRoute> subRoutes, ScimRequestHandler handler) {
        this.description = description;
        this.predicateList = Objects.requireNonNull(predicateList);
        this.subRoutes = Objects.requireNonNull(subRoutes);
        this.handler = Objects.requireNonNull(handler);
    }

    public static ScimRouteBuilder defineRoute(String description) {
        return new ScimRouteBuilder(description, List.of(ScimRoute.TRUE), List.empty(), defaultHandler);
    }

    public ScimRouteBuilder method(HttpMethod method) {
        return new ScimRouteBuilder(this.description, (List<Predicate<ScimRequestContext>>)this.predicateList.append(r -> r.getScimRequest().getMethod() == method), this.subRoutes, this.handler);
    }

    public ScimRouteBuilder scimVersion(ScimVersion version) {
        return new ScimRouteBuilder(this.description, (List<Predicate<ScimRequestContext>>)this.predicateList.append(r -> r.getScimRequest().getScimVersion() == version), this.subRoutes, this.handler);
    }

    public ScimRouteBuilder resource(ScimResource resource) {
        return new ScimRouteBuilder(this.description, (List<Predicate<ScimRequestContext>>)this.predicateList.append(r -> r.getScimRequest().getResource() == resource), this.subRoutes, this.handler);
    }

    public ScimRouteBuilder predicate(Predicate<ScimRequestContext> pred) {
        return new ScimRouteBuilder(this.description, (List<Predicate<ScimRequestContext>>)this.predicateList.append((Object)pred), this.subRoutes, this.handler);
    }

    public ScimRouteBuilder requestHandler(ScimRequestHandler handler) {
        return new ScimRouteBuilder(this.description, this.predicateList, this.subRoutes, handler);
    }

    public ScimRouteBuilder subRoute(ScimRouteBuilder sub) {
        return new ScimRouteBuilder(this.description, this.predicateList, (List<ScimRoute>)this.subRoutes.append((Object)sub.build()), this.handler);
    }

    public ScimRoute build() {
        Predicate matcher = this.predicateList.foldLeft(ScimRoute.TRUE, Predicate::and);
        return new ScimRoute(this.description, matcher, this.subRoutes, this.handler);
    }

    public ScimRouteBuilder resourceId(String resourceId) {
        Predicate<ScimRequestContext> pred = r -> r.getScimRequest().getResourceId().map(rid -> StringUtils.equals(resourceId, rid)).getOrElse(false);
        return new ScimRouteBuilder(this.description, (List<Predicate<ScimRequestContext>>)this.predicateList.append((Object)pred), this.subRoutes, this.handler);
    }

    public String toString() {
        return "ScimRouteBuilder{predicateList=" + this.predicateList + ", handler=" + this.handler + ", subRoutes=" + this.subRoutes + ", description='" + this.description + '\'' + '}';
    }
}

