/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.web;

import com.ksso.scim.ScimLib;
import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimRequestContext;
import com.ksso.scim.ScimResponse;
import com.ksso.scim.service.ScimRequestHandler;
import io.prometheus.client.Histogram;
import io.vavr.collection.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimRoute {
    private static final Logger log = LoggerFactory.getLogger(ScimRoute.class);
    public static final Predicate<ScimRequestContext> TRUE = r -> true;
    private final String description;
    private final Predicate<ScimRequestContext> matcher;
    private final List<ScimRoute> subRoutes;
    private final ScimRequestHandler handler;

    public ScimRoute(String description, Predicate<ScimRequestContext> matcher, List<ScimRoute> subRoutes, ScimRequestHandler handler) {
        this.description = description;
        this.matcher = matcher;
        this.subRoutes = subRoutes;
        this.handler = handler;
    }

    public boolean matches(ScimRequestContext scimRequestContext) {
        return this.matcher.test(scimRequestContext);
    }

    private ScimRoute findRoute(ScimRequestContext ctx) {
        String uri = ctx.getScimRequest().getRequestURI();
        return this.subRoutes.find(r -> r.matches(ctx)).peek(match -> log.trace("{} found sub route: {}, matching request: {}", new Object[]{this, match, uri})).onEmpty(() -> log.trace("{} has NO sub routes matching request: {}", (Object)this, (Object)uri)).map(r -> r.findRoute(ctx)).getOrElse(this);
    }

    public ScimResponse handle(ScimRequestContext ctx) throws RuntimeException {
        ScimRequest req = ctx.getScimRequest();
        log.debug("ScimRoute.handle(), request: {}", (Object)req);
        ScimRoute route = this.findRoute(ctx);
        log.debug("{} is match for request: {} {}", new Object[]{route, req.getMethod(), req.getRequestURI()});
        Histogram.Child timer = (Histogram.Child)ScimLib.Metrics.routeLatency.labels(req.getMethod().toString(), req.getResource().typeString(), req.getScimVersion().pathValue());
        return timer.time(() -> route.handler.handle(ctx));
    }

    public String toString() {
        return "ScimRoute{'" + this.description + "'}";
    }
}

