/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.util;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import io.vavr.Function2;
import io.vavr.collection.Iterator;
import io.vavr.collection.Stream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;

public class JsonUtils {
    private static final Function2<Integer, JSONArray, JSONObject> jsonObjectExtractor = (index, jsonArray) -> jsonArray.getJSONObject((int)index);
    private static final Function2<Integer, JSONArray, String> stringExtractor = (index, jsonArray) -> jsonArray.getString((int)index);

    public static Stream<JSONObject> jsonObjectStream(Object jsonArray) {
        if (jsonArray instanceof JSONArray) {
            return JsonUtils.stream((JSONArray)jsonArray, jsonObjectExtractor);
        }
        return Stream.empty();
    }

    public static Stream<String> stringStream(JSONArray jsonArray) {
        return JsonUtils.stream(jsonArray, stringExtractor);
    }

    public static <T> Stream<T> stream(JSONArray jsonArray, Function2<Integer, JSONArray, T> elementExtractor) {
        return Stream.ofAll(StreamSupport.stream(new JSONArraySpliterator<T>(jsonArray, elementExtractor), false));
    }

    public static Instant dateTimeToInstant(String dateString) {
        TemporalAccessor parse = DateTimeFormatter.ISO_INSTANT.parse(dateString);
        return Instant.from(parse);
    }

    public static JSONObject copy(JSONObject json) {
        String[] names = (String[])Iterator.ofAll(json.keys()).toJavaArray(String[]::new);
        return new JSONObject(json, names);
    }

    public static JSONObject sanitizedCopy(JSONObject json) {
        JSONObject copy = JsonUtils.copy(json);
        Object password = copy.opt("password");
        if (password != null) {
            copy.put("password", "****");
        }
        return copy;
    }

    private static class JSONArraySpliterator<T>
    implements Spliterator<T> {
        protected final JSONArray jsonArray;
        private final Function2<Integer, JSONArray, T> elementExtractor;
        int index;

        public JSONArraySpliterator(JSONArray jsonArray, Function2<Integer, JSONArray, T> elementExtractor) {
            this.jsonArray = jsonArray;
            this.elementExtractor = elementExtractor;
            this.index = 0;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if ((long)this.index < this.estimateSize()) {
                action.accept(this.elementExtractor.apply(this.index++, this.jsonArray));
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.jsonArray.length();
        }

        @Override
        public int characteristics() {
            return 64;
        }
    }
}

