/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.service;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.MetaUrlBuilder;
import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimRequestContext;
import com.ksso.scim.ScimResource;
import com.ksso.scim.ScimResponse;
import com.ksso.scim.ScimResponseCode;
import com.ksso.scim.patch.PatchOperation;
import com.ksso.scim.patch.ScimPatchHandler;
import com.ksso.scim.schema.marshaller.FragmentMarshaller;
import com.ksso.scim.schema.marshaller.ScimErrorMarshallerV2;
import com.ksso.scim.schema.marshaller.ScimResponseMarshaller;
import com.ksso.scim.schema.marshaller.ScimResponseMarshallerFactory;
import com.ksso.scim.schema.requests.MembershipRequest;
import com.ksso.scim.schema.requests.ReplaceGroupRequest;
import com.ksso.scim.schema.requests.ReplaceUserRequest;
import com.ksso.scim.schema.validation.ScimRequestValidatorV2;
import com.ksso.scim.schema.validation.ValidationError;
import com.ksso.scim.schema.vo.ScimGroup;
import com.ksso.scim.schema.vo.ScimUser;
import com.ksso.scim.service.AbstractScimService;
import com.ksso.scim.spi.ScimServerSpi;
import com.ksso.scim.spi.SpiError;
import com.ksso.scim.util.JsonUtils;
import io.vavr.Function1;
import io.vavr.Value;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Validation;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimServiceV2
extends AbstractScimService {
    private static final Logger log = LoggerFactory.getLogger(ScimServiceV2.class);

    public ScimServiceV2() {
        super(new ScimRequestValidatorV2(), new ScimErrorMarshallerV2());
    }

    public ScimResponse patchGroup(ScimRequestContext ctx) {
        ScimRequestValidatorV2 requestValidatorV2 = new ScimRequestValidatorV2();
        ScimRequest req = ctx.getScimRequest();
        String gid = req.getResourceId().getOrElseThrow(() -> new RuntimeException("??? patchGroup reached without resourceId"));
        Validation validation = requestValidatorV2.validatePatchRequest(req).flatMap(seq -> Validation.sequence(seq.map(s -> s.splitOutMembershipOp(gid))));
        if (validation.isInvalid()) {
            return this.errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, validation.getError());
        }
        Seq patchOperationsSplit = (Seq)validation.get();
        Traversable patchOperations = patchOperationsSplit.flatMap(e -> e.swap().toOption());
        Traversable membershipPatchOperations = patchOperationsSplit.flatMap(e -> e.toOption());
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        FragmentMarshaller fragmentMarshaller = ScimResponseMarshallerFactory.nonFilteringFragmentMarshaller(ctx);
        ScimServerSpi spi = ctx.getSpi();
        Either<SpiError, Seq<MembershipRequest>> performedRequests = spi.updateMemberships((Seq<MembershipRequest>)membershipPatchOperations);
        if (performedRequests.isLeft()) {
            return this.errorMarshaller.errorResponse(performedRequests.getLeft());
        }
        if (patchOperations.isEmpty()) {
            return marshaller.noContent();
        }
        Value either = spi.getGroupById(gid).map(group -> fragmentMarshaller.groupJson((ScimGroup)group)).peek(groupJson -> {
            if (log.isDebugEnabled()) {
                log.debug("PATCH JSON [pre-patch]: {}", (Object)JsonUtils.sanitizedCopy(groupJson));
            }
        }).map(groupJson -> new ScimPatchHandler((JSONObject)groupJson)).map(arg_0 -> ScimServiceV2.lambda$patchGroup$8((Seq)patchOperations, arg_0));
        if (either.isLeft()) {
            return this.errorMarshaller.errorResponse((SpiError)((Object)either.getLeft()));
        }
        Option<String> maybeIfMatch = req.getScimHeaders().getIfMatch();
        Validation patchValidation = (Validation)either.get();
        if (log.isDebugEnabled()) {
            patchValidation.peek(json -> log.debug("PATCH JSON [post-patch]: {}", (Object)JsonUtils.sanitizedCopy(json)));
        }
        Validation<Seq, ScimResponse> replaceUserValidation = patchValidation.map(patchedJson -> this.requestValidator.validateReplaceGroupRequest(Option.of(patchedJson), gid, maybeIfMatch)).flatMap(Function.identity());
        return replaceUserValidation.fold(ve -> this.errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, (Seq<ValidationError>)ve), replaceUserReq -> spi.replaceGroup((ReplaceGroupRequest)replaceUserReq).fold(spiError -> this.errorMarshaller.errorResponse((SpiError)((Object)((Object)spiError))), replacedUser -> marshaller.noContent()));
    }

    public ScimResponse patchUser(ScimRequestContext ctx) {
        ScimRequestValidatorV2 requestValidatorV2 = new ScimRequestValidatorV2();
        ScimRequest req = ctx.getScimRequest();
        String uid = req.getResourceId().getOrElseThrow(() -> new RuntimeException("??? patchUser reached without resourceId"));
        Validation<Seq<ValidationError>, Seq<PatchOperation>> validation = requestValidatorV2.validatePatchRequest(req);
        if (validation.isInvalid()) {
            return this.errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, validation.getError());
        }
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        FragmentMarshaller fragmentMarshaller = ScimResponseMarshallerFactory.nonFilteringFragmentMarshaller(ctx);
        ScimServerSpi spi = ctx.getSpi();
        Value either = spi.getUserById(uid).map(user -> fragmentMarshaller.userJson((ScimUser)user)).peek(userJson -> log.debug("PATCH JSON [pre-patch]: {}", userJson)).map(userJson -> new ScimPatchHandler((JSONObject)userJson)).map(handler -> handler.applyOperations((Seq)validation.get()));
        if (either.isLeft()) {
            return this.errorMarshaller.errorResponse((SpiError)((Object)either.getLeft()));
        }
        Option<String> maybeIfMatch = req.getScimHeaders().getIfMatch();
        Validation patchValidation = (Validation)either.get();
        if (log.isDebugEnabled()) {
            patchValidation.peek(json -> log.debug("PATCH JSON [post-patch]: {}", (Object)JsonUtils.sanitizedCopy(json)));
        }
        Validation<Seq, ScimResponse> replaceUserValidation = patchValidation.map(patchedJson -> this.requestValidator.validateReplaceUserRequest(Option.of(patchedJson), uid, maybeIfMatch)).flatMap(Function.identity());
        return replaceUserValidation.fold(ve -> this.errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, (Seq<ValidationError>)ve), replaceUserReq -> spi.replaceUser((ReplaceUserRequest)replaceUserReq).fold(spiError -> this.errorMarshaller.errorResponse((SpiError)((Object)((Object)spiError))), replacedUser -> marshaller.noContent()));
    }

    @Override
    public ScimResponse getUsers(ScimRequestContext ctx) {
        return super.getUsers(ctx);
    }

    @Override
    public ScimResponse createUser(ScimRequestContext ctx) {
        return super.createUser(ctx);
    }

    @Override
    public ScimResponse replaceUser(ScimRequestContext ctx) {
        return super.replaceUser(ctx);
    }

    @Override
    public ScimResponse getGroups(ScimRequestContext ctx) {
        return super.getGroups(ctx);
    }

    @Override
    public ScimResponse createGroup(ScimRequestContext ctx) {
        return super.createGroup(ctx);
    }

    @Override
    public ScimResponse replaceGroup(ScimRequestContext ctx) {
        return super.replaceGroup(ctx);
    }

    public ScimResponse getServiceProviderConfig(ScimRequestContext ctx) {
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        MetaUrlBuilder urlBuilder = ctx.getMetaUrlBuilder();
        JSONObject config = new JSONObject().put("schemas", new JSONArray().put("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig")).put("documentationUri", "https://kantega-sso.atlassian.net/wiki/").put("patch", new JSONObject().put("supported", true)).put("bulk", new JSONObject().put("supported", false).put("maxOperations", 0).put("maxPayloadSize", 0)).put("filter", new JSONObject().put("supported", true).put("maxResults", -1)).put("changePassword", new JSONObject().put("supported", false)).put("sort", new JSONObject().put("supported", false)).put("etag", new JSONObject().put("supported", false)).put("authenticationSchemes", new JSONArray().put(new JSONObject().put("type", "bearertoken").put("name", "OAuth Bearer Token").put("description", "Authentication Scheme using the OAuth Bearer Token Standard").put("primary", true))).put("meta", new JSONObject().put("location", urlBuilder.url(ScimResource.SERVICE_PROVIDER_CONFIG)).put("resourceType", ScimResource.SERVICE_PROVIDER_CONFIG.typeString()));
        return marshaller.jsonResponse(config);
    }

    /*
     * Exception decompiling
     */
    public ScimResponse getSchemas(ScimRequestContext ctx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ScimResponse getResourceTypes(ScimRequestContext ctx) {
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        List<JSONObject> items = List.of(new JSONObject().put("schemas", new JSONArray().put("urn:ietf:params:scim:schemas:core:2.0:ResourceType")).put("name", "User").put("endpoint", "/Users").put("description", "User Account").put("schema", "urn:ietf:params:scim:schemas:core:2.0:User").put("schemaExtensions", new JSONArray().put(new JSONObject().put("schema", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User").put("required", false))).put("meta", new JSONObject().put("resourceType", "ResourceType")), new JSONObject().put("schemas", new JSONArray().put("urn:ietf:params:scim:schemas:core:2.0:ResourceType")).put("name", "Group").put("endpoint", "/Groups").put("description", "Group").put("schema", "urn:ietf:params:scim:schemas:core:2.0:Group").put("meta", new JSONObject().put("resourceType", "ResourceType")));
        return marshaller.simpleListResponse(items, Function1.identity());
    }

    private static /* synthetic */ Validation lambda$patchGroup$8(Seq patchOperations, ScimPatchHandler handler) {
        return handler.applyOperations(patchOperations);
    }
}

